//
//   File : libkvidockwidget.cpp
//   Creation date : Tue Jan 02 20001 14:34:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000-2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//



#include "kvi_settings.h"
#include "kvi_module.h"
#include "kvi_debug.h"
#include "kvi_locale.h"
#include "kvi_app.h"
#include "kvi_string.h"
#include "kvi_uparser.h"
#include "kvi_frame.h"
#include "kvi_taskbar.h"
#include "kvi_window.h"
#include "kvi_dynamictooltip.h"
#include "kvi_locale.h"
#include "kvi_memmove.h"
#include "kvi_iconmanager.h"
#include "kvi_internalcmd.h"

#include "kvi_imagelib.h"



#include <qpixmap.h>
#include "kvi_list.h"
#include <qpainter.h>

#include <stdlib.h>
#include <time.h>

#ifdef COMPILE_ON_WINDOWS
	#include <windows.h>

	#include <qbitmap.h>
	#include <qcursor.h>

	#define ID_DOCKWIDGET_TASKBAR_ICON 0xdeadbeef
	#define WM_KVIRC_NOTIFY_ICON_MESSAGE (WM_USER + 0xbeef)
#else

	#include <X11/Xlib.h>

	//const int XFocusOut = FocusOut;
	const int XFocusIn = FocusIn;
	#undef FocusOut
	#undef FocusIn
	#undef KeyPress
	#undef KeyRelease

	#warning "Later remove this stuff and use a wrapper for #include <X11/Xlib.h>"
	#ifdef Bool
		#undef Bool
	#endif
#endif

#include "libkvidockwidget.h"

#ifdef COMPILE_KDE_SUPPORT
	#include "kwin.h"
#endif

static KviPtrList<KviDockWidget> * g_pDockWidgetList = 0;

static QPixmap * g_pDock1 = 0;
static QPixmap * g_pDock2 = 0;
static QPixmap * g_pDock3 = 0;

#ifdef COMPILE_ON_WINDOWS
	static HICON g_hDock[6];
	static int   g_iCurLevel = -1;
#endif


KviDockWidget::KviDockWidget(KviFrame * frm,const char * name)
: QWidget(0,name)
{
	g_pDockWidgetList->append(this);
	m_pFrm = frm;
	m_pFrm->setDockExtension(this);

#ifdef COMPILE_ON_WINDOWS
	createTaskbarIcon();
#else //!COMPILE_ON_WINDOWS
	setMinimumSize(24,24);
	#ifdef COMPILE_KDE_SUPPORT
		KWin::setSystemTrayWindowFor(winId(),frm->winId());
	#endif
#endif //!COMPILE_ON_WINDOWS

	m_pTip = new KviDynamicToolTip(this,"dock_tooltip");
	connect(m_pTip,SIGNAL(tipRequest(KviDynamicToolTip *,const QPoint &)),this,SLOT(tipRequest(KviDynamicToolTip *,const QPoint &)));

	m_pContextPopup = new QPopupMenu(this);

	int id = m_pContextPopup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_DOCKWIDGET)),__tr("&Hide the dock widget"),m_pFrm,SLOT(executeInternalCommand(int)));
	m_pContextPopup->setItemParameter(id,KVI_INTERNALCOMMAND_DOCKWIDGET_HIDE);
	m_pContextPopup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_RAW)),__tr("&Raise the KVIrc window"),this,SLOT(raiseParentFrame()));
	m_pContextPopup->insertSeparator();
	m_pContextPopup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_QUITAPP)),__tr("&Quit KVIrc"),g_pApp,SLOT(quit()));
}


KviDockWidget::~KviDockWidget()
{
#ifdef COMPILE_ON_WINDOWS
	destroyTaskbarIcon();
#endif
	m_pFrm->setDockExtension(0);
	g_pDockWidgetList->removeRef(this);
}

void KviDockWidget::die()
{
	delete this;
}


#ifdef COMPILE_ON_WINDOWS
void KviDockWidget::createTaskbarIcon()
{
	NOTIFYICONDATA nid;
	nid.cbSize = sizeof(nid);
	nid.hWnd = winId();
	nid.uID = ID_DOCKWIDGET_TASKBAR_ICON;
	nid.uFlags = NIF_ICON | NIF_MESSAGE | NIF_TIP;
	nid.uCallbackMessage = WM_KVIRC_NOTIFY_ICON_MESSAGE;
	kvi_memmove(nid.szTip,"KVIrc",6);
	nid.hIcon  = g_hDock[0];
	Shell_NotifyIcon(NIM_ADD,&nid);
	g_iCurLevel = 0;
}

void KviDockWidget::destroyTaskbarIcon()
{
	NOTIFYICONDATA nid;
	nid.cbSize = sizeof(nid);
	nid.hWnd = winId();
	nid.uID = ID_DOCKWIDGET_TASKBAR_ICON;
	nid.uFlags = 0;
	Shell_NotifyIcon(NIM_DELETE,&nid);
}

void KviDockWidget::setTaskbarIcon(void * hIcon)
{
	NOTIFYICONDATA nid;
	nid.cbSize = sizeof(nid);
	nid.hWnd = winId();
	nid.uID = ID_DOCKWIDGET_TASKBAR_ICON;
	nid.uFlags = NIF_ICON;
	nid.hIcon = (HICON)hIcon;
	Shell_NotifyIcon(NIM_MODIFY,&nid);
}


bool KviDockWidget::winEvent(MSG * m)
{
	if(m->message == WM_KVIRC_NOTIFY_ICON_MESSAGE)
	{
		if(m->wParam == ID_DOCKWIDGET_TASKBAR_ICON)
		{
			switch(m->lParam)
			{
				case WM_MOUSEMOVE:
					tipRequest(m_pTip,QCursor::pos());
					break;
				case WM_LBUTTONDOWN:
					if(m_pFrm->isVisible())m_pFrm->hide();
					else raiseParentFrame();
					break;
				case WM_RBUTTONDOWN:
					m_pContextPopup->popup(QCursor::pos());
					break;
			}
			return true;
		}
	}
	return false;
}

#endif

#define NIDLEMSGS 18

static const char * idlemsgs[NIDLEMSGS]=
{
	__tr_no_lookup("Nothing is happening...") ,
	__tr_no_lookup("Just idling...") ,
	__tr_no_lookup("Dum de dum de dum...") ,
	__tr_no_lookup("Hey man...do something!") ,
	__tr_no_lookup("Umpf!") ,
	__tr_no_lookup("Silence speaking") ,
	__tr_no_lookup("Are ya here ?") ,
	__tr_no_lookup("The world has stopped ?") ,
	__tr_no_lookup("Everything is allright") ,
	__tr_no_lookup("idle()") ,
	__tr_no_lookup("It's so cold here....") ,
	__tr_no_lookup("Do not disturb...watching tv") ,
	__tr_no_lookup("Just vegetating") ,
	__tr_no_lookup("Hey...are ya sure that your network is up ?") ,
	__tr_no_lookup("Seems like the world has stopped spinning") ,
	__tr_no_lookup("This silence is freaking me out!") ,
	__tr_no_lookup("Mieeeeeowww!") ,
	__tr_no_lookup("idle idle idle idle!")
};

#ifdef COMPILE_KDE_SUPPORT
	extern Time qt_x_time;
#endif

void KviDockWidget::enterEvent( QEvent* )
{
#ifdef COMPILE_KDE_SUPPORT
	if(!g_pApp->focusWidget())
	{
		XEvent ev;
		kvi_memset(&ev, 0, sizeof(ev));
		ev.xfocus.display = qt_xdisplay();
		ev.xfocus.type = XFocusIn;
		ev.xfocus.window = winId();
		ev.xfocus.mode = NotifyNormal;
		ev.xfocus.detail = NotifyAncestor;
		Time time = qt_x_time;
		qt_x_time = 1;
		g_pApp->x11ProcessEvent( &ev );
		qt_x_time = time;
    }
#endif
}

void KviDockWidget::tipRequest(KviDynamicToolTip *tip,const QPoint &pnt)
{
	KviStr tmp;

	KviTaskBarBase * t = m_pFrm->taskBar();

	const char * aux;
	for(KviTaskBarItem * b = t->firstItem();b;b = t->nextItem())
	{
		if(b->highlightLevel() > 0)
		{
			aux = b->window()->lastLineOfText();
			tmp.append(KviStr::Format,"<b>%s</b><br>%s<br><br>\n",b->window()->plainTextCaption(),aux ? aux : __tr("Huh ?"));
		}
	}


	srand(time(0));

	// We use the bad way to generate random numbers :)))))

	if(tmp.isEmpty())tmp = __tr_no_xgettext(idlemsgs[(int)(rand() % NIDLEMSGS)]);

#ifdef COMPILE_ON_WINDOWS

#else
	m_pTip->tip(rect(),tmp.ptr());
#endif
}

//int KviDockWidget::message(int,void *)
//{
//	debug("Message");
//	update();
//	return 0;
//}

void KviDockWidget::mousePressEvent(QMouseEvent *e)
{
	if(e->button() & LeftButton)
	{
		if(m_pFrm->isVisible())m_pFrm->hide();
		else raiseParentFrame();
	} else if(e->button() & RightButton)m_pContextPopup->popup(mapToGlobal(e->pos()));
}

void KviDockWidget::raiseParentFrame()
{
	m_pFrm->show();
	m_pFrm->raise();
	m_pFrm->setFocus();
}

void KviDockWidget::refresh()
{
#ifdef COMPILE_ON_WINDOWS
	int max = 0;


	KviTaskBarBase * t = m_pFrm->taskBar();

	for(KviTaskBarItem * b = t->firstItem();b;b = t->nextItem())
	{
		int iLevel = b->highlightLevel();
		if(iLevel > max)max = iLevel;
	}

	if(max > 5)max = 5;

	if(g_iCurLevel != max)
	{
		setTaskbarIcon((void *)(g_hDock[max]));
		g_iCurLevel = max;
	}

#else
	update();
#endif
}


void KviDockWidget::paintEvent(QPaintEvent *)
{
	int consoles = 0; // 0=nothing , 1=new text , 2=alt text
	int channels = 0;
	int queries  = 0;
	int other    = 0;

	KviTaskBarBase * t = m_pFrm->taskBar();

	// 0=nothing , 1=new text , 2=alt text

	for(KviTaskBarItem * b = t->firstItem();b;b = t->nextItem())
	{
		int iLevel = b->highlightLevel();
		switch(b->window()->type())
		{
			case KVI_WINDOW_TYPE_CONSOLE:
				if((consoles < 2) && (iLevel > 0))consoles = iLevel > 3 ? 2 : 1;
			break;
			case KVI_WINDOW_TYPE_CHANNEL:
				if((channels < 2) && (iLevel > 0))channels = iLevel > 3 ? 2 : 1;
			break;
			case KVI_WINDOW_TYPE_QUERY:
				if((queries < 2) && (iLevel > 0))queries = iLevel > 3 ? 2 : 1;
			break;
			default:
				if((other < 2) && (iLevel > 0))other = iLevel > 3 ? 2 : 1;
			break;
		}
	}

	bitBlt(this,0,0,other ? ((other == 2) ? g_pDock3 : g_pDock2) : g_pDock1,0,0,12,12,Qt::CopyROP,true);
	bitBlt(this,0,12,consoles ? ((consoles == 2) ? g_pDock3 : g_pDock2) : g_pDock1,0,12,12,12,Qt::CopyROP,true);
	bitBlt(this,12,0,queries ? ((queries == 2) ? g_pDock3 : g_pDock2) : g_pDock1,12,0,12,12,Qt::CopyROP,true);
	bitBlt(this,12,12,channels ? ((channels == 2) ? g_pDock3 : g_pDock2) : g_pDock1,12,12,12,12,Qt::CopyROP,true);
}


static KviDockWidget * dockwidget_find(KviFrame *f)
{
	if(!g_pDockWidgetList)return 0;
	for(KviDockWidget * w = g_pDockWidgetList->first();w;w = g_pDockWidgetList->next())
	{
		if(w->frame() == f)return w;
	}
	return 0;
}

/*
	@doc: dockwidget.show
	@type:
		command
	@title:
		dockwidget.show
	@short:
		Shows the dock widget for the current frame window
	@keyterms:
		dock widget , system tray
	@syntax:
		dockwidget.show
	@description:
		Shows the dock widget for the current frame window.[br]
		The dock widget is a small widget that docks in the KDE panel.[br]
		It shows a small icon of the earth and eventually displays four squares
		that cover this icon: the bottom left square appears when there is some new
		text in any console window, the square becomes red if the text is highlighted.[br]
		The bottom right square appears when there is some new text in any channel window,
		and it becomes red when the text is highlighted.[br] The upper right square refers to
		query windows and the upper left one to any other kind of window (dcc , links...).[br]
		If you move the mouse over the dock widget a tooltip will show you the last lines
		of the "new" text in all these windows.[br]
		This is useful when you keep the main KVIrc window minimized and you're working on something else:
		if the dock widget shows nothing but the earth icon , nothing is happening in the main KVIrc window.
		If the dock widget shows one or more white (or red) squares , you can move the mouse over
		and check what's happened exactly and eventually bring up the main KVIrc window by clicking on the widget.[br]
		[big]tecnical details[/big]
		The dock widget is currently working in KDE compilation mode only:
		it relies on the KWin implementation of the Window Manager interaction protocol.
	@seealso:
		[cmd]dockwidget.hide[/doc]
*/

static bool dockwidget_module_command_show(KviModule *m,KviCommand *c)
{
	ENTER_CONTEXT(c,"dockwidget_module_cmd_show");

	KviStr dummy;
	if(!g_pUserParser->parseCmdFinalPart(c,dummy))return false;

	if(!(dockwidget_find(c->window()->frame())))
	{
		KviDockWidget * w = new KviDockWidget(c->window()->frame(),"dock_widget");
#ifndef COMPILE_ON_WINDOWS
		w->show();
#else
		w->hide();
#endif
	}

    return c->leaveContext();
}

/*
	@doc: dockwidget.hide
	@type:
		command
	@title:
		dockwidget.hide
	@short:
		Hides the dock widget for the current frame window
	@syntax:
		dockwidget.hide
	@description:
		Hides the dock widget for the current frame window
	@seealso:
		[cmd]dockwidget.show[/doc]
*/

static bool dockwidget_module_command_hide(KviModule *m,KviCommand *c)
{
	ENTER_CONTEXT(c,"dockwidget_module_cmd_hide");

	KviStr dummy;
	if(!g_pUserParser->parseCmdFinalPart(c,dummy))return false;

	KviDockWidget * w= dockwidget_find(c->window()->frame());
	if(w)delete w;

    return c->leaveContext();
}

/*
	@doc: dockwidget.isvisible
	@type:
		function
	@title:
		$dockwidget.isVisible
	@short:
		Returns the state of the dock widget
	@syntax:
		$reguser.isVisible()
	@description:
		Returns 1 if the dock widget is actually visible , 0 otherwise.
	@seealso:
		[cmd]dockwidget.show[/cmd]
*/

static bool dockwidget_module_function_isvisible(KviModule *m,KviCommand *c,KviParameterList * parms,KviStr &buffer)
{
//	ENTER_CONTEXT(c,"dockwidget_module_fnc_isVisible");
	buffer.append(dockwidget_find(c->window()->frame()) ? '1' : '0');
	return true;
}


// =======================================
// init routine
// =======================================
static bool dockwidget_module_init(KviModule * m)
{
	KviStr buffer;
	g_pApp->findImage(buffer,"kvi_dock.png");

	KviImageLibrary l1(buffer.ptr(),24,24);

	g_pDock1 = new QPixmap(l1.getImage(0));
	g_pDock2 = new QPixmap(l1.getImage(1));
	g_pDock3 = new QPixmap(l1.getImage(2));

#ifdef COMPILE_ON_WINDOWS
	ICONINFO inf;
	for(int i=0;i<6;i++)
	{
		inf.fIcon = true;
		QPixmap * pix = g_pIconManager->getSmallIcon(KVI_SMALLICON_IRC0 + i);
		inf.hbmColor = pix->hbm();
		if(!pix->mask())pix->setMask(pix->createHeuristicMask());
		inf.hbmMask = pix->mask()->hbm();
		g_hDock[i]  = CreateIconIndirect(&inf);
	}
#endif


	g_pDockWidgetList = new KviPtrList<KviDockWidget>;
	g_pDockWidgetList->setAutoDelete(false);

	m->registerCommand("hide",dockwidget_module_command_hide);
 	m->registerCommand("show",dockwidget_module_command_show);
 	m->registerFunction("isVisible",dockwidget_module_function_isvisible);

	return true;
}

static bool dockwidget_module_cleanup(KviModule *m)
{
	while(g_pDockWidgetList->first())delete g_pDockWidgetList->first();
	delete g_pDockWidgetList;

#ifdef COMPILE_ON_WINDOWS
	for(int i=0;i<6;i++)DestroyIcon(g_hDock[i]);
#endif

	delete g_pDock1;
	delete g_pDock2;
	delete g_pDock3;

	m->unregisterMetaObject("KviDockWidget");

	return true;
}

static bool dockwidget_module_can_unload(KviModule *)
{
	return g_pDockWidgetList->isEmpty();
}

// =======================================
// plugin definition structure
// =======================================
KVIMODULEEXPORTDATA KviModuleInfo kvirc_module_info =
{
    "KVIrc dock widget implementation",
	"1.0.0",
	"Szymon Stefanek <stefanek@tin.it>" ,
	"exports the /dockwidget.* interface\n",
    dockwidget_module_init ,
    dockwidget_module_can_unload,
	0,
	dockwidget_module_cleanup
};

#include "libkvidockwidget.moc"
