//
//   File : libkvidirbrowser.cpp
//   Creation date : Sat 09 Sep 2000 06:26:12 CEST by Krzysztof Godlewski
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Krzysztof Godlewski <kristoff@poczta.wprost.pl>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_module.h"
#include "kvi_uparser.h"
#include "kvi_locale.h"
#include "kvi_window.h"
#include "kvi_frame.h"
#include "kvi_config.h"
#include "kvi_iconmanager.h"
#include "kvi_app.h"

#include "dirbrowserwindow.h"
#include "dirbrowserwidget.h"

//#include "db_widget.h"

#include "kvi_list.h"
#include <qsplitter.h>

//#include <stdlib.h>

//KviModule		* g_pDBModule = 0;
KviPtrList<KviDirBrowserWidget>  * g_pDirBrowserWidgetList = 0;
KviPtrList<KviDirBrowserWindow>  * g_pDirBrowserWindowList = 0;
//KviDirBrowserIcons          * g_pDirBrowserIcons = 0;
//KviPtrList<KviDBWidget>	* g_pDBWindowList = 0;

/*
	@doc: dirbrowser.open
	@type:
		command
	@title:
		dirbrowser.open
	@short:
		Enables directory browsing
	@syntax:
		dirbrowser.open [-m] [-n] [path]
	@description:
		Opens the dir browser starting in [path] if it is specified.[br]
		If not, it deaults to your home directory.[br]
		If the -m switch is present the created browser is an MDI 
		window, otherwise it is a static window.[br]
		If the -n switch is present, the window creation is forced even
		though other windows are already there.[br]
		This command is exported by the "dirbrowser" module.
*/

static bool dirbrowser_module_cmd_open(KviModule * m, KviCommand * c)
{
	ENTER_CONTEXT(c, "dirbrowser_module_cmd_open");

	KviStr directory;
	if(!g_pUserParser->parseCmdFinalPart(c,directory))return false;

	if(!c->hasSwitch('n'))
	{
		// look for an already open help widget in this frame
		KviDirBrowserWidget * w = (KviDirBrowserWidget *)c->window()->frame()->child(
			"dir_browser_widget","KviDirBrowserWidget");

		if(w)
		{
			if(directory.hasData())w->browse(directory.ptr());
			else w->home();
			return c->leaveContext();
		}
	}

	if(c->hasSwitch('m'))
	{
		KviDirBrowserWindow *w = new KviDirBrowserWindow(c->window()->frame(),"Directory Browser");
		if(directory.hasData())w->dirbrowserWidget()->browse(directory.ptr());
		else w->dirbrowserWidget()->home();
		c->window()->frame()->addWindow(w);
	} else {
		KviDirBrowserWidget *w = new KviDirBrowserWidget(c->window()->frame()->splitter(),
			c->window()->frame(),true);
		if(directory.hasData())w->browse(directory.ptr());
		else w->home();
		w->show();
	}

	return c->leaveContext();
}



//#warning "We need a fallback icon here!!!"
//
//static void dirbrowser_create_icon(KviConfig * cfg,const char * entry,const char * def,QPixmap ** pPix)
//{
//	KviStr buf = cfg->readEntry(entry,def);
//	KviStr szIm;
//	if(g_pApp->findImage(szIm,buf.ptr()))
//	{
//		QPixmap * p = g_pIconManager->getImage(szIm.ptr());
//		if(p)*pPix = new QPixmap(*p);
//		else {
//			// If we have the unknown pixmap , use it
//			if(g_pDirBrowserIcons->pUnknown)*pPix = new QPixmap(*(g_pDirBrowserIcons->pUnknown));
//			else *pPix = new QPixmap(32,32);
//		}
//	} else {
//		(*pPix) = new QPixmap(32,32);
//	}
//}


static bool dirbrowser_module_init(KviModule * m)
{

	g_pDirBrowserWindowList = new KviPtrList<KviDirBrowserWindow>;
	g_pDirBrowserWindowList->setAutoDelete(false);
	g_pDirBrowserWidgetList = new KviPtrList<KviDirBrowserWidget>;
	g_pDirBrowserWidgetList->setAutoDelete(false);

	m->registerCommand("open", dirbrowser_module_cmd_open);

	return true;
}

static bool dirbrowser_module_cleanup(KviModule * m)
{

	while(g_pDirBrowserWidgetList->first())delete g_pDirBrowserWidgetList->first();
	delete g_pDirBrowserWidgetList;
	while(g_pDirBrowserWindowList->first())g_pDirBrowserWindowList->first()->close();
	delete g_pDirBrowserWindowList;


	m->unregisterMetaObject("KviDirBrowserWidget");
	m->unregisterMetaObject("KviDirBrowserWindow");
	m->unregisterMetaObject("KviFileIconDrag");
	m->unregisterMetaObject("KviDirBrowserIconView");
	
	return true;
}

static bool dirbrowser_module_can_unload(KviModule *)
{
	return (g_pDirBrowserWidgetList->isEmpty() && g_pDirBrowserWindowList->isEmpty());
}

KviModuleInfo kvirc_module_info = 
{
	"KVIrc dir browser",
	"0.1.0",
	"Copyright (C) 2000 Krzysztof Godlewski <kristoff@poczta.wprost.pl>",
	"Provides an integrated directory browser.\n",
	dirbrowser_module_init,
	dirbrowser_module_can_unload,
	0,
	dirbrowser_module_cleanup
};
