//
//   File : dirbrowserwindow.cpp
//   Creation date : Tue Jul 02 2001 17:13:22 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "dirbrowserwindow.h"
#include "dirbrowserwidget.h"

#include "kvi_iconmanager.h"
#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_module.h"

#include <qlineedit.h>

extern KviPtrList<KviDirBrowserWindow> * g_pDirBrowserWindowList;
extern KviPtrList<KviDirBrowserWidget> * g_pDirBrowserWidgetList;

KviDirBrowserWindow::KviDirBrowserWindow(KviFrame * lpFrm,const char * name)
: KviWindow(KVI_WINDOW_TYPE_DIRBROWSER,lpFrm,name)
{
	g_pDirBrowserWindowList->append(this);
	m_pDirBrowserWidget = new KviDirBrowserWidget(this,lpFrm);
	connect(m_pDirBrowserWidget,SIGNAL(directoryChanged()),this,SLOT(directoryChanged()));
	// Ensure proper focusing
	setFocusHandler(m_pDirBrowserWidget->directoryEdit(),this);
}

KviDirBrowserWindow::~KviDirBrowserWindow()
{
	g_pDirBrowserWindowList->removeRef(this);
}

void KviDirBrowserWindow::directoryChanged()
{
	updateCaption();
}

QPixmap * KviDirBrowserWindow::myIconPtr()
{
	return g_pIconManager->getSmallIcon(KVI_SMALLICON_FOLDER);
}

void KviDirBrowserWindow::resizeEvent(QResizeEvent *e)
{
	m_pDirBrowserWidget->setGeometry(0,0,width(),height());
}

QSize KviDirBrowserWindow::sizeHint() const
{
	return m_pDirBrowserWidget->sizeHint();
}
void KviDirBrowserWindow::fillCaptionBuffers()
{
	m_szPlainTextCaption.sprintf(__tr("DirBrowser [%s]"),m_pDirBrowserWidget->currentDirectory());
	m_szHtmlActiveCaption.sprintf(__tr("<nobr><font color=\"%s\"><b>DirBrowser</b></font> <font color=\"%s\">[%s]</font></nobr>"),
		KVI_OPTION_COLOR(KviOption_colorCaptionTextActive).name().ascii(),
		KVI_OPTION_COLOR(KviOption_colorCaptionTextActive2).name().ascii(),m_pDirBrowserWidget->currentDirectory());
	m_szHtmlInactiveCaption.sprintf(__tr("<nobr><font color=\"%s\"><b>DirBrowser</b></font> <font color=\"%s\">[%s]</font></nobr>"),
		KVI_OPTION_COLOR(KviOption_colorCaptionTextInactive).name().ascii(),
		KVI_OPTION_COLOR(KviOption_colorCaptionTextInactive2).name().ascii(),m_pDirBrowserWidget->currentDirectory());
}

#include "m_dirbrowserwindow.moc"
