#ifndef _DIRBROWSERWIDGET_H_
#define _DIRBROWSERWIDGET_H_
//
//   File : dirbrowserwidget.h
//   Creation date : Thu Jul 02 2001 17:09:11 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qtoolbar.h>
#include <qwidget.h>
#include <qiconview.h>
#include <qlabel.h>
#include <qmenubar.h>

#include "kvi_thread.h"


class KviFrame;
class QLineEdit;
class KviThread;


class KviFileIconDrag : public QIconDrag
{
	Q_OBJECT
public:
	KviFileIconDrag(QWidget * dragSource,const char * name = 0);
private:
	QStringList   m_lUrls;
	static KviStr m_szMime1;
	static KviStr m_szMime2;
public:
	const char* format(int i) const;
 	QByteArray encodedData(const char * mime) const;
	static bool canDecode(QMimeSource * e);
	void append(const QIconDragItem &item,const QRect &pr,const QRect &tr,const QString &url);
};

class KviDirBrowserWidget;

class KviDirBrowserIconView : public QIconView
{
	Q_OBJECT
public:
	KviDirBrowserIconView(KviDirBrowserWidget * par,const char * nam);
	~KviDirBrowserIconView();
private:
	KviDirBrowserWidget * m_pDirBrowserWidget;
protected:
	virtual QDragObject * dragObject();
	
};

class KviMediaType;

class KviDirBrowserWidget;


typedef struct _KviDirBrowserData
{
	KviStr         szFileName;
	KviStr         szKey;
	KviMediaType * pMediaType;
} KviDirBrowserData;


class KviDirBrowserThread : public KviSensitiveThread
{
public:
	KviDirBrowserThread(KviDirBrowserWidget * w,const char * szDir);
	~KviDirBrowserThread();
private:
	KviDirBrowserWidget * m_pDirBrowserWidget;
	KviStr m_szDir;
private:
	bool processEvents();
	void processEntry(const char * fName);
public:
	virtual void run();
};

class KviDirBrowserWidget : public QWidget
{
	Q_OBJECT
public:
	KviDirBrowserWidget(QWidget *par,KviFrame * lpFrm,bool bIsStandalone = false);
	~KviDirBrowserWidget();
private:
	QMenuBar                 * m_pMenuBar;
	QToolBar                 * m_pToolBar;
	KviDirBrowserIconView    * m_pIconView;
	QLineEdit                * m_pDirectoryEdit;
	bool                       m_bIsStandalone;
	KviStr                     m_szCurrentDir;
	KviDirBrowserThread      * m_pSlaveThread;
	QLabel                   * m_pStatusLabel;
protected:
	virtual void resizeEvent(QResizeEvent *e);
	void killSlave();
	virtual bool event(QEvent *e);
	void addItem(KviDirBrowserData * data);
	const char * currentDir(){ return m_szCurrentDir.ptr(); };
public slots:
	void cdUp();
	void home();
protected slots:
	void returnPressed();
	void doClose();
	void suicide();
	void itemDoubleClicked(QIconViewItem * it);
signals:
	void directoryChanged();
public:
	const char * currentDirectory(){ return m_szCurrentDir.ptr(); };
	void browse(const char * szDir);
	virtual QSize sizeHint() const;
	QLineEdit * directoryEdit(){ return m_pDirectoryEdit; };
};

#endif //_DIRBROWSERWIDGET_H_
