#ifndef _VOICE_H_
#define _VOICE_H_
//
//   File : voice.h
//   Creation date : Thu Aug 23 04:08:10 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"

#include "kvi_databuffer.h"
#include "kvi_sockettype.h"

#include "codec.h"
#include "broker.h"
#include "thread.h"

#include <qhbox.h>
#include <qlabel.h>
#include <qtoolbutton.h>
#include <qtimer.h>

#ifndef _DCC_VOICE_CPP_
	extern bool kvi_dcc_voice_is_valid_codec(const char * codecName);
#endif

#define KVI_DCC_VOICE_THREAD_ACTION_START_RECORDING 0
#define KVI_DCC_VOICE_THREAD_ACTION_STOP_RECORDING 1
#define KVI_DCC_VOICE_THREAD_ACTION_START_PLAYING 2
#define KVI_DCC_VOICE_THREAD_ACTION_STOP_PLAYING 3

typedef struct _KviDccVoiceThreadOptions
{
	bool               bForceHalfDuplex;
	int                iPreBufferSize;
	int                iSampleRate;
	KviStr             szSoundDevice;
	KviDccVoiceCodec * pCodec;
} KviDccVoiceThreadOptions;

class KviDccVoiceThread : public KviDccThread
{
	friend class KviDccVoice;
public:
	KviDccVoiceThread(KviWindow * wnd,kvi_socket_t fd,KviDccVoiceThreadOptions * opt);
	~KviDccVoiceThread();
protected:
//	bool                       m_bUseGsm;
	KviDccVoiceThreadOptions * m_pOpt;
	int                        m_soundFd;
	int                        m_soundFdMode;
	KviDataBuffer              m_outFrameBuffer;
	KviDataBuffer              m_inFrameBuffer;
	KviDataBuffer              m_inSignalBuffer;
	KviDataBuffer              m_outSignalBuffer;
	bool                       m_bPlaying;
	bool                       m_bRecording;
	bool                       m_bRecordingRequestPending;
	bool                       m_bSoundcardChecked;
	int                        m_iLastSignalBufferSize;
	long                       m_iLastSignalBufferTime;
//	unsigned  int              m_uSleepTime;
	KviMutex                 * m_pInfoMutex;
	// stuff protected by the mutex:
	int                        m_iInputBufferSize;
	int                        m_iOutputBufferSize;
protected:
	bool checkSoundcard();
	bool openSoundcardWithDuplexOption(int openMode,int failMode);
	bool openSoundcard(int mode);
	bool openSoundcardForWriting();
	bool openSoundcardForReading();
	void closeSoundcard();
	bool readWriteStep();
	bool soundStep();
	void startRecording();
	void stopRecording();
	void startPlaying();
	void stopPlaying();
	virtual void run();
};

class KviDccMarshal;
class QSlider;

class KviDccVoice : public KviWindow
{
	Q_OBJECT
public:
	KviDccVoice(KviFrame *pFrm,KviDccBrokerDescriptor * dcc,const char * name);
	~KviDccVoice();
protected:
	KviDccBrokerDescriptor * m_pDescriptor;
	KviDccMarshal          * m_pMarshal;
	QHBox                  * m_pHBox;
	QSlider                * m_pVolumeSlider;
	QLabel                 * m_pInputLabel;
	QLabel                 * m_pOutputLabel;
	QLabel                 * m_pRecordingLabel;
	QLabel                 * m_pPlayingLabel;
	QToolButton            * m_pTalkButton;
	QTimer                 * m_pUpdateTimer;
	KviStr                   m_szTarget;
	KviDccVoiceThread      * m_pSlaveThread;
protected:
	virtual void focusInEvent(QFocusEvent *);
	virtual const char * target();
	virtual void fillCaptionBuffers();
	virtual QPixmap * myIconPtr();
	virtual void resizeEvent(QResizeEvent *e);
	virtual QSize sizeHint() const;
	virtual bool event(QEvent *e);
	virtual void getBaseLogFileName(KviStr &buffer);
	void startTalking();
	void stopTalking();
	int getMixerVolume(void) const;
protected slots:
	void handleMarshalError(int err);
	void connected();
	void updateInfo();
	void startOrStopTalking(bool bStart);
	void setMixerVolume(int);
//	void stopTalking();
};

#endif //_VOICE_H_
