#ifndef _SEND_H_
#define _SEND_H_
//
//   File : send.h
//   Creation date : Tue Sep 24 09 2000 15:06:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"
#include "kvi_string.h"

#include "broker.h"

#include "thread.h"

#include "kvi_sockettype.h"

#include "kvi_list.h"
#include <qlabel.h>
#include <qprogressbar.h>
#include <qpopupmenu.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qfile.h>
#include <time.h>

typedef struct _KviDccSendThreadOptions
{
	KviStr szFileName;
	int    iStartPosition;
	int    iPacketSize;
	int    iIdleStepLengthInMSec;
	bool   bFastSend;
	bool   bNoAcks;
	bool   bIsTdcc;
} KviDccSendThreadOptions;


class KviDccSendThread : public KviDccThread
{
public:
	KviDccSendThread(KviWindow * wnd,kvi_socket_t fd,KviDccSendThreadOptions * opt);
	~KviDccSendThread();
private:
	KviDccSendThreadOptions * m_pOpt;
	// stats: SHARED!!!
	time_t    m_iStartTime;
	int       m_iProgress;
	int       m_iAverageSpeed;
	int       m_iInstantSpeed;
	int       m_iFilePosition;
	int       m_iAckedProgress;
public:
	void initGetInfo();
	int progress(){ return m_iProgress; };
	int averageSpeed(){ return m_iAverageSpeed; };
	int instantSpeed(){ return m_iInstantSpeed; };
	int elapsedTime();
	int filePosition(){ return m_iFilePosition; };
	void doneGetInfo();
	int ackedProgress(){ return m_iAckedProgress; };
protected:
	virtual void run();
};

typedef struct _KviDccRecvThreadOptions
{
	bool   bResume;
	KviStr szFileName;
	int    iTotalFileSize;
	bool   bSendZeroAck;
	bool   bNoAcks;
	bool   bIsTdcc;
} KviDccRecvThreadOptions;

class KviDccRecvThread : public KviDccThread
{
public:
	KviDccRecvThread(KviWindow *wnd,kvi_socket_t fd,KviDccRecvThreadOptions * opt);
	~KviDccRecvThread();
protected:
	KviDccRecvThreadOptions * m_pOpt;

	// stats: SHARED!
	time_t    m_iStartTime;
	int       m_iProgress;
	int       m_iAverageSpeed;
	int       m_iInstantSpeed;
	int       m_iFilePosition;

	// internal
	int       m_iTotalReceivedBytes;
	int       m_iInstantReceivedBytes;
	int       m_iLastInstantCheckTime;
	QFile   * m_pFile;
public:
	void initGetInfo();
	int progress(){ return m_iProgress; };
	int averageSpeed(){ return m_iAverageSpeed; };
	int instantSpeed(){ return m_iInstantSpeed; };
	int elapsedTime();
	int filePosition(){ return m_iFilePosition; };
	void doneGetInfo();
protected:
	void postMessageEvent(const char * msg);
	void updateStats();
	bool sendAck(int filePos);
	virtual void run();
};


class KviDccMarshal;

class KviDccSend : public KviWindow
{
	Q_OBJECT
public:
	KviDccSend(KviFrame *pFrm,KviDccBrokerDescriptor * dcc,const char * name);
	~KviDccSend();
protected:
	KviDccBrokerDescriptor * m_pDescriptor;
	KviDccMarshal          * m_pMarshal;
	KviDccSendThread       * m_pSlaveSendThread;
	KviDccRecvThread        * m_pSlaveRecvThread;
	QProgressBar           * m_pDataProgressBar;
	QProgressBar           * m_pAckProgressBar;
	QLabel                 * m_pFileInfoLabel;
	QLabel                 * m_pElapsedTimeLabel;
	QLabel                 * m_pBytesLabel;
	QLabel                 * m_pAvgSpeedLabel;
	QLabel                 * m_pInstantSpeedLabel;
	QVBox                  * m_pVBox;
	QTimer                 * m_pUpdateTimer;
	KviStr                   m_szTarget;
	KviStr                   m_szDccType;
	QPopupMenu             * m_pFilePopup;
	bool                     m_bRunning;
public:
	bool resumeAccepted(const char * filename,const char * port);
	bool doResume(const char * filename,const char * port,unsigned int filePos);
	bool isRunning(){ return m_bRunning; };
protected:
	virtual void fillContextPopup(QPopupMenu * p);
	virtual const char * target();
	virtual void fillCaptionBuffers();
	virtual QPixmap * myIconPtr();
	virtual void resizeEvent(QResizeEvent *e);
	virtual QSize sizeHint() const;
	virtual bool event(QEvent *e);
	virtual void getBaseLogFileName(KviStr &buffer);
	void startConnection();
protected slots:
	void connectionInProgress();
	void sslError(const char * msg);
	void startingSSLHandshake();
	void handleMarshalError(int err);
	void connected();
	void updateDccRecv();
	void updateDccSend();
	void setupFilePopup();
	void slotOpenFile();
	void slotOpenFolder();
	void slotGuessMediaType();
};


#endif //_SEND_H_
