//
//   File : dialogs.cpp
//   Creation date : Tue Sep 19 09 2000 15:23:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "dialogs.h"

#include "kvi_locale.h"
#include "kvi_iconmanager.h"
#include "kvi_app.h"

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qstringlist.h>

KviDccBox::KviDccBox(KviDccBroker * br,KviDccBrokerDescriptor * dcc)
{
	m_pDescriptor = dcc;
	m_pBroker = br;
}

KviDccBox::~KviDccBox()
{
	if(m_pDescriptor)delete m_pDescriptor;
	m_pDescriptor = 0;
	m_pBroker->unregisterDccBox(this);
}

void KviDccBox::forgetDescriptor()
{
	m_pDescriptor = 0;
}

KviDccAcceptBox::KviDccAcceptBox(KviDccBroker * br,KviDccBrokerDescriptor * dcc,const char * text,const char * capt)
: QWidget(0,"dcc_accept_box") , KviDccBox(br,dcc)
{
	QGridLayout * g = new QGridLayout(this,2,2,4,4);
	QLabel * l = new QLabel(text,this);
	g->addMultiCellWidget(l,0,0,0,1);
	QPushButton * btn = new QPushButton(__tr("Reject"),this);
	g->addWidget(btn,1,0);
	connect(btn,SIGNAL(clicked()),this,SLOT(rejectClicked()));
	btn = new QPushButton(__tr("Accept"),this);
	btn->setDefault(true);
	g->addWidget(btn,1,1);
	connect(btn,SIGNAL(clicked()),this,SLOT(acceptClicked()));
	btn->setFocus();

	setIcon(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_DCCMSG)));
	setCaption(capt);
}

KviDccAcceptBox::~KviDccAcceptBox()
{
}

void KviDccAcceptBox::acceptClicked()
{
	hide();
	emit accepted(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}

void KviDccAcceptBox::rejectClicked()
{
	hide();
	emit rejected(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}

void KviDccAcceptBox::closeEvent(QCloseEvent *e)
{
	hide();
	e->ignore();
	emit rejected(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}

void KviDccAcceptBox::showEvent(QShowEvent *e)
{
	move((g_pApp->desktop()->width() - width()) >> 1,
		(g_pApp->desktop()->height() - height()) >> 1);
	QWidget::showEvent(e);
}



KviDccSaveFileBox::KviDccSaveFileBox(KviDccBroker * br,KviDccBrokerDescriptor * dcc)
: KviFileDialog(QString::null,QString::null,0,"dcc_save_file_box") , KviDccBox(br,dcc)
{
	setShowHiddenFiles(true);
	setMode(QFileDialog::AnyFile);

	setIcon(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_DCCMSG)));
	setCaption(__tr("Choose the save file name"));
	setDir(QDir(dcc->szLocalFileName.ptr()));
	dcc->szLocalFileName = "";
	setSelection(dcc->szFileName.ptr());
}

KviDccSaveFileBox::~KviDccSaveFileBox()
{
}

void KviDccSaveFileBox::closeEvent(QCloseEvent *e)
{
	hide();
	e->ignore();
	emit rejected(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}

void KviDccSaveFileBox::accept()
{
	hide();
	m_pDescriptor->szLocalFileName = selectedFile();
	m_pDescriptor->szLocalFileName.stripWhiteSpace();
	if(m_pDescriptor->szLocalFileName.isEmpty())
		emit rejected(this,m_pDescriptor);
	else
		emit accepted(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}

void KviDccSaveFileBox::reject()
{
	hide();
	emit rejected(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}

void KviDccSaveFileBox::showEvent(QShowEvent *e)
{
	move((g_pApp->desktop()->width() - width()) >> 1,
		(g_pApp->desktop()->height() - height()) >> 1);
	KviFileDialog::showEvent(e);
}



KviDccLoadFileBox::KviDccLoadFileBox(KviDccBroker * br,KviDccBrokerDescriptor * dcc)
: KviFileDialog(QString::null,QString::null,0,"dcc_load_file_box") , KviDccBox(br,dcc)
{
	setShowHiddenFiles(true);
	setMode(QFileDialog::ExistingFiles);

	setIcon(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_DCCMSG)));
	setCaption(__tr("Choose the files to send"));
	KviStr tmp;
	g_pApp->getLocalKvircDirectory(tmp,KviApp::Incoming);
	setDir(QDir::homeDirPath());
}

KviDccLoadFileBox::~KviDccLoadFileBox()
{
}

void KviDccLoadFileBox::accept()
{
	hide();
	QStringList l = selectedFiles();

	if(l.count() > 1)
	{
		KviDccBrokerDescriptor * d;
		KviDccBrokerDescriptor * templ = m_pDescriptor;
		QStringList::Iterator it=l.begin();
		while(it != l.end())
		{
			d = new KviDccBrokerDescriptor;
			KviDccBroker::copyDescriptor(d,templ);
			d->szLocalFileName = *(it);
			d->szLocalFileName.stripWhiteSpace();
			++it;
			if(d->szLocalFileName.isEmpty())emit rejected((it == l.end()) ? this : 0,d);
			else emit accepted((it == l.end()) ? this : 0,d);
		}
		delete templ; // We loose the original
		m_pDescriptor = 0;
	} else {
		if(l.count() > 0)
		{
			m_pDescriptor->szLocalFileName = *(l.begin());
			m_pDescriptor->szLocalFileName.stripWhiteSpace();
			if(m_pDescriptor->szLocalFileName.isEmpty())emit rejected(this,m_pDescriptor);
			else emit accepted(this,m_pDescriptor);

		} else emit rejected(this,m_pDescriptor);
	}
	g_pApp->collectGarbage(this);
}

void KviDccLoadFileBox::reject()
{
	hide();
	emit rejected(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}

void KviDccLoadFileBox::closeEvent(QCloseEvent *e)
{
	hide();
	e->ignore();
	emit rejected(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}

void KviDccLoadFileBox::showEvent(QShowEvent *e)
{
	move((g_pApp->desktop()->width() - width()) >> 1,
		(g_pApp->desktop()->height() - height()) >> 1);
	KviFileDialog::showEvent(e);
}




KviDccRenameBox::KviDccRenameBox(KviDccBroker * br,KviDccBrokerDescriptor * dcc,const char * text)
: QWidget(0,"dcc_rename_box") , KviDccBox(br,dcc)
{
	QGridLayout * g = new QGridLayout(this,2,4,4,4);
	QLabel * l = new QLabel(text,this);
	g->addMultiCellWidget(l,0,0,0,3);

	QPushButton * btn = new QPushButton(__tr("Rename"),this);
	g->addWidget(btn,1,0);
	connect(btn,SIGNAL(clicked()),this,SLOT(renameClicked()));

	btn = new QPushButton(__tr("Overwrite"),this);
	g->addWidget(btn,1,1);
	connect(btn,SIGNAL(clicked()),this,SLOT(overwriteClicked()));

	btn = new QPushButton(__tr("Resume"),this);
	g->addWidget(btn,1,2);
	connect(btn,SIGNAL(clicked()),this,SLOT(resumeClicked()));

	btn = new QPushButton(__tr("Cancel"),this);
	g->addWidget(btn,1,3);
	connect(btn,SIGNAL(clicked()),this,SLOT(cancelClicked()));
	btn->setDefault(true);
	btn->setFocus();

	setIcon(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_DCCMSG)));
	setCaption(__tr("DCC: File already existing"));
}

KviDccRenameBox::~KviDccRenameBox()
{
}

void KviDccRenameBox::closeEvent(QCloseEvent *e)
{
	hide();
	e->ignore();
	emit cancelSelected(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}

void KviDccRenameBox::showEvent(QShowEvent *e)
{
	move((g_pApp->desktop()->width() - width()) >> 1,
		(g_pApp->desktop()->height() - height()) >> 1);
	QWidget::showEvent(e);
}

void KviDccRenameBox::renameClicked()
{
	hide();
	emit renameSelected(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}

void KviDccRenameBox::overwriteClicked()
{
	hide();
	emit overwriteSelected(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}

void KviDccRenameBox::resumeClicked()
{
	hide();
	m_pDescriptor->bResume = true;
	emit overwriteSelected(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}

void KviDccRenameBox::cancelClicked()
{
	hide();
	emit cancelSelected(this,m_pDescriptor);
	g_pApp->collectGarbage(this);
}




#include "m_dialogs.moc"
