#ifndef _BROKER_H_
#define _BROKER_H_
//
//   File : broker.h
//   Creation date : Tue Sep 19 09 2000 10:20:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"
#include "kvi_list.h"

#include <qobject.h>

class KviConsole;
class KviDccBroker;

class KviWindow;
//#ifdef COMPILE_ON_WINDOWS
//	typedef struct _KviDccBrokerDescriptor KviDccBrokerDescriptor;
//	#include "dialogs.h"
//#else
	class KviDccBox;
//#endif



// passive = 
// active  = 

typedef struct _KviDccBrokerDescriptor
{
	// Generic parameters
	KviStr         szType;            // DCC type : CHAT , SCHAT , SEND , TSSEND....

	KviConsole   * pConsole;          // console relative to the irc context

	bool           bActive;           // active or passive connection ?

	KviStr         szNick;            // remote user nickname
	KviStr         szUser;            // remote user name (unknown for passive dcc)
	KviStr         szHost;            // remote user host (unknown for passive dcc)

	KviStr         szLocalNick;       // local user nickname (always from irc)
	KviStr         szLocalUser;       // local user username (always from irc)
	KviStr         szLocalHost;       // local user hostname (always from irc)

	KviStr         szIp;              // remote user ip (active dcc only)
	KviStr         szPort;            // remote user port (active dcc only)

	KviStr         szListenIp;        // passive only : ip to listen on
	KviStr         szListenPort;      // passive only : port to listen on

	bool           bSendRequest;      // passive only : true if we have to send the CTCP request

	KviStr         szFakeIp;          // passive only : fake ip to send in the CTCP
	KviStr         szFakePort;        // passive only : fake port to send in the CTCP

	bool           bDoTimeout;        // the marshall has to setup a timeout ?

	bool           bIsTdcc;           // is this a TDCC ?

	bool           bOverrideMinimize; // Override the default minimize option ?
	bool           bShowMinimized;    // Show minimized ? (valid if bOverrideMinimize is true)

	bool           bAutoAccept;       // Auto accepted dcc send/chat ?
#ifdef COMPILE_SSL_SUPPORT
	bool           bIsSSL;            // do we have to use SSL ?
#endif
	// Specific parameters

	// DCC SEND/RECV

	KviStr         szFileName;        // RECVFILE: incoming file name, SENDFILE: filename sent to the remote end
	KviStr         szFileSize;        // RECVFILE: incoming file size

	KviStr         szLocalFileName;   // RECVFILE: save file name selected, SENDFILE: file to send
	KviStr         szLocalFileSize;   // RECVFILE: local file size (to resume), SENDFILE: file to send size

	bool           bRecvFile;         // do we have to RECEIVE the file or SEND it ?

	bool           bResume;           // do we want to resume ?
	bool           bNoAcks;           // blind dcc send ? (do not receive nor send acknowledges)

	bool           bIsIncomingAvatar; // It is an Incoming Avatar DCC SEND ?

	// DCC VOICE

	KviStr         szCodec;           // codec name
	int            iSampleRate;       // Sample rate

} KviDccBrokerDescriptor;


class KviDccBroker : public QObject
{
	Q_OBJECT
public:
	KviDccBroker();
	~KviDccBroker();
protected:
	KviPtrList<KviDccBox>         * m_pBoxList;
	KviPtrList<KviWindow>         * m_pDccWindowList;
public:
	static void copyDescriptor(KviDccBrokerDescriptor * dst,KviDccBrokerDescriptor * src);

	unsigned int runningDccSendTransfersCount(); // the number of dcc SEND (GET , RECV etc..) transfers
	unsigned int terminatedDccSendTransfersCount();
	unsigned int dccWindowsCount(){ return m_pDccWindowList->count(); };
	unsigned int dccBoxCount(){ return m_pBoxList->count(); };
//	void killBox(KviDccBox * box);

	void unregisterDccBox(KviDccBox * box);
	void unregisterDccWindow(KviWindow *dcc);

	void rsendManage(KviDccBrokerDescriptor * dcc);
	void rsendAskForFileName(KviDccBrokerDescriptor * dcc);

	void activeChatManage(KviDccBrokerDescriptor * dcc);
	void passiveChatExecute(KviDccBrokerDescriptor * dcc);

	void activeCanvasManage(KviDccBrokerDescriptor * dcc);
	void passiveCanvasExecute(KviDccBrokerDescriptor * dcc);

	void activeVoiceManage(KviDccBrokerDescriptor * dcc);
	void passiveVoiceExecute(KviDccBrokerDescriptor * dcc);

	void recvFileManage(KviDccBrokerDescriptor * dcc);
	void sendFileManage(KviDccBrokerDescriptor * dcc);

	bool handleResumeAccepted(const char * filename,const char * port);
	bool handleResumeRequest(const char * filename,const char * port,unsigned int filePos);

public slots:
	void rsendExecute(KviDccBox * box,KviDccBrokerDescriptor * dcc);

	void activeChatExecute(KviDccBox * box,KviDccBrokerDescriptor * dcc);
	void activeCanvasExecute(KviDccBox * box,KviDccBrokerDescriptor * dcc);
	void activeVoiceExecute(KviDccBox * box,KviDccBrokerDescriptor * dcc);

	void sendFileExecute(KviDccBox * box,KviDccBrokerDescriptor * dcc);
	void recvFileExecute(KviDccBox * box,KviDccBrokerDescriptor * dcc);


	void chooseSaveFileName(KviDccBox *box,KviDccBrokerDescriptor * dcc);
	void renameOverwriteResume(KviDccBox *box,KviDccBrokerDescriptor * dcc);
	void renameDccSendFile(KviDccBox *box,KviDccBrokerDescriptor * dcc);

	void cancelDcc(KviDccBox *box,KviDccBrokerDescriptor * dcc);

	void closeAllTerminatedDccSendTransfers();
public:
	bool canUnload();
};

#endif
