//
//   File : libkvichannelsjoin.cpp
//   Creation date : Thu Nov 06 2001 12:30:25 CEST by Juanjo lvarez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_module.h"
#include "kvi_uparser.h"

#include "channelsjoinwindow.h"
#include "kvi_window.h"
#include "kvi_frame.h"
#include "kvi_locale.h"
#include "kvi_config.h"

#include <qsplitter.h>

KviChannelsJoinWindow * g_pChannelsWindow = 0;
QRect                   g_rectChannelsJoinGeometry;

/*
 	@doc: channelsjoin.open
	@type:
		command
	@title:
		channelsjoin.open
	@short:
		Opens a window to join channels
	@syntax:
		channelsjoin.open [-t]
	@description:
		Shows a dialog that allows the user to enter channels in a visual manner.[br]
		If the [-t] switch is used, the dialog is opened as toplevel window,
		otherwise it is opened as part of the current frame window.[br]
		This command is exported by the "channelsjoin" module.
 
  */

static bool channelsjoin_module_cmd_open(KviModule *m,KviCommand *c) 
{
	ENTER_CONTEXT(c,"channelsjoin_module_cmd_open");

	KviStr dummy;
	if(!g_pUserParser->parseCmdFinalPart(c,dummy))return false;

	if(g_pChannelsWindow) 
	{
		if(c->hasSwitch('t'))
		{
			if(g_pChannelsWindow->parent())
			{
				g_pChannelsWindow->reparent(0,QPoint(0,0),true);
			}
		} else {
			if(g_pChannelsWindow->parent() != c->window()->frame()->splitter())
			{
				g_pChannelsWindow->reparent(c->window()->frame()->splitter(),QPoint(0,0),true);
			}
		}
	} else {
		g_pChannelsWindow = new KviChannelsJoinWindow(
				c->hasSwitch('t') ? 0 : c->window()->frame()->splitter(), "channelsjoin");		
	}
	
	g_pChannelsWindow->show();
	g_pChannelsWindow->raise();
	g_pChannelsWindow->setFocus();

	return c->leaveContext();
}

static bool channelsjoin_module_init(KviModule * m)
{
	KviStr fName;
	m->getDefaultConfigFileName(fName);
	KviConfig cfg(fName.ptr());

	g_rectChannelsJoinGeometry = cfg.readRectEntry("geometry",QRect(30,30,286,398));
	
	m->registerCommand("open",channelsjoin_module_cmd_open);
	return true;
}

static bool channelsjoin_module_cleanup(KviModule *m)
{
	KviStr fName;
	m->getDefaultConfigFileName(fName);
	KviConfig cfg(fName.ptr());

	cfg.writeEntry("geometry",g_rectChannelsJoinGeometry);
	
	if (g_pChannelsWindow)delete g_pChannelsWindow;		
	g_pChannelsWindow = 0;
	m->unregisterMetaObject("KviChannelsJoinWindow");
	return true;
}

static bool channelsjoin_module_can_unload(KviModule *m)
{
	return (!g_pChannelsWindow);
}

KVIMODULEEXPORTDATA KviModuleInfo kvirc_module_info=
{
	"ChannelsJoin",
	"0.0.2",
	"Copyright (C) 2001-2002 Juan Jos lvarez (juanjux@yahoo.es)",
	"Window to join channels in a GUI",
	channelsjoin_module_init,
	channelsjoin_module_can_unload,
	0,
	channelsjoin_module_cleanup
};
	
		
