//
//   File : channelsjoinwindow.cpp
//   Creation date : Thu Nov 6 2001 12:41:18 by Juanjo lvarez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the linkss of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "channelsjoinwindow.h"

#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_selectors.h"
#include "kvi_app.h"
#include "kvi_uparser.h"
#include "kvi_string.h"

#include <qhbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

extern KviChannelsJoinWindow * g_pChannelsWindow;
extern QRect                   g_rectChannelsJoinGeometry;

KviChannelsJoinWindow::KviChannelsJoinWindow(QWidget * par, const char * name) 
: QWidget(par, name)	
{
	QGridLayout * g = new QGridLayout(this,8,3,4,4);
	
	QLabel * l = new QLabel(__tr("Channel:"), this);
	g->addWidget(l,0,0);

	m_pChannelEdit = new QLineEdit(this); 
	g->addWidget(m_pChannelEdit,1,0);
	connect(m_pChannelEdit,SIGNAL(returnPressed()), this, SLOT(editReturnPressed()));

	QListBox * m_pRecentListBox = new QListBox(this);
	m_pRecentListBox->setMinimumHeight(200); 
	g_pApp->fillRecentChannelsListBox(m_pRecentListBox);
	g->addWidget(m_pRecentListBox,3,0);
	connect(m_pRecentListBox,SIGNAL(clicked(QListBoxItem *)),this,SLOT(itemClicked(QListBoxItem *)));
	connect(m_pRecentListBox,SIGNAL(doubleClicked(QListBoxItem *)), this,SLOT(itemDoubleClicked(QListBoxItem *)));

	l = new QLabel(__tr("Password:"), this);
	g->addWidget(l,4,0);

	m_pPass = new QLineEdit(this);
	m_pPass->setEchoMode(QLineEdit::Password);
	g->addWidget(m_pPass,5,0);

	m_pShowAtStartupCheck = new QCheckBox(__c2q(__tr("Show after connection to a server")),this);
	m_pShowAtStartupCheck->setChecked(KVI_OPTION_BOOL(KviOption_boolShowChannelsJoinOnIrc));
	g->addWidget(m_pShowAtStartupCheck, 6, 0);

//	m_pCloseAfterJoinCheck = new QCheckBox(__c2q(__tr("Close after joining")),this);
//	m_pCloseAfterJoinCheck->setChecked(KVI_OPTION_BOOL(KviOption_boolCloseChannelsJoinAfterJoin));
//	g->addWidget(m_pCloseAfterJoinCheck, 7, 0);

	QHBox * h = new QHBox(this);
	h->setSpacing(4);

	QPushButton * joinButton = new QPushButton(__c2q(__tr("Join")), h);
	connect(joinButton,SIGNAL(clicked()),this,SLOT(joinClicked()));

	QPushButton * cancelButton = new QPushButton(__c2q(__tr("Close")), h);
	cancelButton->setDefault(true);
	connect(cancelButton,SIGNAL(clicked()),this,SLOT(cancelClicked()));

	g->addWidget(h,7,0);

	QHBox * hb = new QHBox(this);
	hb->setSpacing(4);
	
	QPushButton * namesButton = new QPushButton("/names", hb);
	connect(namesButton,SIGNAL(clicked()),this,SLOT(namesClicked()));
	QPushButton * whoButton = new QPushButton("/who", hb);
	connect(whoButton,SIGNAL(clicked()),this,SLOT(whoClicked()));

	g->addWidget(hb,2,0);

	if(!par)
	{
		if(g_rectChannelsJoinGeometry.y() < 5)
			g_rectChannelsJoinGeometry.setY(5);

		resize(g_rectChannelsJoinGeometry.width(),g_rectChannelsJoinGeometry.height());
		move(g_rectChannelsJoinGeometry.x(),g_rectChannelsJoinGeometry.y());
	}
}

KviChannelsJoinWindow::~KviChannelsJoinWindow()
{
	KVI_OPTION_BOOL(KviOption_boolShowChannelsJoinOnIrc) = m_pShowAtStartupCheck->isChecked();
//	KVI_OPTION_BOOL(KviOption_boolCloseChannelsJoinAfterJoin) = m_pCloseAfterJoinCheck->isChecked();
	if(!parent())g_rectChannelsJoinGeometry = QRect(pos().x(),pos().y(),size().width(),size().height());
	g_pChannelsWindow = 0;
}

void KviChannelsJoinWindow::itemClicked(QListBoxItem * it) 
{
	if (it == 0)return;
	KviStr tmp = it->text();
	m_pChannelEdit->setText(tmp.ptr());
}

void KviChannelsJoinWindow::cancelClicked()
{
	delete this;
}

void KviChannelsJoinWindow::joinClicked()
{
	KviStr pass = m_pPass->text();
	KviStr tmp = m_pChannelEdit->text();
	if (pass.isEmpty())doCmd("join", tmp.ptr());
	else doCmd("join", tmp.ptr(), pass.ptr());
//	if(KVI_OPTION_BOOL(KviOption_boolCloseChannelsJoinAfterJoin))
//		delete this;
}

void KviChannelsJoinWindow::whoClicked()
{
	KviStr tmp = m_pChannelEdit->text();
	if(!tmp.isEmpty())doCmd("who", tmp.ptr());
}

void KviChannelsJoinWindow::namesClicked()
{
	KviStr tmp = m_pChannelEdit->text();
	//FIXME: I must be a nice guy and implement /names in the core...
	if(!tmp.isEmpty())doCmd("raw names", tmp.ptr());
}

void KviChannelsJoinWindow::itemDoubleClicked(QListBoxItem * it)
{
	if (it == 0)return;
	KviStr tmp = it->text();
	doCmd("join", tmp.ptr());
//	if(KVI_OPTION_BOOL(KviOption_boolCloseChannelsJoinAfterJoin))
//		g_pApp->collectGarbage(this);
}

void KviChannelsJoinWindow::editReturnPressed()
{
	KviStr tmp = m_pChannelEdit->text();
	if (!tmp.isEmpty())doCmd("join", tmp.ptr());
//	if(KVI_OPTION_BOOL(KviOption_boolCloseChannelsJoinAfterJoin))delete this;
}	

void KviChannelsJoinWindow::closeEvent(QCloseEvent *e)
{
	e->ignore();
	delete this;
}

void KviChannelsJoinWindow::doCmd(const char * cmd, const char * channel, const char * pass)
{
	KviStr command;
    command.sprintf("%s %s %s",cmd, channel, pass ? pass : "");
    g_pUserParser->parseCommandBuffer(command.ptr(),g_pApp->activeWindow());
}
#include "m_channelsjoinwindow.moc"
