//
//   File : kvi_about.cpp
//   Creation date : Tue Jul 6 1999 03:54:25 by Szymon Stefanek
//   Last major modification : Tue Dec 05 2000 06:00:00 by Christian Strmmen
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Till Bush (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_module.h"
//#include "kvi_debug.h"
#include "kvi_locale.h"
//#include "kvi_app.h"
//#include "kvi_string.h"
#include "kvi_uparser.h"
//#include "kvi_iconmanager.h"
//#include "kvi_settings.h"

#include "aboutdialog.h"

//#include "libkviabout.h"
/*
#include <qscrollview.h>
#include <qpalette.h>
#include <qlayout.h>
#include <qtimer.h>
#include <qpushbutton.h>
#include <qbitmap.h>
#include <qpainter.h>

#include <qsimplerichtext.h>
*/

//KviDlgAbout * g_pAboutDialog = 0;

//KviDlgBuildInfo * g_pBuildInfoDialog = 0;

//KviModule   * g_pAboutModule = 0;

KviAboutDialog * g_pAboutDialog = 0;

//extern KVIRC_API KviIconManager	* g_pIconManager;
/*
static char * g_szAboutText = "<center>\n" \
"<font color=\"#FFFFFF\" face=\"helvetica\" size=\"2\">\n" \
"<font color=\"#FF2020\"><h2>The KVIrc staff</h2></font><br>\n" \
"<br>\n" \
"<b>This is a small list<br>\n" \
"of people that have contributed<br>\n" \
"in some way to the KVIrc project</b><br>\n" \
"<font size=\"2\">(in a pseudo-random order at this point)</font><br>\n" \
"<br>\n" \
"<font size=\"3\"><b>\"Honor and Glory\" to\n:</b></font><br>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Szymon <font color=\"#FFA000\">'Pragma@OpenProjects\\IRCNet'</font> Stefanek</b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[pragma@kvirc.net]" \
	"</b></font><br>\n" \
		"The \"creator\" of KVirc<br>\n" \
		"Mental work, hand work,<br>\n" \
		"eyes consuming and coffee drinking<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"i'll check ... lemme check\"<br>\n" \
		"\"i'll fix it tomorrow\"<br>\n" \
		"\"KVIrc : the client that can't make coffee\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Christian <font color=\"#FFA000\">'Number1@Undernet\\OpenProjects'</font> Strmmen</b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[number1@realityx.net]" \
	"</b></font><br>\n" \
		"Makes sure that nobody is lazy, bug-hunter, a LOT of suggestions and maker of RealityX IRC<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
                "\"Pragma: could you add these<br>\n" \
                "functions: $rubmyback() and<br>\n" \
                "$makecoffe() ?\"<br>\n" \
		"\"Skydiving is almost as exciting<br>\n" \
		"as KVIrc scripting !\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Krzysztof <font color=\"#FFA000\">'Kristoff@OpenProjects\\IRCNet'</font> Godlewski</b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[kristoff@poczta.wprost.pl]" \
	"</b></font><br>\n" \
		"Official polish beer provider\n" \
		"and plugin developer :)<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"echo \"STOP IT\" > /dev/neighbour\"<br>\n" \
		"\"cd ./neighbour && make clean\"<br>\n" \
		"\"Pragma...erm...bugs ? WHAT bugs ? ;))\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Jan <font color=\"#FFA000\">'istari@IrcNet\\OpenProjects'</font> Wagner</b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[istari@kvirc.net]" \
	"</b></font><br>\n" \
		"Bughunter, webmaster, snapshot maintainer,\n" \
		"support gay^Wguy :o) and the man that gives,\n" \
		"you KVIrc through IPv6.<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Andrew <font color=\"#FFA000\">'Drosha@Undernet'</font> Frolov</b></font><br>\n" \
		"Beta testing<br>\n" \
		"Ideator of <u><font color=\"#9090FF\">www.kvirc.org</font></u><br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"This free project is better that shareware\n" \
		"mIrc for windows even in alpha stage\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>RAD Kade 1</b></font><br>\n" \
		"Debugging and improvements<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"I'm just *really* good at doing things\n" \
		"when I have no idea of what I'm actually doing\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Fritz <font color=\"#FFA000\">'KNFritz@IRCNet'</font> Elfert</b></font><br>\n" \
		"Improvements of KVIrc code<br>\n" \
		"and of my linux knowledge...<br>\n" \
		"I like to think of him as a 'spiritual guide'...<br>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Olle <font color=\"#FFA000\">'Crocodile@OpenProjects'</font> Hallnas</b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[olle@xmms.org]" \
	"</b></font><br>\n" \
		"\"The open hand\" for the KVIrc project.<br>\n" \
		"Provider of the CVS service, www & ftp mirrors\n" \
		"great ideas and fun while coding<br>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>BuTi <font color=\"#FFA000\">'BuTi@IRCNet\\OpenProjects'</font></b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[buti@geocities.com]" \
	"</b></font><br>\n" \
		"Some \"tiny\" pieces of code...<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"but it _should_ work...\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Luk <font color=\"#FFA000\">'Balboy@OpenProjects'</font> De Ketelaere</b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[balboy@skynet.be]" \
	"</b></font><br>\n" \
		"Help in documentation and bug-searching..<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"no idea what you're talking about... or why you need it :)\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Charles <font color=\"#FFA000\">'Njaard@OpenProjects'</font> Samuels</b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[charles@altair.dhs.org]" \
	"</b></font><br>\n" \
		"The KDE man! Making sure that KVirc has a reason to have a K in the beginning<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"Could I please make KVirc a pure KDE application today?? Pleeease...\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Nick <font color=\"#FFA000\">'Error403@OpenProjects'</font> Betcher</b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[nbetcher@real-time.com]" \
	"</b></font><br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"&lt;Error403&gt; Number1: I imagined you looking crazy :)\"<br>\n" \
		"\"&lt;NumeroUno&gt; I was drunk\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Andrea <font color=\"#FFA000\">'YaP@IRCNet\\OpenProjects'</font> Parrella</b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[anandrea@iname.com]" \
	"</b></font><br>\n" \
		"Official bug hunter,<br>\n" \
		"plugin developer<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"why you haven't implemented a class like\n" \
		"DoEverythingByYourself ? :)\"<br>\n" \
		"\"&lt;Pragma&gt; a wonderful recursive function :)<br>\n" \
		"&lt;YaP&gt; Damn...I knew it eheheheheh\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>rn <font color=\"#FFA000\">'oehansen@Undernet'</font> E. Hansen</b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[oe.hansen@gamma.telenordia.se]" \
	"</b></font><br>\n" \
		"The official C++ manual,\n" \
		"and plugin developer<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"prepare yourselves..<br>\n" \
		"#include &lt;iostream.h&gt;<br>\n" \
		"class testing {...\"<br>\n" \
		"\"&lt;oehansen&gt; I must admit, I'm getting confused :-)<br>\n" \
		"&lt;Pragma&gt; Me too , at this point :)\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Anodine <font color=\"#FFA000\">'[Anodine]@EFNet'</font></b></font><br>\n" \
		"Various funky improvements<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"I can program anything\n" \
		"I set my mind to!\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Ted <font color=\"#FFA000\">'alch3m1st@IRCNet'</font> Podgurski</b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[tedp@toocool.com]" \
	"</b></font><br>\n" \
		"Test scripter, official bug hunter,<br>\n" \
		"ideator & creator of <u><font color=\"#9090FF\">www.kvirc.net</font></u><br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"whassup ?\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Christopher <font color=\"#FFA000\">'CGabriel@IRCNet'</font> R. Gabriel</b></font><br>\n" \
	"<font color=\"#4545FF\"><b>" \
		"[cgabriel@linux.it]" \
	"</b></font><br>\n" \
		"The 'light' inside the GNU clouds<br>\n" \
		"Generic (??!) official project supporter :)<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"Pragma: seems that kvirc with all its plugins is becoming a desktop environment\"<br>\n" \
		"\"echo espresso > /dev/coffee\"<br>\n" \
		"\"Pragma: you reached the user limit. WTF!\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Diabl0 <font color=\"#FFA000\">'Diabl0@IRCNet'</font></b></font><br>\n" \
		"Beta testing, bugs hunting<br>\n" \
		"also a great source for new ideas<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"Bus report...\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>Paul <font color=\"#FFA000\">'infected@IRCNet'</font> Boehm</b></font><br>\n" \
		"Beta testing ,<br>\n" \
		"language structure improvements<br>\n" \
	"<font color=\"#E0E0E0\"><i>\n" \
		"\"...it's enough for 100 IPs per meter\n" \
		"on earth, so every lightswitch can have\n" \
		"its own IP...then you telnet to your lightswitch\n" \
		"and turn it off!\"<br>\n" \
	"</i></font>\n" \
"<br>\n" \
"\n" \
	"<font color=\"#FFFF00\"><b>munehiro <font color=\"#FFA000\">'munehiro@IRCNet'</font></b></font><br>\n" \
		"Italian translations, code improvements and many useful suggestions<br>\n" \
"<br>\n" \

    "<font color=\"#FFFF00\"><b>Juanjo <font color=\"#FFA000\">'Kane@Terra\\OpenProjects'</font> lvarez</b></font><br>\n" \
    "<font color=\"#4545FF\"><b>" \
        "[juanjux@yahoo.es]" \
    "</b></font><br>\n" \
        "Away system, colored nicks, general programming, spanish translantation<br>\n" \
    "<font color=\"#E0E0E0\"><i>\n" \
                "\"Pragma: think of KVIrc as a tool for scripters... we have to left them something to do :)\n" \
    "</i></font>\n" \
"<br>\n" \
"<br>\n" \
"<br>\n" \
"<br>\n" \
"<font color=\"#FFFF00\"><b>KVIrc public releases :</b></font><br>\n" \
"<br>\n" \
"<font color=\"#FF0000\">0.9.0</font><br>\n" \
"<font size=\"2\" color=\"#808080\">Release date: 25.01.1999</font><br>\n" \
"<br>\n" \
"<font color=\"#FF0000\">1.0.0 'Millennium'</font><br>\n" \
"<font size=\"2\">\"The net in your hands\"</font><br>\n" \
"<font size=\"2\" color=\"#808080\">Release date: 21.12.1999</font><br>\n" \
"<br>\n" \
"<font color=\"#FF0000\">2.0.0 'Phoenix'</font><br>\n" \
"<font size=\"2\">\"The client that can't make coffee\"</font><br>\n" \
"<font size=\"2\" color=\"#808080\">Release date: 30.05.2000</font><br>\n" \
"<br>\n" \
"<font color=\"#FF0000\">2.1.0 'Dark Star'</font><br>\n" \
"<font size=\"2\">\"The client that can't make coffee\"</font><br>\n" \
"<font size=\"2\" color=\"#808080\">Release date: 30.01.2001</font><br>\n" \
"<br>\n" \
"<font color=\"#FF0000\">2.1.1 'Monolith'</font><br>\n" \
"<font size=\"2\">\"A breath of fresh net\"</font><br>\n" \
"<font size=\"2\" color=\"#808080\">Release date: 01.05.2001</font><br>\n" \
"<br>\n" \
"<font color=\"#FF0000\">3.0.0 'Avatar'</font><br>\n" \
"<font size=\"2\">\"A window to the souls\"</font><br>\n" \
"<font size=\"2\" color=\"#808080\">Release date: Still unknown</font><br>\n" \
"\n" \
"</font>\n" \
"</center>";
*/
/*
#define BORDER 4
#define DOUBLEBORDER 8


KviAboutLabel::KviAboutLabel(KviDlgAbout * par)
: QLabel(par)
{
	m_pAboutDialog = par;
	m_pMemPixmap = new QPixmap(width(),height());
}

KviAboutLabel::~KviAboutLabel()
{
	delete m_pMemPixmap;
}

void KviAboutLabel::resizeEvent(QResizeEvent *e)
{
	m_pMemPixmap->resize(width(),height());
}

void KviAboutLabel::drawContents(QPainter *p)
{
	QPixmap tmp_pix(*m_pAboutDialog->m_pBackground);

	//QPainter paint(m_pMemPixmap);

	int fw = frameWidth();
	int fw2 = fw << 1;

	bitBlt(m_pMemPixmap,fw,fw,m_pAboutDialog->m_pBackground,fw,fw,width() - fw2,height() - fw2);

	int theH = m_pAboutDialog->m_ppix_text->height() - m_pAboutDialog->m_posy;
	if(theH > height())theH = height();

	bitBlt(m_pMemPixmap,BORDER,fw,m_pAboutDialog->m_ppix_text,0,m_pAboutDialog->m_posy,width() - DOUBLEBORDER,theH);

	if(m_pAboutDialog->m_posy > height() + m_pAboutDialog->m_ppix_text->height() )
	{
		m_pAboutDialog->m_posy = 0;
	}

	//p.end();

	bitBlt(this,fw,fw,m_pMemPixmap,fw,fw, width() - (fw << 1), height() - (fw << 1));
}


KviDlgAbout::KviDlgAbout()
: QDialog(0) {
	
	setCaption(__c2q(__tr("About KVirc")));

	QGridLayout *g = new QGridLayout(this,3,1,10,4);

	KviStr szImage;

	m_pfield = new KviAboutLabel(this);

	m_pfield->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	g->addWidget(m_pfield,1,0);

	m_posy            = 0;

	m_pBackground = new QPixmap();
	if(g_pApp->findImage(szImage,"kvi_about_bg.png"))m_pBackground->load(szImage.ptr());
	else m_pBackground->resize(200,200);

	m_pfield->setFixedSize(m_pBackground->width(),m_pBackground->height());

	QSimpleRichText doc(g_szAboutText,QFont("helvetica",16));
	doc.setWidth(m_pBackground->width() - DOUBLEBORDER);

	int text_height=doc.height();

	// draw text and shadow
	m_ppix_text = new QPixmap(m_pBackground->width() - DOUBLEBORDER,text_height);
	m_ppix_text->fill(Qt::black);
	QPainter p(m_ppix_text);

	QRegion reg(0,0,m_pBackground->width() - DOUBLEBORDER,text_height);
#if QT_VERSION >= 300
	doc.draw(&p,0,0,reg,colorGroup());
#else
	doc.draw(&p,0,0,reg,palette());
#endif
	m_ppix_text->setMask(m_ppix_text->createHeuristicMask(false));

	QPushButton * btn_ok = new QPushButton(__c2q(__tr("Close")),this);
	btn_ok->setDefault(true);
	g->addWidget(btn_ok,2,0);
	connect(btn_ok,SIGNAL(clicked()),this,SLOT(close()));

	QTimer *timer = new QTimer(m_pfield);
	connect(timer,SIGNAL(timeout()),SLOT(scrollText()));
	timer->start(80);
}

void KviDlgAbout::scrollText()
{
	m_posy++;
	m_pfield->repaint(false);
}


//void KviDlgAbout::paintEvent( QPaintEvent * )
//{


//}

KviDlgAbout::~KviDlgAbout()
{
	delete m_ppix_text;
	delete m_pBackground;
}

////////////////////////////////////////////////////////////////////////////////
////////// 			KviDlgBuildInfo				////////
////////////////////////////////////////////////////////////////////////////////

KviDlgBuildInfo::KviDlgBuildInfo() : QDialog(NULL)
{
	setCaption(__c2q(__tr("KVirc build info")));
	
	setFixedSize(300, 150);

	m_pPicLabel = new QLabel(this);
	m_pPicLabel->move(10, 10);
//#warning "We need a big kvirc icon here"
	m_pPicLabel->setPixmap(*(g_pIconManager->getSmallIcon( \
		KVI_SMALLICON_KVIRC)));

	m_pTextLabel = new QLabel(this);
	m_pTextLabel->move(40, 15);
	m_pTextLabel->setAutoResize(true);
	m_pTextLabel->setAlignment(AlignLeft);
	QString str(KVI_VERSION);
	str += __c2q(__tr("\nScript language tag: "));
	str += KVI_SCRIPT_LANGUAGE_TAG;
	str += __c2q(__tr("\nBuild number: "));
	str += BUILD_NUMBER;
	str += __c2q(__tr("\nBuild date: "));
	str += BUILD_DATE;
//#warning "Can we make the URL a real link ?"
	str += __c2q(__tr("\nHome page: http://www.kvirc.net"));
	m_pTextLabel->setText(str);

	m_pButton = new QPushButton(__c2q(__tr("Close")), this);
	m_pButton->setDefault(true);
	m_pButton->move(150 - m_pButton->width()/2, 150 - m_pButton->height() -\
		10);
	connect(m_pButton, SIGNAL(clicked()), this, SLOT(close()));
}

KviDlgBuildInfo::~KviDlgBuildInfo()
{
}

void about_module_buildinfo_dialog_closed(KviDlgBuildInfo * dlg)
{
	if(g_pBuildInfoDialog)delete dlg;
	g_pBuildInfoDialog = 0;
	g_pAboutModule->unlock();
}

void KviDlgBuildInfo::close()
{
	about_module_buildinfo_dialog_closed(this);
}

void KviDlgBuildInfo::closeEvent(QCloseEvent * )
{
	about_module_buildinfo_dialog_closed(this);
}

void about_module_dialog_closed(KviDlgAbout * dlg)
{
	if(g_pAboutDialog)delete dlg;
	g_pAboutDialog = 0;
	g_pAboutModule->unlock();
}

void KviDlgAbout::closeEvent(QCloseEvent *)
{
	about_module_dialog_closed(this);
}

void KviDlgAbout::close()
{
	about_module_dialog_closed(this);
}
*/

/*
	@doc: about.kvirc
	@type:
		command
	@title:
		about.kvirc
	@short:
		Shows the "about dialog"
	@syntax:
		about.aboutkvirc
	@description:
		Shows the KVIrc "about dialog".
		This command is exported by the "about" module.
*/

bool about_module_command_kvirc(KviModule *m,KviCommand *c)
{
	ENTER_CONTEXT(c,"about_module_cmd_kvirc");

//	__range_valid(m == g_pAboutModule);

	KviStr dummy;
	if(!g_pUserParser->parseCmdFinalPart(c,dummy))return false;

 	if(!g_pAboutDialog){
//		g_pAboutModule->lock()
		g_pAboutDialog = new KviAboutDialog();
		g_pAboutDialog->show();
	}
	else
		g_pAboutDialog->raise();

    return c->leaveContext();
}
/*
bool about_module_command_buildinfo(KviModule * m, KviCommand * c)
{
	ENTER_CONTEXT(c, "about_module_command_buildinfo");
	
	__range_valid(m == g_pAboutModule);

	KviStr dummy;
	if(!g_pUserParser->parseCmdFinalPart(c, dummy))
		return false;

	if(!g_pBuildInfoDialog)
	{
		g_pAboutModule->lock();
		g_pBuildInfoDialog = new KviDlgBuildInfo();
		g_pBuildInfoDialog->show();
	}
	else
		g_pBuildInfoDialog->raise();

	return c->leaveContext();
}
*/
// =======================================
// init routine
// =======================================
static bool about_module_init(KviModule * m)
{
//	g_pAboutModule = m;
    m->registerCommand("kvirc",about_module_command_kvirc);
//    m->registerCommand("BUILDINFO", about_module_command_buildinfo);
    return true;
}

static bool about_module_cleanup(KviModule *m)
{
	if(g_pAboutDialog)delete g_pAboutDialog;
	g_pAboutDialog = 0;
//	m->unregisterMetaObject("KviDlgAbout");
//	m->unregisterMetaObject("KviDlgBuildInfo");
//	m->unregisterMetaObject("KviAboutLabel");
	m->unregisterMetaObject("KviAboutDialog");
	return true;
}

static bool about_module_can_unload(KviModule * m)
{
	return (!g_pAboutDialog);
}

// =======================================
// plugin definition structure
// =======================================
KVIMODULEEXPORTDATA KviModuleInfo kvirc_module_info =
{
    "KVIrc about dialog",
	"2.0.0",
    "Till Bush <buti@geocities.com>\n" \
	"Szymon Stefanek <stefanek@tin.it>" ,
	"Exports the /aboutkvirc command\n",
    about_module_init ,
    about_module_can_unload,
    0,
	about_module_cleanup
};

//#include "libkviabout.moc"
