#ifndef _KVI_POPUPMENU_H_
#define _KVI_POPUPMENU_H_

//
//   File : kvi_popupmenu.h
//   Creation date : Sun Sep 1 2000 14:47:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"

#include <qpopupmenu.h>
#include "kvi_list.h"

class KviPopupMenuItem;

class KviWindow;
class KviParameterList;
class KviDataContainer;
class KviConfig;

class QLabel;

class KVIRC_API KviPopupMenuTopLevelData
{
	friend class KviPopupMenu;
public:
	KviPopupMenuTopLevelData(KviDataContainer * d,KviParameterList * l,KviWindow * wnd);
	~KviPopupMenuTopLevelData();
protected:
	KviParameterList * pParamList;
	KviDataContainer * pDataContainer;
	KviWindow        * pWnd;
	bool               bLocked;
#ifdef COMPILE_ON_WINDOWS
public:
	// On windows we need to override new and delete operators
	// to ensure that always the right new/delete pair is called for an object instance
	// This bug is present in all the classes exported by a module that
	// can be instantiated/destroyed from external modules.
	// (this is a well known bug described in Q122675 of MSDN)
	void       * operator new(size_t tSize);
	void         operator delete(void * p);
#endif
};


class KVIRC_API KviPopupMenu : public QPopupMenu
{
	friend class KviPopupManager;
	friend class KviSinglePopupEditor;
	Q_OBJECT
public:
	KviPopupMenu(const char * name);
	~KviPopupMenu();
protected:
	KviPtrList<KviPopupMenuItem>  * m_pItemList;
private:
	KviPopupMenu             * m_pParentPopup;
	KviStr                     m_szEpilogueCode;
	KviStr                     m_szPrologueCode;
	KviPopupMenuTopLevelData * m_pTopLevelData;
	// this is a temporary used to hack-in the activation from KviMenuBar
	KviPopupMenuTopLevelData * m_pTempTopLevelData;
	bool                       m_bSetupDone;
public:
	void copyFrom(const KviPopupMenu * src);
	KviPopupMenuTopLevelData * topLevelData();
	KviPopupMenu * topLevelPopup();
	bool isLocked();
	void addItem(KviPopupMenuItem * it);
	void doPopup(const QPoint & pnt,KviWindow * wnd,KviParameterList * params);
	bool isEmpty(){ return (m_pItemList->count() == 0); };
	void doClear();
	void setPrologue(const char * code){ m_szPrologueCode = code; };
	void setEpilogue(const char * code){ m_szEpilogueCode = code; };
	bool hasPrologue(){ return m_szPrologueCode.hasData(); };
	bool hasEpilogue(){ return m_szEpilogueCode.hasData(); };
	const char * prologue(){ return m_szPrologueCode.ptr(); };
	const char * epilogue(){ return m_szEpilogueCode.ptr(); };
	KviPopupMenu * parentPopup(){ return m_pParentPopup; };
	void generateDefPopup(KviStr &buffer);
protected:
	void lock(bool bLock);
	void setParentPopup(KviPopupMenu * par){ m_pParentPopup = par; };
	void load(const char * prefix,KviConfig * cfg);
	void save(const char * prefix,KviConfig * cfg);
	void generateDefPopupCore(KviStr &buffer);
private slots:
	void setupMenuContents();
private:
	void clearMenuContents();
protected slots:
	void itemClicked(int itemId);
#ifdef COMPILE_ON_WINDOWS
public:
	// On windows we need to override new and delete operators
	// to ensure that always the right new/delete pair is called for an object instance
	// This bug is present in all the classes exported by a module that
	// can be instantiated/destroyed from external modules.
	// (this is a well known bug described in Q122675 of MSDN)
	void       * operator new(size_t tSize);
	void         operator delete(void * p);
#endif
};


class KVIRC_API KviPopupMenuItem
{
public:
	enum Type { Item , Menu , Label , Separator , ExtMenu };
private:
	KviStr         m_szText;
	KviStr         m_szCode; // for "ExtMenu" it contains the external menu name!!!!!!!
	KviStr         m_szIcon;
	KviStr         m_szExpr;
	KviPopupMenu * m_pMenu;
	Type           m_type;
	QLabel       * m_pLabel;
public:
	KviPopupMenuItem(Type t,const char * text = 0,const char * icon = 0,const char * expr = 0,
			const char * code = 0,KviPopupMenu * menu = 0)
		: m_type(t),
		m_szText(text ? text : ""),
		m_szCode(code ? code : ""),
		m_szIcon(icon ? icon : ""),
		m_szExpr(expr ? expr : ""),
		m_pMenu(menu),
		m_pLabel(0) {};

	KviPopupMenuItem(const KviPopupMenuItem *src);
	~KviPopupMenuItem(){ if(m_pMenu)delete m_pMenu; };
public:
	KviPopupMenuItem::Type type(){ return m_type; };

	char * text(){ return m_szText.ptr(); };
	char * code(){ return m_szCode.ptr(); };
	char * icon(){ return m_szIcon.ptr(); };
	char * expr(){ return m_szExpr.ptr(); };

	bool hasExpression(){ return m_szExpr.hasData(); };
	bool hasIcon(){ return m_szIcon.hasData(); };

	bool isSeparator(){ return m_type == Separator; };
	bool isLabel(){ return m_type == Label; };
	bool isExtMenu(){ return m_type == ExtMenu; };
	bool isMenu(){ return m_type == Menu; };

	QLabel * label(){ return m_pLabel; };
	void setLabel(QLabel * l){ m_pLabel = l; };

	KviPopupMenu * menu(){ return m_pMenu; };
	void setMenu(KviPopupMenu * m);
#ifdef COMPILE_ON_WINDOWS
public:
	// On windows we need to override new and delete operators
	// to ensure that always the right new/delete pair is called for an object instance
	// This bug is present in all the classes exported by a module that
	// can be instantiated/destroyed from external modules.
	// (this is a well known bug described in Q122675 of MSDN)
	void       * operator new(size_t tSize);
	void         operator delete(void * p);
#endif
};


#endif //_KVI_POPUPMENU_H_
