#ifndef _KVI_POPUPMANAGER_H_
#define _KVI_POPUPMANAGER_H_

//
//   File : kvi_popupmanager.h
//   Creation date : Sun Sep 1 2000 16:13:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include "kvi_popupmenu.h"
#include <qasciidict.h>
#include "kvi_list.h"
#include "kvi_string.h"

class KVIRC_API KviPopupManager
{
public:
	KviPopupManager();
	~KviPopupManager();
private:
	QAsciiDict<KviPopupMenu> * m_pPopupDict;
public:
	//void killPopupsInList(KviPtrList<KviStr> * l);
	void clear(){ m_pPopupDict->clear(); };
	const QAsciiDict<KviPopupMenu> * popupDict(){ return m_pPopupDict; };
	KviPopupMenu * lookupPopup(const char * nam){ return m_pPopupDict->find(nam); };
	KviPopupMenu * getPopup(const char * nam);
	void removePopup(const char * nam){ m_pPopupDict->remove(nam); };
	void save(const char * filename);
	void load(const char * filename);
};

extern KVIRC_API KviPopupManager * g_pPopupManager;

#endif //_KVI_POPUPMANAGER_H_
