//
//   File : kvi_ircurl.cpp
//   Creation date : Sun Mar 04 2001 14:20:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__
#include "kvi_string.h"

#define _KVI_IRCURL_CPP_
#include "kvi_ircurl.h"


bool parseIrcUrl(const char * url,KviStr &cmdBuffer,int contextSpec)
{
	// irc[6]://<server>[:<port>][/<channel>[?<pass>]]
	KviStr szUrl = url;
	bool bIpV6 = false;
	KviStr szServer;
	unsigned short int uPort;
	bool bGotPort = false;
	if(kvi_strEqualCIN(szUrl.ptr(),"irc://",6))
	{
		szUrl.cutLeft(6);
	} else if(kvi_strEqualCIN(szUrl.ptr(),"irc6://",7))
	{
		bIpV6 = true;
		szUrl.cutLeft(7);
	} else return false;

	KviStr szServerAndPort;

	int idx = szUrl.findFirstIdx('/');
	if(idx != -1)
	{
		szServerAndPort = szUrl.left(idx);
		szUrl.cutLeft(idx + 1);
	} else {
		szServerAndPort = szUrl;
		szUrl = "";
	}

	if(szServerAndPort.isEmpty())return false;

	idx = szServerAndPort.findFirstIdx(':');

	if(idx != -1)
	{
		szServer = szServerAndPort.left(idx);
		szServerAndPort.cutLeft(idx + 1);
		bool bOk;
		uPort = szServerAndPort.toUShort(&bOk);
		if(!bOk)uPort = 6667;
		bGotPort = true;
	} else {
		szServer = szServerAndPort;
	}

	cmdBuffer = "server ";
	switch(contextSpec)
	{
		case KVI_IRCURL_CONTEXT_FIRSTFREE:
			cmdBuffer.append("-u ");
			break;
		case KVI_IRCURL_CONTEXT_NEW:
			cmdBuffer.append("-n ");
			break;
	}
	if(bIpV6)cmdBuffer.append(" -i ");

	if(szUrl.hasData())
	{
		KviStr szChannel;
		KviStr szPass;

		idx = szUrl.findFirstIdx('?');
		if(idx != -1)
		{
			szChannel = szUrl.left(idx);
			szUrl.cutLeft(idx + 1);
			szPass = szUrl;
		} else {
			szChannel = szUrl;
			szPass = "";
		}

		if(!(szChannel.firstCharIs('#') || szChannel.firstCharIs('!') || szChannel.firstCharIs('&')))
				szChannel.prepend('#');

		if(szPass.isEmpty())cmdBuffer.append(KviStr::Format," -c=\"join %s\" ",szChannel.ptr());
		else cmdBuffer.append(KviStr::Format," -c=\"join %s %s\" ",szChannel.ptr(),szPass.ptr());

	}

	cmdBuffer.append(szServer);
	if(bGotPort)cmdBuffer.append(KviStr::Format," %d",uPort);

	cmdBuffer.append(';');

	return true;
}
