#ifndef _KVI_EVENTHANDLER_H_
#define _KVI_EVENTHANDLER_H_
//
//   File : kvi_eventhandler.h
//   Creation date : Thu Dec  6 04:10:23 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"
#include "kvi_window.h"
#include "kvi_module.h"
#include "kvi_parameterlist.h"

class KviEventHandler
{
public:
	enum Type { Script , Module };
protected:
	Type m_type;
public:
	KviEventHandler(Type t): m_type(t) {};
	virtual ~KviEventHandler(){};
public:
	Type type(){ return m_type; };
};

class KviScriptEventHandler : public KviEventHandler
{
public:
	KviScriptEventHandler() : KviEventHandler(KviEventHandler::Script) {};
	virtual ~KviScriptEventHandler(){};
protected:
	KviStr m_szName;
	KviStr m_szCode;
	bool   m_bEnabled;
public:
	const char * name(){ return m_szName.ptr(); };
	const char * code(){ return m_szCode.ptr(); };
	KviStr & codeString(){ return m_szCode; };
	bool enabled(){ return m_bEnabled; };

	void setEnabled(bool bEnabled){ m_bEnabled = bEnabled; };
	void setCode(const char * code){ m_szCode = code; };
	void setName(const char * name){ m_szName = name; };
};

class KviModuleEventHandler : public KviEventHandler
{
protected:
	KviModule               * m_pModule;
	KviModuleEventParseProc   m_proc;
public:
	KviModuleEventHandler(KviModuleEventParseProc p,KviModule * m)
		: KviEventHandler(KviEventHandler::Module), m_pModule(m), m_proc(p) {};
	virtual ~KviModuleEventHandler(){};
public:
	KviModule * module(){ return m_pModule; };
	void setModule(KviModule * m){ m_pModule = m; };
	KviModuleEventParseProc proc(){ return m_proc; };
	void setProc(KviModuleEventParseProc p){ m_proc = p; };
};

#endif //_KVI_EVENTHANDLER_H_
