#ifndef _KVI_ALIASMANAGER_H_
#define _KVI_ALIASMANAGER_H_

//
//   File : kvi_aliasmanager.h
//   Creation date : Sat Nov 18 2000 12:33:44 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_alias.h"
#include <qasciidict.h>
#include "kvi_list.h"


class KVIRC_API KviAliasManager
{
public:
	KviAliasManager();
	~KviAliasManager();
private:
	QAsciiDict<KviAlias> * m_pAliasDict;
public:
	QAsciiDict<KviAlias> * aliasDict(){ return m_pAliasDict; };
	KviAlias * lookupAlias(const char * nam){ return m_pAliasDict->find(nam); };
	void addAlias(const char * nam,KviAlias * a){ m_pAliasDict->replace(nam,a); };
	void removeAlias(const char * nam){ m_pAliasDict->remove(nam); };
	void clear(){ m_pAliasDict->clear(); };
	void save(const char * filename);
	void load(const char * filename);
	void completeCommand(const KviStr &word,KviPtrList<KviStr> * matches);
};

//#ifndef _KVI_ALIASMANAGER_CPP_
	extern KVIRC_API KviAliasManager * g_pAliasManager;
//#endif

#endif //_KVI_ALIASMANAGER_H_
