//
//   File : kvi_aliasmanager.cpp
//   Creation date : Sat Nov 18 2000 12:36:45 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__
#define _KVI_ALIASMANAGER_CPP_

#include "kvi_list.h"

#include "kvi_aliasmanager.h"
#include "kvi_config.h"

KviAliasManager * g_pAliasManager = 0;

KviAliasManager::KviAliasManager()
{
	m_pAliasDict = new QAsciiDict<KviAlias>(17,false,true);
	m_pAliasDict->setAutoDelete(true);
}

KviAliasManager::~KviAliasManager()
{
	delete m_pAliasDict;
}

void KviAliasManager::completeCommand(const KviStr &word,KviPtrList<KviStr> * matches)
{
	QAsciiDictIterator<KviAlias> it(*m_pAliasDict);
	while(it.current())
	{
		if(kvi_strEqualCIN(word.ptr(),it.current()->name(),word.len()))
			matches->append(new KviStr(it.current()->name()));
		++it;
	}
}


// FIXME: #warning "A binary config would work better and faster here!"

void KviAliasManager::save(const char * filename)
{
	KviConfig cfg(filename);
	cfg.clear();

	QAsciiDictIterator<KviAlias> it(*m_pAliasDict);
	while(it.current())
	{
		cfg.setGroup(it.current()->name());
		it.current()->save("",&cfg);
		++it;
	}
}

void KviAliasManager::load(const char * filename)
{
	m_pAliasDict->clear();
	KviConfig cfg(filename);

	KviConfigIterator it(*(cfg.dict()));

	KviPtrList<KviStr> l;
	l.setAutoDelete(true);

	while(it.current())
	{
		l.append(new KviStr(it.currentKey()));
		++it;
	}

	for(KviStr * s = l.first();s;s = l.next())
	{
		cfg.setGroup(s->ptr());
		KviAlias * m = new KviAlias(s->ptr());
		m->load("",&cfg);
		m_pAliasDict->insert(s->ptr(),m);
		++it;
	}
}
