#ifndef _KVI_ALIAS_H_
#define _KVI_ALIAS_H_

//
//   File : kvi_alias.h
//   Creation date : Sat Nov 18 2000 12:39:33 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"

class KviConfig;

class KVIRC_API KviAlias
{
	friend class KviAliasManager;
public:
	KviAlias(const char * name);
	~KviAlias();
private:
	KviStr                    m_szName;
	KviStr                    m_szDataBuffer;
	unsigned int              m_uLock;
public:
	unsigned int lock(){ m_uLock++; return m_uLock; };
	unsigned int unlock(){ m_uLock--; return m_uLock; };
	void totalUnlock(){ m_uLock = 0; };
	const char * name(){ return m_szName.ptr(); };
	bool isLocked(){ return (m_uLock != 0); };
	const char * dataBuffer(){ return m_szDataBuffer; };
	void setDataBuffer(const char * db){ m_szDataBuffer = db; };
protected:
	void load(const char * prefix,KviConfig * cfg);
	void save(const char * prefix,KviConfig * cfg);
};



#endif //_KVI_ALIAS_H_
