#ifndef _KVI_WINDOW_H_
#define _KVI_WINDOW_H_
//
//   File : kvi_window.h
//   Creation date : Tue Jul 6 1999 14:52:20 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_settings.h"

#ifdef COMPILE_ON_WINDOWS
	// The brain-damaged MSVC compiler can't instantiate QList templates without a destructor definition
	#include "kvi_mdichild.h"
#else
	class KviMdiChild;
#endif
class KviFrame;
class KviTaskBarItem;
class KviConfig;
class KviIrcView;
class KviInput;
class KviConsole;

class QPopupMenu;
class QPixmap;
class QSplitter;
class QHBox;
class QAccel;

#ifdef COMPILE_CRYPT_SUPPORT
	class KviCryptController;
	class QToolButton;
	typedef struct _KviCryptSessionInfo KviCryptSessionInfo;
#endif

#include <qwidget.h>

#define KVI_WINDOW_TYPE_CONSOLE 0
#define KVI_WINDOW_TYPE_CHANNEL 1
#define KVI_WINDOW_TYPE_QUERY 2
#define KVI_WINDOW_TYPE_HELP 3
#define KVI_WINDOW_TYPE_TERM 4
#define KVI_WINDOW_TYPE_EDITOR 5
#define KVI_WINDOW_TYPE_DCCCHAT 6
#define KVI_WINDOW_TYPE_DCCSEND 7
#define KVI_WINDOW_TYPE_SOCKETSPY 8
#define KVI_WINDOW_TYPE_LINKS 9
#define KVI_WINDOW_TYPE_ICQ 10
#define KVI_WINDOW_TYPE_GNUTELLA 11
#define KVI_WINDOW_TYPE_DIRBROWSER 12
#define KVI_WINDOW_TYPE_DCCCANVAS 13
#define KVI_WINDOW_TYPE_DCCVOICE 14
#define KVI_WINDOW_TYPE_LIST 15
#define KVI_WINDOW_TYPE_OFFER 16
#define KVI_WINDOW_TYPE_LOGVIEW 17

#define KVI_WINDOW_NUM_TYPES 18


class KVIRC_API KviWindow : public QWidget
{
	friend class KviFrame;
	friend class KviTaskBarItem;
	friend class KviTaskBarButton;
	friend class KviTreeTaskBarItem;
	friend class KviTreeTaskBar;
	Q_OBJECT
public:
	KviWindow(int type,KviFrame * lpFrm,const char * name,KviConsole * lpConsole = 0);
	virtual ~KviWindow();
protected:
	KviFrame                            * m_pFrm;
	KviConsole                          * m_pConsole;
	int                                   m_type;
	KviTaskBarItem                      * m_pTaskBarItem;
	QWidget                             * m_pFocusHandler;
	QPopupMenu                          * m_pContextPopup;
	KviStr                                m_szPlainTextCaption;
	KviStr                                m_szHtmlActiveCaption;
	KviStr                                m_szHtmlInactiveCaption;
	KviIrcView                          * m_pIrcView;
	KviInput                            * m_pInput;
	QSplitter                           * m_pSplitter;
	QHBox                               * m_pButtonBox;
	KviStr                                m_szId;
#ifdef COMPILE_CRYPT_SUPPORT
	QToolButton                         * m_pCryptControllerButton;
	KviCryptController                  * m_pCryptController;
	KviCryptSessionInfo                 * m_pCryptSessionInfo;
#endif
	static const char * m_typeTable[KVI_WINDOW_NUM_TYPES];
	QObject                             * m_pLastPressedChild;
	bool                                  m_bNewLastPressedChild;
	QObject                             * m_pWheelEventHandler;
	QAccel                              * m_pAccel;
public:
#ifdef COMPILE_CRYPT_SUPPORT
	KviCryptSessionInfo * cryptSessionInfo(){ return m_pCryptSessionInfo; };
#endif
	int type(){ return m_type; };
	KviFrame * frame(){ return m_pFrm; };
	KviIrcView * view(){ return m_pIrcView; };
	KviMdiChild * mdiParent(){ return (KviMdiChild *)parent(); };
	KviConsole * console(){ return m_pConsole; };
	QSplitter * splitter(){ return m_pSplitter; };
	KviTaskBarItem * taskBarItem(){ return m_pTaskBarItem; };
	QHBox * buttonContainer(){ return m_pButtonBox; };
	void contextPopup();
	void delayedAutoRaise();
	bool isMinimized();
	bool isMaximized();
	void getDefaultLogFileName(KviStr &buffer);
	const char * lastLineOfText();
	const char * typeString(){ return m_typeTable[m_type]; };
	virtual const char * target(){ return ""; };
	virtual void saveProperties(KviConfig *cfg);
	virtual void loadProperties(KviConfig *cfg);
	virtual void fillContextPopup(QPopupMenu * p);
	virtual void getConfigGroupName(KviStr &buf);
	virtual void getBaseLogFileName(KviStr &buffer);
	virtual void updateCaption();
	virtual void applyOptions();
	virtual void ownMessage(const char * text){};
	virtual void ownAction(const char * text){};
	virtual const char * plainTextCaption(){ return m_szPlainTextCaption.ptr(); };
	virtual const char * htmlActiveCaption(){ return m_szHtmlActiveCaption.ptr(); };
	virtual const char * htmlInactiveCaption(){ return m_szHtmlInactiveCaption.ptr(); };
	QRect externalGeometry();
	virtual void output(int msg_type,const char * format,...);
	virtual void outputNoFmt(int msg_type,const char * text);
	virtual KviWindow * outputProxy();
	const char * id(){ return m_szId.ptr(); };
	void updateBackgrounds(QObject * obj = 0);
	QObject * findChildScrollBar(QObject * par);
	void setWheelEventHandler(QObject * o);
	void listWindowTypes();
public slots:
	void dock();
	void undock();
	void autoRaise();
	void maximize();
	void minimize();
	void restore();
protected slots:
	void savePropertiesAsDefault();
	void toggleCryptController();     // This has to be here even if the crypt support is enabled...moc does not support conditionals
	void cryptControllerFinished();   // same as above
	void cryptSessionInfoDestroyed(); //  same as above
	void systemPopupRequest(const QPoint &pnt);
//	void wheelEventHandlerDestroyed();
protected:
	virtual void triggerCreationEvents(){};
	virtual void createTaskBarItem();
	virtual void destroyTaskBarItem();
	void createCryptControllerButton(QWidget * par);
	void setProgress(int progress);
	virtual void fillCaptionBuffers();
	virtual void youAreDocked();
	virtual void youAreUndocked();
	virtual QPixmap * myIconPtr();
	void setFocusHandler(QWidget *focusedOne,QWidget *w);
	void setFocusHandlerNoChildren(QWidget *focusedOne,QWidget *w = 0,bool bInChildTree = false);
	void setFocusHandlerNoClass(QWidget *focusedOne,QWidget *w,const char * clName);
	virtual void moveEvent(QMoveEvent *e);
	virtual void closeEvent(QCloseEvent *e);
	bool eventFilter(QObject *o,QEvent *e);
	virtual void wheelEvent(QWheelEvent *e);
	virtual void childEvent(QChildEvent *e);
	QToolButton * createToolButton(QWidget * par,const char * nam,int pixon,int pixoff,const char * tooltip,bool bOn);
};

#endif //_KVI_WINDOW_H_
