#ifndef _KVI_TOPICW_H_
#define _KVI_TOPICW_H_

//
//   File : kvi_topicw.h
//   Creation date : Fri Aug 4 2000 12:03:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include <qframe.h>
#include <qpushbutton.h>

#include "kvi_string.h"

class QComboBox;
class KviChannel;

class KVIRC_API KviTopicWidget : public QFrame
{
	Q_OBJECT
	Q_PROPERTY(int TransparencyCapable READ dummyRead)
	friend class KviChannel;
	
public:
	KviTopicWidget(QWidget * par,const char * name);
	~KviTopicWidget();
private:
	KviStr        m_szTopic;
	KviStr        m_szSetBy;
	KviStr        m_szSetAt;
	QComboBox   * m_pComboBox;
	QPushButton * m_pAccept;
	QPushButton * m_pDiscard;
protected:
	virtual void drawContents(QPainter *p);
	virtual void mouseDoubleClickEvent(QMouseEvent *e);
	virtual void keyPressEvent(QKeyEvent * e);
	virtual void resizeEvent(QResizeEvent *e);
	void updateToolTip();
	void deactivate();
public:
	int dummyRead() const { return 0; };
	void setTopic(const char * topic);
	void setTopicSetBy(const char * setBy);
	void setTopicSetAt(const char * setAt);
	const char * topic(){ return m_szTopic.ptr(); };
	const char * topicSetBy(){ return m_szSetBy.ptr(); };
	const char * topicSetAt(){ return m_szSetAt.ptr(); };
	virtual QSize sizeHint() const;
	void applyOptions();
protected slots:
//	void comboActivated(const QString &str);
	void acceptClicked();
	void discardClicked();
signals:
	void topicSelected(const char * topic);
};

#endif //_KVI_TOPICW_H_
