//
//   File : kvi_topicw.cpp
//   Creation date : Fri Aug 4 2000 12:09:21 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__

#include "kvi_topicw.h"
#include "kvi_options.h"
#include "kvi_mirccntrl.h"
#include "kvi_locale.h"
#include "kvi_defaults.h"
#include "kvi_settings.h"
#include "kvi_iconmanager.h"

#include <qpainter.h>
#include <qfontmetrics.h>
#include <qtooltip.h>
#include <qcombobox.h>
#include <qlineedit.h>

// FIXME: #warning "The combo should disappear when it looses focus!...(how to do it ?)"

#ifdef COMPILE_PSEUDO_TRANSPARENCY
	extern QPixmap * g_pShadedChildGlobalDesktopBackground;
#endif


extern const char * getColorBytes(const char *data_ptr,unsigned char *byte_1,unsigned char *byte_2);

extern QStringList  * g_pRecentTopicList;

KviTopicWidget::KviTopicWidget(QWidget * par,const char * name)
: QFrame(par,name)
{
	setFrameStyle(QFrame::Sunken | QFrame::Panel);
	setFont(KVI_OPTION_FONT(KviOption_fontLabel));
	m_pComboBox = 0;
	m_pAccept = 0;
	m_pDiscard = 0;
	m_szTopic = __tr("[unknown]");
	QToolTip::add(this,__tr("No topic message has been received from the server yet."));
}

KviTopicWidget::~KviTopicWidget()
{
}

void KviTopicWidget::applyOptions()
{
	setFont(KVI_OPTION_FONT(KviOption_fontLabel));
	if(m_pComboBox)m_pComboBox->setFont(KVI_OPTION_FONT(KviOption_fontLabel));
	resizeEvent(0);
}

#define KVI_LABEL_DEF_BACK 100
#define KVI_LABEL_DEF_FORE 101

void KviTopicWidget::drawContents(QPainter *p)
{
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	if(g_pShadedChildGlobalDesktopBackground)
	{
		QPoint pnt = mapToGlobal(contentsRect().topLeft());
		p->drawTiledPixmap(contentsRect(),*g_pShadedChildGlobalDesktopBackground,pnt);
	} else {
#endif

		if(KVI_OPTION_PIXMAP(KviOption_pixmapLabelBackground).pixmap())
		{
			p->drawTiledPixmap(contentsRect(),*(KVI_OPTION_PIXMAP(KviOption_pixmapLabelBackground).pixmap()));
		} else {
			p->fillRect(contentsRect(),KVI_OPTION_COLOR(KviOption_colorLabelBackground));
		}

#ifdef COMPILE_PSEUDO_TRANSPARENCY
	}
#endif

	const char * t = m_szTopic.ptr();
	QFontMetrics fm(p->font());
	

	bool curBold      = false;
	bool curUnderline = false;
	unsigned char curFore      = KVI_LABEL_DEF_FORE; //default fore
	unsigned char curBack      = KVI_LABEL_DEF_BACK; //default back
	int baseline = ((height() + fm.ascent() - fm.descent() + 1) >> 1);

	int curX = contentsRect().x() + 2; //2 is the margin

	while(*t && (curX < width()))
	{
		const char * aux = t;
		while(*aux && (*aux != KVI_TEXT_COLOR) && (*aux != KVI_TEXT_BOLD) &&
					(*aux != KVI_TEXT_UNDERLINE) && (*aux != KVI_TEXT_REVERSE) &&
					(*aux != KVI_TEXT_RESET))++aux;
		int len = aux - t;
		int wdth;

		if(len > 0)
		{
			wdth = fm.width(t,len);
	
			if(curFore == KVI_LABEL_DEF_FORE)
			{
				p->setPen(KVI_OPTION_COLOR(KviOption_colorLabelForeground));
			} else {
				if(curFore > 16)p->setPen(KVI_OPTION_COLOR(KviOption_colorLabelBackground));
				else p->setPen(KVI_OPTION_MIRCCOLOR(curFore));
			}
		
			if(curBack != KVI_LABEL_DEF_BACK)
			{
				if(curBack > 16)
				{
					p->fillRect(curX,contentsRect().y() + 2,wdth,contentsRect().height() - 4,
						KVI_OPTION_COLOR(KviOption_colorLabelForeground));
				} else {
					p->fillRect(curX,contentsRect().y() + 2,wdth,contentsRect().height() - 4,
						KVI_OPTION_MIRCCOLOR(curBack));
				}
			}

			p->drawText(curX,baseline,t,len);
	
			if(curBold)p->drawText(curX+1,baseline,t,len);
			if(curUnderline){
				p->drawLine(curX,baseline + 1,curX+wdth,baseline + 1);
			}
		} else {
			wdth = 0;
		}

	
		switch(*aux)
		{
			case KVI_TEXT_BOLD: curBold = !curBold; ++aux; break;
			case KVI_TEXT_UNDERLINE: curUnderline = !curUnderline; ++aux; break;
			case KVI_TEXT_REVERSE:
				{
					char auxBack = curBack;
					curBack = curFore;
					curFore = auxBack;
				}
				++aux;
			break;
			case KVI_TEXT_RESET:
				curFore = KVI_LABEL_DEF_FORE;
				curBack = KVI_LABEL_DEF_BACK;
				curBold = false;
				curUnderline = false;
				++aux;
			break;
			case KVI_TEXT_COLOR:
			{
				++aux;
				unsigned char fore;
				unsigned char back;
				aux = getColorBytes(aux,&fore,&back);
				if(fore != KVI_NOCHANGE)curFore = fore;
				else curFore = KVI_LABEL_DEF_FORE;
				if(back != KVI_NOCHANGE)curBack = back;
				else curBack = KVI_LABEL_DEF_BACK;
			}
			break;
		}



		t = aux;
		curX += wdth;
	}
}

void KviTopicWidget::setTopic(const char * topic)
{
	m_szTopic = topic;
	bool bFound = false;
	for(QStringList::Iterator it=g_pRecentTopicList->begin();it != g_pRecentTopicList->end(); ++it)
	{
		if(kvi_strEqualCS((*it).ascii(),m_szTopic.ptr()))
		{
			bFound = true;
			break;
		}
	}
	if(!bFound && m_szTopic.hasData())
	{
		if(g_pRecentTopicList->count() >= KVI_RECENT_TOPIC_ENTRIES)
		{
			g_pRecentTopicList->remove(g_pRecentTopicList->begin());
		}
		g_pRecentTopicList->append(m_szTopic.ptr());
	}
	updateToolTip();
	update();
}

void KviTopicWidget::setTopicSetBy(const char * setBy)
{
	m_szSetBy = setBy;
	updateToolTip();
}

void KviTopicWidget::setTopicSetAt(const char * setAt)
{
	m_szSetAt = setAt;
	updateToolTip();
}

void KviTopicWidget::updateToolTip()
{
	QToolTip::remove(this);
	if(m_szTopic.hasData())
	{
		KviStr tmp = m_szTopic.ptr();
		tmp.replaceAll("<","&lt;");
		tmp.replaceAll(">","&gt;");
		if(m_szSetBy.hasData())
		{
			tmp.append(__tr("<br><br>Set by <b>"));
			tmp.append(m_szSetBy);
			tmp.append("</b>");
			if(m_szSetAt.hasData())
			{
				tmp.append(__tr(" on <b>"));
				tmp.append(m_szSetAt);
				tmp.append("</b>");
			}
		}
		tmp.prepend(__tr("<b>Channel topic</b><br>"));
		tmp.append(__tr("<br>Double click to edit"));
		QToolTip::add(this,tmp.ptr());
	} else {
		QToolTip::add(this,__tr("No topic is set<br>Double click to set it.<br>"));
	}
}

QSize KviTopicWidget::sizeHint() const
{
	QFontMetrics fm(font());
	int hght = fm.lineSpacing() + (frameWidth() << 1) + 4;
	if(hght < 20)hght = 20;
	return QSize(50,hght);
}

void KviTopicWidget::mouseDoubleClickEvent(QMouseEvent *)
{
	if(isEnabled() && (m_pComboBox == 0))
	{
		m_pComboBox = new QComboBox(true,this,"topic_combo");
		m_pComboBox->setFont(font());
		m_pComboBox->setGeometry(0,0,width() - (height() << 1),height());
		m_pAccept = new QPushButton(this,"accept_button");
		m_pAccept->setPixmap(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_ACCEPT)));
		m_pAccept->setGeometry(width() - (height() << 1),0,height(),height());
		m_pAccept->show();
		QToolTip::add(m_pAccept,__tr("Commit changes"));
		connect(m_pAccept,SIGNAL(clicked()),this,SLOT(acceptClicked()));
		m_pDiscard = new QPushButton(this,"discard_button");
		m_pDiscard->setPixmap(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_DISCARD)));
		m_pDiscard->setGeometry(width() - height(),0,height(),height());
		QToolTip::add(m_pDiscard,__tr("Discard changes"));
		m_pDiscard->show();
		connect(m_pDiscard,SIGNAL(clicked()),this,SLOT(discardClicked()));
		m_pComboBox->insertStringList(*g_pRecentTopicList);
		m_pComboBox->lineEdit()->setText(m_szTopic.ptr());
		m_pComboBox->lineEdit()->selectAll();
		m_pComboBox->show();
		m_pComboBox->setFocus();
//		connect(m_pComboBox,SIGNAL(activated(const QString &)),this,SLOT(comboActivated(const QString &)));
	}
}

void KviTopicWidget::keyPressEvent(QKeyEvent * e)
{
	switch(e->key())
	{
		case Qt::Key_Enter:
		case Qt::Key_Return:
			acceptClicked();
			break;
		case Qt::Key_Escape:
			deactivate();
			break;
		default:
			e->ignore();
	}
}

void KviTopicWidget::resizeEvent(QResizeEvent *e)
{
	if(e)QFrame::resizeEvent(e);
	if(m_pComboBox)
	{
		m_pComboBox->setGeometry(0,0,width() - (height() << 1),height());
		m_pAccept->setGeometry(width() - (height() << 1),0,height(),height());
		m_pDiscard->setGeometry(width() - height(),0,height(),height());
	}
}

//void KviTopicWidget::comboActivated(const QString &str)
//{
//	
//}

void KviTopicWidget::deactivate()
{
	if(m_pComboBox)
	{
		delete m_pComboBox;
		m_pComboBox = 0;
		delete m_pAccept;
		m_pAccept = 0;
		delete m_pDiscard;
		m_pDiscard = 0;
	}
	((QWidget *)parent())->setFocus();
}

void KviTopicWidget::discardClicked()
{
	deactivate();
}

void KviTopicWidget::acceptClicked()
{
	KviStr tmp = m_pComboBox->currentText();
	if(!kvi_strEqualCS(tmp.ptr(),m_szTopic.ptr()))emit topicSelected(tmp.ptr());
	deactivate();
}

#include "kvi_topicw.moc"
