#ifndef _KVI_TASKBAR_H_
#define _KVI_TASKBAR_H_
//
//   File : kvi_taskbar.h
//   Creation date : Thu Jan 7 1999 03:56:50 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include "kvi_tal_toolbar.h"

#include "kvi_list.h"
#include <qframe.h>
#include <qtooltip.h>
#include <qlistview.h>



class KviWindow;
class KviFrame;
class QPixmap;
class KviDynamicToolTip;

//
// KviTaskBarItem
//
// The base class for the taskBar items
// this is the only interface to an item visible to external classes
//

class KVIRC_API KviTaskBarItem
{
public:
	KviTaskBarItem(KviWindow * wnd);
	virtual ~KviTaskBarItem();
protected:
	KviWindow * m_pWindow;
public:
	KviWindow * window(){ return m_pWindow; };
	virtual void captionChanged(){};
	virtual void highlight(int iLevel = 1){};
	virtual void setProgress(int progress){};
	virtual int highlightLevel(){ return 0; };
	virtual bool active(){ return false; };
};

//
// KviTaskBarBase
//
// The base class for the taskbar implementations
// This is the basic interface that all the external classes should see
//

class KVIRC_API KviTaskBarBase : public KviTalToolBar
{
	Q_OBJECT
public:
	KviTaskBarBase(KviFrame * lpFrm);
	virtual ~KviTaskBarBase();
protected:
	KviFrame * m_pFrm;
public:
	virtual KviTaskBarItem * addItem(KviWindow *){ return 0; };
	virtual bool removeItem(KviTaskBarItem *){ return false; };
	virtual void setActiveItem(KviTaskBarItem *){};
	virtual KviTaskBarItem * firstItem(){ return 0; };
	virtual KviTaskBarItem * lastItem(void) { return 0; }
	virtual KviTaskBarItem * nextItem(){ return 0; };
	virtual KviTaskBarItem * prevItem(void) { return 0; }
	virtual bool setIterationPointer(KviTaskBarItem * it){ return false; };
	virtual void switchWindow(bool bNext,bool bInContextOnly);
	virtual void updatePseudoTransparency(){};
};

//
// Implementation details: the following classes should be
// never used directly (with just the exception of KviFrame
// that creates the taskbar)
//

class KviClassicTaskBar;

class KVIRC_API KviTaskBarButton : public QWidget , KviTaskBarItem
{
	friend class KviClassicTaskBar;
	Q_OBJECT
public:
	KviTaskBarButton(QWidget * par,KviWindow * wnd,const char * name);
	~KviTaskBarButton();
protected:
	int                 m_iHighlightLevel;
	int                 m_iProgress;
	bool                m_bActive;
	KviDynamicToolTip * m_pTip;
protected:
	virtual void mousePressEvent(QMouseEvent *e);
#if QT_VERSION >= 300
	virtual void contextMenuEvent(QContextMenuEvent *e);
#endif
	virtual void paintEvent(QPaintEvent *e);
public:
	virtual bool active(){ return m_bActive; };
	virtual int highlightLevel(){ return  m_iHighlightLevel; };
	virtual void highlight(int iLevel = 1);
	virtual void setProgress(int progress);
	virtual void captionChanged();
protected:
	void setActive(bool bActive);
protected slots:
	void tipRequest(KviDynamicToolTip *tip,const QPoint &pnt);
};

class KVIRC_API KviClassicTaskBar : public KviTaskBarBase
{
	Q_OBJECT
public:
	KviClassicTaskBar(KviFrame * lpFrm);
	~KviClassicTaskBar();
protected:
	KviPtrList<KviTaskBarButton> * m_pButtonList;
	int                       m_iButtonHeight;
	QWidget                 * m_pBase;
protected:
	void calcButtonHeight();
	void doLayout();
	void insertButton(KviTaskBarButton * b);
public:
	virtual void fontChange(const QFont & old);
	virtual void resizeEvent(QResizeEvent *e);
public:
	virtual KviTaskBarItem * addItem(KviWindow *);
	virtual bool removeItem(KviTaskBarItem *);
	virtual void setActiveItem(KviTaskBarItem *);
	virtual KviTaskBarItem * firstItem();
	virtual KviTaskBarItem * lastItem(void);
	virtual KviTaskBarItem * nextItem();
	virtual KviTaskBarItem * prevItem(void);
	virtual bool setIterationPointer(KviTaskBarItem * it);
};

class KviTreeTaskBar;

class KVIRC_API KviTreeTaskBarItem : public QListViewItem , public KviTaskBarItem
{
	friend class KviTreeTaskBar;
public:
	KviTreeTaskBarItem(QListView * par,KviWindow * wnd);
	KviTreeTaskBarItem(KviTreeTaskBarItem * par,KviWindow * wnd);
	~KviTreeTaskBarItem();
protected:
	int  m_iProgress;
	int  m_iHighlightLevel;
//	bool m_bActive;
public:
	virtual QString key(int column,bool) const;
	virtual void paintCell(QPainter *p,const QColorGroup &cg,int column,int width,int alignment);
	virtual void paintBranches(QPainter *p,const QColorGroup &cg,int w,int y,int h,GUIStyle s);
	virtual void captionChanged();
	virtual int highlightLevel(){ return m_iHighlightLevel; };
	virtual void highlight(int iLevel = 1);
	virtual void setProgress(int progress);
	virtual bool active(){ return isSelected(); };
protected:
	void setActive(bool bActive);
};

class KVIRC_API KviTreeTaskBarListView : public QListView
{
	friend class KviTreeTaskBarItem;
	Q_OBJECT
public:
	KviTreeTaskBarListView(QWidget * par);
	~KviTreeTaskBarListView();
protected:
	virtual void contentsMousePressEvent(QMouseEvent *e);
	//void paintEmptyAreaInternal(QPainter * p,const QRect &viewportRect,const QRect &painterRect);
	virtual void paintEmptyArea(QPainter * p,const QRect &rct);
	virtual void resizeEvent(QResizeEvent *e);
signals:
	void leftMousePress(QListViewItem * it);
	void rightMousePress(QListViewItem * it);
};


class KVIRC_API KviTreeTaskBar : public KviTaskBarBase
{
	Q_OBJECT
public:
	KviTreeTaskBar(KviFrame * lpFrm);
	~KviTreeTaskBar();
private:
	KviTreeTaskBarListView * m_pListView;
	KviTreeTaskBarItem * m_pCurrentItem;
	KviDynamicToolTip  * m_pToolTip;
public:
	virtual KviTaskBarItem * addItem(KviWindow *);
	virtual bool removeItem(KviTaskBarItem *);
	virtual void setActiveItem(KviTaskBarItem *);
	virtual KviTaskBarItem * firstItem();
	virtual KviTaskBarItem * nextItem(void);
	virtual KviTaskBarItem * lastItem();
	virtual KviTaskBarItem * prevItem(void);
	virtual bool setIterationPointer(KviTaskBarItem * it);
	virtual void updatePseudoTransparency();
protected:
	virtual void moveEvent(QMoveEvent *);
protected slots:
	void leftMousePress(QListViewItem * it);
	void rightMousePress(QListViewItem * it);
	void tipRequest(KviDynamicToolTip *tip,const QPoint &pnt);
	void contextPopupRequested(QListViewItem *it,const QPoint &,int);
//	void mouseButtonPressed(int b,QListViewItem * it,const QPoint &,int);
//	virtual void mousePressEvent(QMouseEvent *e);
};


#endif //_KVI_TASKBAR_H_
