#ifndef _KVI_SCRIPTEDITOR_H_
#define _KVI_SCRIPTEDITOR_H_

//
//   File : kvi_scripteditor.h
//   Creation date : Sun Mar 28 1999 16:11:48 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include <qwidget.h>
#include <qcstring.h>


//
// This is the basic interface of a script editor widget
//
// Actually the REAL script editor is implemented in an
// external module called "libkvieditor", and it is a really
// huge class.
// The constructor of this thing is protected: forget
// about instantiating it directly
//


class KVIRC_API KviScriptEditor : public QWidget
{
	Q_OBJECT
protected:
	KviScriptEditor(QWidget * par);
	~KviScriptEditor();
public:
	virtual void setText(const QCString &txt);
	virtual void getText(QCString &txt);
	static KviScriptEditor * getDummyEditor(QWidget * par);
};

//#ifndef _KVI_SCRIPTEDITOR_CPP_
extern KVIRC_API KviScriptEditor * kvi_createScriptEditor(QWidget * par);
//#endif


#endif //!_KVI_SCRIPTEDITOR_H_
