//
//   File : kvi_scripteditor.cpp
//   Creation date : Sun Mar 28 1999 16:12:41 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __KVIRC__

#define _KVI_SCRIPTEDITOR_CPP_

#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"

#include "kvi_scripteditor.h"
#include "kvi_modulemanager.h"


KviScriptEditor::KviScriptEditor(QWidget * par)
: QWidget(par)
{
}


KviScriptEditor::~KviScriptEditor()
{
}

void KviScriptEditor::setText(const QCString &txt)
{
}

void KviScriptEditor::getText(QCString &txt)
{
}

KviScriptEditor * KviScriptEditor::getDummyEditor(QWidget * par)
{
	return new KviScriptEditor(par);
}


static KviScriptEditor * (*editorModuleCreateScriptEditor)(QWidget *);


KviScriptEditor * kvi_createScriptEditor(QWidget * par)
{
	KviModule * m = g_pModuleManager->getModule("editor");
	// If the module can't be loaded...return a dummy widget
// FIXME: #warning "Maybe provide some sort of basic default editable widget ?"
	if(!m)return KviScriptEditor::getDummyEditor(par); // dummy implementation


	editorModuleCreateScriptEditor = (KviScriptEditor * (*)(QWidget *)) m->getSymbol("editor_module_createScriptEditor");

	if(!editorModuleCreateScriptEditor)return KviScriptEditor::getDummyEditor(par);

	return editorModuleCreateScriptEditor(par);

}

#include "kvi_scripteditor.moc"
