#ifndef _KVI_QUERY_H_
#define _KVI_QUERY_H_
//
//   File : kvi_query.h
//   Creation date : Mon Aug 7 2000 14:19:00 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_window.h"
#include "kvi_string.h"
#include "kvi_ircuserdb.h"
#include "kvi_userlistview.h"

#include <qasciidict.h>

class KviConsole;
class KviConfig;
class QSplitter;
class QToolButton;

class KVIRC_API KviQuery : public KviWindow
{
	Q_OBJECT
public:
	KviQuery(KviFrame * lpFrm,KviConsole * lpConsole,const char * name);
	~KviQuery();
protected:
	//QSplitter                           * m_pTopSplitter;
	KviUserListView                     * m_pUserListView;
	QToolButton                         * m_pListViewButton;
	KviStr                                m_szTargets;
protected:
	virtual QPixmap * myIconPtr();
	virtual void fillCaptionBuffers();
	virtual void resizeEvent(QResizeEvent *e);
	virtual void loadProperties(KviConfig * cfg);
	virtual void saveProperties(KviConfig * cfg);
	virtual void getBaseLogFileName(KviStr &buffer);
	virtual void triggerCreationEvents();
public:
	unsigned int targetCount(){ return m_pUserListView->count(); };
	virtual QSize sizeHint() const;
	virtual const char * target(){ return m_szTargets.ptr(); };
	KviUserListEntry * addTarget(const char * nick,const char *user = 0,const char * host = 0);
	bool removeTarget(const char * nick);
	void removeAllTargets();
	void updateTargets();
	void userAction(KviIrcMask *user,int actionTemperature);
	bool nickChange(const char * oldNick,const char * newNick);
	bool haveTarget(const char * nick){ return (m_pUserListView->findEntry(nick) != 0); };
	void ownMessage(const char * buffer);
	void ownAction(const char * buffer);
	bool avatarChanged(const char * nick){ return m_pUserListView->avatarChanged(nick); };
	void notifyCommonChannels(const char * nick,const char * user,const char * host,int iChans,const char * chans);
	void showListView(bool bShow);
protected slots:
	void textViewRightClicked();
	void toggleListView();
};

#endif //_KVI_CHANNEL_H_
