//
//   File : kvi_optionswidget.h
//   Creation date : Mon Jun 10 2000 17:47:33 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__

#include "kvi_optionswidget.h"

#define _WANT_OPTION_FLAGS_
#include "kvi_options.h"

#include "kvi_app.h"

#include <qobjcoll.h>

#define KVI_OPTIONSWIDGET_GIRDLAYOUT_BORDER 4
#define KVI_OPTIONSWIDGET_GRIDLAYOUT_SPACE 2

//#define KVI_OPTIONSELECTOR_TYPE_BOOL 1
//#define KVI_OPTIONSELECTOR_TYPE_UINT 2
//#define KVI_OPTIONSELECTOR_TYPE_STRING 3
//#define KVI_OPTIONSELECTOR_TYPE_PIXMAP 4


KviOptionsWidget::KviOptionsWidget(QWidget * parent,const char * name,bool bSunken)
: QFrame(parent,name)
{
	if(bSunken)setFrameStyle(QFrame::Panel | QFrame::Sunken);
	else setFrameStyle(QFrame::Panel | QFrame::Plain);
	m_pLayout = 0;
	m_iResetFlags = 0;
	m_iSelectors = 0;
	m_pSelectorInterfaceList = new KviPtrList<KviSelectorInterface>;
	m_pSelectorInterfaceList->setAutoDelete(false);
}

KviOptionsWidget::~KviOptionsWidget()
{
	delete m_pSelectorInterfaceList;
}

void KviOptionsWidget::createLayout(int rows,int cols)
{
	m_pLayout = new QGridLayout(this,rows,cols,KVI_OPTIONSWIDGET_GIRDLAYOUT_BORDER,KVI_OPTIONSWIDGET_GRIDLAYOUT_SPACE);
}


void KviOptionsWidget::addWidgetToLayout(QWidget * w,int x1,int y1,int x2,int y2)
{
	if((x1 == x2) && (y1 == y2))layout()->addWidget(w,y1,x1);
	else layout()->addMultiCellWidget(w,y1,y2,x1,x2);
}

KviDirectorySelector * KviOptionsWidget::addDirectorySelector(int x1,int y1,int x2,int y2,const char * txt,KviStr *pOption,bool bEnabled)
{
	KviDirectorySelector * d = new KviDirectorySelector(this,txt,pOption,bEnabled);
	addWidgetToLayout(d,x1,y1,x2,y2);
	m_pSelectorInterfaceList->append(d);
	return d;
}

KviDirectorySelector * KviOptionsWidget::addDirectorySelector(int x1,int y1,int x2,int y2,const char * txt,int optId,bool bEnabled)
{
	m_iResetFlags |= (g_stringOptionsTable[optId].flags & KviOption_resetMask);
	return addDirectorySelector(x1,y1,x2,y2,txt,&(KVI_OPTION_STRING(optId)),bEnabled);
}



KviFileSelector * KviOptionsWidget::addFileSelector(int x1,int y1,int x2,int y2,const char * txt,KviStr *pOption,bool bEnabled)
{
	KviFileSelector * d = new KviFileSelector(this,txt,pOption,bEnabled);
	addWidgetToLayout(d,x1,y1,x2,y2);
	m_pSelectorInterfaceList->append(d);
	return d;
}

KviFileSelector * KviOptionsWidget::addFileSelector(int x1,int y1,int x2,int y2,const char * txt,int optId,bool bEnabled)
{
	m_iResetFlags |= (g_stringOptionsTable[optId].flags & KviOption_resetMask);
	return addFileSelector(x1,y1,x2,y2,txt,&(KVI_OPTION_STRING(optId)),bEnabled);
}



KviBoolSelector * KviOptionsWidget::addBoolSelector(int x1,int y1,int x2,int y2,const char * txt,bool *pOption,bool bEnabled)
{
	KviBoolSelector * b = new KviBoolSelector(this,txt,pOption,bEnabled);
	addWidgetToLayout(b,x1,y1,x2,y2);
	m_pSelectorInterfaceList->append(b);
	return b;
}

KviBoolSelector * KviOptionsWidget::addBoolSelector(int x1,int y1,int x2,int y2,const char * txt,int optId,bool bEnabled)
{
	m_iResetFlags |= (g_boolOptionsTable[optId].flags & KviOption_resetMask);
	return addBoolSelector(x1,y1,x2,y2,txt,&(KVI_OPTION_BOOL(optId)),bEnabled);
}


KviPixmapSelector * KviOptionsWidget::addPixmapSelector(int x1,int y1,int x2,int y2,const char * txt,KviPixmap *pOption,bool bEnabled)
{
	KviPixmapSelector * b = new KviPixmapSelector(this,txt,pOption,bEnabled);
	addWidgetToLayout(b,x1,y1,x2,y2);
	m_pSelectorInterfaceList->append(b);
	return b;
}

KviPixmapSelector * KviOptionsWidget::addPixmapSelector(int x1,int y1,int x2,int y2,const char * txt,int optId,bool bEnabled)
{
	m_iResetFlags |= (g_pixmapOptionsTable[optId].flags & KviOption_resetMask);
	return addPixmapSelector(x1,y1,x2,y2,txt,&(KVI_OPTION_PIXMAP(optId)),bEnabled);
}

KviUIntSelector * KviOptionsWidget::addUIntSelector(int x1,int y1,int x2,int y2,const char * txt,
	unsigned int * pOption,unsigned int uLowBound,
	unsigned int uHighBound,unsigned int uDefault,bool bEnabled)
{
	KviUIntSelector * u = new KviUIntSelector(this,txt,pOption,uLowBound,uHighBound,uDefault,bEnabled,false);
	addWidgetToLayout(u,x1,y1,x2,y2);
	m_pSelectorInterfaceList->append(u);
	return u;
}

KviUIntSelector * KviOptionsWidget::addUShortIntSelector(int x1,int y1,int x2,int y2,const char * txt,
	unsigned short int * pOption,unsigned int uLowBound,
	unsigned int uHighBound,unsigned int uDefault,bool bEnabled)
{
	KviUIntSelector * u = new KviUIntSelector(this,txt,(unsigned int *)pOption,uLowBound,uHighBound,uDefault,bEnabled,true);
	addWidgetToLayout(u,x1,y1,x2,y2);
	m_pSelectorInterfaceList->append(u);
	return u;
}

KviUIntSelector * KviOptionsWidget::addUIntSelector(int x1,int y1,int x2,int y2,const char * txt,
	int optId,unsigned int uLowBound,
	unsigned int uHighBound,unsigned int uDefault,bool bEnabled)
{
	m_iResetFlags |= (g_uintOptionsTable[optId].flags & KviOption_resetMask);
	return addUIntSelector(x1,y1,x2,y2,txt,&(KVI_OPTION_UINT(optId)),uLowBound,uHighBound,uDefault,bEnabled);
}

KviStringSelector * KviOptionsWidget::addStringSelector(int x1,int y1,int x2,int y2,const char * txt,KviStr *pOption,bool bEnabled)
{
	KviStringSelector * d = new KviStringSelector(this,txt,pOption,bEnabled);
	addWidgetToLayout(d,x1,y1,x2,y2);
	m_pSelectorInterfaceList->append(d);
	return d;
}

KviStringSelector * KviOptionsWidget::addStringSelector(int x1,int y1,int x2,int y2,const char * txt,int optId,bool bEnabled)
{
	m_iResetFlags |= (g_stringOptionsTable[optId].flags & KviOption_resetMask);
	return addStringSelector(x1,y1,x2,y2,txt,&(KVI_OPTION_STRING(optId)),bEnabled);
}


KviPasswordSelector * KviOptionsWidget::addPasswordSelector(int x1,int y1,int x2,int y2,const char * txt,KviStr *pOption,bool bEnabled)
{
	KviPasswordSelector * d = new KviPasswordSelector(this,txt,pOption,bEnabled);
	addWidgetToLayout(d,x1,y1,x2,y2);
	m_pSelectorInterfaceList->append(d);
	return d;
}

KviPasswordSelector * KviOptionsWidget::addPasswordSelector(int x1,int y1,int x2,int y2,const char * txt,int optId,bool bEnabled)
{
	m_iResetFlags |= (g_stringOptionsTable[optId].flags & KviOption_resetMask);
	return addPasswordSelector(x1,y1,x2,y2,txt,&(KVI_OPTION_STRING(optId)),bEnabled);
}

KviStringListSelector * KviOptionsWidget::addStringListSelector(int x1,int y1,int x2,int y2,const char * txt,QStringList * pOption,bool bEnabled)
{
	KviStringListSelector * d = new KviStringListSelector(this,txt,pOption,bEnabled);
	addWidgetToLayout(d,x1,y1,x2,y2);
	m_pSelectorInterfaceList->append(d);
	return d;
}

KviStringListSelector * KviOptionsWidget::addStringListSelector(int x1,int y1,int x2,int y2,const char * txt,int optId,bool bEnabled)
{
	m_iResetFlags |= (g_stringlistOptionsTable[optId].flags & KviOption_resetMask);
	return addStringListSelector(x1,y1,x2,y2,txt,&(KVI_OPTION_STRINGLIST(optId)),bEnabled);
}



KviColorSelector * KviOptionsWidget::addColorSelector(int x1,int y1,int x2,int y2,const char * txt,int optId,bool bEnabled)
{
	m_iResetFlags |= (g_colorOptionsTable[optId].flags & KviOption_resetMask);
	return addColorSelector(x1,y1,x2,y2,txt,&(KVI_OPTION_COLOR(optId)),bEnabled);
}

KviColorSelector * KviOptionsWidget::addColorSelector(int x1,int y1,int x2,int y2,const char * txt,QColor * pOption,bool bEnabled)
{
	KviColorSelector * s = new KviColorSelector(this,txt,pOption,bEnabled);
	addWidgetToLayout(s,x1,y1,x2,y2);
	m_pSelectorInterfaceList->append(s);
	return s;
}

KviFontSelector * KviOptionsWidget::addFontSelector(int x1,int y1,int x2,int y2,const char * txt,int optId,bool bEnabled)
{
	m_iResetFlags |= (g_fontOptionsTable[optId].flags & KviOption_resetMask);
	return addFontSelector(x1,y1,x2,y2,txt,&(KVI_OPTION_FONT(optId)),bEnabled);
}

KviFontSelector * KviOptionsWidget::addFontSelector(int x1,int y1,int x2,int y2,const char * txt,QFont * pOption,bool bEnabled)
{
	KviFontSelector * f = new KviFontSelector(this,txt,pOption,bEnabled);
	addWidgetToLayout(f,x1,y1,x2,y2);
	m_pSelectorInterfaceList->append(f);
	return f;
}
//#define DECLARE_COMMIT_FUNCTION(__fnc,__class,__classString) 
//	void KviOptionsWidget::__fnc() 
//	{ 
//		QObjectList * l = queryList(__classString); 
//		if(!l)return; 
//		QObjectListIt it(*l); 
//		while(it.current()) 
//		{ 
//			((__class *)it.current())->commit(); 
//			++it; 
//		} 
//		delete l; 
//	}

//DECLARE_COMMIT_FUNCTION(commitBoolSelectors,KviBoolSelector,"KviBoolSelector")
//DECLARE_COMMIT_FUNCTION(commitUIntSelectors,KviUIntSelector,"KviUIntSelector")
//DECLARE_COMMIT_FUNCTION(commitStringSelectors,KviStringSelector,"KviStringSelector")
//DECLARE_COMMIT_FUNCTION(commitPixmapSelectors,KviPixmapSelector,"KviPixmapSelector")

void KviOptionsWidget::addRowSpacer(int x1,int y1,int x2,int y2)
{
	QWidget * w = new QWidget(this);
	addWidgetToLayout(w,x1,y1,x2,y2);
	layout()->setRowStretch(y1,1);
}

QLabel * KviOptionsWidget::addLabel(int x1,int y1,int x2,int y2,const char * text,bool bEnabled)
{
	QLabel * l = new QLabel(__c2q(text),this);
	l->setEnabled(bEnabled);
	addWidgetToLayout(l,x1,y1,x2,y2);
	return l;
}

QLineEdit * KviOptionsWidget::addLineEdit(int x1,int y1,int x2,int y2,bool bEnabled)
{
	QLineEdit * l = new QLineEdit(this);
	l->setEnabled(bEnabled);
	addWidgetToLayout(l,x1,y1,x2,y2);
	return l;
}

QFrame * KviOptionsWidget::addSeparator(int x1,int y1,int x2,int y2)
{
	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	addWidgetToLayout(f,x1,y1,x2,y2);
	return f;
}


void KviOptionsWidget::commitSelectors()
{
//	if(m_iSelectors & KVI_OPTIONSELECTOR_TYPE_BOOL)commitBoolSelectors();
//	if(m_iSelectors & KVI_OPTIONSELECTOR_TYPE_UINT)commitUIntSelectors();
//	if(m_iSelectors & KVI_OPTIONSELECTOR_TYPE_STRING)commitStringSelectors();
//	if(m_iSelectors & KVI_OPTIONSELECTOR_TYPE_PIXMAP)commitPixmapSelectors();
//	m_iSelectors = 0;
	for(KviSelectorInterface * i = m_pSelectorInterfaceList->first();i;i = m_pSelectorInterfaceList->next())
	{
		i->commit();
	}
}

void KviOptionsWidget::commitOptionsReset()
{
	if(m_iResetFlags)g_pApp->optionResetUpdate(m_iResetFlags);
	//m_iResetFlags = 0;
}

void KviOptionsWidget::commit()
{
	commitSelectors();
	commitOptionsReset();
}

#include "kvi_optionswidget.moc"
