#ifndef _KVI_MENUBAR_H_
#define _KVI_MENUBAR_H_

//
//   File : kvi_menubar.h
//   Creation date : Wen Jun 21 2000 13:11:24 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include "kvi_tal_menubar.h"
#include "kvi_string.h"

#include "kvi_list.h"

class KviFrame;
class QPopupMenu;
class KviPopupMenu;

typedef struct _KviScriptMenuBarItem
{
	int            id;
	KviStr         szPopupName;
	KviPopupMenu * pPopup;
	KviStr         szText;
} KviScriptMenuBarItem;


class KVIRC_API KviMenuBar : public KviTalMenuBar
{
	Q_OBJECT
public:
	KviMenuBar(KviFrame * par,const char * name);
	~KviMenuBar();
	QPopupMenu * toolsMenu() { return m_pTools; };
private:
	QPopupMenu * m_pTools;
protected:
	QPopupMenu                  * m_pRecentServersPopup;
	KviFrame                    * m_pFrm;
	KviPtrList<KviScriptMenuBarItem> * m_pScriptItemList;
	int                           m_iNumDefaultItems;
	int                         * m_pDefaultItemId;
protected:
	KviScriptMenuBarItem * findMenu(const char * text);
	KviScriptMenuBarItem * findMenu(KviPopupMenu * p);
	void addDefaultItem(const QString &text,QPopupMenu * pop);
public:
	int getDefaultItemRealIndex(int iDefaultIndex);
	void addMenu(const char * text,KviPopupMenu * p,int index);
	bool removeMenu(const char * text);
protected slots:
	void menuDestroyed();
	void setupMainPopup();
	void setupRecentServersPopup();
	void newConnectionToServer(int id);
};

#endif //_KVI_MENUBAR_H_
