//
//   File : kvi_menubar.cpp
//   Creation date : Wen Jun 21 2000 13:12:11 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__
#include "kvi_menubar.h"
#include "kvi_app.h"
#include "kvi_locale.h"
#include "kvi_frame.h"
#include "kvi_mdimanager.h"
#include "kvi_iconmanager.h"
#include "kvi_internalcmd.h"
#include "kvi_settings.h"
#include "kvi_ircurl.h"
#include "kvi_uparser.h"
#include "kvi_console.h"
#include "kvi_popupmenu.h"
#include "kvi_malloc.h"

#include <qpopupmenu.h>

KviMenuBar::KviMenuBar(KviFrame * par,const char * name)
: KviTalMenuBar(par,name)
{
	m_pFrm = par;

	m_iNumDefaultItems = 0;
	m_pDefaultItemId = 0;

	QPopupMenu * pop = new QPopupMenu(this);
	connect(pop,SIGNAL(aboutToShow()),this,SLOT(setupMainPopup()));
	addDefaultItem("&KVIrc",pop);

	m_pRecentServersPopup = new QPopupMenu(this);
	connect(m_pRecentServersPopup,SIGNAL(aboutToShow()),this,SLOT(setupRecentServersPopup()));
	connect(m_pRecentServersPopup,SIGNAL(activated(int)),this,SLOT(newConnectionToServer(int)));

	m_pScriptItemList = 0;

	QPopupMenu * opt = new QPopupMenu(this);
// FIXME: #warning "Toggle these items on the fly ?"
	int id = opt->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_OPTIONS)),__c2q(__tr("&Options")),m_pFrm,SLOT(executeInternalCommand(int)));
	opt->setItemParameter(id,KVI_INTERNALCOMMAND_OPTIONS_DIALOG);
	id = opt->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_REGUSERS)),__c2q(__tr("&Registered users")),m_pFrm,SLOT(executeInternalCommand(int)));
	opt->setItemParameter(id,KVI_INTERNALCOMMAND_REGUSER_EDIT);
	id = opt->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_SCRIPTCENTER)),__c2q(__tr("&Script center")),m_pFrm,SLOT(executeInternalCommand(int)));
	opt->setItemParameter(id,KVI_INTERNALCOMMAND_SCRIPTCENTER_OPEN);
	opt->insertSeparator();
	opt->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_FLOPPY)),__c2q(__tr("&Save configuration")),g_pApp,SLOT(saveConfiguration()));

	addDefaultItem(__c2q(__tr("&Settings")),opt);

	m_pTools = new QPopupMenu(this);
	m_pTools->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_ICONMANAGER)),__c2q(__tr("&Icon widget")),g_pIconManager,SLOT(showIconWidget()));
//	id = m_pTools->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_ICQ)),__c2q(__tr("Ic&q window")),m_pFrm,SLOT(executeInternalCommand(int)));
//	m_pTools->setItemParameter(id,KVI_INTERNALCOMMAND_ICQ_OPEN);
	id = m_pTools->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_GNUTELLA)),__c2q(__tr("&Gnutella window")),m_pFrm,SLOT(executeInternalCommand(int)));
	m_pTools->setItemParameter(id,KVI_INTERNALCOMMAND_GNUTELLA_OPEN);
#ifdef COMPILE_KDE_SUPPORT
	id = m_pTools->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_TERMINAL)),__c2q(__tr("&Terminal window")),m_pFrm,SLOT(executeInternalCommand(int)));
	m_pTools->setItemParameter(id,KVI_INTERNALCOMMAND_TERM_OPEN);
#endif
	id = m_pTools->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_FOLDER)),__c2q(__tr("&Directory browser")),m_pFrm,SLOT(executeInternalCommand(int)));
	m_pTools->setItemParameter(id,KVI_INTERNALCOMMAND_BROWSER_OPEN);
// FIXME: #warning "New icon for browser MDI"
	id = m_pTools->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_FOLDER)),__c2q(__tr("&Directory browser (MDI)")),m_pFrm,SLOT(executeInternalCommand(int)));
	m_pTools->setItemParameter(id,KVI_INTERNALCOMMAND_BROWSER_OPEN_MDI);
	id = m_pTools->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_LOG)),__c2q(__tr("&Log viewer")),m_pFrm,SLOT(executeInternalCommand(int)));
	m_pTools->setItemParameter(id,KVI_INTERNALCOMMAND_LOGVIEWER_OPEN);
    id = m_pTools->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_LOG)),__c2q(__tr("Log viewer (&MDI)")),m_pFrm,SLOT(executeInternalCommand(int)));
    m_pTools->setItemParameter(id,KVI_INTERNALCOMMAND_LOGVIEWERMDI_OPEN);
	id = m_pTools->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_OFFER)),__c2q(__tr("&Offer list")),m_pFrm,SLOT(executeInternalCommand(int)));
	m_pTools->setItemParameter(id,KVI_INTERNALCOMMAND_OFFER_WINDOW);


	addDefaultItem(__c2q(__tr("&Tools")),m_pTools);

	addDefaultItem(__c2q(__tr("&Window")),par->mdiManager()->windowPopup());

	QPopupMenu * help = new QPopupMenu(this);
	id = help->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_HELP)),__c2q(__tr("&Help (static browser)")),m_pFrm,SLOT(executeInternalCommand(int)));
	help->setItemParameter(id,KVI_INTERNALCOMMAND_HELP_NEWSTATICWINDOW);
	id = help->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_MDIHELP)),__c2q(__tr("Help (&MDI browser)")),m_pFrm,SLOT(executeInternalCommand(int)));
	help->setItemParameter(id,KVI_INTERNALCOMMAND_HELP_NEWMDIWINDOW);
	help->insertSeparator();
	id = help->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_IDEA)),__c2q(__tr("&Did you know...")),m_pFrm,SLOT(executeInternalCommand(int)));
	help->setItemParameter(id,KVI_INTERNALCOMMAND_TIP_OPEN);
	help->insertSeparator();
	id = help->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_KVIRC)),__c2q(__tr("About &KVIrc...")),m_pFrm,SLOT(executeInternalCommand(int)));
	help->setItemParameter(id,KVI_INTERNALCOMMAND_ABOUT_ABOUTKVIRC);
//	id = help->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_KVIRC)),__c2q(__tr("&Build info")),par,SLOT(executeInternalCommand(int)));
//	help->setItemParameter(id,KVI_INTERNALCOMMAND_ABOUT_BUILDINFO);
	help->insertSeparator();
	id = help->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_HOMEPAGE)),__c2q(__tr("KVIrc home&page")),m_pFrm,SLOT(executeInternalCommand(int)));
	help->setItemParameter(id,KVI_INTERNALCOMMAND_KVIRC_HOMEPAGE);

	addDefaultItem(__c2q(__tr("&Help")),help);


//	setBackgroundMode( PaletteBackground );
}

KviMenuBar::~KviMenuBar()
{
	if(m_pScriptItemList)delete m_pScriptItemList;
	if(m_pDefaultItemId)kvi_free(m_pDefaultItemId);
}

void KviMenuBar::addDefaultItem(const QString &text,QPopupMenu * pop)
{
	m_iNumDefaultItems++;
	m_pDefaultItemId = (int *)kvi_realloc((void *)m_pDefaultItemId,sizeof(int) * m_iNumDefaultItems);
	m_pDefaultItemId[m_iNumDefaultItems - 1] = insertItem(text,pop);
}

//void KviMenuBar::setBackgroundMode(QWidget::BackgroundMode)
//{
//	// forget any other background mode
//	QMenuBar::setBackgroundMode(PaletteButton);
//}

/*
void KviMenuBar::styleChange(QStyle &old)
{
	QMenuBar::styleChange(old);
	setBackgroundMode(PaletteButton);
}
*/
void KviMenuBar::setupMainPopup()
{
	QPopupMenu * main = (QPopupMenu *)sender();

	main->clear();

	main->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_CONSOLE)),__c2q(__tr("&New irc context")),m_pFrm,SLOT(newConsole()));
	main->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_WORLD)),__c2q(__tr("&New connection to")),m_pRecentServersPopup);

	main->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_RAW)),__c2q(__tr("New &frame window")),g_pApp,SLOT(createNewFrame()));

	main->insertSeparator();

	if(m_pFrm->dockExtension())
	{
		int id = main->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_DOCKWIDGET)),__c2q(__tr("Hide &dock widget")),m_pFrm,SLOT(executeInternalCommand(int)));
		main->setItemParameter(id,KVI_INTERNALCOMMAND_DOCKWIDGET_HIDE);
	} else {
		int id = main->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_DOCKWIDGET)),__c2q(__tr("Show &dock widget")),m_pFrm,SLOT(executeInternalCommand(int)));
		main->setItemParameter(id,KVI_INTERNALCOMMAND_DOCKWIDGET_SHOW);
	}

	main->insertSeparator();

	main->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_QUITAPP)),__c2q(__tr("&Quit")),g_pApp,SLOT(quit()));
}

void KviMenuBar::setupRecentServersPopup()
{
	g_pApp->fillRecentServersPopup((QPopupMenu *)sender());
}

void KviMenuBar::newConnectionToServer(int id)
{
	KviStr text = m_pRecentServersPopup->text(id);
	if(text.hasData())
	{
		KviStr szCommand;
		if(parseIrcUrl(text.ptr(),szCommand,KVI_IRCURL_CONTEXT_NEW))
		{
			g_pUserParser->parseCommandBuffer(szCommand.ptr(),m_pFrm->firstConsole());
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Script items
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int KviMenuBar::getDefaultItemRealIndex(int iDefaultIndex)
{
	if(iDefaultIndex < 0)iDefaultIndex = 0;
	if(iDefaultIndex >= m_iNumDefaultItems)
		return indexOf(m_pDefaultItemId[m_iNumDefaultItems - 1]) + 1;
	return indexOf(m_pDefaultItemId[iDefaultIndex]);
}

KviScriptMenuBarItem * KviMenuBar::findMenu(const char * text)
{
	if(!m_pScriptItemList)return 0;
	for(KviScriptMenuBarItem * i = m_pScriptItemList->first();i;i = m_pScriptItemList->next())
	{
		if(kvi_strEqualCI(i->szText.ptr(),text))return i;
	}
	return 0;
}

KviScriptMenuBarItem * KviMenuBar::findMenu(KviPopupMenu * p)
{
	if(!m_pScriptItemList)return 0;
	for(KviScriptMenuBarItem * i = m_pScriptItemList->first();i;i = m_pScriptItemList->next())
	{
		if(i->pPopup == p)return i;
	}
	return 0;
}

bool KviMenuBar::removeMenu(const char * text)
{
	KviScriptMenuBarItem * i = findMenu(text);
	if(i)
	{
		disconnect(i->pPopup,SIGNAL(destroyed()),this,SLOT(menuDestroyed()));
		removeItem(i->id);
		m_pScriptItemList->removeRef(i);
		return true;
	}
	return false;
}

void KviMenuBar::menuDestroyed()
{
	KviScriptMenuBarItem * i = findMenu(((KviPopupMenu *)sender()));
	if(i)
	{
		removeItem(i->id);
		m_pScriptItemList->removeRef(i);
	}
}

void KviMenuBar::addMenu(const char * text,KviPopupMenu * p,int index)
{
	if(!m_pScriptItemList)
	{
		m_pScriptItemList = new KviPtrList<KviScriptMenuBarItem>;
		m_pScriptItemList->setAutoDelete(true);
	}/* else {
		removeMenu(text);
	}*/
	KviScriptMenuBarItem * it = new KviScriptMenuBarItem;
	it->szText = text;
	it->szPopupName = p->name();
	it->pPopup = p;
	it->id = insertItem(text,p,-1,index);
	connect(p,SIGNAL(destroyed()),this,SLOT(menuDestroyed()));
	m_pScriptItemList->append(it);
}

#include "kvi_menubar.moc"
