#ifndef _KVI_MDIMANAGER_H_
#define _KVI_MDIMANAGER_H_
//
//   File : kvi_mdimanager.h
//   Creation date : Wed Jun 21 2000 17:28:04 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include <qframe.h>
#include "kvi_list.h"
#include <qpixmap.h>

#define KVI_MDICHILD_BORDER 3
#define KVI_MDICHILD_SPACING 1
#define KVI_MDICHILD_MIN_WIDTH 100
#define KVI_MDICHILD_MIN_HEIGHT 40
#define KVI_MDICHILD_HIDDEN_EDGE 3
#define KVI_MDICHILD_DOUBLE_HIDDEN_EDGE 6

class KviMdiChild;
class KviMdiCaptionButton;
class KviFrame;

class QPopupMenu;

class KVIRC_API KviMdiManager : public QFrame
{
	friend class KviMdiChild;
	friend class KviMdiCaption;
	Q_OBJECT
public:
	KviMdiManager(QWidget * parent,KviFrame * pFrm,const char * name);
	~KviMdiManager();
public:
	KviMdiChild * topChild(){ return m_pZ->last(); };
	void manageChild(KviMdiChild * lpC,bool bCascade = true,QRect * setGeom = 0);
	void setTopChild(KviMdiChild *lpC,bool bSetFocus);
	void showAndActivate(KviMdiChild * lpC);
	QPopupMenu * windowPopup(){ return m_pWindowPopup; };
	void focusTopChild();
	void destroyChild(KviMdiChild *lpC,bool bFocusTopChild = true);
	int getVisibleChildCount();
protected:
	KviPtrList<KviMdiChild>  * m_pZ; // topmost child is the last in the list
	QFrame              * m_pSdiFrame;
	KviMdiCaptionButton * m_pSdiRestoreButton;
	KviMdiCaptionButton * m_pSdiMinimizeButton;
	KviMdiCaptionButton * m_pSdiCloseButton;
	int                   m_iSdiIconItemId;
	QPopupMenu          * m_pWindowPopup;
	QPopupMenu          * m_pTileMethodPopup;
	KviFrame            * m_pFrm;
protected:
	void childMaximized(KviMdiChild *lpC);
	void childMinimized(KviMdiChild *lpC,bool bWasMaximized);
	void childRestored(KviMdiChild *lpC,bool bWasMaximized);
	virtual void focusInEvent(QFocusEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void resizeEvent(QResizeEvent *e);
	virtual void drawContents(QPainter *p);
public slots:
	void cascadeWindows();
	void cascadeMaximized();
	void expandVertical();
	void expandHorizontal();
	void tile();
	void toggleAutoTile();

	void tileAnodine();
/*
	void tilePragma4Vertical();
	void tilePragma4Horizontal();
	void tilePragma6Vertical();
	void tilePragma6Horizontal();
	void tilePragma9Vertical();
	void tilePragma9Horizontal();
*/
protected slots:
	void minimizeActiveChild();
	void restoreActiveChild();
	void closeActiveChild();
	void activeChildSystemPopup();
	void menuActivated(int id);
	void tileMethodMenuActivated(int id);
	void fillWindowPopup();
private:
	void tileAllInternal(int maxWnds,bool bHorizontal);
	QPoint getCascadePoint(int indexOfWindow);
	void enterSDIMode(KviMdiChild *lpC);
	void leaveSDIMode();
	void updateSDIMode();
signals:
	void enteredSdiMode();
	void leftSdiMode();
};

#endif //_KVI_MDIMANAGER_H_
