#ifndef _KVI_MDICHILD_H_
#define _KVI_MDICHILD_H_
//=================================================================================================
//
//   File : kvi_mdichild.h
//   Creation date : Wed Jun 21 2000 17:35:04 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=================================================================================================

#include "kvi_settings.h"
#include "kvi_string.h"

#include <qframe.h>
#include <qtoolbutton.h>
#include <qlabel.h>


class KviMdiManager;
class KviMdiChild;

class QCursor;


class KVIRC_API KviMdiCaptionButton : public QToolButton
{
	Q_OBJECT
public:
	KviMdiCaptionButton(const QPixmap &pix,QWidget * parent,const char * name);
	~KviMdiCaptionButton();
protected:
	virtual void drawButton(QPainter * p);
};


class KVIRC_API KviMdiCaption : public QLabel
{
	Q_OBJECT
public:
	KviMdiCaption(KviMdiChild * parent,const char * name);
	~KviMdiCaption();
protected:
	QPoint m_lastMousePos;
	bool   m_bMouseGrabbed;
	int    m_iLineSpacing;
	bool   m_bActive;
public:
	int heightHint();
	void setActive(bool bActive);
	bool active(){ return m_bActive; };
protected:
	virtual void fontChange(const QFont &old);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseMoveEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *e);
};


class KVIRC_API KviMdiChild : public QFrame
{
	friend class KviMdiManager;
	friend class KviMdiCaption;
	Q_OBJECT
public:
	KviMdiChild(KviMdiManager* par,const char * name = 0);
	~KviMdiChild();
public:
	enum MdiChildState { Maximized , Minimized , Normal };
protected:
	KviMdiCaptionButton        * m_pMaximizeButton;
	KviMdiCaptionButton        * m_pMinimizeButton;
	KviMdiCaptionButton        * m_pCloseButton;
	KviMdiCaption              * m_pCaptionLabel;
	KviMdiCaptionButton        * m_pIconButton;
private:
	int                          m_iResizeCorner;
	int                          m_iLastCursorCorner;
	bool                         m_bResizeMode;
	QWidget                    * m_pClient;
	MdiChildState                m_state;
	QRect                        m_restoredGeometry;

	KviStr                       m_szXmlActiveCaption;
	KviStr                       m_szXmlInactiveCaption;
	KviStr                       m_szPlainCaption;
public:
	void setClient(QWidget * w);
	void unsetClient();
	KviMdiCaption * captionLabel(){ return m_pCaptionLabel; };
	MdiChildState state(){ return m_state; };
	const char * plainCaption(){ return m_szPlainCaption.ptr(); };
	const char * xmlActiveCaption(){ return m_szXmlActiveCaption.ptr(); };
	const char * xmlInactiveCaption(){ return m_szXmlInactiveCaption.ptr(); };
	void setCaption(const char * plain,const char * xmlActive,const char * xmlInactive);
	virtual QSize sizeHint();
	void setIcon(const QPixmap &pix);
	const QPixmap * icon();
	void enableClose(bool bEnable);
	bool closeEnabled();
	KviMdiManager * manager(){ return ((KviMdiManager *)parent()); };
public slots:
	void maximize();
	void minimize();
	void restore();
	void systemPopupSlot();
	void closeRequest();
signals:
	void systemPopupRequest(const QPoint & pnt);
protected:
	virtual void setBackgroundMode(QWidget::BackgroundMode bgmd);
	virtual void resizeEvent(QResizeEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseMoveEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *e);
	virtual void leaveEvent(QEvent *e);
	virtual void focusInEvent(QFocusEvent *);
	virtual void moveEvent(QMoveEvent *e);
	bool eventFilter(QObject *o,QEvent *e);
	void emitSystemPopupRequest(const QPoint & pnt){ emit systemPopupRequest(pnt); };
private:
	void linkChildren(QWidget *w);
	void unlinkChildren(QWidget *w);
	QCursor getResizeCursor(int resizeCorner);
	void resizeWindowOpaque(int resizeCorner);
	int getResizeCorner(int ax,int ay);
	void calculateMinimumSize(int &minWidth,int &minHeight);
	void setResizeCursor(int resizeCorner);
	void calculateResizeRect(int resizeCorner,QPoint mousePos,QRect &resizeRect,int minWidth,int minHeight);
};


#endif //_KVI_MDICHILD_H_
