#ifndef _KVI_MASKEDITOR_H_
#define _KVI_MASKEDITOR_H_

//
//   File : kvi_maskeditor.h
//   Creation date : Tue Aug 30 2000 12:20:10 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include <qwidget.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include "kvi_list.h"

#include "kvi_string.h"

typedef struct _KviMaskEntry
{
	KviStr szMask;
	KviStr szSetBy;
	KviStr szSetAt;
} KviMaskEntry;

class KVIRC_API KviMaskEditor : public QWidget
{
	Q_OBJECT
public:
	KviMaskEditor(QWidget * par,KviPtrList<KviMaskEntry> * maskList,
		char flag,const char * nam);
	~KviMaskEditor();
protected:
	QListView           * m_pMaskBox;
	QPushButton         * m_pRemoveMask;
	char                  m_cFlag;
public:
	char flag(){ return m_cFlag; };
	void addMask(KviMaskEntry *e);
	void removeMask(KviMaskEntry *e);
protected slots:
	void removeClicked();
signals:
	void removeMasks(KviMaskEditor *,KviPtrList<KviMaskEntry> *);
};

#endif //_KVI_MASKEDITOR_H_
