//
//   File : kvi_maskeditor.cpp
//   Creation date : Tue Aug 30 2000 12:24:59 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__
#include "kvi_maskeditor.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"

#include <qlayout.h>
#include <qlabel.h>

KviMaskEditor::KviMaskEditor(QWidget * par,KviPtrList<KviMaskEntry> * maskList,char flag,const char * nam)
: QWidget(par,nam)
{
	setFocusPolicy(QWidget::ClickFocus);

	QGridLayout *g = new QGridLayout(this,3,2,2,2);

	m_cFlag = flag;

	const char * txt;
	int          ico;
	switch(flag)
	{
		case 'b':
			txt = __tr("Active bans");
			ico = KVI_SMALLICON_BAN;
		break;
		case 'I':
			txt = __tr("Active invite exceptions");
			ico = KVI_SMALLICON_INVITEEXCEPT;
		break;
		case 'e':
			txt = __tr("Active ban exceptions");
			ico = KVI_SMALLICON_BANEXCEPT;
		break;
		default:
			txt = "?";
			ico = KVI_SMALLICON_UNHANDLED;
		break;
	}

	QLabel * l = new QLabel("",this);
	l->setPixmap(*(g_pIconManager->getSmallIcon(ico)));
	g->addWidget(l,0,0);

	l = new QLabel(txt,this);
	g->addWidget(l,0,1);

	m_pMaskBox = new QListView(this);
	m_pMaskBox->setFocusPolicy(QWidget::ClickFocus);
	m_pMaskBox->setFocusProxy(this);
	m_pMaskBox->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
	m_pMaskBox->addColumn(__tr(" - Mask - List - "));
	m_pMaskBox->addColumn(__tr("Set by"));
	m_pMaskBox->addColumn(__tr("Set at"));
	m_pMaskBox->setMultiSelection(true);
	m_pMaskBox->setAllColumnsShowFocus(true);
	g->addMultiCellWidget(m_pMaskBox,1,1,0,1);

	m_pRemoveMask  = new QPushButton(__tr("Remove"),this);
	m_pRemoveMask->setFocusPolicy(QWidget::ClickFocus);
	m_pRemoveMask->setFocusProxy(this);
	connect(m_pRemoveMask,SIGNAL(clicked()),this,SLOT(removeClicked()));
	g->addMultiCellWidget(m_pRemoveMask,2,2,0,1);

	g->setColStretch(1,1);

	for(KviMaskEntry * e = maskList->first();e;e = maskList->next())addMask(e);
}

KviMaskEditor::~KviMaskEditor()
{
}

void KviMaskEditor::removeClicked()
{
	KviPtrList<KviMaskEntry>  * l = new KviPtrList<KviMaskEntry>;
	l->setAutoDelete(true);
	QListViewItem * it = m_pMaskBox->firstChild();
	while(it)
	{
		if(it->isSelected())
		{
			KviMaskEntry * e = new KviMaskEntry;
			e->szMask  = it->text(0);
			e->szSetBy = it->text(1);
			e->szSetAt = it->text(2);
			l->append(e);
		}
		it = it->nextSibling();
	}
	if(l->count() > 0)emit removeMasks(this,l);
	delete l;
}

void KviMaskEditor::addMask(KviMaskEntry *e)
{
	QListViewItem *it = new QListViewItem(m_pMaskBox,e->szMask.ptr(),e->szSetBy.ptr(),e->szSetAt.ptr());
}

void KviMaskEditor::removeMask(KviMaskEntry *e)
{
	QListViewItem * it = m_pMaskBox->firstChild();
	while(it)
	{
		KviStr tmp = it->text(0);
		if(kvi_strEqualCI(tmp.ptr(),e->szMask.ptr()))
		{
			delete it;
			return;
		}
		it = it->nextSibling();
	}
}

#include "kvi_maskeditor.moc"
