//
//   File : kvi_ircview.cpp
//   Creation date : Tue Jul 6 1999 14:45:20 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __KVIRC__

// Damn complex class ...but it works :)
// #include <brain.h>
//
// #define HOPE_THAT_IT_WILL_NEWER_NEED_TO_BE_MODIFIED :)

// 07 May 1999 ,
//      Already forgot how this damn thing works ,
//      and spent 1 hour over a stupid bug.
//      I had to recreate the whole thing in my mind......ooooouh...
//      How did I wrote it ?
//      Just take a look to paintEvent() or to calculateLineWraps()...
//      Anyway...I've solved the bug.

// 23 Nov 1999 ,
//      Well , not so bad...I seem to still remember how it works
//      So just for fun , complicated the things a little bit more.
//      Added precaclucaltion of the text blocks and word wrapping
//      and a fast scrolling mode (3 lines at once) for consecutive
//      appendText() calls.
//      Now the code becomes really not understandable...:)

// 29 Jun 2000 21:02 ,
//      Here we go again... I have to adjust this stuff for 3.0.0
//      Will I make this thingie work ?
// 01 Jul 2000 04:20 (AM!) ,
//      Yes....I got it to work just now
//      and YES , complicated the things yet more.
//      This time made some paint event code completly unreadable
//      by placing two monster macros...
//      I hope that you have a smart compiler (such as gcc is).

// 09 Dec 2000
//      This is my C-asm-optimisation-hack playground
//      Expect Bad Programming(tm) , Ugly Code(tm) , Unreadable Macros (tm)
//      and massive usage of the Evil(tm) goto.

// 25 Sep 2001
//      This stuff is going to be ported to Windoze
//      A conditionally compiled code will use only Qt calls...let's see :)
//


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Here we go... a huge set of includes
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define _KVI_IRCVIEW_CPP_

//#define _KVI_DEBUG_CLASS_NAME_ "KviIrcView"
//#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_settings.h"
#include "kvi_options.h"
#include "kvi_mirccntrl.h"
#include "kvi_ircview.h"
#include "kvi_defaults.h"
#include "kvi_window.h"
#include "kvi_locale.h"
#include "kvi_frame.h"
#include "kvi_malloc.h"
#include "kvi_memmove.h"
#include "kvi_iconmanager.h"
#include "kvi_out.h"
#include "kvi_uparser.h"
#include "kvi_parameterlist.h"
#include "kvi_event.h"
#include "kvi_console.h"
#include "kvi_ircuserdb.h"
#include "kvi_channel.h"
#include "kvi_topicw.h"
#include "kvi_query.h"
#include "kvi_filedialog.h"
#include "kvi_msgbox.h"
#include "kvi_texticonmanager.h"

#ifndef COMPILE_NO_X_DRAW_CALLS
	#include "kvi_xlib.h"
#endif

// FIXME: #warning "There should be an option to preserve control codes in copied text (clipboard) (mIrc = CTRL+Copy->with colors)"

#include <qbitmap.h>
#include <qpainter.h>
#include <qregexp.h>
#include <qtabwidget.h>
#include <qheader.h>

// FIXME: #warning "There are problems with the selection and wrapped lines: you can select something on the first line and get the second highlighted"
// FIXME: #warning "This hack is temporary...later remove it"

#if QT_VERSION >= 300
	#ifndef QT_CLEAN_NAMESPACE
		#define QT_CLEAN_NAMESPACE
		#include <qcursor.h>
		#undef QT_CLEAN_NAMESPACE
	#else
		#include <qcursor.h>
	#endif
#else
	#include <qcursor.h>
#endif

#include <qclipboard.h>
#include <qdatetime.h>
#include <qdragobject.h>
#include <qmessagebox.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <time.h>


#ifdef COMPILE_ON_WINDOWS
	#pragma warning(disable: 4102)
#endif

// FIXME: #warning "The scrollbar should NOT have a fixed size : the KDE styles can configure the size (sizeHint() ?)"

//
// FIXME: PgUp and PgDn scrolls a fixed number of lines!
//        Make it view height dependant
//
// FIXME: This widget is quite slow on a 300 MHz processor
//


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Globals
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Stuff declared in kvi_app.cpp and managed by KviApp class

#ifndef COMPILE_NO_X_DRAW_CALLS

	// global display
	extern Display           * g_display;
	// stuff shared between all the ircviews
	extern GC                  g_ircviewGC;
	extern HANDLE              g_hIrcViewMemBuffer;

	#ifdef COMPILE_USE_AA_FONTS
		static XftFont       * g_pIrcViewXftFont;
		static XftDraw       * g_pIrcViewXftDraw;
		// prototypes fo Qt internal functions
	#endif
	
#endif //!COMPILE_NO_X_DRAW_CALLS

#ifdef COMPILE_PSEUDO_TRANSPARENCY
	extern QPixmap       * g_pShadedChildGlobalDesktopBackground;
#endif

extern QPixmap           * g_pIrcViewMemBuffer;

// the list ircview widgets
extern KviPtrList<KviIrcView> * g_pIrcViewWidgetList;


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Internal constants
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define KVI_IRCVIEW_BLOCK_SELECTION_TOTAL 0
#define KVI_IRCVIEW_BLOCK_SELECTION_LEFT 1
#define KVI_IRCVIEW_BLOCK_SELECTION_RIGHT 2
#define KVI_IRCVIEW_BLOCK_SELECTION_CENTRAL 3
#define KVI_IRCVIEW_BLOCK_SELECTION_ICON 4

#define KVI_IRCVIEW_PIXMAP_SIZE 16

#define KVI_IRCVIEW_ESCAPE_TAG_URLLINK 'u'
#define KVI_IRCVIEW_ESCAPE_TAG_NICKLINK 'n'
#define KVI_IRCVIEW_ESCAPE_TAG_SERVERLINK 's'
#define KVI_IRCVIEW_ESCAPE_TAG_HOSTLINK 'h'
#define KVI_IRCVIEW_ESCAPE_TAG_GENERICESCAPE '['

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Info about escape syntax
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// escape commands:
//
//  <cr>!<escape_command><cr><visible parameters<cr>
//
//  <escape_command> ::= u        <--- url link
//  <escape_command> ::= n        <--- nick link
//  <escape_command> ::= s        <--- server link
//  <escape_command> ::= h        <--- host link
//  <escape_command> ::= [...     <--- generic escape "rbt" | "mbt" | "dbl" | "txt"
//

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tool widget implementation
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


KviIrcMessageCheckListItem::KviIrcMessageCheckListItem(QListView * par,KviIrcViewToolWidget * w,int id)
: QCheckListItem(par,QString::null,QCheckListItem::CheckBox)
{
	m_iId = id;
	m_pToolWidget = 0;
	setPixmap(0,*(g_pIconManager->getSmallIcon(KVI_OPTION_MSGTYPE(id).pixId())));
	setOn(true);
	m_pToolWidget = w;
}

KviIrcMessageCheckListItem::~KviIrcMessageCheckListItem()
{
}

void KviIrcMessageCheckListItem::stateChange(bool bOn)
{
	QCheckListItem::stateChange(bOn);
	if(!m_pToolWidget)return;
	m_pToolWidget->forceRepaint();
}



KviIrcViewToolWidget::KviIrcViewToolWidget(KviIrcView * par)
: QFrame(par)
{
	m_pIrcView = par;
	setFrameStyle(QFrame::WinPanel | QFrame::Raised);

	QGridLayout * gl = new QGridLayout(this,2,2,4,2);

	QLabel * l = new QLabel(__tr("<font color=\"#8060FF\" size=\"-1\">Search tools</font>"),this);
	l->setMaximumHeight(14);
	l->setBackgroundColor(Qt::black);
	gl->addWidget(l,0,0);

	QToolButton *tb = new QToolButton(DownArrow,this);
	tb->setFixedSize(14,14);
	tb->setAutoRepeat(false);
	connect(tb,SIGNAL(clicked()),m_pIrcView,SLOT(toggleToolWidget()));
	gl->addWidget(tb,0,1);


	QTabWidget * tw = new QTabWidget(this);



	// Find tab
	QWidget * w = new QWidget(tw);

	QGridLayout * g = new QGridLayout(w,6,2,2,1);

	m_pStringToFind = new QLineEdit(w);
	g->addMultiCellWidget(m_pStringToFind,0,0,0,2);

	m_pCaseSensitive = new QCheckBox(__tr("Case sensitive"),w);
	g->addMultiCellWidget(m_pCaseSensitive,1,1,0,2);

	m_pRegExp = new QCheckBox(__tr("Regular expression"),w);
	g->addMultiCellWidget(m_pRegExp,2,2,0,2);

	m_pExtendedRegExp = new QCheckBox(__tr("Extended regexp"),w);
	g->addMultiCellWidget(m_pExtendedRegExp,3,3,0,2);
	m_pExtendedRegExp->setEnabled(false);
	connect(m_pRegExp,SIGNAL(toggled(bool)),m_pExtendedRegExp,SLOT(setEnabled(bool)));

	QPushButton * pb = new QPushButton(__tr("Find prev"),w);
	connect(pb,SIGNAL(clicked()),this,SLOT(findPrev()));
	g->addWidget(pb,4,0);

	pb = new QPushButton(__tr("Find next"),w);
	connect(pb,SIGNAL(clicked()),this,SLOT(findNext()));
	g->addMultiCellWidget(pb,4,4,1,2);

	m_pFindResult = new QLabel(w);
	m_pFindResult->setFrameStyle(QFrame::Sunken | QFrame::Panel);
	g->addMultiCellWidget(m_pFindResult,5,5,0,2);

	//g->setResizeMode(QGridLayout::Fixed);

	tw->addTab(w,__tr("Find"));

	// Filter tab
	QWidget * w1 = new QWidget(tw);

	g = new QGridLayout(w1,5,2,2,1);

	m_pFilterView = new QListView(w1);
	m_pFilterView->addColumn(__tr("Type"));
	m_pFilterView->header()->hide();
//	m_pFilterView->setMaximumHeight(150);
//	m_pFilterView->setMaximumWidth(60);
	m_pFilterView->setMinimumSize(QSize(10,10));

	g->addMultiCellWidget(m_pFilterView,0,4,0,0);


	m_pFilterItems = (KviIrcMessageCheckListItem **)kvi_malloc(KVI_NUM_MSGTYPE_OPTIONS * sizeof(KviIrcMessageCheckListItem *));

	for(int i=0;i<KVI_NUM_MSGTYPE_OPTIONS;i++)
	{
		m_pFilterItems[i] = new KviIrcMessageCheckListItem(m_pFilterView,this,i);
	}

	pb = new QPushButton(__tr("All"),w1);
	connect(pb,SIGNAL(clicked()),this,SLOT(filterEnableAll()));
	g->addWidget(pb,0,1);

	pb = new QPushButton(__tr("None"),w1);
	connect(pb,SIGNAL(clicked()),this,SLOT(filterEnableNone()));
	g->addWidget(pb,1,1);

	pb = new QPushButton(__tr("Load"),w1);
	connect(pb,SIGNAL(clicked()),this,SLOT(filterLoad()));
	g->addWidget(pb,2,1);

	pb = new QPushButton(__tr("Save"),w1);
	connect(pb,SIGNAL(clicked()),this,SLOT(filterSave()));
	g->addWidget(pb,3,1);

	tw->addTab(w1,__tr("Filter"));

	gl->addMultiCellWidget(tw,1,1,0,1);

	gl->setResizeMode(QGridLayout::Fixed);

	tw->showPage(w);
}

KviIrcViewToolWidget::~KviIrcViewToolWidget()
{
	kvi_free((void *)m_pFilterItems);
}

void KviIrcViewToolWidget::filterEnableAll()
{
	for(int i=0;i<KVI_NUM_MSGTYPE_OPTIONS;i++)
	{
		m_pFilterItems[i]->setToolWidget(0);
		m_pFilterItems[i]->setOn(true);
		m_pFilterItems[i]->setToolWidget(this);
	}
	forceRepaint();
}

void KviIrcViewToolWidget::filterEnableNone()
{
	for(int i=0;i<KVI_NUM_MSGTYPE_OPTIONS;i++)
	{
		m_pFilterItems[i]->setToolWidget(0);
		m_pFilterItems[i]->setOn(false);
		m_pFilterItems[i]->setToolWidget(this);
	}
	forceRepaint();
}

void KviIrcViewToolWidget::filterLoad()
{
	KviStr szFile;
	KviStr szInit;
	g_pApp->getLocalKvircDirectory(szInit,KviApp::Filters);
	if(KviFileDialog::askForOpenFileName(szFile,__tr("Select a filter file"),szInit.ptr()))
	{
		QFile f(szFile.ptr());
		if(f.open(IO_ReadOnly))
		{
			char buffer[KVI_NUM_MSGTYPE_OPTIONS];
			kvi_memset(buffer,0,KVI_NUM_MSGTYPE_OPTIONS);
			f.readBlock(buffer,KVI_NUM_MSGTYPE_OPTIONS);
			f.close();
			for(int i=0;i<KVI_NUM_MSGTYPE_OPTIONS;i++)
			{
				m_pFilterItems[i]->setToolWidget(0);
				m_pFilterItems[i]->setOn(buffer[i]);
				m_pFilterItems[i]->setToolWidget(this);
			}
			forceRepaint();
		} else kvi_warningBox(__tr("Can't open the filter file %s for reading"),szFile.ptr());
	}
}

void KviIrcViewToolWidget::filterSave()
{
	KviStr szFile;
	KviStr szInit;
	g_pApp->getLocalKvircDirectory(szInit,KviApp::Filters,"filter.kvf");
	if(KviFileDialog::askForSaveFileName(szFile,__tr("Select a name for the filter file"),szInit.ptr(),0,false,true))
	{
		QFile f(szFile.ptr());
		if(f.open(IO_WriteOnly))
		{
			char buffer[KVI_NUM_MSGTYPE_OPTIONS];
			for(int i=0;i<KVI_NUM_MSGTYPE_OPTIONS;i++)
			{
				buffer[i] = messageEnabled(i) ? 1 : 0;
			}
			if(f.writeBlock(buffer,KVI_NUM_MSGTYPE_OPTIONS) < KVI_NUM_MSGTYPE_OPTIONS)
				kvi_warningBox(__tr("Failed to write the filter file %s (IO Error)"),szFile.ptr());
			f.close();
		} else kvi_warningBox(__tr("Can't open the filter file %s for writing"),szFile.ptr());
	}
}

void KviIrcViewToolWidget::forceRepaint()
{
	m_pIrcView->paintEvent(0);
}

void KviIrcViewToolWidget::setFindResult(const char * text)
{
	m_pFindResult->setText(text);
}

void KviIrcViewToolWidget::findPrev()
{
	KviStr tmp = m_pStringToFind->text();
	if(tmp.isEmpty())return;
	bool bRegExp = m_pRegExp->isChecked();
	m_pIrcView->findPrev(tmp.ptr(),m_pCaseSensitive->isChecked(),bRegExp,bRegExp && m_pExtendedRegExp->isChecked());
}

void KviIrcViewToolWidget::findNext()
{
	KviStr tmp = m_pStringToFind->text();
	if(tmp.isEmpty())return;
	bool bRegExp = m_pRegExp->isChecked();
	m_pIrcView->findNext(tmp.ptr(),m_pCaseSensitive->isChecked(),bRegExp,bRegExp && m_pExtendedRegExp->isChecked());
}


void KviIrcViewToolWidget::mousePressEvent(QMouseEvent *e)
{
	m_pressPoint = e->pos();
}

void KviIrcViewToolWidget::mouseMoveEvent(QMouseEvent *)
{
	QPoint p=m_pIrcView->mapFromGlobal(QCursor::pos());
	p-=m_pressPoint;
	if(p.x() < 1)p.setX(1);
	else {
		int www = (m_pIrcView->width() - (m_pIrcView->m_pScrollBar->width() + 1));
		if((p.x() + width()) > www)p.setX(www - width());
	}
	if(p.y() < 1)p.setY(1);
	else {
		int hhh = (m_pIrcView->height() - 1);
		if((p.y() + height()) > hhh)p.setY(hhh - height());
	}
	move(p);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Link tip label implementation
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

static KviIrcViewTipWidget * g_pIrcViewTipWidget = 0; // local to this file

KviIrcViewTipWidget::KviIrcViewTipWidget()
#if QT_VERSION >= 300
: QLabel(0,"ircview_tooltip",WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WX11BypassWM)
#else
: QLabel(0,"ircview_tooltip",WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool)
#endif
{
	setMargin(1);
	setIndent(0);
	setAutoMask(false);
	setFrameStyle(QFrame::Plain | QFrame::Box);
	setLineWidth(1);
	setAlignment(AlignLeft | AlignTop);
	polish();
	m_iHideTimer = 0;
}

KviIrcViewTipWidget::~KviIrcViewTipWidget()
{
	if(m_iHideTimer)killTimer(m_iHideTimer);
}

void KviIrcViewTipWidget::abort()
{
	if(isVisible())hide();
	if(m_iHideTimer != 0)
	{
		killTimer(m_iHideTimer);
		m_iHideTimer = 0;
	}
}

void KviIrcViewTipWidget::popup(const QPoint &pnt)
{
	abort();
	move(pnt);
	show();
	m_iHideTimer = startTimer(KVI_OPTION_UINT(KviOption_uintIrcViewToolTipHideTimeoutInMsec));
}

void KviIrcViewTipWidget::timerEvent(QTimerEvent *e)
{
	__range_valid(m_iHideTimer == e->timerId());
	killTimer(e->timerId());
	m_iHideTimer = 0;
	hide();
}

void KviIrcViewTipWidget::mousePressEvent(QMouseEvent *e)
{
	abort();
}

void KviIrcViewTipWidget::enterEvent(QEvent *e)
{
	abort();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Helper functions
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//static inline int getTextIcon(const char * icon_name)
//{
//	return ;
//}

KVIRC_API const char * getColorBytes(const char *data_ptr,unsigned char *byte_1,unsigned char *byte_2)
{
	//
	// Scans the data_ptr for a mIrc color code XX,XX
	// and fills the color values in the two bytes
	//

	//First we can have a digit or a coma
	if(((*data_ptr >= '0') && (*data_ptr <='9')))
	{
		//Something interesting ok.
		(*byte_1)=(*data_ptr)-'0'; //store the code
		data_ptr++;     //and check the next
		if(((*data_ptr >= '0') && (*data_ptr <= '9'))||(*data_ptr==','))
		{
			//Yes we can understand it
			if(*data_ptr==',')
			{
				//A coma , need to check for background
				data_ptr++;
			} else {
				//A number
				(*byte_1)=((((*byte_1)*10)+((*data_ptr)-'0'))%16);
				data_ptr++;
				if(*data_ptr==',')
				{
					//A coma , need to check for background
					data_ptr++;
				} else {
					//Senseless return
					(*byte_2)=KVI_NOCHANGE;
					return data_ptr;
				}
			}
		} else {
			//Senseless character control code OK and return
			(*byte_2)=KVI_NOCHANGE;
			return data_ptr;
		}
	} else {
		//Senseless character : only a CTRL+K code
		(*byte_1)=KVI_NOCHANGE;
		(*byte_2)=KVI_NOCHANGE;
		return data_ptr;
	}

	if((*data_ptr >= '0') && (*data_ptr <='9'))
	{
		//Background , a color code
		(*byte_2)=(*data_ptr)-'0';
		data_ptr++;
		if((*data_ptr >= '0') && (*data_ptr <='9'))
		{
			(*byte_2)=((((*byte_2)*10)+((*data_ptr)-'0'))%16);
			data_ptr++;
		}
		return data_ptr;
	} else {
		(*byte_2)=KVI_NOCHANGE;
		return data_ptr;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// The IrcView : construct and destroy
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

KviIrcView::KviIrcView(QWidget *parent,KviFrame *pFrm,KviWindow *pWnd)
:QWidget(parent,"irc_view")
{
	// Ok...here we go

	// if this is the first created widget create the tip widget too
	if(g_pIrcViewWidgetList->isEmpty())g_pIrcViewTipWidget = new KviIrcViewTipWidget();
	// register this IrcView widget
	g_pIrcViewWidgetList->append(this);

	// say qt to avoid erasing on repaint
	setBackgroundMode(NoBackground);

	// Create the scroll bar
	m_pScrollBar               = new QScrollBar(0,0,1,10,0,QScrollBar::Vertical,this,"irc_view_scrollbar");
	m_pScrollBar->setTracking(true);
	m_pScrollBar->show();
	m_pScrollBar->setFocusProxy(this);

	// and adjust the global memory buffer
	resizeMemBuffer();

	// initialize the initializable
	m_pFirstLine               = 0;
	m_pCurLine                 = 0;
	m_pLastLine                = 0;
	m_pCursorLine              = 0;
	m_iNumLines                = 0;
	m_iMaxLines                = KVI_OPTION_UINT(KviOption_uintIrcViewMaxBufferSize);

	m_uNextLineIndex           = 0;

	if(m_iMaxLines < 32)
	{
		m_iMaxLines = 32;
		KVI_OPTION_UINT(KviOption_uintIrcViewMaxBufferSize) = 32;
	}

	m_bMouseIsDown               = false;

	m_bShowImages              = KVI_OPTION_BOOL(KviOption_boolIrcViewShowImages);

	m_iSelectTimer             = 0;
	m_iTipTimer                = 0;
	m_bTimestamp               = KVI_OPTION_BOOL(KviOption_boolIrcViewTimestamp);

	m_bAcceptDrops             = false;
	m_pPrivateBackgroundPixmap = 0;
	m_bSkipScrollBarRepaint    = false;
	m_pLogFile                 = 0;
	m_pKviWindow               = pWnd;
	m_pFrm                     = pFrm;

	m_iUnprocessedPaintEventRequests = 0;
	m_bPostedPaintEventPending = false;

	m_pLastLinkUnderMouse      = 0;
	m_iLastLinkRectTop         = -1;
	m_iLastLinkRectHeight      = -1;

	m_pMasterView              = 0;


	m_pToolWidget              = 0;
//    m_bDrawEmoticons           = ;

	m_pMessagesStoppedWhileSelecting = new KviPtrList<KviIrcViewTextLine>;
	m_pMessagesStoppedWhileSelecting->setAutoDelete(false);

	m_pToolWidgetButton = new QToolButton(this);
#if QT_VERSION >= 300
	QIconSet is1(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_LOUPE)),QIconSet::Small);
	m_pToolWidgetButton->setIconSet(is1);
#else
	m_pToolWidgetButton->setOnIconSet(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_LOUPE)));
#endif
	QToolTip::add(m_pToolWidgetButton,__tr("Search tools"));
	m_pToolWidgetButton->setFocusProxy(this);
	connect(m_pToolWidgetButton,SIGNAL(clicked()),this,SLOT(toggleToolWidget()));
	m_pToolWidgetButton->show();

	connect(m_pScrollBar,SIGNAL(valueChanged(int)),this,SLOT(scrollBarPositionChanged(int)));
	m_iLastScrollBarValue      = 0;

	// set the minimum width
	setMinimumWidth(KVI_IRCVIEW_MINIMUM_WIDTH);
	// and catch all mouse events
	setMouseTracking(true);
	// let's go!
	applyOptions();
}

static inline void delete_text_line(KviIrcViewTextLine * l)
{
	kvi_free(l->data_ptr);                        //free string data
	for(int i=0;i<l->attr_len;i++)
	{
		if((l->attr_ptr[i].attribute == KVI_TEXT_ESCAPE) || (l->attr_ptr[i].attribute == KVI_TEXT_ICON))
		{
			kvi_free(l->attr_ptr[i].escape_cmd);
		}
	}
	kvi_free(l->attr_ptr);                        //free attributes data
	if(l->num_text_blocks)kvi_free(l->text_blocks_ptr);
	delete l;
}

KviIrcView::~KviIrcView()
{
	// unregister this widget
	g_pIrcViewWidgetList->removeRef(this); // unregister
	if(g_pIrcViewWidgetList->isEmpty())
	{
		// this is the last widget in the list: destroy the tip widget
		delete g_pIrcViewTipWidget;
		g_pIrcViewTipWidget = 0;
	}

	resizeMemBuffer(); //<--- we are no longer on the widget list
	// kill any pending timer
	if(m_iSelectTimer)killTimer(m_iSelectTimer);
	if(m_iTipTimer)killTimer(m_iTipTimer);
	// and close the log file (flush!)
	stopLogging();
	if(m_pToolWidget)delete m_pToolWidget;
	// don't forget the bacgkround pixmap!
	if(m_pPrivateBackgroundPixmap)delete m_pPrivateBackgroundPixmap;
	// and to remove all the text lines
	emptyBuffer(false);
	// the pending ones too!
	while(KviIrcViewTextLine * l = m_pMessagesStoppedWhileSelecting->first())
	{
		m_pMessagesStoppedWhileSelecting->removeFirst();
		delete_text_line(l);
	}
	delete m_pMessagesStoppedWhileSelecting;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// The IrcView : options
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


void KviIrcView::applyOptions()
{
	recalcFontVariables(KVI_OPTION_FONT(KviOption_fontIrcView));
	KviIrcViewTextLine * l = m_pFirstLine;
	while(l){
		l->max_line_width = -1;
		l = l->next_line;
	}
	paintEvent(0);
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// The IrcView : DnD
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void KviIrcView::enableDnd(bool bEnable)
{
	setAcceptDrops(bEnable);
	m_bAcceptDrops = bEnable;
}

void KviIrcView::dragEnterEvent(QDragEnterEvent *e)
{
	if(!m_bAcceptDrops)return;
	e->accept(QUriDrag::canDecode(e));
	emit dndEntered();
}

void KviIrcView::dropEvent(QDropEvent *e)
{
	if(!m_bAcceptDrops)return;
	QStringList list;
	if(QUriDrag::decodeLocalFiles(e,list))
	{
		if(!list.isEmpty())
		{
			QStringList::ConstIterator it = list.begin(); //kewl ! :)
			for( ; it != list.end(); ++it )
			{
				KviStr tmp = *it; //wow :)
				if(*(tmp.ptr()) != '/')tmp.prepend("/"); //HACK HACK HACK for Qt bug (?!?)
				emit fileDropped(tmp.ptr());
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// The IrcView : Logging
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


void KviIrcView::stopLogging()
{
	if(m_pLogFile)
	{
		KviStr szLogEnd(KviStr::Format,
			__tr("### Log session terminated at %s ###"),
			__q2ascii(QDateTime::currentDateTime().toString()));

		add2Log(szLogEnd.ptr());

		m_pLogFile->close();
		delete m_pLogFile;
		m_pLogFile = 0;
	}
}

void KviIrcView::getLogFileName(KviStr &buffer)
{
	if(m_pLogFile)buffer.append(m_pLogFile->name());
}

void KviIrcView::getTextBuffer(KviStr &buffer)
{
	// FIXME: #warning "This does not merge the KviChannel::m_pMessageView buffer!"
	buffer = "";
	if(!m_pLastLine)return;
	for(KviIrcViewTextLine *l=m_pFirstLine;l;l=l->next_line)
	{
		buffer.append(l->data_ptr);
		buffer.append("\n");
	}
}

void KviIrcView::flushLog()
{
	if(m_pLogFile)m_pLogFile->flush();
	else if(m_pMasterView)m_pMasterView->flushLog();
}

const char * KviIrcView::lastLineOfText()
{
	if(!m_pLastLine)return 0;
	return m_pLastLine->data_ptr;
}

//void KviIrcView::toggleLogging()
//{
//	if(isLogging())stopLogging();
//	else {
//#warning "FIX THIS COMMENTED STUFF"
//
//		KviStr tmp;
//		m_pKviWindow->getDefaultLogName(tmp);
//		startLogging(tmp.ptr());
//
//	}
//}

void KviIrcView::setMasterView(KviIrcView * v)
{
	if(m_pMasterView)disconnect(this,SLOT(masterDead()));
	m_pMasterView = v;
	if(m_pMasterView)connect(m_pMasterView,SIGNAL(destroyed()),this,SLOT(masterDead()));
}

void KviIrcView::masterDead()
{
	m_pMasterView = 0;
}

bool KviIrcView::startLogging(const char *filename,bool bPrependCurBuffer)
{
	stopLogging();

	KviStr fName;

	if(!filename)
	{
		if(!m_pKviWindow)return false;
		m_pKviWindow->getDefaultLogFileName(fName);
		filename = fName.ptr();
	}

	m_pLogFile = new QFile(filename);

	if(m_pLogFile->exists())
	{
		if(!m_pLogFile->open(IO_Append|IO_WriteOnly))
		{
			delete m_pLogFile;
			m_pLogFile = 0;
			return false;
		}
	} else {
		if(!m_pLogFile->open(IO_WriteOnly))
		{
			delete m_pLogFile;
			m_pLogFile = 0;
			return false;
		}
	}

	KviStr szLogStart(KviStr::Format,__tr("### Log session started at %s ###"),__q2ascii(QDateTime::currentDateTime().toString()));
	add2Log(szLogStart.ptr());
	if(bPrependCurBuffer)
	{
		add2Log(__tr("### Existing data buffer:"));
		KviStr buffer;
		getTextBuffer(buffer);
		add2Log(buffer.ptr());
		add2Log(__tr("### End of existing data buffer."));
	}

	return true;
}

void KviIrcView::add2Log(const char *buffer,int buf_len)
{
	//if(!m_pLogFile)return;
	if(buf_len<0)buf_len=strlen(buffer);
	if((m_pLogFile->writeBlock(buffer,buf_len)==-1)||(m_pLogFile->putch('\n')==-1))
			debug("WARNING : Can not write to the log file.");
}

//void KviIrcView::logToFile()
//{
//	// Yeah....this is powerful! :)
////	KviStr cmd = "/DIALOG (savefile,Choose a log file name,$deflogfile($window),$window) "
////		"if((\"$dialogresult\" != \"\")&&(\"$dialogmagic\" == \"$window\"))log on $dialogresult";
////	m_pFrm->m_pUserParser->parseUserCommand(cmd,m_pKviWindow);
//}

//=============================================================================
//
// Some slots
//

//void KviIrcView::saveBufferToFile()
//{
//	// Yeah....this is powerful! :)
////	KviStr cmd = "/DIALOG (savefile,Choose a file name,$deflogfile($window).savebuf,$window) "
////		"if(\"$dialogresult\" != \"\")window $dialogmagic savebuffer $dialogresult";
////	m_pFrm->m_pUserParser->parseUserCommand(cmd,m_pKviWindow);
//}

void KviIrcView::toggleTimestamp()
{
	setTimestamp(!timestamp());
}

void KviIrcView::toggleImages()
{
	setShowImages(!imagesVisible());
}

void KviIrcView::clearBuffer()
{
	emptyBuffer(true);
}

bool KviIrcView::saveBuffer(const char *filename)
{
	QFile f(filename);
	if(!f.open(IO_WriteOnly|IO_Truncate))return false;
	KviStr tmp;
	getTextBuffer(tmp);
	f.writeBlock(tmp.ptr(),tmp.len());
	f.close();
	return true;
}

void KviIrcView::prevLine(){ m_pScrollBar->subtractLine(); }
void KviIrcView::nextLine(){ m_pScrollBar->addLine(); }
void KviIrcView::prevPage(){ m_pScrollBar->subtractPage(); }
void KviIrcView::nextPage(){ m_pScrollBar->addPage(); }

void KviIrcView::setPrivateBackgroundPixmap(const QPixmap &pixmap,bool bRepaint)
{
	if(m_pPrivateBackgroundPixmap){
		delete m_pPrivateBackgroundPixmap;
		m_pPrivateBackgroundPixmap=0;
	}
	if(!pixmap.isNull())m_pPrivateBackgroundPixmap = new QPixmap(pixmap);
	if(bRepaint)paintEvent(0);
}

void KviIrcView::emptyBuffer(bool bRepaint)
{
	while(m_pLastLine != 0)removeHeadLine();
//	g_uNextLineIndex = 0;
	if(bRepaint)paintEvent(0);
}

void KviIrcView::setMaxBufferSize(int maxBufSize,bool bRepaint)
{
	if(maxBufSize < 32)maxBufSize = 32;
	m_iMaxLines = maxBufSize;
	while(m_iNumLines > m_iMaxLines)removeHeadLine();
	m_pScrollBar->setRange(0,m_iNumLines);
	if(bRepaint)paintEvent(0);
}

void KviIrcView::setShowImages(bool bShow,bool bRepaint)
{
	if(m_bShowImages!=bShow)
	{
		m_bShowImages=bShow;
		if(bRepaint)paintEvent(0);
	}
}

void KviIrcView::setTimestamp(bool bTimestamp)
{
	m_bTimestamp = bTimestamp;


// STATS FOR A BUFFER FULL OF HIGHLY COLORED STRINGS , HIGHLY WRAPPED
//
// Lines = 1024 (322425 bytes - 314 KB) (avg 314 bytes per line) , well :)
// string bytes = 87745 (85 KB)
// attributes = 3576 (42912 bytes - 41 KB)
// blocks = 12226 (146712 bytes - 143 KB)     
//
//	unsigned long int nAlloc = 0;
//	unsigned long int nLines = 0;
//	unsigned long int nStringBytes = 0;
//	unsigned long int nAttrBytes = 0;
//	unsigned long int nBlockBytes = 0;
//	unsigned long int nBlocks = 0;
//	unsigned long int nAttributes = 0;
//	KviIrcViewTextLine * l=m_pFirstLine;
//	while(l){
//		nLines++;
//		nAlloc += sizeof(KviIrcViewTextLine);
//		nStringBytes += l->data_len + 1;
//		nAlloc += l->data_len + 1;
//		nAlloc += (l->attr_len * sizeof(KviIrcViewTextAttribute));
//		nAttrBytes +=(l->attr_len * sizeof(KviIrcViewTextAttribute));
//		nAlloc += (l->num_text_blocks * sizeof(KviIrcViewTextAttribute));
//		nBlockBytes += (l->num_text_blocks * sizeof(KviIrcViewTextAttribute));
//		nBlocks += (l->num_text_blocks);
//		nAttributes += (l->attr_len);
//		l = l->next_line;
//	}
//	debug("\n\nLines = %u (%u bytes - %u KB) (avg %u bytes per line)",nLines,nAlloc,nAlloc / 1024,nLines ? (nAlloc / nLines) : 0);
//	debug("string bytes = %u (%u KB)",nStringBytes,nStringBytes / 1024);
//	debug("attributes = %u (%u bytes - %u KB)",nAttributes,nAttrBytes,nAttrBytes / 1024);
//	debug("blocks = %u (%u bytes - %u KB)\n",nBlocks,nBlockBytes,nBlockBytes / 1024);

}

void KviIrcView::scrollBarPositionChanged(int newValue)
{
	if(!m_pCurLine)return;
	int diff = 0;
	if(newValue > m_iLastScrollBarValue)
	{
		while(newValue > m_iLastScrollBarValue)
		{
			if(m_pCurLine->next_line)
			{
				m_pCurLine=m_pCurLine->next_line;
				diff++;
			}
			m_iLastScrollBarValue++;
		}
	} else {
		while(newValue < m_iLastScrollBarValue)
		{
			if(m_pCurLine->prev_line)m_pCurLine=m_pCurLine->prev_line;
			m_iLastScrollBarValue--;
		}
	}
	__range_valid(newValue == m_iLastScrollBarValue);
	if(!m_bSkipScrollBarRepaint)paintEvent(0);
//	if(!m_bSkipScrollBarRepaint)postUpdateEvent();
}

bool KviIrcView::event(QEvent *e)
{
	if(e->type() == QEvent::User)
	{
		__range_valid(m_bPostedPaintEventPending);
		if(m_iUnprocessedPaintEventRequests)paintEvent(0);
		// else we just had a pointEvent that did the job
		m_bPostedPaintEventPending = false;
		return true;
	}
	return QWidget::event(e);
}



void KviIrcView::postUpdateEvent()
{
	// This will post a QEvent with a full repaint request
	if(!m_bPostedPaintEventPending)
	{
		m_bPostedPaintEventPending = true;
		QEvent *e = new QEvent(QEvent::User);
		g_pApp->postEvent(this,e); // queue a repaint
	}

	m_iUnprocessedPaintEventRequests++; // paintEvent() will set it to 0

	if(m_iUnprocessedPaintEventRequests == 3)
	{
		// Three unprocessed paint events...do it now
#ifdef COMPILE_PSEUDO_TRANSPARENCY
		if(! ((KVI_OPTION_PIXMAP(KviOption_pixmapIrcViewBackground).pixmap()) || m_pPrivateBackgroundPixmap || g_pShadedChildGlobalDesktopBackground))fastScroll(3);
#else
		if(! ((KVI_OPTION_PIXMAP(KviOption_pixmapIrcViewBackground).pixmap()) || m_pPrivateBackgroundPixmap))fastScroll(3);
#endif
		else paintEvent(0);
	}
}

void KviIrcView::appendLine(KviIrcViewTextLine *ptr,bool bRepaint)
{
	//This one appends a KviIrcViewTextLine to
	//the buffer list (at the end)
	if(m_bMouseIsDown)
	{
		// Do not move the view!
		// So we append the text line to a temp queue
		// and then we'll add it when the mouse button is released
		m_pMessagesStoppedWhileSelecting->append(ptr);
		return;
	}

	if(m_pLastLine)
	{
		// There is at least one line in the view
		m_pLastLine->next_line=ptr;
		ptr->prev_line  =m_pLastLine;
		ptr->next_line  =0;
		m_iNumLines++;

		if(m_iNumLines > m_iMaxLines)
		{
			// Too many lines in the view...remove one
			removeHeadLine();
			if(m_pCurLine==m_pLastLine)
			{
				m_pCurLine=ptr;
				if(bRepaint)postUpdateEvent();
			} else {
				// the cur line remains the same
				// the scroll bar must move up one place to be in sync
				m_bSkipScrollBarRepaint = true;
				if(m_pScrollBar->value() > 0)
				{
					m_iLastScrollBarValue--;
					__range_valid(m_iLastScrollBarValue >= 0);
					m_pScrollBar->subtractLine();
				} // else will stay in sync
				m_bSkipScrollBarRepaint = false;
			}
		} else {
			// Just append
			m_pScrollBar->setRange(0,m_iNumLines);
			if(m_pCurLine==m_pLastLine)
			{
				m_bSkipScrollBarRepaint = true;
				m_pScrollBar->addLine();
				m_bSkipScrollBarRepaint = false;
				if(bRepaint)postUpdateEvent();
			}
		}
		m_pLastLine=ptr;
	} else {
		//First line
		m_pLastLine    = ptr;
		m_pFirstLine   = ptr;
		m_pCurLine     = ptr;
		ptr->prev_line = 0;
		ptr->next_line = 0;
		m_iNumLines    = 1;
		m_pScrollBar->setRange(0,1);
		m_pScrollBar->addLine();
		if(bRepaint)paintEvent(0);
	}

	// Don't use add2log here!...we must go as fast as possible, so we avoid some push and pop calls, and also a couple of branches


	if(m_pLogFile)
	{
		if(KVI_OPTION_MSGTYPE(ptr->msg_type).logEnabled())
		{
			m_pLogFile->writeBlock(ptr->data_ptr,ptr->data_len - 1);
			m_pLogFile->putch('\n');
			// If we fail...this has been already reported!
		}
		// mmh.. when this overflows... we have problems (find doesn't work anymore :()
		// but it overflows at 2^32 lines... 2^32 = 4.294.967.296 lines
		// to spit it out in a year you'd need to print 1360 lines per second... that's insane :D
		// a really fast but reasonable rate of printed lines might be 10 per second
		// thus 429.496.730 seconds would be needed to make this var overflow
		// that means more or less 13 years of text spitting at full rate :D
		// I think that we can safely assume that this will NOT overflow ... your cpu (or you)
		// will get mad before. Well.. it is not that dangerous after all...
		ptr->index = m_uNextLineIndex;
		m_uNextLineIndex++;
	} else {
		if(m_pMasterView)
		{
			if(m_pMasterView->m_pLogFile)
			{
				if(KVI_OPTION_MSGTYPE(ptr->msg_type).logEnabled())
				{
					m_pMasterView->m_pLogFile->writeBlock(ptr->data_ptr,ptr->data_len - 1);
					m_pMasterView->m_pLogFile->putch('\n');
				}
			}
			ptr->index = m_pMasterView->m_uNextLineIndex;
			m_pMasterView->m_uNextLineIndex++;
		} else {
			ptr->index = m_uNextLineIndex;
			m_uNextLineIndex++;
		}
	}
}

//============== removeHeadLine ===============//

void KviIrcView::removeHeadLine(bool bRepaint)
{
	//Removes the first line of the text buffer
	if(!m_pLastLine)return;
	__range_valid(m_pFirstLine->prev_line==0);
	__range_valid(m_pFirstLine->data_ptr);

	if(m_pFirstLine == m_pCursorLine)m_pCursorLine = 0;

	if(m_pFirstLine->next_line)
	{
		KviIrcViewTextLine *aux_ptr=m_pFirstLine->next_line; //get the next line
		aux_ptr->prev_line=0;                                //becomes the first
		if(m_pFirstLine==m_pCurLine)m_pCurLine=aux_ptr;      //move the cur line if necessary
		delete_text_line(m_pFirstLine);                      //delete the struct
		m_pFirstLine=aux_ptr;                                //set the last
		m_iNumLines--;                                       //and decrement the count
	} else { //unique line
		m_pCurLine   = 0;
		delete_text_line(m_pFirstLine);
		m_pFirstLine = 0;
		m_iNumLines  = 0;
		m_pLastLine  = 0;
	}
	if(bRepaint)paintEvent(0);
}

void KviIrcView::splitMessagesTo(KviIrcView *v)
{
	v->emptyBuffer(false);
	
	KviIrcViewTextLine * l = m_pFirstLine;
	KviIrcViewTextLine * tmp;
	while(l)
	{
		if((l->msg_type == KVI_OUT_CHANPRIVMSG) ||
			(l->msg_type == KVI_OUT_CHANPRIVMSGCRYPTED) ||
			(l->msg_type == KVI_OUT_CHANNELNOTICE) ||
			(l->msg_type == KVI_OUT_CHANNELNOTICECRYPTED) ||
			(l->msg_type == KVI_OUT_ACTION) ||
			(l->msg_type == KVI_OUT_OWNPRIVMSG) ||
			(l->msg_type == KVI_OUT_OWNPRIVMSGCRYPTED) ||
			(l->msg_type == KVI_OUT_HIGHLIGHT))
		{
			m_iNumLines--;
			v->m_iNumLines++;

			if(l->next_line)l->next_line->prev_line = l->prev_line;
			if(l->prev_line)l->prev_line->next_line = l->next_line;
			if(l == m_pFirstLine)m_pFirstLine = l->next_line;
			if(l == m_pLastLine)m_pLastLine = l->prev_line;
			if(v->m_pLastLine)
			{
				v->m_pLastLine->next_line = l;
				l->prev_line = v->m_pLastLine;
				v->m_pLastLine = l;
			} else {
				v->m_pFirstLine = l;
				l->prev_line = 0;
				v->m_pLastLine = l;
			}
			tmp = l->next_line;
			l->next_line = 0;
			l = tmp;
		} else {
			l = l->next_line;
		}
	}
	v->m_pCurLine = v->m_pLastLine;
	m_pCurLine = m_pLastLine;

	v->m_pCursorLine = 0;
	m_pCursorLine = 0;

	m_iLastScrollBarValue = m_iNumLines;
	m_pScrollBar->setRange(0,m_iNumLines);
	m_pScrollBar->setValue(m_iNumLines);
	paintEvent(0);

	v->m_iLastScrollBarValue = v->m_iNumLines;
	v->m_pScrollBar->setRange(0,v->m_iNumLines);
	v->m_pScrollBar->setValue(v->m_iNumLines);
	v->paintEvent(0);
}

void KviIrcView::joinMessagesFrom(KviIrcView *v)
{
	KviIrcViewTextLine * l1 = m_pFirstLine;
	KviIrcViewTextLine * l2 = v->m_pFirstLine;
	KviIrcViewTextLine * tmp;

	while(l2)
	{
		if(l1)
		{
			if(l2->index < l1->index)
			{
				// the external message is older than the current internal one
				l2->prev_line = l1->prev_line;
				if(l1->prev_line)l1->prev_line->next_line = l2;
				else m_pFirstLine = l2;
				l1->prev_line = l2;
				tmp = l2->next_line;
				l2->next_line = l1;
				l2 = tmp;
			} else {
				// the external message is younger than the current internal one
				l1 = l1->next_line;
			}
		} else {
			// There is no current internal message (ran over the end)
			// merge at the end then
			if(m_pFirstLine)
			{
				m_pLastLine->next_line = l2;
				l2->prev_line = m_pLastLine;
			} else {
				m_pFirstLine = l2;
				l2->prev_line = 0;
			}
			tmp = l2->next_line;
			l2->next_line = 0;
			m_pLastLine  = l2;
			l2 = tmp;
		}
	}

	m_pCurLine = m_pLastLine;
	m_pCursorLine = 0;
	v->m_pFirstLine = 0;
	v->m_pLastLine = 0;
	v->m_pCurLine = 0;
	v->m_pCursorLine = 0;
	m_iNumLines += v->m_iNumLines;
	v->m_iNumLines = 0;
//	v->m_pScrollBar->setRange(0,0);
//	v->m_pScrollBar->setValue(0);

	m_iLastScrollBarValue = m_iNumLines;
	m_pScrollBar->setRange(0,m_iNumLines);
	m_pScrollBar->setValue(m_iNumLines);
	paintEvent(0);
}

//============= appendText ===============//

void KviIrcView::appendText(int msg_type,const char *data_ptr,bool bRepaint)
{
	//appends a text string to the buffer list
	//splits the lines
	__range_valid(data_ptr);
	m_pLastLinkUnderMouse = 0;
	while(*data_ptr)
	{                                         //Have more data
		KviIrcViewTextLine *line_ptr=new KviIrcViewTextLine;  //create a line struct
//		line_ptr->index = g_uNextLineIndex;
//		g_uNextLineIndex++;
		line_ptr->msg_type=msg_type;
		line_ptr->max_line_width=-1;
		line_ptr->num_text_blocks=0;
		data_ptr=getTextLine(msg_type,data_ptr,line_ptr);
		appendLine(line_ptr,bRepaint);
	}
}

void KviIrcView::getLinkEscapeCommand(KviStr &buffer,const char * escape_cmd,const char * escape_label,int label_len)
{
	if(!(*escape_cmd))return;

	for(;;)
	{
		while(*escape_cmd && (*escape_cmd != '['))escape_cmd++;
		if(!*escape_cmd)return;
		if(kvi_strEqualCSN(escape_cmd,escape_label,label_len))break;
		else escape_cmd++;
	}

	escape_cmd+=label_len;
	const char * aux = escape_cmd;

	for(;;)
	{
		while(*escape_cmd && (*escape_cmd != '['))escape_cmd++;
		if(!*escape_cmd)break;
		if(kvi_strEqualCSN(escape_cmd,"[!",2))break;
		escape_cmd++;
	}

	buffer.extractFromString(aux,escape_cmd);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// The IrcView : Get text line
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



const char * KviIrcView::getTextLine(int msg_type,
					const char * data_ptr,KviIrcViewTextLine *line_ptr)
{
	//Splits the text data in lines (separated by '\n')

	int buffer_pos_idx = 0;       //we're at the beginning in the buffer
	int curAttrIdx     = 0;
	int blockLen;

	register const char *p=data_ptr;

	//Alloc the first attribute
	line_ptr->attr_len = 1;
	line_ptr->attr_ptr = (KviIrcViewTextAttribute *)kvi_malloc(sizeof(KviIrcViewTextAttribute));
	//And fill it up
	line_ptr->attr_ptr[0].attribute = KVI_TEXT_COLOR;
	line_ptr->attr_ptr[0].block_idx = 0;
	line_ptr->attr_ptr[0].attr_data.colors.back = KVI_OPTION_MSGTYPE(msg_type).back();
	line_ptr->attr_ptr[0].attr_data.colors.fore = KVI_OPTION_MSGTYPE(msg_type).fore();

	if(m_bTimestamp)
	{
		// We need the timestamp string to be added
		// alloc the necessary space
		line_ptr->data_ptr              = (char *)kvi_malloc(12); // [hh:mm:ss]space\0
		line_ptr->data_len              = 12;                     // so actually 11 chars + terminator
		line_ptr->attr_ptr[0].block_len = 11;
		buffer_pos_idx                  = 11;                     // the rest of the string will begin 11 chars later

		// then create the timestamp string
		time_t tt = time(0);
		struct tm * pTm = KVI_OPTION_BOOL(KviOption_boolIrcViewTimestampUTC) ? gmtime(&tt) : localtime(&tt);

		register char * data_ptr_aux = line_ptr->data_ptr;

		*data_ptr_aux++     = '[';
		*data_ptr_aux++     = (pTm->tm_hour / 10) + '0';          // first digit of hour
		*data_ptr_aux++     = (pTm->tm_hour % 10) + '0';          // second digit of hours
		*data_ptr_aux++     = ':';
		*data_ptr_aux++     = (pTm->tm_min / 10)  + '0';          // first digit of minutes
		*data_ptr_aux++     = (pTm->tm_min % 10)  + '0';          // second digit of minutes
		*data_ptr_aux++     = ':';
		*data_ptr_aux++     = (pTm->tm_sec / 10)  + '0';           // first digit of seconds
		*data_ptr_aux++     = (pTm->tm_sec % 10)  + '0';           // second digit of seconds
		*data_ptr_aux++     = ']';
		*data_ptr_aux       = ' ';
	} else {
		// Timestamp not needed....just a terminator for now (that we will place later)
		line_ptr->data_ptr              = (char *)kvi_malloc(1);  //at least terminator
		line_ptr->data_len              = 1;
		line_ptr->attr_ptr[0].block_len = 0;
	}

	//
	// Ok... a couple of macros that occur really frequently
	// in the following code...
	// these could work well as functions too...but the macros are a lot faster :)
	//

#define APPEND_LAST_TEXT_BLOCK(__data_ptr,__data_len) \
	blockLen = (__data_len); \
	line_ptr->data_len += blockLen; \
	line_ptr->attr_ptr[curAttrIdx].block_len += blockLen; \
	line_ptr->data_ptr = (char *)kvi_realloc((void *)line_ptr->data_ptr,line_ptr->data_len); \
	kvi_fastmove((void *)(line_ptr->data_ptr+buffer_pos_idx),(void *)(__data_ptr),blockLen); \
	buffer_pos_idx+=blockLen;

#define APPEND_ZERO_LENGTH_BLOCK(__data_ptr) /* does nothing */

#define NEW_ATTRIBUTE_BLOCK(_attr_type) \
	line_ptr->attr_len++; \
	line_ptr->attr_ptr=(KviIrcViewTextAttribute *)kvi_realloc((void *)line_ptr->attr_ptr, \
		line_ptr->attr_len * sizeof(KviIrcViewTextAttribute)); \
	curAttrIdx++; \
	line_ptr->attr_ptr[curAttrIdx].attribute = _attr_type; \
	line_ptr->attr_ptr[curAttrIdx].block_idx = buffer_pos_idx; \
	line_ptr->attr_ptr[curAttrIdx].block_len = 0;

	// EOF Macros

	int partLen;

#ifdef COMPILE_USE_DYNAMIC_LABELS

	// Herezy :)

	// This is not only usage of the *Evil Goto(tm)*
	// This is also a *rather unclear* use of the *Really Evil Goto(tm)*
	// char_to_check_jump_table is a table of dynamic label addresses...
	// we use it to jump to the proper check
	// loop_begin is a dynamic label, and we use it to
	// return to the appropriate loop
	// This is again BAD PROGRAMMING(TM) :).... but it is faster than
	// the version with no dynamic gotos, and really faster
	// that any version without gotos that comed into my mind...
	// 
	// This code will prolly work only with GCC...(and even needs a "smart" one)

	// Again did two versions... the first was:
	//
	//  if(void * jmp_address = char_to_check_jump_table[*((unsigned char *)p)])goto *jmp_address;
	//    18a3:	8b 55 f0             	movl   0xfffffff0(%ebp),%edx
	//    18a6:	31 c0                	xorl   %eax,%eax
	//    18a8:	8a 02                	movb   (%edx),%al
	//    18aa:	8b 04 85 20 00 00 00 	movl   0x20(,%eax,4),%eax
	//    18b1:	85 c0                	testl  %eax,%eax
	//    18b3:	74 02                	je     18b7 <KviIrcView::getTextLine(int, char const *, KviIrcViewTextLine *)+0x1f3>
	//    18b5:	ff e0                	jmp    *%eax
	//
	// I even had a nicer version:
	//
	//  goto *(char_to_check_jump_table[*((unsigned char *)p)]);
	//    18a3:	8b 55 f0             	movl   0xfffffff0(%ebp),%edx
	//    18a6:	31 c0                	xorl   %eax,%eax
	//    18a8:	8a 02                	movb   (%edx),%al
	//    18aa:	ff 24 85 20 00 00 00 	jmp    *0x20(,%eax,4)
	//
	// but sth tells me that "jmp *0x20(,%eax,4)" takes a loooooot of clock ticks...
	// ...we have less instructions , but the code takes longer to execute (7-8% longer)
	// it might be also due to pipeline tricks, jump "next instruction precalculation" stuff...

	// So we end up using the fist version here

	void * loop_begin;

//	struct timeval tmv,tmv2;
//	gettimeofday(&tmv,0);


	static void * char_to_check_jump_table[256]=
	{
		&&found_end_of_buffer  ,0                      ,&&found_mirc_escape    ,&&found_color_escape   ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,&&found_end_of_line    ,0                      ,
		0                      ,&&found_command_escape ,0                      ,&&found_mirc_escape    ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,&&found_mirc_escape    ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,&&found_icon_escape    ,0                      ,&&found_mirc_escape    , // 000-031
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      , // 032-047
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,&&check_emoticon_char  ,&&check_emoticon_char  ,
		0                      ,&&check_emoticon_char  ,0                      ,0                      , // 048-063 // 61='=' , 59=';' , 58=':'
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,&&check_file_or_ftp_url,0                      ,
		&&check_http_url       ,&&check_irc_url        ,0                      ,0                      ,
		0                      ,&&check_mailto_url     ,0                      ,0                      , // 064-079  // 070==F 072==H 073==I  077==M
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,&&check_www_url        ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      , // 080-095  // 087==W
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,&&check_file_or_ftp_url,0                      ,
		&&check_http_url       ,&&check_irc_url        ,0                      ,0                      ,
		0                      ,&&check_mailto_url     ,0                      ,0                      , // 096-111  // 102==f 104==h 105==i 109==m
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,&&check_www_url        ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      , // 112-127  // 119==w
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      , // 128-133
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      , // 134-159
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      , // 160-175
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      , // 176-191
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      , // 192-207
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      , // 208-223
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      , // 224-239
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                      ,
		0                      ,0                      ,0                      ,0                        // 240-255
	};

	if(KVI_OPTION_BOOL(KviOption_boolIrcViewUrlHighlighting))
	{
		loop_begin = &&highlighting_check_loop;               // get the address of the return label
		// forewer loop
highlighting_check_loop:
		// yet more optimized
		if(void * jmp_address = char_to_check_jump_table[*((unsigned char *)p)])goto *jmp_address;
//		goto *(char_to_check_jump_table[*((unsigned char *)p)]); <--- replace 0 with &nothing_found
nothing_found:
		p++;
		goto highlighting_check_loop;
		// newer here
	} else {
		loop_begin = &&escape_check_loop;                     // get the address of the return label
		// forever loop
escape_check_loop:
		while(((unsigned char)*p) > 31)p++;
		goto check_escape_switch;                             // returns to escape_check_loop or returns from the function at all
		// newer here
	}
	// newer here


#else // !COMPILE_USE_DYNAMIC_LABELS

	// No way to have a jump table, nor a dynamic return jump
	// Anyway...we can have sth similar to a jump table...
	// Note: this could be substituted by a compiler generated jump table
	//       for a switch command... but this is STILL faster

	static char char_to_check_table[256]=
	{
		1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, // 000-015
		1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, // 016-031
		0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, // 032-047
		0,0,0,0,0,0,0,0, 0,0,7,7,0,7,0,0, // 048-063
		0,0,0,0,0,0,3,0, 2,5,0,0,0,6,0,0, // 064-079  // 070==F 072==H 073==I 077==M
		0,0,0,0,0,0,0,4, 0,0,0,0,0,0,0,0, // 080-095  // 087==W
		0,0,0,0,0,0,3,0, 2,5,0,0,0,6,0,0, // 096-111  // 102==f 104==h 105==i 109==m
		0,0,0,0,0,0,0,4, 0,0,0,0,0,0,0,0, // 112-127  // 119==w
		0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, // 128-133
		0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, // 134-159
		0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, // 160-175
		0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, // 176-191
		0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, // 192-207
		0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, // 208-223
		0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, // 224-239
		0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0  // 240-255
	};

check_char_loop:
	if(KVI_OPTION_BOOL(KviOption_boolIrcViewUrlHighlighting))
	{
		for(;;)
		{
			if(unsigned int chk = char_to_check_table[*((unsigned char *)p)])
			{
				switch(chk)
				{
					case 1: goto check_escape_switch;      break; // returns to check_char_loop or returns from the function at all
					case 2: goto check_http_url;           break; // returns to check_char_loop
					case 3: goto check_file_or_ftp_url;    break; // returns to check_char_loop
					case 4: goto check_www_url;            break; // returns to check_char_loop
					case 5: goto check_irc_url;            break; // returns to check_char_loop
					case 6: goto check_mailto_url;         break; // returns to check_char_loop
					case 7: goto check_emoticon_char;      break; // returns to check_char_loop
//                    case 8: goto check_emoticon_eight;     break;
				}
			}
			p++;
		}
	} else {
		while(((unsigned char)*p) > 31)p++;
		goto check_escape_switch;                                 // returns to check_char_loop
	}

#endif // !COMPILE_USE_DYNAMIC_LABELS

check_escape_switch:

	switch(*p)
	{
		case '\0':
found_end_of_buffer:
//			{
//				gettimeofday(&tmv2,0);
//				if(tmv2.tv_sec != tmv.tv_sec)debug("USEC: %d",(1000000 - tmv.tv_usec) + (1000000 * (tmv2.tv_sec  - tmv.tv_sec)) + tmv2.tv_usec);
//				else debug("USEC: %d",tmv2.tv_usec - tmv.tv_usec);
//			}
			APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
			line_ptr->data_ptr[buffer_pos_idx]='\0';
			return p;
			break;
		case '\n':
found_end_of_line:
			// Found the end of a line
			APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
			// terminate the string
			line_ptr->data_ptr[buffer_pos_idx]='\0';
			// move the current pointer to the next character...
			// if it is '\0' we will simply stop
			p++;
			return p;
			break;
		case '\r':
found_command_escape:
			// Command escape sequence
			// \r!<escape_cmd>\r<visible parameters string>\r
			p++;
			if(*p == '!')
			{
				const char * next_cr = p;
				// lookup the next carriage return
				while(*next_cr && (*next_cr != '\r'))next_cr++;
				if(*next_cr)
				{
					const char * term_cr = next_cr;
					term_cr++;
					while(*term_cr && (*term_cr != '\r'))term_cr++;
					if(*term_cr)
					{
						// ok....the format is right:
						//  \r!    ... \r ...    \r
						//    ^p        ^next_cr  ^term_cr
						p--;
						//  \r!    ... \r ...    \r
						//   ^p         ^next_cr  ^term_cr
						APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
						NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ESCAPE)

						p+=2; //point after \r!

						blockLen = (next_cr - p);
						line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc((next_cr - p) + 1);
						kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),p,blockLen);
						line_ptr->attr_ptr[curAttrIdx].escape_cmd[blockLen] = '\0';
						line_ptr->attr_ptr[curAttrIdx].attr_data.colors.fore = KVI_NOCHANGE;
						++next_cr; //point after the middle \r

						APPEND_LAST_TEXT_BLOCK(next_cr,term_cr - next_cr)
						NEW_ATTRIBUTE_BLOCK(KVI_TEXT_UNESCAPE)

						p=++term_cr;
						data_ptr=p;
					}
				}
			}
			break;
		case KVI_TEXT_COLOR:
found_color_escape:
			//Color control code...need a new attribute struct
			APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
			NEW_ATTRIBUTE_BLOCK(*p)
			p++;
			p=getColorBytes(p,&(line_ptr->attr_ptr[curAttrIdx].attr_data.colors.fore),
							&(line_ptr->attr_ptr[curAttrIdx].attr_data.colors.back));
			data_ptr=p;
			break;
		case KVI_TEXT_ICON:
found_icon_escape:
			p++;
			if(*p > 32)
			{
				// Icon control word... need a new attribute struct
				p--;
				APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
				NEW_ATTRIBUTE_BLOCK(*p)
				//debug("Appending icon block (%d)",*p);
				p++;
				const char * icon_name = p;
				while(*p > 32)p++;
				int datalen = p - icon_name;
				line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(datalen + 1);
				kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),icon_name,datalen);
				line_ptr->attr_ptr[curAttrIdx].escape_cmd[datalen] = '\0';
				line_ptr->attr_ptr[curAttrIdx].attr_data.icon_id = g_pTextIconManager->lookupTextIcon(line_ptr->attr_ptr[curAttrIdx].escape_cmd);
				if(*p == KVI_TEXT_ICON)p++; // ending delimiter
				data_ptr = p;
//				APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr);
				APPEND_ZERO_LENGTH_BLOCK(data_ptr)
				NEW_ATTRIBUTE_BLOCK(KVI_TEXT_UNICON)
				//debug("And an unicon block (%d)",KVI_TEXT_UNICON);
			}
			break;
		case KVI_TEXT_BOLD:
		case KVI_TEXT_UNDERLINE:
		case KVI_TEXT_REVERSE:
		case KVI_TEXT_RESET:
found_mirc_escape:
			APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
			NEW_ATTRIBUTE_BLOCK(*p)
			data_ptr=++p;
			break;
		default:
			p++;
			break;
	}
#ifdef COMPILE_USE_DYNAMIC_LABELS
	goto *loop_begin;
#else // !COMPILE_USE_DYNAMIC_LABELS
	goto check_char_loop;
#endif // !COMPILE_USE_DYNAMIC_LABELS

check_http_url:
	p++;
	if((*p == 't') || (*p == 'T'))
	{
		p--;
		if(kvi_strEqualCIN(p,"http://",7))
		{
			partLen = 7;
			goto got_url;
		}
		if(kvi_strEqualCIN(p,"https://",8))
		{
			partLen = 8;
			goto got_url;
		}
		p++;
	}
#ifdef COMPILE_USE_DYNAMIC_LABELS
	goto *loop_begin;
#else // !COMPILE_USE_DYNAMIC_LABELS
	goto check_char_loop;
#endif // !COMPILE_USE_DYNAMIC_LABELS


check_file_or_ftp_url:
	p++;
	if((*p == 'i') || (*p == 'I'))
	{
		p--;
		if(kvi_strEqualCIN(p,"file://",7))
		{
			partLen = 7;
			goto got_url;
		}
		p++;
	} else if((*p == 't') || (*p == 'T'))
	{
		p--;
		if(kvi_strEqualCIN(p,"ftp://",6))
		{
			partLen = 6;
			goto got_url;
		}
		if(kvi_strEqualCIN(p,"ftp.",4))
		{
			partLen = 4;
			goto got_url;
		}
		p++;
	}

#ifdef COMPILE_USE_DYNAMIC_LABELS
	goto *loop_begin;
#else // !COMPILE_USE_DYNAMIC_LABELS
	goto check_char_loop;
#endif // !COMPILE_USE_DYNAMIC_LABELS

check_www_url:
	p++;
	if((*p == 'w') || (*p == 'W'))
	{
		p--;
		if(kvi_strEqualCIN(p,"www.",4))
		{
			partLen = 4;
			goto got_url;
		}
		p++;
	}

#ifdef COMPILE_USE_DYNAMIC_LABELS
	goto *loop_begin;
#else // !COMPILE_USE_DYNAMIC_LABELS
	goto check_char_loop;
#endif // !COMPILE_USE_DYNAMIC_LABELS

check_irc_url:
	p++;
	if((*p == 'r') || (*p == 'R'))
	{
		p--;
		if(kvi_strEqualCIN(p,"irc://",6))
		{
			partLen = 6;
			goto got_url;
		}
		if(kvi_strEqualCIN(p,"irc6://",7))
		{
			partLen = 7;
			goto got_url;
		}
		p++;
	}

#ifdef COMPILE_USE_DYNAMIC_LABELS
	goto *loop_begin;
#else // !COMPILE_USE_DYNAMIC_LABELS
	goto check_char_loop;
#endif // !COMPILE_USE_DYNAMIC_LABELS

check_mailto_url:
	p++;
	if((*p == 'a') || (*p == 'A'))
	{
		p--;
		if(kvi_strEqualCIN(p,"mailto:",7))
		{
			partLen = 7;
			goto got_url;
		}
		p++;
	}
#ifdef COMPILE_USE_DYNAMIC_LABELS
	goto *loop_begin;
#else // !COMPILE_USE_DYNAMIC_LABELS
	goto check_char_loop;
#endif // !COMPILE_USE_DYNAMIC_LABELS



got_url:
	//Url highlighting block
	APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
	NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ESCAPE)
// FIXME: #warning "Option for the URL escape...double click and right button!!!"
//	int urlLen = KVI_OPTION_STRING(KviOption_stringUrlLinkCommand).len() + 1;
	line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(2);
	kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),"u",2);
	line_ptr->attr_ptr[curAttrIdx].attr_data.colors.fore = KVI_OPTION_MSGTYPE(KVI_OUT_URL).fore();
	//and run until the presumed end of the url
	data_ptr=p;
	p+=partLen;
	//Question : What characters are NOT allowed in an URL ?
	//I assume [] () {} and chars below 33 (space too , and negative chars too! (for signed char systems))
	while((((unsigned char)*p) > 32) && (*p != '[') && (*p != ']') &&
			(*p != '(') && (*p != ')') && (*p != '{') && (*p != '}'))p++;

	if(m_pKviWindow)
	{
		if(g_pEventManager->hasEventHandlers(KviEvent_OnUrl))
			g_pUserParser->triggerEvent(KviEvent_OnUrl,m_pKviWindow,new KviParameterList(new KviStr(data_ptr,p-data_ptr)));
	}

	APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
	NEW_ATTRIBUTE_BLOCK(KVI_TEXT_UNESCAPE)

	data_ptr=p;

#ifdef COMPILE_USE_DYNAMIC_LABELS
	goto *loop_begin;
#else // !COMPILE_USE_DYNAMIC_LABELS
	goto check_char_loop;
#endif // !COMPILE_USE_DYNAMIC_LABELS

	//FIXME #warning: Add more emoticons, and more intelligent code to detect when they're not really emoticons

/*
check_emoticon_eight: // Emoticons starting with '8' like '8-)' (Glasses)
    p++;
    if(KVI_OPTION_BOOL(KviOption_boolDrawEmoticons))
    {
        switch(*p)
        {
            case ')':
                p--; // Rewind to before the '8)' to APPEND the previous text
                APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
                NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ICON);
                line_ptr->attr_ptr[curAttrIdx].attr_data.icon_id = g_pTextIconManager->lookupTextIcon("smileglasses");
                line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(3);
                kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),"8)",3);
                goto got_emoticon;
            case '-':
                p++;
                switch(*p)
                { // Please note that emoticons with more than 2 chars 
                  // need to have a p++ for every aditional char
                    case ')':
                        p-=2; // Rewind to before the ':-)' to APPEND the previous text
                        APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
                        NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ICON);
                        line_ptr->attr_ptr[curAttrIdx].attr_data.icon_id = g_pTextIconManager->lookupTextIcon("smileglasses");
                        line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(4);
                        kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),"8-)",3);
                        p++;                        
                        goto got_emoticon;
                }
        }
    }
*/  
check_emoticon_char:
	// What about this ?

	if(KVI_OPTION_BOOL(KviOption_boolDrawEmoticons) && \
		( \
			(msg_type == KVI_OUT_CHANPRIVMSG) || \
			(msg_type == KVI_OUT_ACTION) || \
			(msg_type == KVI_OUT_OWNPRIVMSG) || \
			(msg_type == KVI_OUT_QUERYPRIVMSG) || \
			(msg_type == KVI_OUT_QUERYPRIVMSGCRYPTED) || \
			(msg_type == KVI_OUT_QUERYNOTICE) || \
			(msg_type == KVI_OUT_QUERYNOTICECRYPTED) || \
			(msg_type == KVI_OUT_CHANPRIVMSGCRYPTED) || \
			(msg_type == KVI_OUT_CHANNELNOTICE) || \
			(msg_type == KVI_OUT_CHANNELNOTICECRYPTED) || \
			(msg_type == KVI_OUT_OWNPRIVMSGCRYPTED) || \
			(msg_type == KVI_OUT_HIGHLIGHT) \
		))
	{
		const char * begin = p;
		p++;

		// Pragma: 31.05.2002 : I had to kill the 8 prefix
		// It happens really too often to have an 8 followed by a parenthesis
		// that is not an emoticon

		// *begin can be one of ':' , ';' , '='
		if(*p == '-')p++; // FIXME: we could handle also '' and 'o' as a nose ??? (extreme: also '+' ?)
		// FIXME: use a "jump-like-check-table" here ? .... it would be surely faster
		// FIXME: handle also '[',']','\\','','p','@','#','<','>','|' ???
		if(*p == ')' || *p == '(' || *p == '/' || *p == 'D' || *p == 'P' || *p == 'O' || *p == '*')
		{
			const char * item = p;
			p++;
			while(*p == *item)p++;
			if(!*p || (*p == ' '))
			{
				// ok! this is an emoticon (sequence) !
				// We lookup simplified versions of the emoticons...
				char lookupstring[3];
				// actually we're using ':' as begginning , but we could use *begin
				// and map everything to different emoticons...
				// it's just that we don't have enough icons for now :D
				// so finally we map everything to :X
				lookupstring[0] = ':'; // = *begin
				lookupstring[1] = *item;
				lookupstring[2] = 0;
				unsigned short icon_id = g_pTextIconManager->lookupTextIcon(lookupstring);
				// but the tooltip will carry the original emoticon source text
				APPEND_LAST_TEXT_BLOCK(data_ptr,begin - data_ptr)
				NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ICON)
				int emolen = p - begin;
				line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(emolen + 1);
				kvi_fastmove(line_ptr->attr_ptr[curAttrIdx].escape_cmd,begin,emolen);
				line_ptr->attr_ptr[curAttrIdx].escape_cmd[emolen] = 0;
				line_ptr->attr_ptr[curAttrIdx].attr_data.icon_id = icon_id;
				data_ptr = p;
				APPEND_ZERO_LENGTH_BLOCK(data_ptr)
				// let's also handle thingies like :DDDD
				item++;
				while(item != p)
				{
					NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ICON)
					line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(emolen + 1);
					kvi_fastmove(line_ptr->attr_ptr[curAttrIdx].escape_cmd,begin,emolen);
					line_ptr->attr_ptr[curAttrIdx].escape_cmd[emolen] = 0;
					line_ptr->attr_ptr[curAttrIdx].attr_data.icon_id = icon_id;
					APPEND_ZERO_LENGTH_BLOCK(data_ptr)
					item++;
				}
				NEW_ATTRIBUTE_BLOCK(KVI_TEXT_UNICON)
			} // we don't even need to skip back... the text eventually parsed is ok to be in a single block for sure
			//else {
				// hmm.. rather not an emoticon (might still be , but we're too unsure)
				//p = begin;
				//p++;
			//}
		} // we don't even need to skip back... the text eventually parsed is ok to be in a single block for sure
		//else {
			//p = begin;
			//p++;
		//}
	} else p++;

#ifdef COMPILE_USE_DYNAMIC_LABELS
	goto *loop_begin;
#else // !COMPILE_USE_DYNAMIC_LABELS
	goto check_char_loop;
#endif // !COMPILE_USE_DYNAMIC_LABELS

/*

   //Little & obvious state machine here... the complexity this way is much smaller than the same 
    //code testing for every smile with kvi_strEqualCIN.

    p++;
    if(KVI_OPTION_BOOL(KviOption_boolDrawEmoticons)) 
    {
        switch(*p)
        {
            case ')':
                p--; // Rewind to before the ':)' to APPEND the previous text
                APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
                NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ICON);
                line_ptr->attr_ptr[curAttrIdx].attr_data.icon_id = g_pTextIconManager->lookupTextIcon("smile");
                line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(3);
                kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),":)",3);
                goto got_emoticon;
            case '(':
                p--; // Rewind to before the ':(' to APPEND the previous text
                APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
                NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ICON);
                line_ptr->attr_ptr[curAttrIdx].attr_data.icon_id = g_pTextIconManager->lookupTextIcon("sad");
                line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(3);
                kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),":(",3);
                goto got_emoticon;
            case 'D':
                p--;
                APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
                NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ICON);
                line_ptr->attr_ptr[curAttrIdx].attr_data.icon_id = g_pTextIconManager->lookupTextIcon(":D");
                line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(3);
                kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),":D",3);                
                goto got_emoticon;
            case '-':
                p++; 
                switch(*p)
                { // Please note that emoticons with more than 2 chars
                  // need to have a p++ for every aditional char
                    case ')':
                        p-=2; // Rewind to before the ':-)' to APPEND the previous text
                        APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
                        NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ICON);
                        line_ptr->attr_ptr[curAttrIdx].attr_data.icon_id = g_pTextIconManager->lookupTextIcon("smile");
                        line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(4);
                        kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),":-)",3);
                        p++;
                        goto got_emoticon;
                    case '(':
                        p-=2; // Rewind to before the ':-(' to APPEND the previous text
                        APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
                        NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ICON);
                        line_ptr->attr_ptr[curAttrIdx].attr_data.icon_id = g_pTextIconManager->lookupTextIcon("sad");
                        line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(4);
                        kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),":-(",3);
                        p++;
                        goto got_emoticon;
                    case 'D':
                        p-=2; // Rewind to before the ':-D' to APPEND the previous text
                        APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
                        NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ICON);
                        line_ptr->attr_ptr[curAttrIdx].attr_data.icon_id = g_pTextIconManager->lookupTextIcon(":D");
                        line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(4);
                        kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),":-D",3);
                        p++;
                        goto got_emoticon;
                        
                    case 'O':
                        p-=2; // Rewind to before the ':-O' to APPEND the previous text
                        APPEND_LAST_TEXT_BLOCK(data_ptr,p - data_ptr)
                        NEW_ATTRIBUTE_BLOCK(KVI_TEXT_ICON);
                        line_ptr->attr_ptr[curAttrIdx].attr_data.icon_id = g_pTextIconManager->lookupTextIcon(":O");
                        line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(4);                  
                        kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),":-O",3);
                        p++;
                        goto got_emoticon;
                }
        }
//FIXME: #warning Add check_emoticons_semicolon & etc here as soon as we've the icons for them    
#ifdef COMPILE_USE_DYNAMIC_LABELS
        goto *loop_begin;
#else // !COMPILE_USE_DYNAMIC_LABELS
        goto check_char_loop;
#endif // !COMPILE_USE_DYNAMIC_LABELS
              
got_emoticon:
        //if(*p == KVI_TEXT_ICON)p++;
        p+=2;
        data_ptr = p;
        APPEND_ZERO_LENGTH_BLOCK(data_ptr);
        NEW_ATTRIBUTE_BLOCK(KVI_TEXT_UNICON);
    }

#ifdef COMPILE_USE_DYNAMIC_LABELS
	goto *loop_begin;
#else // !COMPILE_USE_DYNAMIC_LABELS
	goto check_char_loop;
#endif // !COMPILE_USE_DYNAMIC_LABELS

*/

	// never here
	return p;

}

void KviIrcView::fastScroll(int lines)
{
	m_iUnprocessedPaintEventRequests = 0;
	if(!isVisible())return;
	// Ok...the current line is the last one here
	// It is the only one that needs to be repainted
	int widgetWidth  = width()-m_pScrollBar->width();
	if(widgetWidth < 20)return; //can't show stuff here
	int widgetHeight = height();
	int maxLineWidth = widgetWidth;
	int defLeftCoord=KVI_IRCVIEW_HORIZONTAL_BORDER;
	if(m_bShowImages){
		maxLineWidth -= KVI_IRCVIEW_PIXMAP_SEPARATOR_AND_DOUBLEBORDER_WIDTH;
		defLeftCoord+=KVI_IRCVIEW_PIXMAP_AND_SEPARATOR;
	}
	int heightToPaint = 1;
	KviIrcViewTextLine * l = m_pCurLine;
	while(lines > 0){
		if(l){
			if(maxLineWidth != l->max_line_width)calculateLineWraps(l,maxLineWidth);
			heightToPaint += l->line_wraps * m_iFontLineSpacing;
			heightToPaint += (m_iFontLineSpacing + m_iFontDescent);
			lines--;
			l = l->prev_line;
		} else lines = 0;
	}
#ifdef COMPILE_NO_X_DRAW_CALLS
	bitBlt(this,1,1,this,1,heightToPaint,widgetWidth -2,widgetHeight - (heightToPaint + KVI_IRCVIEW_VERTICAL_BORDER));
#else
	XCopyArea(g_display,handle(),handle(),g_ircviewGC,
				1,heightToPaint,
				widgetWidth - 2,
				widgetHeight - (heightToPaint + KVI_IRCVIEW_VERTICAL_BORDER),
				1,1);
#endif
	QRect r(0,widgetHeight - (heightToPaint + KVI_IRCVIEW_VERTICAL_BORDER),
			widgetWidth,heightToPaint + KVI_IRCVIEW_VERTICAL_BORDER);

	QPaintEvent * e = new QPaintEvent(r);
	paintEvent(e);
	delete e;

	if(m_iLastLinkRectHeight > -1)
	{
		// need to kill the last highlighted link
		m_iLastLinkRectTop -= heightToPaint;
		if(m_iLastLinkRectTop < 0)
		{
			m_iLastLinkRectHeight += m_iLastLinkRectTop;
			m_iLastLinkRectTop = 0;
		}
	}

}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// The IrcView : THE paint event
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void KviIrcView::paintEvent(QPaintEvent *p)
{
	//debug("PAINT EVENT");
	//
	// THIS FUNCTION IS A MONSTER
	//
	//debug("PAINTING ON %d,%d",width(),height());

	int scrollbarWidth = m_pScrollBar->width();
	int widgetWidth  = width() - scrollbarWidth;
	if(!isVisible() || (widgetWidth < 20))
	{
		m_iUnprocessedPaintEventRequests = 0; // assume a full repaint when this widget is shown...
		return; //can't show stuff here
	}
	int widgetHeight = height();

	static QRect r; // static: avoid calling constructor and destructor every time...

	if(p)
	{
		r=p->rect(); // app triggered , or self triggered from fastScroll (in that case m_iUnprocessedPaintEventRequests is set to 0 there)
	} else {
		// A self triggered event
		m_iUnprocessedPaintEventRequests = 0; // only full repaints reset
		r = rect();	
	}

	int rectLeft   = r.x();
	int rectTop    = r.y();
	int rectHeight = r.height();
	int rectBottom = rectTop + rectHeight;
	int rectWidth  = r.width();
	if(rectWidth > widgetWidth)rectWidth = widgetWidth;

#ifdef COMPILE_NO_X_DRAW_CALLS

	QPainter pa(g_pIrcViewMemBuffer);

	#ifdef COMPILE_PSEUDO_TRANSPARENCY
		if(g_pShadedChildGlobalDesktopBackground)
		{
			QPoint pnt = mapToGlobal(QPoint(rectLeft,rectTop));
			pa.drawTiledPixmap(rectLeft,rectTop,rectWidth,rectHeight,*g_pShadedChildGlobalDesktopBackground,pnt.x(),pnt.y());
		} else {
	#endif
	
			if(m_pPrivateBackgroundPixmap)
			{
				pa.drawTiledPixmap(rectLeft,rectTop,rectWidth,rectHeight,*m_pPrivateBackgroundPixmap,0,0);
			} else {
				if(KVI_OPTION_PIXMAP(KviOption_pixmapIrcViewBackground).pixmap())
				{
					pa.drawTiledPixmap(rectLeft,rectTop,rectWidth,rectHeight,*(KVI_OPTION_PIXMAP(KviOption_pixmapIrcViewBackground).pixmap()),0,0);
				} else {
					pa.fillRect(rectLeft,rectTop,rectWidth,rectHeight,KVI_OPTION_COLOR(KviOption_colorIrcViewBackground));
				}
			}
	#ifdef COMPILE_PSEUDO_TRANSPARENCY
		}
	#endif

	pa.setFont(KVI_OPTION_FONT(KviOption_fontIrcView));

#else //!COMPILE_NO_X_DRAW_CALLS

	// evil XFillRectangle...

	#ifdef COMPILE_PSEUDO_TRANSPARENCY
		if(g_pShadedChildGlobalDesktopBackground)
		{
			XSetTile(g_display,g_ircviewGC,g_pShadedChildGlobalDesktopBackground->handle());
			XSetFillStyle(g_display,g_ircviewGC,FillTiled);
			QPoint pnt = mapToGlobal(QPoint(0,0));
			XSetTSOrigin(g_display,g_ircviewGC,-pnt.x(),-pnt.y());
		   	XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,rectLeft,rectTop,rectWidth,rectHeight);
			XSetFillStyle(g_display,g_ircviewGC,FillSolid);
		} else {
	#endif
	
			if(m_pPrivateBackgroundPixmap)
			{
				XSetTile(g_display,g_ircviewGC,m_pPrivateBackgroundPixmap->handle());
				XSetFillStyle(g_display,g_ircviewGC,FillTiled);
			   	XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,rectLeft,rectTop,rectWidth,rectHeight);
				XSetFillStyle(g_display,g_ircviewGC,FillSolid);
			} else {
				if(KVI_OPTION_PIXMAP(KviOption_pixmapIrcViewBackground).pixmap())
				{
					XSetTile(g_display,g_ircviewGC,KVI_OPTION_PIXMAP(KviOption_pixmapIrcViewBackground).pixmap()->handle());
					XSetFillStyle(g_display,g_ircviewGC,FillTiled);
				   	XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,rectLeft,rectTop,rectWidth,rectHeight);
					XSetFillStyle(g_display,g_ircviewGC,FillSolid);
				} else {
					XSetForeground(g_display,g_ircviewGC,KVI_OPTION_COLOR(KviOption_colorIrcViewBackground).pixel());
					XSetBackground(g_display,g_ircviewGC,KVI_OPTION_COLOR(KviOption_colorIrcViewBackground).pixel());
				   	XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,rectLeft,rectTop,rectWidth,rectHeight);
				}
			}
	#ifdef COMPILE_PSEUDO_TRANSPARENCY
		}
	#endif
	
	#ifdef COMPILE_USE_AA_FONTS
		if(kvi_xft_enabled())
		{
			g_pIrcViewXftFont = kvi_xft_font(&(KVI_OPTION_FONT(KviOption_fontIrcView)));
			g_pIrcViewXftDraw = kvi_xft_lookup_drawable(g_hIrcViewMemBuffer,g_pIrcViewMemBuffer,0);
			if(!g_pIrcViewXftDraw)
			{
				g_pIrcViewXftFont = 0;
				XSetFont(g_display,g_ircviewGC,KVI_OPTION_FONT(KviOption_fontIrcView).handle());
			}
		} else {
	#endif
			XSetFont(g_display,g_ircviewGC,KVI_OPTION_FONT(KviOption_fontIrcView).handle());
	#ifdef COMPILE_USE_AA_FONTS
			g_pIrcViewXftFont = 0;
			g_pIrcViewXftDraw = 0;
		}
	#endif
#endif //!COMPILE_NO_X_DRAW_CALLS



	//Have lines visible
	int curBottomCoord = widgetHeight - KVI_IRCVIEW_VERTICAL_BORDER;
	int maxLineWidth   = widgetWidth;
	int defLeftCoord   = KVI_IRCVIEW_HORIZONTAL_BORDER;
	int lineWrapsHeight;

	if(m_bShowImages)
	{
		maxLineWidth -= KVI_IRCVIEW_PIXMAP_SEPARATOR_AND_DOUBLEBORDER_WIDTH;
		defLeftCoord += KVI_IRCVIEW_PIXMAP_AND_SEPARATOR;
	}

	KviIrcViewTextLine *pCurTextLine = m_pCurLine;

	if(m_bMouseIsDown)
	{
		m_szLastSelectionLine          = "";
		m_szLastSelection              = "";
		m_iLastSelectionLineLen        = 0;
	}

	//Make sure that we have enough space to paint something...
	if(maxLineWidth < m_iMinimumPaintWidth)pCurTextLine=0;


	//And loop thru lines until we not run over the upper bound of the view
	while((curBottomCoord >= KVI_IRCVIEW_VERTICAL_BORDER) && pCurTextLine)
	{



		//Paint pCurTextLine
		if(maxLineWidth != pCurTextLine->max_line_width)
		{
			// Width of the widget or the font has been changed
			// from the last time that this line was painted
			calculateLineWraps(pCurTextLine,maxLineWidth);
		}

		//debug("Ok.. will run now (lines wrapped)");

		// the evil multiplication
		// in an i486 it can get up to 42 clock cycles
		lineWrapsHeight  = (pCurTextLine->line_wraps) * m_iFontLineSpacing;
		curBottomCoord  -= lineWrapsHeight;

		if((curBottomCoord - m_iFontLineSpacing) > rectBottom)
		{
			// not in update rect... skip
			curBottomCoord -= (m_iFontLineSpacing + m_iFontDescent);
			pCurTextLine = pCurTextLine->prev_line;
			continue;
		}

		//debug("Showing image");

		if(m_bShowImages)
		{
			//Paint the pixmap first
			//Calculate the position of the image
			//imageYPos = curBottomCoord - (pixmapHeight(16) + ((m_iFontLineSpacing - 16)/2) );
			int imageYPos = curBottomCoord - m_iRelativePixmapY;
			//Set the mask if needed
#ifdef COMPILE_NO_X_DRAW_CALLS
			pa.drawPixmap(KVI_IRCVIEW_HORIZONTAL_BORDER,imageYPos,*(g_pIconManager->getSmallIcon(KVI_OPTION_MSGTYPE(pCurTextLine->msg_type).pixId())));
#else //!COMPILE_NO_X_DRAW_CALLS
			QPixmap *pix = g_pIconManager->getSmallIcon(KVI_OPTION_MSGTYPE(pCurTextLine->msg_type).pixId());
			if(pix->mask())
			{
				XSetClipMask(g_display,g_ircviewGC,pix->mask()->handle());
				XSetClipOrigin(g_display,g_ircviewGC,KVI_IRCVIEW_HORIZONTAL_BORDER,imageYPos);
			}
			//Draw the pixmap
			XCopyArea(g_display,pix->handle(),g_hIrcViewMemBuffer,g_ircviewGC,0,0,KVI_IRCVIEW_PIXMAP_SIZE,
				KVI_IRCVIEW_PIXMAP_SIZE,KVI_IRCVIEW_HORIZONTAL_BORDER,imageYPos);
			XSetClipMask(g_display,g_ircviewGC,None);
#endif
		}

		if(m_pToolWidget)
		{
			if(!m_pToolWidget->messageEnabled(pCurTextLine->msg_type))
			{
				// not in update rect... skip
				curBottomCoord -= (m_iFontLineSpacing + m_iFontDescent);
				pCurTextLine = pCurTextLine->prev_line;
				continue;
			}
		}

		//Initialize for drawing this line of text
		char defaultBack  = pCurTextLine->text_blocks_ptr->attr_ptr->attr_data.colors.back;
		char defaultFore  = pCurTextLine->text_blocks_ptr->attr_ptr->attr_data.colors.fore;
		bool curBold      = false;
		bool curUnderline = false;
		char foreBeforeEscape= KVI_BLACK;
		bool curLink      = false;
		char curFore      = defaultFore;
		char curBack      = defaultBack;
		int  curLeftCoord = defLeftCoord;
		curBottomCoord   -= m_iFontDescent; //rise up the text...

		//
		// Single text line loop (paint all text blocks)
		// (May correspond to more physical lines on the display if the text is wrapped)
		//


		for(int i=0;i < pCurTextLine->num_text_blocks;i++)
		{

			register KviIrcViewTextBlock * block = &(pCurTextLine->text_blocks_ptr[i]);

			// Play with the attributes
			//debug("Painting block %d",i);

			if(block->attr_ptr)
			{
				//debug("Has an attribute");
				//normal block
				switch(block->attr_ptr->attribute)
				{
					case KVI_TEXT_COLOR:
						if(block->attr_ptr->attr_data.colors.fore != KVI_NOCHANGE)
							curFore = block->attr_ptr->attr_data.colors.fore;
						else
							curFore = defaultFore;
						if(block->attr_ptr->attr_data.colors.back != KVI_NOCHANGE)
							curBack = block->attr_ptr->attr_data.colors.back;
						else
							curBack = defaultBack;
						// Begin Edit by GMC-jimmy: Added condition for handling a CTRL+K code when missing numbers.
						// When KVIrc encounters a CTRL+K code without any trailing numbers, we then use KVIrc's default color value defined by the user in the Options dialog.
						// This is to allow KVIrc to handle mIRC color codes in a similar fashion to most other modern irc clients.
						// See also kvi_input.cpp

						// Pragma: optimized: moved the code above (avoided duplicate if())

						//if(block->attr_ptr->attr_data.colors.fore == KVI_NOCHANGE)
						//	curFore = defaultFore;
						//if(block->attr_ptr->attr_data.colors.back == KVI_NOCHANGE)
						//	curBack = defaultBack;
						// End Edit
						break;
					case KVI_TEXT_ESCAPE:
						foreBeforeEscape      = curFore;
						if(block->attr_ptr->attr_data.colors.fore != KVI_NOCHANGE)
							curFore = block->attr_ptr->attr_data.colors.fore;
						if(m_pLastLinkUnderMouse == block)curLink = true;
						break;
					case KVI_TEXT_UNESCAPE:
						curLink            = false;
						curFore            = foreBeforeEscape;
						break;
					case KVI_TEXT_BOLD:
						curBold            = !curBold;
						break;
					case KVI_TEXT_UNDERLINE:
						curUnderline       = !curUnderline;
						break;
					case KVI_TEXT_RESET:
						curBold            = false;
						curUnderline       = false;
						curFore            = defaultFore;
						curBack            = defaultBack;
						break;
					case KVI_TEXT_REVERSE: //Huh ?
						if(curBack != KVI_TRANSPARENT)
						{
							char aux       =curFore;
							curFore        = curBack;
							curBack        = aux;
						} else {
							curBack = curFore;
							switch(curBack)
							{
								case KVI_WHITE:
								case KVI_ORANGE:
								case KVI_YELLOW:
								case KVI_LIGHTGREEN:
								case KVI_BLUEMARINE:
								case KVI_LIGHTBLUE:
								case KVI_LIGHTVIOLET:
								case KVI_LIGHTGRAY:
									curFore=KVI_BLACK;
									break;
								default: //transparent too
									curFore=KVI_LIGHTGREEN;
									break;
							}
						}
						break;
					//case KVI_TEXT_ICON:
					//case KVI_TEXT_UNICON:
						// does nothing
						//debug("Have a block with ICON/UNICON attr");
						//break;
				}

			} else {
				//debug("No attributes , it's a line wrap");

				// no attributes , it is a line wrap
				curLeftCoord = defLeftCoord;
				if(KVI_OPTION_BOOL(KviOption_boolIrcViewWrapMargin))curLeftCoord+=m_iWrapMargin;
				curBottomCoord += m_iFontLineSpacing;

			}

			//debug("Now it's time to paint");

//
// Here we run really out of bounds :)))))
// A couple of macros that could work well as functions...
// but since there are really many params to be passed
// and push & pop calls take clock cycles
// my paranoic mind decided to go for the macro way.
// This is NOT good programming
//

#ifdef COMPILE_NO_X_DRAW_CALLS

	#define DRAW_SELECTED_TEXT(_text_ptr,_text_len,_text_width) \
		pa.setPen(KVI_OPTION_MIRCCOLOR(KVI_OPTION_MSGTYPE(KVI_OUT_SELECT).fore())); \
		{ \
			int theWdth = _text_width; \
			if(theWdth < 0) \
				theWdth=width()-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER+scrollbarWidth); \
			pa.fillRect(curLeftCoord,curBottomCoord - m_iFontLineSpacing + m_iFontDescent,theWdth,m_iFontLineSpacing,KVI_OPTION_MIRCCOLOR(KVI_OPTION_MSGTYPE(KVI_OUT_SELECT).back())); \
		} \
		pa.drawText(curLeftCoord,curBottomCoord,_text_ptr,_text_len); \
		m_szLastSelectionLine.setLen(m_iLastSelectionLineLen + _text_len); \
		kvi_fastmove(m_szLastSelectionLine.ptr()+m_iLastSelectionLineLen,_text_ptr,_text_len); \
		m_iLastSelectionLineLen += _text_len; \
		curLeftCoord += _text_width;
	
	#define DRAW_NORMAL_TEXT(_text_ptr,_text_len,_text_width) \
		pa.setPen(KVI_OPTION_MIRCCOLOR((unsigned char)curFore)); \
		if(curBack != KVI_TRANSPARENT){ \
			int theWdth = _text_width; \
			if(theWdth < 0) \
				theWdth=width()-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER+scrollbarWidth); \
			pa.fillRect(curLeftCoord,curBottomCoord - m_iFontLineSpacing + m_iFontDescent,theWdth,m_iFontLineSpacing,KVI_OPTION_MIRCCOLOR((unsigned char)curBack)); \
		} \
		pa.drawText(curLeftCoord,curBottomCoord,_text_ptr,_text_len); \
		if(curBold)pa.drawText(curLeftCoord+1,curBottomCoord,_text_ptr,_text_len); \
		if(curUnderline){ \
			int theWdth = _text_width; \
			if(theWdth < 0) \
				theWdth=width()-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER+scrollbarWidth); \
			pa.drawLine(curLeftCoord,curBottomCoord,curLeftCoord+theWdth,curBottomCoord); \
		} \
		curLeftCoord += _text_width;

#else //!COMPILE_NO_X_DRAW_CALLS

	#define DRAW_X_SELECTED_TEXT(_text_ptr,_text_len,_text_width) \
		XSetForeground(g_display,g_ircviewGC, \
			KVI_OPTION_MIRCCOLOR(KVI_OPTION_MSGTYPE(KVI_OUT_SELECT).fore()).pixel()); \
		XSetBackground(g_display,g_ircviewGC, \
			KVI_OPTION_MIRCCOLOR(KVI_OPTION_MSGTYPE(KVI_OUT_SELECT).back()).pixel()); \
		XDrawImageString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord, \
			curBottomCoord,_text_ptr,_text_len); \
		m_szLastSelectionLine.setLen(m_iLastSelectionLineLen + _text_len); \
		kvi_fastmove(m_szLastSelectionLine.ptr()+m_iLastSelectionLineLen,_text_ptr,_text_len); \
		m_iLastSelectionLineLen += _text_len; \
		curLeftCoord += _text_width;
	
	#define DRAW_X_NORMAL_TEXT(_text_ptr,_text_len,_text_width) \
		XSetForeground(g_display,g_ircviewGC, \
			KVI_OPTION_MIRCCOLOR((unsigned char)curFore).pixel()); \
		if(curBack != KVI_TRANSPARENT){ \
			XSetBackground(g_display,g_ircviewGC, \
				KVI_OPTION_MIRCCOLOR((unsigned char)curBack).pixel()); \
			XDrawImageString(g_display,g_hIrcViewMemBuffer,g_ircviewGC, \
				curLeftCoord,curBottomCoord,_text_ptr,_text_len); \
		} else XDrawString(g_display,g_hIrcViewMemBuffer,g_ircviewGC, \
				curLeftCoord,curBottomCoord,_text_ptr,_text_len); \
		if(curBold)XDrawString(g_display,g_hIrcViewMemBuffer,g_ircviewGC, \
				curLeftCoord+1,curBottomCoord,_text_ptr,_text_len); \
		if(curUnderline){ \
			int theWdth = _text_width; \
			if(theWdth < 0) \
				theWdth=width()-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER+scrollbarWidth); \
			XSetLineAttributes(g_display,g_ircviewGC,m_iFontLineWidth, \
				LineSolid,CapButt,JoinMiter); \
			XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC, \
				curLeftCoord,curBottomCoord,curLeftCoord+theWdth,curBottomCoord); \
		} \
		curLeftCoord += _text_width;
	
	
	#ifdef COMPILE_USE_AA_FONTS

		#define DRAW_SELECTED_TEXT(_text_ptr,_text_len,_text_width) \
			if(g_pIrcViewXftFont){ \
				int theWdth = _text_width; \
				if(theWdth < 0) \
					theWdth=width()-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER+scrollbarWidth); \
				XSetForeground(g_display,g_ircviewGC, \
					KVI_OPTION_MIRCCOLOR(KVI_OPTION_MSGTYPE(KVI_OUT_SELECT).back()).pixel()); \
				XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord, \
					curBottomCoord - m_iFontLineSpacing + m_iFontDescent,theWdth,m_iFontLineSpacing); \
				QColor * clr = &(KVI_OPTION_MIRCCOLOR(KVI_OPTION_MSGTYPE(KVI_OUT_SELECT).fore())); \
				XftColor color; \
				color.color.red = clr->red() | clr->red() << 8; \
				color.color.green = clr->green() | clr->green() << 8; \
				color.color.blue = clr->blue() | clr->blue() << 8; \
				color.color.alpha = 0xffff; \
				color.pixel = clr->pixel(); \
				XftDrawString8(g_pIrcViewXftDraw,&color,g_pIrcViewXftFont,curLeftCoord,curBottomCoord,(unsigned char *)_text_ptr,_text_len); \
				m_szLastSelectionLine.setLen(m_iLastSelectionLineLen + _text_len); \
				kvi_fastmove(m_szLastSelectionLine.ptr()+m_iLastSelectionLineLen,_text_ptr,_text_len); \
				m_iLastSelectionLineLen += _text_len; \
				curLeftCoord += _text_width; \
			} else { \
				DRAW_X_SELECTED_TEXT(_text_ptr,_text_len,_text_width) \
			}
	
		#define DRAW_NORMAL_TEXT(_text_ptr,_text_len,_text_width) \
			if(g_pIrcViewXftFont){ \
				if(curBack != KVI_TRANSPARENT){ \
					int theWdth = _text_width; \
					if(theWdth < 0) \
						theWdth=width()-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER+scrollbarWidth); \
					XSetForeground(g_display,g_ircviewGC, \
						KVI_OPTION_MIRCCOLOR((unsigned char)curBack).pixel()); \
					XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord, \
						curBottomCoord - m_iFontLineSpacing + m_iFontDescent,theWdth,m_iFontLineSpacing); \
				} \
				QColor * clr = &(KVI_OPTION_MIRCCOLOR((unsigned char)curFore)); \
				XftColor color; \
				color.color.red = clr->red() | clr->red() << 8; \
				color.color.green = clr->green() | clr->green() << 8; \
				color.color.blue = clr->blue() | clr->blue() << 8; \
				color.color.alpha = 0xffff; \
				color.pixel = clr->pixel(); \
				XftDrawString8(g_pIrcViewXftDraw,&color,g_pIrcViewXftFont,curLeftCoord,curBottomCoord,(unsigned char *)_text_ptr,_text_len); \
				if(curBold)XftDrawString8(g_pIrcViewXftDraw,&color,g_pIrcViewXftFont,curLeftCoord + 1,curBottomCoord,(unsigned char *)_text_ptr,_text_len); \
				if(curUnderline){ \
					XSetForeground(g_display,g_ircviewGC, \
						KVI_OPTION_MIRCCOLOR((unsigned char)curFore).pixel()); \
					int theWdth = _text_width; \
					if(theWdth < 0) \
						theWdth=width()-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER+scrollbarWidth); \
					XSetLineAttributes(g_display,g_ircviewGC,m_iFontLineWidth, \
						LineSolid,CapButt,JoinMiter); \
					XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC, \
						curLeftCoord,curBottomCoord,curLeftCoord+theWdth,curBottomCoord); \
				} \
				curLeftCoord += _text_width; \
			} else { \
				DRAW_X_NORMAL_TEXT(_text_ptr,_text_len,_text_width) \
			}
	
	#else //!COMPILE_USE_AA_FONTS

		#define DRAW_NORMAL_TEXT(_text_ptr,_text_len,_text_width) DRAW_X_NORMAL_TEXT(_text_ptr,_text_len,_text_width)
		#define DRAW_SELECTED_TEXT(_text_ptr,_text_len,_text_width) DRAW_X_SELECTED_TEXT(_text_ptr,_text_len,_text_width)

	#endif //!COMPILE_USE_AA_FONTS

#endif //!COMPILE_NO_X_DRAW_CALLS

// EOF macro declarations

			if(m_bMouseIsDown)
			{
				//Check if the block or a part of it is selected
				if(checkSelectionBlock(pCurTextLine,curLeftCoord,curBottomCoord,i))
				{
					//Selected in some way
					//__range_valid(g_pOptions->m_cViewOutSeleFore != KVI_TRANSPARENT);
					//__range_valid(g_pOptions->m_cViewOutSeleBack != KVI_TRANSPARENT);
					switch(m_TextBlockSelectionInfo.selection_type)
					{
						case KVI_IRCVIEW_BLOCK_SELECTION_TOTAL:
							DRAW_SELECTED_TEXT(block->block_ptr,
								block->block_len,block->block_width)
						break;
						case KVI_IRCVIEW_BLOCK_SELECTION_LEFT:
							DRAW_SELECTED_TEXT(block->block_ptr,
								m_TextBlockSelectionInfo.part_1_length,
								m_TextBlockSelectionInfo.part_1_width)
							DRAW_NORMAL_TEXT(block->block_ptr+m_TextBlockSelectionInfo.part_1_length,
								m_TextBlockSelectionInfo.part_2_length,
								m_TextBlockSelectionInfo.part_2_width)
						break;
						case KVI_IRCVIEW_BLOCK_SELECTION_RIGHT:
							DRAW_NORMAL_TEXT(block->block_ptr,
								m_TextBlockSelectionInfo.part_1_length,
								m_TextBlockSelectionInfo.part_1_width)
							DRAW_SELECTED_TEXT(block->block_ptr + m_TextBlockSelectionInfo.part_1_length,
								m_TextBlockSelectionInfo.part_2_length,
								m_TextBlockSelectionInfo.part_2_width)
						break;
						case KVI_IRCVIEW_BLOCK_SELECTION_CENTRAL:
							DRAW_NORMAL_TEXT(block->block_ptr,
								m_TextBlockSelectionInfo.part_1_length,
								m_TextBlockSelectionInfo.part_1_width)
							DRAW_SELECTED_TEXT(block->block_ptr + m_TextBlockSelectionInfo.part_1_length,
								m_TextBlockSelectionInfo.part_2_length,
								m_TextBlockSelectionInfo.part_2_width)
							DRAW_NORMAL_TEXT(block->block_ptr+m_TextBlockSelectionInfo.part_1_length+m_TextBlockSelectionInfo.part_2_length,
								m_TextBlockSelectionInfo.part_3_length,
								m_TextBlockSelectionInfo.part_3_width)
						break;
						case KVI_IRCVIEW_BLOCK_SELECTION_ICON:
						{
							int theWdth = block->block_width;
							if(theWdth < 0)theWdth=width()-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER+scrollbarWidth);
#ifdef COMPILE_NO_X_DRAW_CALLS
							pa.fillRect(curLeftCoord,curBottomCoord - m_iFontLineSpacing + m_iFontDescent,theWdth,m_iFontLineSpacing,KVI_OPTION_MIRCCOLOR(KVI_OPTION_MSGTYPE(KVI_OUT_SELECT).back()));
#else //!COMPILE_NO_X_DRAW_CALLS
							XSetForeground(g_display,g_ircviewGC,KVI_OPTION_MIRCCOLOR(KVI_OPTION_MSGTYPE(KVI_OUT_SELECT).back()).pixel());
							XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,curBottomCoord - m_iFontLineSpacing + m_iFontDescent,theWdth,m_iFontLineSpacing);
#endif //!COMPILE_NO_X_DRAW_CALLS
							int the_len = kvi_strLen(block->attr_ptr->escape_cmd);
							m_szLastSelectionLine.setLen(m_iLastSelectionLineLen + the_len + 2);
							kvi_fastmove(m_szLastSelectionLine.ptr()+m_iLastSelectionLineLen,&(block->attr_ptr->attribute),1);
							kvi_fastmove(m_szLastSelectionLine.ptr()+m_iLastSelectionLineLen+1,block->attr_ptr->escape_cmd,the_len);
							kvi_fastmove(m_szLastSelectionLine.ptr()+m_iLastSelectionLineLen+1+the_len,&(block->attr_ptr->attribute),1);
							m_iLastSelectionLineLen += (the_len + 2);
							goto no_selection_paint;
						}
						break;
					}
				} else {
					if(block->attr_ptr && block->attr_ptr->attribute == KVI_TEXT_ICON)goto no_selection_paint;
					int wdth = block->block_width;
					if(wdth == 0)
					{
						// Last block before a word wrap , or a zero characters attribute block ?
						if(i < (pCurTextLine->num_text_blocks - 1))
						{
							// There is another block...
							// Check if it is a wrap...
							if(pCurTextLine->text_blocks_ptr[i+1].attr_ptr == 0)wdth = widgetWidth-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER);
							// else simply a zero characters block
						}
						// else simply a zero characters block
					}
					DRAW_NORMAL_TEXT(block->block_ptr,block->block_len,wdth)
				}
			} else {
				//No selection ...go fast!
no_selection_paint:
				if(block->attr_ptr && block->attr_ptr->attribute == KVI_TEXT_ICON)
				{
					//debug("Will paint an ICON block");
					int wdth = block->block_width;
					//debug("With block width of %d",wdth);
					if(wdth < 0)wdth = widgetWidth - (curLeftCoord + KVI_IRCVIEW_HORIZONTAL_BORDER);
					int imageYPos = curBottomCoord - m_iRelativePixmapY;
					//Set the mask if needed
#ifdef COMPILE_NO_X_DRAW_CALLS
					if(curBack != KVI_TRANSPARENT)
					{
						pa.fillRect(curLeftCoord,curBottomCoord - m_iFontLineSpacing + m_iFontDescent,wdth,m_iFontLineSpacing,KVI_OPTION_MIRCCOLOR((unsigned char)curBack));
					}
					pa.drawPixmap(curLeftCoord + m_iIconSideSpacing,imageYPos,*(g_pIconManager->getSmallIcon(block->attr_ptr->attr_data.icon_id)));
#else //!COMPILE_NO_X_DRAW_CALLS
					if(curBack != KVI_TRANSPARENT)
					{
						XSetForeground(g_display,g_ircviewGC,KVI_OPTION_MIRCCOLOR((unsigned char)curBack).pixel());
						XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,
							curBottomCoord - m_iFontLineSpacing + m_iFontDescent,wdth,m_iFontLineSpacing);
					}
					QPixmap *pix = g_pIconManager->getSmallIcon(block->attr_ptr->attr_data.icon_id);
					if(pix->mask())
					{
						XSetClipMask(g_display,g_ircviewGC,pix->mask()->handle());
						XSetClipOrigin(g_display,g_ircviewGC,curLeftCoord + m_iIconSideSpacing,imageYPos);
					}
					//Draw the pixmap
					XCopyArea(g_display,pix->handle(),g_hIrcViewMemBuffer,g_ircviewGC,0,0,KVI_IRCVIEW_PIXMAP_SIZE,
						KVI_IRCVIEW_PIXMAP_SIZE,curLeftCoord + m_iIconSideSpacing,imageYPos);
					XSetClipMask(g_display,g_ircviewGC,None);
#endif
					//debug("SHifting by %d",block->block_width);
					curLeftCoord += block->block_width;
				} else {
#ifdef COMPILE_NO_X_DRAW_CALLS
					int wdth = block->block_width;
					if(wdth < 0)wdth = widgetWidth - (curLeftCoord + KVI_IRCVIEW_HORIZONTAL_BORDER);
	
					// FIXME: We could avoid this XSetForeground if the curFore was not changed....
					pa.setPen(KVI_OPTION_MIRCCOLOR((unsigned char)curFore));
	
					if(curBack != KVI_TRANSPARENT)
					{
						pa.fillRect(curLeftCoord,curBottomCoord - m_iFontLineSpacing + m_iFontDescent,wdth,m_iFontLineSpacing,KVI_OPTION_MIRCCOLOR((unsigned char)curBack));
					}
					pa.drawText(curLeftCoord,curBottomCoord,block->block_ptr,block->block_len);
					if(curBold)
					{
						//Draw doubled font (simulate bold)
						pa.drawText(curLeftCoord + 1,curBottomCoord,block->block_ptr,block->block_len);
					}
					if(curLink)
					{
						pa.setPen(KVI_OPTION_MIRCCOLOR(KVI_OPTION_MSGTYPE(KVI_OUT_LINK).fore()));
						pa.drawText(curLeftCoord - 1,curBottomCoord - 1,block->block_ptr,block->block_len);
					}
					if(curUnderline)
					{ 
						//Draw a line under the text block....
						pa.drawLine(curLeftCoord,curBottomCoord,curLeftCoord+wdth,curBottomCoord);
					}
					curLeftCoord += block->block_width;
	
#else //!COMPILE_NO_X_DRAW_CALLS

	#ifdef COMPILE_USE_AA_FONTS
					if(g_pIrcViewXftFont)
					{
						if(curBack != KVI_TRANSPARENT){
							int wdth = block->block_width;
							if(wdth == 0)
							{
								// Last block before a word wrap , or a zero characters attribute block ?
								if(i < (pCurTextLine->num_text_blocks - 1))
								{
									// There is another block...
									// Check if it is a wrap...
									if(pCurTextLine->text_blocks_ptr[i+1].attr_ptr == 0)wdth = widgetWidth-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER);
									// else simply a zero characters block
								} // else simply a zero characters block : it is the last one!
							}
							XSetForeground(g_display,g_ircviewGC,KVI_OPTION_MIRCCOLOR((unsigned char)curBack).pixel());
							XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,
								curBottomCoord - m_iFontLineSpacing + m_iFontDescent,wdth,m_iFontLineSpacing);
						}
						QColor * clr = &(KVI_OPTION_MIRCCOLOR((unsigned char)curFore));
						XftColor color;
						color.color.red = clr->red() | clr->red() << 8;
						color.color.green = clr->green() | clr->green() << 8;
						color.color.blue = clr->blue() | clr->blue() << 8;
						color.color.alpha = 0xffff;
						color.pixel = clr->pixel();
						XftDrawString8(g_pIrcViewXftDraw,&color,g_pIrcViewXftFont,curLeftCoord,
							curBottomCoord,(unsigned char *)(block->block_ptr),block->block_len);
						if(curBold)XftDrawString8(g_pIrcViewXftDraw,&color,g_pIrcViewXftFont,curLeftCoord + 1,
										curBottomCoord,(unsigned char *)(block->block_ptr),block->block_len);
						if(curLink)
						{
							QColor * clr = &(KVI_OPTION_MIRCCOLOR(KVI_OPTION_MSGTYPE(KVI_OUT_LINK).fore()));
							XftColor color;
							color.color.red = clr->red() | clr->red() << 8;
							color.color.green = clr->green() | clr->green() << 8;
							color.color.blue = clr->blue() | clr->blue() << 8;
							color.color.alpha = 0xffff;
							color.pixel = clr->pixel();
							XftDrawString8(g_pIrcViewXftDraw,&color,g_pIrcViewXftFont,curLeftCoord - 1,
								curBottomCoord - 1,(unsigned char *)(block->block_ptr),block->block_len);
						}
	
						if(curUnderline)
						{ 
							//Draw a line under the text block....
							int wdth = block->block_width;
	
							if(wdth < 0)wdth = widgetWidth - (curLeftCoord + KVI_IRCVIEW_HORIZONTAL_BORDER);
							XSetForeground(g_display,g_ircviewGC,KVI_OPTION_MIRCCOLOR((unsigned char)curFore).pixel());
							XSetLineAttributes(g_display,g_ircviewGC,m_iFontLineWidth,LineSolid,CapButt,JoinMiter);
							XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,curBottomCoord,
								curLeftCoord+wdth,curBottomCoord);
						}
						curLeftCoord += block->block_width;
					} else {
	#endif
						// FIXME: We could avoid this XSetForeground if the curFore was not changed....	
						XSetForeground(g_display,g_ircviewGC,KVI_OPTION_MIRCCOLOR((unsigned char)curFore).pixel());	
		
						if(curBack != KVI_TRANSPARENT)
						{
							XSetBackground(g_display,g_ircviewGC,KVI_OPTION_MIRCCOLOR((unsigned char)curBack).pixel());
							XDrawImageString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,
								curBottomCoord,block->block_ptr,block->block_len);
						} else {
							XDrawString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,
								curBottomCoord,block->block_ptr,block->block_len);
						}
						if(curBold)
						{
							//Draw doubled font (simulate bold)
							XDrawString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord+1,
								curBottomCoord,block->block_ptr,block->block_len);
						}
						if(curLink)
						{
							XSetForeground(g_display,g_ircviewGC,KVI_OPTION_MIRCCOLOR(KVI_OPTION_MSGTYPE(KVI_OUT_LINK).fore()).pixel());
							//XSetFunction(g_display,g_ircviewGC,GXxor);
							XDrawString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord-1,
								curBottomCoord-1,block->block_ptr,block->block_len);
							//XSetFunction(g_display,g_ircviewGC,GXcopy);
						}
						if(curUnderline)
						{ 
							//Draw a line under the text block....
							int wdth = block->block_width;
							if(wdth < 0)wdth = widgetWidth - (curLeftCoord + KVI_IRCVIEW_HORIZONTAL_BORDER);
							XSetLineAttributes(g_display,g_ircviewGC,m_iFontLineWidth,LineSolid,CapButt,JoinMiter);
							XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,curBottomCoord,
								curLeftCoord+wdth,curBottomCoord);
						}
						curLeftCoord += block->block_width;
	#ifdef COMPILE_USE_AA_FONTS
					}
	#endif

#endif //!COMPILE_NO_X_DRAW_CALLS
				}
			}
		}
		if(pCurTextLine == m_pCursorLine)
		{
			// paint the cursor line
			int iH = lineWrapsHeight + m_iFontLineSpacing;
#ifdef COMPILE_NO_X_DRAW_CALLS
			pa.setRasterOp(NotROP);
			pa.fillRect(0,curBottomCoord - iH,widgetWidth,iH + (m_iFontDescent << 1),Qt::black);
//			debug("Qt Painting it at %d->%d",curBottomCoord - iH + m_iFontDescent,curBottomCoord + m_iFontDescent);
			pa.setRasterOp(CopyROP);
#else
			XSetFunction(g_display,g_ircviewGC,GXinvert);
			XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,0,curBottomCoord - iH,widgetWidth,iH + (m_iFontDescent << 1));
//			debug("Painting it at %d->%d",curBottomCoord - iH + m_iFontDescent,curBottomCoord + m_iFontDescent);
			XSetFunction(g_display,g_ircviewGC,GXcopy);
#endif
		}

		if(m_bMouseIsDown)
		{
			if(m_iLastSelectionLineLen > 0)
			{
				if(m_szLastSelection.hasData())m_szLastSelection.prepend("\n");
				m_szLastSelection.prepend(m_szLastSelectionLine.ptr());
				m_szLastSelectionLine = "";
				m_iLastSelectionLineLen = 0;
			}
		}

		curBottomCoord -= (lineWrapsHeight + m_iFontLineSpacing);
		pCurTextLine    = pCurTextLine->prev_line;
	}

#ifdef COMPILE_NO_X_DRAW_CALLS

	//Need to draw the sunken rect around the view now...
	pa.setPen(colorGroup().dark());
	pa.drawLine(0,0,widgetWidth,0);
	pa.drawLine(0,0,0,widgetHeight);
	pa.setPen(colorGroup().light());
	widgetWidth--;
	pa.drawLine(1,widgetHeight-1,widgetWidth,widgetHeight-1);
	pa.drawLine(widgetWidth,1,widgetWidth,widgetHeight);

	// COPY TO THE DISPLAY
	bitBlt(this,rectLeft,rectTop,g_pIrcViewMemBuffer,rectLeft,rectTop,rectWidth,rectHeight,Qt::CopyROP);

#else //!COMPILE_NO_X_DRAW_CALLS

	//Need to draw the sunken rect around the view now...
	XSetLineAttributes(g_display,g_ircviewGC,1,LineSolid,CapButt,JoinMiter); //need this for line size
	XSetForeground(g_display,g_ircviewGC,colorGroup().dark().pixel());
	XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,0,0,widgetWidth,0);
	XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,0,0,0,widgetHeight);
	XSetForeground(g_display,g_ircviewGC,colorGroup().light().pixel());
	widgetWidth--;
	XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,1,widgetHeight-1,widgetWidth,widgetHeight-1);
	XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,widgetWidth,1,widgetWidth,widgetHeight);

	// COPY TO THE DISPLAY
	// EVIL XCopyArea... it takes soooo long.
	XCopyArea(g_display,g_hIrcViewMemBuffer,this->handle(),g_ircviewGC,rectLeft,rectTop,rectWidth,rectHeight,rectLeft,rectTop);

#endif //!COMPILE_NO_X_DRAW_CALLS
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// The IrcView : calculate line wraps
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void KviIrcView::calculateLineWraps(KviIrcViewTextLine *ptr,int maxWidth)
{
	//
	// Another monster
	//

	//debug("CALC LINE WRAPS\n===================================");

	if(ptr->num_text_blocks != 0)kvi_free(ptr->text_blocks_ptr); // free any previous wrap blocks
	ptr->text_blocks_ptr = (KviIrcViewTextBlock *)kvi_malloc(sizeof(KviIrcViewTextBlock)); // alloc one block
	ptr->max_line_width  = maxWidth; // calculus for this width
	ptr->num_text_blocks = 0;        // it will be ++
	ptr->line_wraps      = 0;        // no line wraps yet

	int curAttrBlock     = 0;        // Current attribute block
	int curLineWidth     = 0;

	// init the first block
	ptr->text_blocks_ptr->block_ptr   = ptr->data_ptr;
	ptr->text_blocks_ptr->block_len   = 0;
	ptr->text_blocks_ptr->block_width = 0;
	ptr->text_blocks_ptr->attr_ptr    = &(ptr->attr_ptr[0]);

	int maxBlockLen = ptr->attr_ptr->block_len; // ptr->attr_ptr[0].block_len


	for(;;)
	{
		//debug("BLOCK %d/%d",ptr->num_text_blocks,curAttrBlock);
		//Calculate the block_width
		register char *p=ptr->text_blocks_ptr[ptr->num_text_blocks].block_ptr;
		//debug("Assigned ptr");
		int curBlockLen   = 0;
		int curBlockWidth = 0;

		//debug("Checking block type");
		if(ptr->attr_ptr[curAttrBlock].attribute == KVI_TEXT_ICON)
		{
			curBlockWidth = m_iIconWidth;
			//debug("Icon block of %d pix",curBlockWidth);
		} else {
			//debug("Not icon block %d (maxBlockLen = %d)",ptr->attr_ptr[curAttrBlock].attribute,maxBlockLen);
			while(curBlockLen < maxBlockLen)
			{
				//debug("Running");
				curBlockWidth += m_iFontCharacterWidth[((unsigned char)*p)];
				curBlockLen++;
				p++;
			}
			//debug("Finished");
		}
		//Check the length
		curLineWidth += curBlockWidth;

		if(curLineWidth < maxWidth)
		{
			//debug("Block of %d pix and len %d with type %d",ptr->text_blocks_ptr[ptr->num_text_blocks].block_width,ptr->text_blocks_ptr[ptr->num_text_blocks].block_len,ptr->attr_ptr[curAttrBlock].attribute);
			//Ok....proceed to next block
			ptr->text_blocks_ptr[ptr->num_text_blocks].block_len   = curBlockLen;
			ptr->text_blocks_ptr[ptr->num_text_blocks].block_width = curBlockWidth;
			curAttrBlock++;
			ptr->num_text_blocks++;
			//Process the next block of data in the next loop or return if have no more blocks
			if(curAttrBlock < ptr->attr_len)
			{
				ptr->text_blocks_ptr = (KviIrcViewTextBlock *)kvi_realloc(ptr->text_blocks_ptr,(ptr->num_text_blocks + 1) * sizeof(KviIrcViewTextBlock));
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_ptr = &(ptr->data_ptr[ptr->attr_ptr[curAttrBlock].block_idx]);
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_len = 0;
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_width = 0;
				ptr->text_blocks_ptr[ptr->num_text_blocks].attr_ptr  = &(ptr->attr_ptr[curAttrBlock]);
				maxBlockLen = ptr->text_blocks_ptr[ptr->num_text_blocks].attr_ptr->block_len;
			} else return;
		} else {
			//Need word wrap
			//First go back to an admissible width
			while((curLineWidth >= maxWidth) && curBlockLen)
			{
				p--;
				curBlockLen--;
				curLineWidth-=m_iFontCharacterWidth[((unsigned char)*p)];
			}
			//Now look for a space
			while((*p != ' ') && curBlockLen)
			{ 
				p--;
				curBlockLen--;
				curLineWidth-=m_iFontCharacterWidth[((unsigned char)*p)];
			}

			//If we ran up to the beginning of the block....
			if(curBlockLen == 0)
			{
				if(ptr->attr_ptr[curAttrBlock].attribute == KVI_TEXT_ICON)
				{
					// This is an icon block: needs to be wrapped differently:
					// The wrap block goes BEFORE the icon itself
					ptr->text_blocks_ptr[ptr->num_text_blocks].attr_ptr    = 0;
					ptr->text_blocks_ptr[ptr->num_text_blocks].block_width = 0;
					ptr->num_text_blocks++;
					ptr->text_blocks_ptr = (KviIrcViewTextBlock *)kvi_realloc(ptr->text_blocks_ptr,(ptr->num_text_blocks + 1) * sizeof(KviIrcViewTextBlock));
					ptr->text_blocks_ptr[ptr->num_text_blocks].block_ptr   = p;
					ptr->text_blocks_ptr[ptr->num_text_blocks].block_len   = 0;
					ptr->text_blocks_ptr[ptr->num_text_blocks].block_width = 0;
					ptr->text_blocks_ptr[ptr->num_text_blocks].attr_ptr    = &(ptr->attr_ptr[curAttrBlock]);
					goto wrap_line;
				}
				//Don't like it....forced wrap here...
				//Go ahead up to the biggest possible string
				if(maxBlockLen > 0)
				{
					do
					{
						curBlockLen++;
						p++;
						curLineWidth+=m_iFontCharacterWidth[((unsigned char)*p)];
					} while((curLineWidth < maxWidth) && (curBlockLen < maxBlockLen));
					//Now overrunned , go back 1 char
					p--;
					curBlockLen--;
				}
				//K...wrap
			} else {
				//found a space...
				//include it in the first block
				p++;
				curBlockLen++;
			}

			ptr->text_blocks_ptr[ptr->num_text_blocks].block_len = curBlockLen;
			ptr->text_blocks_ptr[ptr->num_text_blocks].block_width = -1; // word wrap --> negative block_width
			maxBlockLen-=curBlockLen;
			ptr->num_text_blocks++;
			ptr->text_blocks_ptr = (KviIrcViewTextBlock *)kvi_realloc(ptr->text_blocks_ptr,(ptr->num_text_blocks + 1) * sizeof(KviIrcViewTextBlock));
			ptr->text_blocks_ptr[ptr->num_text_blocks].block_ptr   = p;
			ptr->text_blocks_ptr[ptr->num_text_blocks].block_len   = 0;
			ptr->text_blocks_ptr[ptr->num_text_blocks].block_width = 0;
			ptr->text_blocks_ptr[ptr->num_text_blocks].attr_ptr    = 0;
wrap_line:
			curLineWidth = 0;
			ptr->line_wraps++;
			if(ptr->line_wraps == 1)
			{
				if(KVI_OPTION_BOOL(KviOption_boolIrcViewWrapMargin))maxWidth-=m_iWrapMargin;
			}
		}
	}

	ptr->num_text_blocks++;
}

//================= calculateSelectionBounds ==================//

void KviIrcView::calculateSelectionBounds()
{
	if(m_mousePressPos.y() < m_mouseCurrentPos.y())
	{
		m_iSelectionTop     = m_mousePressPos.y();
		m_iSelectionBottom  = m_mouseCurrentPos.y();
		m_iSelectionBegin   = m_mousePressPos.x();
		m_iSelectionEnd     = m_mouseCurrentPos.x();
	} else {
		m_iSelectionTop     = m_mouseCurrentPos.y();
		m_iSelectionBottom  = m_mousePressPos.y();
		m_iSelectionBegin   = m_mouseCurrentPos.x();
		m_iSelectionEnd     = m_mousePressPos.x();
	}

	if(m_iSelectionBegin < m_iSelectionEnd)
	{
		m_iSelectionLeft    = m_iSelectionBegin;
		m_iSelectionRight   = m_iSelectionEnd;
	} else {
		m_iSelectionLeft    = m_iSelectionEnd;
		m_iSelectionRight   = m_iSelectionBegin;
	}
}

//============== checkForEscape =================//
/*
void KviIrcView::checkForEscape(KviIrcViewTextLine * line,int left,int bottom,int bufIndex)
{
	__range_valid(bufIndex >= 0);
	int top = bottom-m_iFontLineSpacing;
	int right  = (line->text_blocks_ptr[bufIndex].block_width ? \
					left+line->text_blocks_ptr[bufIndex].block_width : width()-KVI_IRCVIEW_SCROLLBAR_AND_HORIZONTAL_BORDER_WIDTH);
	if((left < m_mousePressPos.x())&&(right > m_mousePressPos.x())&&
		(bottom > m_mousePressPos.y())&&(top < m_mousePressPos.y())){
		//Yeah man! This block clicked...check if it is a part of an url
		if(line->text_blocks_ptr[bufIndex].attr_ptr==0){
			//Could be a word wrapped url...go back until we find a block with attributes
			while((line->text_blocks_ptr[bufIndex].attr_ptr==0)&&(bufIndex > 0))bufIndex--;
		}
		if(bufIndex == 0)return; //Can't be...the first is always a color block
		if(line->text_blocks_ptr[bufIndex].attr_ptr){
			if(line->text_blocks_ptr[bufIndex].attr_ptr->attribute == KVI_TEXT_ESCAPE)
			{
				m_szLastEscape = KviStr(line->text_blocks_ptr[bufIndex].block_ptr,line->text_blocks_ptr[bufIndex].block_len);
				m_szLastEscapeCmd = line->text_blocks_ptr[bufIndex].attr_ptr->escape_cmd;
			} else return;
			//Continue while we do not find a non word wrap block block
			for(;;){
				bufIndex++;
				if(bufIndex == line->num_text_blocks)return;
				if(line->text_blocks_ptr[bufIndex].attr_ptr)return; //finished : not a word wrap
				KviStr szBlockData(line->text_blocks_ptr[bufIndex].block_ptr,line->text_blocks_ptr[bufIndex].block_len);
				m_szLastEscape.append(szBlockData.ptr());
			}
		}
	}
}
*/
//=============== checkSelectionBlock ===============//

bool KviIrcView::checkSelectionBlock(KviIrcViewTextLine * line,int left,int bottom,int bufIndex)
{
	//
	// Yahoo!!!!
	//
	register char *p=line->text_blocks_ptr[bufIndex].block_ptr;
	int top = bottom-m_iFontLineSpacing;
	int right  = ((line->text_blocks_ptr[bufIndex].block_width >= 0) ? \
					left+line->text_blocks_ptr[bufIndex].block_width : width()-(KVI_IRCVIEW_HORIZONTAL_BORDER + m_pScrollBar->width()));
	if(bottom < m_iSelectionTop)return false; //The selection starts under this line
	if(top > m_iSelectionBottom)return false; //The selection ends over this line
	if((top >= m_iSelectionTop)&&(bottom < m_iSelectionBottom))
	{
		//Whole line selected
		if(line->text_blocks_ptr[bufIndex].attr_ptr && line->text_blocks_ptr[bufIndex].attr_ptr->attribute == KVI_TEXT_ICON)
			m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_ICON;
		else
			m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_TOTAL;
		return true;
	}
	if((top < m_iSelectionTop) && (bottom >= m_iSelectionBottom))
	{
		//Selection begins and ends in this line
		if(right < m_iSelectionLeft)return false;
		if(left  > m_iSelectionRight)return false;
		if(line->text_blocks_ptr[bufIndex].attr_ptr && line->text_blocks_ptr[bufIndex].attr_ptr->attribute == KVI_TEXT_ICON)
		{
			m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_ICON;
			return true;
		}
		if((right <= m_iSelectionRight) && (left > m_iSelectionLeft))
		{
			//Whole line selected
			m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_TOTAL;
			return true;
		}
		if((right > m_iSelectionRight) && (left <= m_iSelectionLeft))
		{
			//Selection ends and begins in THIS BLOCK!
			m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_CENTRAL;
			m_TextBlockSelectionInfo.part_1_length = 0;
			m_TextBlockSelectionInfo.part_1_width  = 0;
			while((left <= m_iSelectionLeft) && (m_TextBlockSelectionInfo.part_1_length < line->text_blocks_ptr[bufIndex].block_len)){
				left += m_iFontCharacterWidth[(unsigned char) *p];
				m_TextBlockSelectionInfo.part_1_width+=m_iFontCharacterWidth[(unsigned char) *p];
				p++;
				m_TextBlockSelectionInfo.part_1_length++;
			}
			//Need to include the first character
			if(m_TextBlockSelectionInfo.part_1_length > 0)
			{
				m_TextBlockSelectionInfo.part_1_length--;
				p--;
				left -= m_iFontCharacterWidth[(unsigned char) *p];
				m_TextBlockSelectionInfo.part_1_width-=m_iFontCharacterWidth[(unsigned char) *p];
			}
			int maxLenNow = line->text_blocks_ptr[bufIndex].block_len-m_TextBlockSelectionInfo.part_1_length;
			int maxWidthNow = line->text_blocks_ptr[bufIndex].block_width-m_TextBlockSelectionInfo.part_1_width;
			m_TextBlockSelectionInfo.part_2_length = 0;
			m_TextBlockSelectionInfo.part_2_width  = 0;
			while((left < m_iSelectionRight) && (m_TextBlockSelectionInfo.part_2_length < maxLenNow))
			{
				left += m_iFontCharacterWidth[(unsigned char) *p];
				m_TextBlockSelectionInfo.part_2_width+=m_iFontCharacterWidth[(unsigned char) *p];
				p++;
				m_TextBlockSelectionInfo.part_2_length++;
			}		
			m_TextBlockSelectionInfo.part_3_length = maxLenNow-m_TextBlockSelectionInfo.part_2_length;
			m_TextBlockSelectionInfo.part_3_width  = maxWidthNow-m_TextBlockSelectionInfo.part_2_width;
			return true;
		}
		if(right > m_iSelectionRight)
		{
			//Selection ends in THIS BLOCK!
			m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_LEFT;
			m_TextBlockSelectionInfo.part_1_length = 0;
			m_TextBlockSelectionInfo.part_1_width  = 0;
			while((left < m_iSelectionRight) && (m_TextBlockSelectionInfo.part_1_length < line->text_blocks_ptr[bufIndex].block_len))
			{
				left += m_iFontCharacterWidth[(unsigned char) *p];
				m_TextBlockSelectionInfo.part_1_width+=m_iFontCharacterWidth[(unsigned char) *p];
				p++;
				m_TextBlockSelectionInfo.part_1_length++;
			}
			m_TextBlockSelectionInfo.part_2_length = line->text_blocks_ptr[bufIndex].block_len-m_TextBlockSelectionInfo.part_1_length;
			m_TextBlockSelectionInfo.part_2_width  = line->text_blocks_ptr[bufIndex].block_width-m_TextBlockSelectionInfo.part_1_width;
			//debug("%d",m_TextBlockSelectionInfo.part_2_width);
			return true;
		}
		//Selection begins in THIS BLOCK!
		m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_RIGHT;
		m_TextBlockSelectionInfo.part_1_length = 0;
		m_TextBlockSelectionInfo.part_1_width  = 0;
		while((left <= m_iSelectionLeft) && (m_TextBlockSelectionInfo.part_1_length < line->text_blocks_ptr[bufIndex].block_len))
		{
			left += m_iFontCharacterWidth[(unsigned char) *p];
			m_TextBlockSelectionInfo.part_1_width+=m_iFontCharacterWidth[(unsigned char) *p];
			p++;
			m_TextBlockSelectionInfo.part_1_length++;
		}
		//Need to include the first character
		if(m_TextBlockSelectionInfo.part_1_length > 0)
		{
			m_TextBlockSelectionInfo.part_1_length--;
			p--;
			left -= m_iFontCharacterWidth[(unsigned char) *p];
			m_TextBlockSelectionInfo.part_1_width-=m_iFontCharacterWidth[(unsigned char) *p];
		}
		m_TextBlockSelectionInfo.part_2_length = line->text_blocks_ptr[bufIndex].block_len-m_TextBlockSelectionInfo.part_1_length;
		m_TextBlockSelectionInfo.part_2_width  = line->text_blocks_ptr[bufIndex].block_width-m_TextBlockSelectionInfo.part_1_width;
		return true;
	}

	if(top < m_iSelectionTop)
	{
		//Selection starts in this line
		if(right < m_iSelectionBegin)return false;
		if(line->text_blocks_ptr[bufIndex].attr_ptr && line->text_blocks_ptr[bufIndex].attr_ptr->attribute == KVI_TEXT_ICON)
		{
			m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_ICON;
			return true;
		}
		if(left > m_iSelectionBegin)
		{
			//Whole block selected
			m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_TOTAL;
			return true;
		}
		//Selection begins in THIS BLOCK!
		m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_RIGHT;
		m_TextBlockSelectionInfo.part_1_length = 0;
		m_TextBlockSelectionInfo.part_1_width  = 0;
		while((left <= m_iSelectionBegin) && (m_TextBlockSelectionInfo.part_1_length < line->text_blocks_ptr[bufIndex].block_len))
		{
			left += m_iFontCharacterWidth[(unsigned char) *p];
			m_TextBlockSelectionInfo.part_1_width+=m_iFontCharacterWidth[(unsigned char) *p];
			p++;
			m_TextBlockSelectionInfo.part_1_length++;
		}
		//Need to include the first character
		if(m_TextBlockSelectionInfo.part_1_length > 0)
		{
			m_TextBlockSelectionInfo.part_1_length--;
			p--;
			left -= m_iFontCharacterWidth[(unsigned char) *p];
			m_TextBlockSelectionInfo.part_1_width-=m_iFontCharacterWidth[(unsigned char) *p];
		}
		m_TextBlockSelectionInfo.part_2_length = line->text_blocks_ptr[bufIndex].block_len-m_TextBlockSelectionInfo.part_1_length;
		m_TextBlockSelectionInfo.part_2_width  = line->text_blocks_ptr[bufIndex].block_width-m_TextBlockSelectionInfo.part_1_width;
		return true;
	}
	//Selection ends in this line
	if(left  > m_iSelectionEnd)return false;
	if(line->text_blocks_ptr[bufIndex].attr_ptr && line->text_blocks_ptr[bufIndex].attr_ptr->attribute == KVI_TEXT_ICON)
	{
		m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_ICON;
		return true;
	}
	if(right < m_iSelectionEnd)
	{
		//Whole block selected
		m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_TOTAL;
		return true;
	}
	//Selection ends in THIS BLOCK!
	m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_LEFT;
	m_TextBlockSelectionInfo.part_1_length = 0;
	m_TextBlockSelectionInfo.part_1_width  = 0;
	while((left < m_iSelectionEnd) && (m_TextBlockSelectionInfo.part_1_length < line->text_blocks_ptr[bufIndex].block_len))
	{
		left += m_iFontCharacterWidth[(unsigned char) *p];
		m_TextBlockSelectionInfo.part_1_width+=m_iFontCharacterWidth[(unsigned char) *p];
		p++;
		m_TextBlockSelectionInfo.part_1_length++;
	}
	m_TextBlockSelectionInfo.part_2_length = line->text_blocks_ptr[bufIndex].block_len-m_TextBlockSelectionInfo.part_1_length;
	m_TextBlockSelectionInfo.part_2_width  = line->text_blocks_ptr[bufIndex].block_width-m_TextBlockSelectionInfo.part_1_width;
	return true;
}

//============ recalcFontVariables ==============//

void KviIrcView::recalcFontVariables(const QFont &fnt)
{
// FIXME: #warning "OPTIMIZE THIS: GLOBAL VARIABLES"
	QFontMetrics fm(fnt);
	m_iFontLineSpacing = fm.lineSpacing();
	if(m_iFontLineSpacing < KVI_IRCVIEW_PIXMAP_SIZE)m_iFontLineSpacing = KVI_IRCVIEW_PIXMAP_SIZE;
	m_iFontDescent     =fm.descent();
	m_iFontLineWidth   =fm.lineWidth();
	if(m_iFontLineWidth==0)m_iFontLineWidth=1;
	m_iWrapMargin = fm.width("wwww");
	for(int i=0;i<256;i++)m_iFontCharacterWidth[i]=fm.width((char)i);
	m_iMinimumPaintWidth = (m_iFontCharacterWidth['w'] << 1)+m_iWrapMargin;
	m_iRelativePixmapY = (m_iFontLineSpacing + KVI_IRCVIEW_PIXMAP_SIZE) >> 1;
	m_iIconWidth = fm.width("w");
	QFontInfo fi(fnt);
	if(fi.fixedPitch() && (m_iIconWidth > 0))
	{
		while(m_iIconWidth < 18)m_iIconWidth += m_iIconWidth;
		m_iIconSideSpacing = (m_iIconWidth - 16) >> 1;
	} else {
		m_iIconWidth = 18;
		m_iIconSideSpacing = 1;
	}
}

//================ resizeEvent ===============//

void KviIrcView::resizeMemBuffer()
{
	// check if we can make the mem buffer a bit smaller (save some memory)
	int maxw = 16;
	int maxh = 16;

	for(KviIrcView *i=g_pIrcViewWidgetList->first();i;i=g_pIrcViewWidgetList->next())
	{
		if((i->width() - i->m_pScrollBar->width()) > maxw)maxw = i->width() - i->m_pScrollBar->width();
		if(i->height() > maxh)maxh = i->height();
	}

//	debug("maxw = %d,maxh = %d",maxw,maxh);

	if((maxw != g_pIrcViewMemBuffer->width())||(maxh != g_pIrcViewMemBuffer->height()))
	{
		//debug("[MEMBUF]: Resizing to %d,%d",maxw,maxh);
		g_pIrcViewMemBuffer->resize(maxw,maxh);
#ifndef COMPILE_NO_X_DRAW_CALLS
		g_hIrcViewMemBuffer = g_pIrcViewMemBuffer->handle(); // Qt may change it while resizing
#endif //!COMPILE_NO_X_DRAW_CALLS
	}

	// Ok....mem buffer is big enough for all the irc views alive
}

void KviIrcView::resizeEvent(QResizeEvent *)
{
//	debug("[RESIZE EVENT]: %d,%d",width(),height());
	int iScr = m_pScrollBar->sizeHint().width();
	int iLeft = width()-iScr;
	m_pToolWidgetButton->setGeometry(iLeft,0,iScr,iScr);
	m_pScrollBar->setGeometry(iLeft,iScr,iScr,height() - iScr);
	resizeMemBuffer();

	if(m_pToolWidget)
	{
		if( ((m_pToolWidget->x() + m_pToolWidget->width()) > (iLeft - 1)) ||
			((m_pToolWidget->y() + m_pToolWidget->height()) > (height() - 1)))
		{
			m_pToolWidget->move(10,10);
		}
	}
}

QSize KviIrcView::sizeHint() const
{
	QSize ret(KVI_IRCVIEW_SIZEHINT_WIDTH,KVI_IRCVIEW_SIZEHINT_HEIGHT);
	return ret;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// The IrcView : tool widget
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void KviIrcView::toggleToolWidget()
{
	if(m_pToolWidget)
	{
		delete m_pToolWidget;
		m_pToolWidget = 0;
		m_pCursorLine = 0;
		paintEvent(0);
	} else {
		m_pToolWidget = new KviIrcViewToolWidget(this);
		int w = m_pToolWidget->sizeHint().width();
		m_pToolWidget->move(width() - (w + 40),10);
		m_pToolWidget->show();
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// The IrcView : find
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


void KviIrcView::setCursorLine(KviIrcViewTextLine * l)
{
	m_pCursorLine = l;
	if(m_pCursorLine == m_pCurLine)
	{
		paintEvent(0); // repaint everything so the line is shown
		return;
	}
	int sc = m_pScrollBar->value();
	l = m_pCurLine;
	if(m_pCursorLine->index > m_pCurLine->index)
	{
		// The cursor line is below the current line
		while(l && (l != m_pCursorLine))
		{
			l = l->next_line;
			sc++;
		}
		if(!l)return;
		if(sc != m_pScrollBar->value())
		{
			m_pCurLine = m_pCursorLine;
			m_iLastScrollBarValue = sc;
			m_pScrollBar->setValue(sc);
		} else paintEvent(0);
	} else {
		// The cursor line is over the current line
		// Here we're in trouble :D
		int curBottomCoord = height() - KVI_IRCVIEW_VERTICAL_BORDER;
		int maxLineWidth   = width();
		if(m_bShowImages)maxLineWidth -= KVI_IRCVIEW_PIXMAP_SEPARATOR_AND_DOUBLEBORDER_WIDTH;
		//Make sure that we have enough space to paint something...
		if(maxLineWidth < m_iMinimumPaintWidth)return; // ugh
		//And loop thru lines until we not run over the upper bound of the view
		KviIrcViewTextLine * curLine = m_pCurLine;
		while(l)
		{
			if(maxLineWidth != l->max_line_width)calculateLineWraps(l,maxLineWidth);
			curBottomCoord -= (l->line_wraps + 1) * m_iFontLineSpacing;
//			debug("Now is %d",curBottomCoord);
			while(curLine && (curBottomCoord < KVI_IRCVIEW_VERTICAL_BORDER))
			{
				if(curLine->max_line_width != maxLineWidth)calculateLineWraps(curLine,maxLineWidth);
				curBottomCoord += ((curLine->line_wraps + 1) * m_iFontLineSpacing) + m_iFontDescent;
//				debug("Stepping back :; %d",curBottomCoord);
				curLine = curLine->prev_line;
				sc--;
			}
			if(l == m_pCursorLine)break;
			curBottomCoord -= m_iFontDescent;
			l = l->prev_line;
		}
		if(!curLine)return;
		if(sc != m_pScrollBar->value())
		{
			m_pCurLine = curLine;
			m_iLastScrollBarValue = sc;
			m_pScrollBar->setValue(sc);
		} else paintEvent(0);
	}
}

void KviIrcView::findNext(const char * text,bool bCaseS,bool bRegExp,bool bExtended)
{
	KviIrcViewTextLine * l = m_pCursorLine;
	if(!l)l = m_pCurLine;
	if(l)
	{
		l = l->next_line;
		if(!l)l = m_pFirstLine;
		KviIrcViewTextLine * start = l;

		int idx = -1;

		do{
			if(m_pToolWidget)
			{
				if(!(m_pToolWidget->messageEnabled(l->msg_type)))goto do_next_line;
			}

			if(bRegExp)
			{
				QRegExp re(text,bCaseS,!bExtended);
#if QT_VERSION >= 300
				idx = re.search(l->data_ptr,0);
#else
				idx = re.find(l->data_ptr,0);
#endif
			} else {
				KviStr tmp = l->data_ptr;
				idx = tmp.findFirstIdx(text,bCaseS);
			}

			if(idx != -1)
			{
				setCursorLine(l);
				if(m_pToolWidget)
				{
					KviStr tmp(KviStr::Format,__tr("Pos %d"),idx);
					m_pToolWidget->setFindResult(tmp.ptr());
				}
				return;
			}

do_next_line:

			l = l->next_line;
			if(!l)l = m_pFirstLine;

		} while(l != start);
	}
	m_pCursorLine = 0;
	paintEvent(0);
	if(m_pToolWidget)m_pToolWidget->setFindResult(__tr("Not found"));
}


void KviIrcView::findPrev(const char * text,bool bCaseS,bool bRegExp,bool bExtended)
{
	KviIrcViewTextLine * l = m_pCursorLine;
	if(!l)l = m_pCurLine;
	if(l)
	{
		l = l->prev_line;
		if(!l)l = m_pLastLine;
		KviIrcViewTextLine * start = l;

		int idx = -1;

		do{

			if(m_pToolWidget)
			{
				if(!(m_pToolWidget->messageEnabled(l->msg_type)))goto do_prev_line;
			}

			if(bRegExp)
			{
				QRegExp re(text,bCaseS,!bExtended);
#if QT_VERSION >= 300
				idx = re.search(l->data_ptr,0);
#else
				idx = re.find(l->data_ptr,0);
#endif
			} else {
				KviStr tmp = l->data_ptr;
				idx = tmp.findFirstIdx(text,bCaseS);
			}

			if(idx != -1)
			{
				setCursorLine(l);
				if(m_pToolWidget)
				{
					KviStr tmp(KviStr::Format,__tr("Pos %d"),idx);
					m_pToolWidget->setFindResult(tmp.ptr());
				}
				return;
			}

do_prev_line:

			l = l->prev_line;
			if(!l)l = m_pLastLine;

		} while(l != start);
	}
	m_pCursorLine = 0;
	paintEvent(0);
	if(m_pToolWidget)m_pToolWidget->setFindResult(__tr("Not found"));
}

KviIrcViewTextLine * KviIrcView::getVisibleLineAt(int xPos,int yPos)
{
	KviIrcViewTextLine * l = m_pCurLine;
	int iTop = height() - KVI_IRCVIEW_VERTICAL_BORDER;

	while(iTop > yPos)
	{
		if(l)
		{
			iTop -= ((l->line_wraps + 1) * m_iFontLineSpacing) + m_iFontDescent;
			if(iTop <= yPos)return l;
			l = l->prev_line;
		} else return 0;
	}
	return 0;
}

KviIrcViewTextBlock * KviIrcView::getLinkUnderMouse(int xPos,int yPos,int *rectTop,int *rectHeight,KviStr * linkCmd,KviStr * linkText)
{
	KviIrcViewTextLine * l = m_pCurLine;
	int iTop = height() - KVI_IRCVIEW_VERTICAL_BORDER;

	while(iTop > yPos)
	{
		if(l)
		{
			iTop -= ((l->line_wraps + 1) * m_iFontLineSpacing) + m_iFontDescent;
			if(iTop <= yPos)
			{
				// got the right KviIrcViewTextLine
				int iLeft = KVI_IRCVIEW_HORIZONTAL_BORDER;
				if(m_bShowImages)iLeft += KVI_IRCVIEW_PIXMAP_AND_SEPARATOR;
				int firstRowTop = iTop;
				int i = 0;

				for(;;)
				{
					if(yPos <= iTop + m_iFontLineSpacing)
					{
						// this row!!!
						if(iTop != firstRowTop)if(KVI_OPTION_BOOL(KviOption_boolIrcViewWrapMargin))iLeft+=m_iWrapMargin;
						if(xPos < iLeft)return 0;
						for(;;)
						{
							if(i >= l->num_text_blocks)return 0;
							if(l->text_blocks_ptr[i].block_width > 0)
							{
								iLeft += l->text_blocks_ptr[i].block_width;
							} else {
								if(i < (l->num_text_blocks - 1))
								{
									// There is another block...
									// Check if it is a wrap...
									if(l->text_blocks_ptr[i+1].attr_ptr == 0)
									{
										iLeft = width();
									}
									// else simply a zero characters block
								}
							}
//							if(i < 0)
//							{
//								debug("HUH?");
//								return 0; // word wrap block : no link here!
//							}
							if(xPos < iLeft)
							{
								// Got it!
								// link ?
								bool bHadWordWraps = false;
								while(l->text_blocks_ptr[i].attr_ptr == 0)
								{
									// word wrap ?
									if(i >= 0)
									{
										i--;
										bHadWordWraps = true;
									} else return 0; // all word wraps ?!!!
								}
								if(l->text_blocks_ptr[i].attr_ptr->attribute == KVI_TEXT_ESCAPE)
								{
									if(rectTop)*rectTop = bHadWordWraps ? firstRowTop : iTop;
									if(rectHeight)*rectHeight = ((l->line_wraps + 1) * m_iFontLineSpacing) + m_iFontDescent;
									if(linkCmd)
									{
										*linkCmd = l->text_blocks_ptr[i].attr_ptr->escape_cmd;
										linkCmd->stripWhiteSpace();
									}
									if(linkText)
									{
										linkText->setStr(l->text_blocks_ptr[i].block_ptr,l->text_blocks_ptr[i].block_len);
										// grab the rest of the link visible string
										// Continue while we do not find a non word wrap block block
										for(int bufIndex = (i + 1);bufIndex < l->num_text_blocks;bufIndex++)
										{
											if(l->text_blocks_ptr[bufIndex].attr_ptr)break; //finished : not a word wrap
											else {
												KviStr szBlockData(l->text_blocks_ptr[bufIndex].block_ptr,l->text_blocks_ptr[bufIndex].block_len);
												linkText->append(szBlockData.ptr());
											}
										}
									}
									return &(l->text_blocks_ptr[i]);
								}
								if(l->text_blocks_ptr[i].attr_ptr->attribute == KVI_TEXT_ICON)
								{
									if(rectTop)*rectTop = bHadWordWraps ? firstRowTop : iTop;
									if(rectHeight)*rectHeight = ((l->line_wraps + 1) * m_iFontLineSpacing) + m_iFontDescent;
									if(linkCmd)
									{
										*linkCmd = "[!txt]";
										linkCmd->append(l->text_blocks_ptr[i].attr_ptr->escape_cmd);
										linkCmd->stripWhiteSpace();
									}
									if(linkText)
									{
										*linkText = "";
									}
									return &(l->text_blocks_ptr[i]);
								}
								return 0;
							}
							i++;
						}
					} else {
						// run until a word wrap block
						i++; //at least one block!
						while(i < l->num_text_blocks)
						{
							// still ok to run right
							if(l->text_blocks_ptr[i].attr_ptr == 0)
							{
//								i++;
								break;
							} else i++;
						}
						if(i >= l->num_text_blocks)return 0;
						iTop += m_iFontLineSpacing;
					}
				}
			} else l = l->prev_line;
		} else return 0;
	}
	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Mouse handling routines
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*
	@doc: escape_sequences
	@title:
		Escape sequences and clickable links
	@type:
		generic
	@doby:
		The KVIrc view widgets support clickable links.[br]
		The links can be realized by using special escape sequences in the text
		passed to the [cmd]echo[/cmd] command.[br]
		Also KVIrc uses some escape sequences in the text "echoed" internally.[br]
		The simplest way to explain it is to use an example:[br]
		[example]
			[cmd]echo[/cmd] This is a [fnc]$cr[/fnc]![!dbl][cmd]echo[/cmd] You have clicked it![fnc]$cr[/fnc]\clickable link$cr !
		[/example]
		The example above will show the following text line: "This is a clickable link".
		If you move the mouse over the words "clickable link", you will see the text "rising up".[br]
		Once you double click one of that words, the command "[cmd]echo[/cmd] You have clicked it!" will be executed.[br]
		The format looks complex ?... it is not...just read on.[br]

		<cr>!<link_type><cr><visible text><cr>
		<cr>!<escape_command><cr><visible text><cr>

		[big]Escape format[/big]
		The whole escape sequence format is the following:[br]
		[b]<cr>!<escape_command><cr><visible text><cr>[/b][br]
		<cr> is the carriage return character. You can obtain it by using the [fnc]]$cr[/fnc] function.[br]
		<visible text> is the text that will appear as "link" when you move the mouse over it.[br]
		<escape_command> is the description of the actions to be taken when the user interacts with the link.[br]
		<escape_command> has the two following syntactic forms:[br]
		[b]<escape_command> ::= <user_defined_commands>[/b][br]
		[b]<escape_command> ::= <builtin_link_description>[/b]

		[big]User defined links[/big][br]
		The user defined links allow you to perform arbitrary commands when the user interacts with the link.[br]
		The commands are specified in the <escape_command> part by using the following syntax:[br]
		<escape_command> ::= <user_defined_commands>[br]
		<user_defined_commands> ::= <command_rule> [<user_defined_commands>][br]
		<command_rule> ::= <action_tag><command>[br]
		<action_tag> ::= "[!" <action> "]"[br]
		<action> ::= "rbt" | "mbt" | "dbl" | "txt"[br]
		<command> ::= any kvirc command (see notes below)[br]
		
		[big]Builtin links[/big][br]
		The builtin links have builtin actions performed when the user interact with the link.[br]
		These links are used internally in KVIrc , but you can use them too.[br]
		The <escape_command> is a single letter this time: it defines the type of the link.[br]
		Currently KVIrc uses six types of builtin links : 'n' for nickname links, 'u' for url links,
		'c' for channel links, 'h' for hostname links, 'm' for mask links and 's' for server links.[br]
		Theoretically you can also use your own link types: just use any other letter or digit (you can't use ']' and <cr>),
		but probably you will prefer a completly user defined link in that case anyway.[br]
		Once the user interacts with the link , kvirc executes the predefined events:[br]
		On right click the event OnBuiltinLinkRightClicked is triggered: the first parameter is the link type,
		the second parameter is the <visible text> (as a single parameter!!!)[br]
		On middle click the event OnBuiltinLinkMiddleClicked is triggered: the parameters are similar to the previous one.[br]
		In the same way you have OnBuiltinLinkDoubleClicked.[br]

		[big]A shortcut[/big]
		You may have a look at the [fnc]$fmtlink[/fnc] function: it does automatically some of the job explained
		in this document.[br]
		
*/

// FIXME: #warning "Finish the doc above!! Maybe some examples ?!"


void KviIrcView::mouseDoubleClickEvent(QMouseEvent *e)
{
	KviStr linkCmd;
	KviStr linkText;

	getLinkUnderMouse(e->pos().x(),e->pos().y(),0,0,&linkCmd,&linkText);

	if(linkCmd.hasData())
	{
		switch(*(linkCmd.ptr()))
		{
			case 'n':
				{
					bool bTrigger = false;
					switch(m_pKviWindow->type())
					{
						case KVI_WINDOW_TYPE_CHANNEL:
							if(((KviChannel *)m_pKviWindow)->isOn(linkText.ptr()))
							{
								if(g_pEventManager->hasEventHandlers(KviEvent_OnChannelNickDefaultActionRequest))
									g_pUserParser->triggerEvent(KviEvent_OnChannelNickDefaultActionRequest,m_pKviWindow,
										new KviParameterList(new KviStr(linkText)));
							} else bTrigger = true;
						break;
						case KVI_WINDOW_TYPE_QUERY:
							if(((KviQuery *)m_pKviWindow)->haveTarget(linkText.ptr()))
							{
								if(g_pEventManager->hasEventHandlers(KviEvent_OnQueryNickDefaultActionRequest))
									g_pUserParser->triggerEvent(KviEvent_OnChannelNickDefaultActionRequest,m_pKviWindow,
										new KviParameterList(new KviStr(linkText)));
							} else bTrigger = true;
						break;
						default:
							bTrigger = true;
						break;
					}
					if(bTrigger)
					{
						if(console())
						{
							if(g_pEventManager->hasEventHandlers(KviEvent_OnNickLinkDefaultActionRequest))
								g_pUserParser->triggerEvent(KviEvent_OnNickLinkDefaultActionRequest,m_pKviWindow,
									new KviParameterList(new KviStr(linkText.ptr())));
						} else emit rightClicked();
					}
				}
			break;
			case 'm':
				if((linkCmd.len() > 2) && (m_pKviWindow->type() == KVI_WINDOW_TYPE_CHANNEL))
				{
					if(((KviChannel *)m_pKviWindow)->isMeOp())
					{
						char plmn = *(linkCmd.ptr() + 1);
						if((plmn == '+') || (plmn == '-'))
						{
							KviStr cmd;
							char flag = *(linkCmd.ptr() + 2);
							switch(flag)
							{
								case 'o':
								case 'v':
									// We can do nothing here...
								break;
	
								case 'b':
								case 'I':
								case 'e':
								case 'k':
									cmd.sprintf("mode %s %c%c %s",m_pKviWindow->name(),plmn,flag,linkText.ptr());
								break;
								default:
									cmd.sprintf("mode %s %c%c",m_pKviWindow->name(),plmn,flag);
								break;
							}
							if(cmd.hasData())g_pUserParser->parseCommandBuffer(cmd.ptr(),m_pKviWindow);
						}
					}
				}
			break;
			case 'h':
				{
					m_pKviWindow->output(KVI_OUT_HOSTLOOKUP,__tr("Looking up host %s..."),linkText.ptr());
					KviStr cmd(KviStr::Format,"host -a %s",linkText.ptr());
					g_pUserParser->parseCommandBuffer(cmd.ptr(),m_pKviWindow);
				}
			break;
			case 'u':
				{
					KviStr cmd(KviStr::Format,"openurl %s",linkText.ptr());
					g_pUserParser->parseCommandBuffer(cmd.ptr(),m_pKviWindow);
				}
			break;
			case 'c':
				{
					if(console())
					{
						if(KviChannel * c = console()->findChannel(linkText.ptr()))
						{
// FIXME: #warning "Is this ok ?"
							c->raise();
							c->setFocus();
						} else {
							KviStr cmd(KviStr::Format,"join %s",linkText.ptr());
							g_pUserParser->parseCommandBuffer(cmd.ptr(),m_pKviWindow);
						}
					}
				}
			break;
			case 's':
// FIXME: #warning "Default server action ????"
				{
					KviStr cmd(KviStr::Format,"motd %s",linkText.ptr());
					g_pUserParser->parseCommandBuffer(cmd.ptr(),m_pKviWindow);
				}
			break;
			default:
			{
				KviStr tmp;
				getLinkEscapeCommand(tmp,linkCmd.ptr(),"[!dbl]",6);
				if(tmp.hasData())
				{
					KviParameterList * l = new KviParameterList(linkText.ptr());
					g_pUserParser->parseCommandBuffer(tmp.ptr(),m_pKviWindow,l);
				} else {
					TRIGGER_EVENT(KviEvent_OnTextViewDoubleClicked,m_pKviWindow);
				}
			}
			break;
		}
	} else {
		TRIGGER_EVENT(KviEvent_OnTextViewDoubleClicked,m_pKviWindow);
	}
}

void KviIrcView::mousePressEvent(QMouseEvent *e)
{
	abortTip();

	if(e->button() & LeftButton)
	{
		// This is the beginning of a selection...
		// We just set the mouse to be "down" and
		// await mouseMove events...

		if(m_pToolWidget)
		{
			m_pCursorLine = getVisibleLineAt(e->pos().x(),e->pos().y());
			paintEvent(0);
		}

		m_mousePressPos   = e->pos();
		m_mouseCurrentPos = e->pos();

		m_bMouseIsDown=true;
	} else {

		KviStr linkCmd;
		KviStr linkText;

		getLinkUnderMouse(e->pos().x(),e->pos().y(),0,0,&linkCmd,&linkText);

		// extract the escape_cmd of the link under the mouse....

		if((e->button() & RightButton) && (!(e->state() & ControlButton)))
		{
			if(linkCmd.hasData())
			{
				switch(*(linkCmd.ptr()))
				{
					case 'n':
						{
							bool bTrigger = false;
							switch(m_pKviWindow->type())
							{
								case KVI_WINDOW_TYPE_CHANNEL:
									if(((KviChannel *)m_pKviWindow)->isOn(linkText.ptr()))
									{
										if(g_pEventManager->hasEventHandlers(KviEvent_OnChannelNickPopupRequest))
											g_pUserParser->triggerEvent(KviEvent_OnChannelNickPopupRequest,m_pKviWindow,
												new KviParameterList(new KviStr(linkText)));
									} else bTrigger = true;
								break;
								case KVI_WINDOW_TYPE_QUERY:
									if(((KviQuery *)m_pKviWindow)->haveTarget(linkText.ptr()))
									{
										if(g_pEventManager->hasEventHandlers(KviEvent_OnQueryNickPopupRequest))
											g_pUserParser->triggerEvent(KviEvent_OnQueryNickPopupRequest,m_pKviWindow,
												new KviParameterList(new KviStr(linkText)));
									} else bTrigger = true;
								break;
								default:
									bTrigger = true;
								break;
							}
							if(bTrigger)
							{
								if(console())
								{
									if(g_pEventManager->hasEventHandlers(KviEvent_OnNickLinkPopupRequest))
										g_pUserParser->triggerEvent(KviEvent_OnNickLinkPopupRequest,m_pKviWindow,
											new KviParameterList(new KviStr(linkText.ptr())));
								} else emit rightClicked();
							}
						}
					break;
					case 'h':
						if(g_pEventManager->hasEventHandlers(KviEvent_OnHostLinkPopupRequest))
							g_pUserParser->triggerEvent(KviEvent_OnHostLinkPopupRequest,m_pKviWindow,
								new KviParameterList(new KviStr(linkText.ptr())));
					break;
					case 'u':
						if(g_pEventManager->hasEventHandlers(KviEvent_OnUrlLinkPopupRequest))
							g_pUserParser->triggerEvent(KviEvent_OnUrlLinkPopupRequest,m_pKviWindow,
								new KviParameterList(new KviStr(linkText.ptr())));
					break;
					case 'c':
						if(g_pEventManager->hasEventHandlers(KviEvent_OnChannelLinkPopupRequest))
							g_pUserParser->triggerEvent(KviEvent_OnChannelLinkPopupRequest,m_pKviWindow,
								new KviParameterList(new KviStr(linkText.ptr())));
					break;
					case 's':
						if(g_pEventManager->hasEventHandlers(KviEvent_OnServerLinkPopupRequest))
							g_pUserParser->triggerEvent(KviEvent_OnServerLinkPopupRequest,m_pKviWindow,
								new KviParameterList(new KviStr(linkText.ptr())));
					break;
					default:
					{
						KviStr tmp;
						getLinkEscapeCommand(tmp,linkCmd.ptr(),"[!rbt]",6);
						if(tmp.hasData())
						{
							KviParameterList * l = new KviParameterList(linkText.ptr());
							g_pUserParser->parseCommandBuffer(tmp.ptr(),m_pKviWindow,l);
						} else emit rightClicked();
					}
					break;
				}
			} else emit rightClicked();
			
		} else if((e->button() & MidButton) || ((e->button() & RightButton) && (e->state() & ControlButton)))
		{
			KviStr tmp;
			getLinkEscapeCommand(tmp,linkCmd.ptr(),"[!mbt]",6);
			if(tmp.hasData())
			{
				KviParameterList * l = new KviParameterList(linkText.ptr());
				g_pUserParser->parseCommandBuffer(tmp.ptr(),m_pKviWindow,l);
			} else {
				TRIGGER_EVENT(KviEvent_OnWindowPopupRequest,m_pKviWindow);
			}
		}

	}
}

//================ mouseReleaseEvent ===============//

void KviIrcView::mouseReleaseEvent(QMouseEvent *)
{
	if(m_iSelectTimer)
	{
		killTimer(m_iSelectTimer);
		m_iSelectTimer = 0;
		g_pApp->clipboard()->setText(m_szLastSelection.ptr());
	}

	if(m_bMouseIsDown)
	{
		m_bMouseIsDown = false;
		// Insert the lines blocked while selecting
		while(KviIrcViewTextLine * l = m_pMessagesStoppedWhileSelecting->first())
		{
			m_pMessagesStoppedWhileSelecting->removeFirst();
			appendLine(l,false);
		}

		paintEvent(0);
	}
}

// FIXME: #warning "The tooltip timeout should be small, because the view scrolls!"

void KviIrcView::mouseMoveEvent(QMouseEvent *e)
{
//	debug("Pos : %d,%d",e->pos().x(),e->pos().y());
	if(m_bMouseIsDown && (e->state() & LeftButton)) // m_bMouseIsDown MUST BE true...(otherwise the mouse entered the window with the button pressed ?)
	{
		if(m_iSelectTimer == 0)m_iSelectTimer = startTimer(KVI_IRCVIEW_SELECT_REPAINT_INTERVAL);
	} else {
		if(m_iSelectTimer)
		{
			killTimer(m_iSelectTimer);
			m_iSelectTimer = 0;
		}

		int yPos = e->pos().y();
		int rectTop;
		int rectHeight;
		KviIrcViewTextBlock * newLinkUnderMouse = getLinkUnderMouse(e->pos().x(),yPos,&rectTop,&rectHeight);
		if(newLinkUnderMouse != m_pLastLinkUnderMouse)
		{
			abortTip();
			m_iTipTimer = startTimer(KVI_OPTION_UINT(KviOption_uintIrcViewToolTipTimeoutInMsec));
			m_pLastLinkUnderMouse = newLinkUnderMouse;
			if(m_pLastLinkUnderMouse)
			{

				if(rectTop < 0)rectTop = 0;
				if((rectTop + rectHeight) > height())rectHeight = height() - rectTop;

				if(m_iLastLinkRectHeight > -1)
				{
					// prev link
					int top = (rectTop < m_iLastLinkRectTop) ? rectTop : m_iLastLinkRectTop;
					int lastBottom = m_iLastLinkRectTop + m_iLastLinkRectHeight;
					int thisBottom = rectTop + rectHeight;
					QRect r(0,top,width(),((lastBottom > thisBottom) ? lastBottom : thisBottom) - top);
					QPaintEvent * pev = new QPaintEvent(r);
					paintEvent(pev);
					delete pev;
				} else {
					// no prev link
					QRect r(0,rectTop,width(),rectHeight);
					QPaintEvent * pev = new QPaintEvent(r);
					paintEvent(pev);
					delete pev;
				}
				m_iLastLinkRectTop = rectTop;
				m_iLastLinkRectHeight = rectHeight;
			} else {
				if(m_iLastLinkRectHeight > -1)
				{
					// There was a previous bottom rect
					QRect r(0,m_iLastLinkRectTop,width(),m_iLastLinkRectHeight);
					QPaintEvent * pev = new QPaintEvent(r);
					paintEvent(pev);
					delete pev;
					m_iLastLinkRectTop = -1;
					m_iLastLinkRectHeight = -1;
				}
			}

		}
	}
}

KviConsole * KviIrcView::console()
{
	return m_pKviWindow->console();
}

void KviIrcView::doLinkToolTip(KviStr &linkCmd,KviStr &linkText)
{
	KviStr tip;


	switch(*(linkCmd.ptr()))
	{
		case 'u': // url link
		{
			tip = __tr("Double click to open this link<br>Right click to view other options");
		}
		break;
		case 'h': // host link
		{
			if(linkText.contains('*'))
			{
				if(linkText.len() > 1)tip = __tr("This looks like a masked hostname: can't look it up");
				else tip = __tr("This looks like an unknown hostname: can't look it up");
					
			} else {
				tip = __tr("Double click to lookup this host<br>Right click to view other options");
			}
		}
		break;
		case 's': // server link
		{
// FIXME: #warning "Spit out some server info...hub ?...registered ?"
			if(linkText.contains('*'))
			{
				if(linkText.len() > 1)tip = __tr("This looks like a hub server<br>");
				else tip = __tr("This looks like an unknown server<br>"); // might happen...
			}

			tip.append(__tr("Double click to read the motd<br>Right click to view other options"));
		}
		break;
		case 'm': // mode link
		{
			if((linkCmd.len() > 2) && (m_pKviWindow->type() == KVI_WINDOW_TYPE_CHANNEL))
			{
				if(((KviChannel *)m_pKviWindow)->isMeOp())
				{
					char plmn = *(linkCmd.ptr() + 1);
					if((plmn == '+') || (plmn == '-'))
					{
						tip = __tr("Double click to set<br>");
						char flag = *(linkCmd.ptr() + 2);
						switch(flag)
						{
							case 'o':
							case 'v':
								// We can do nothing here...
								tip = "";
							break;

							case 'b':
							case 'I':
							case 'e':
							case 'k':
								tip.append(KviStr::Format,__tr("<b>mode %s %c%c %s</b>"),m_pKviWindow->name(),plmn,flag,linkText.ptr());
							break;
							default:
								tip.append(KviStr::Format,__tr("<b>mode %s %c%c</b>"),m_pKviWindow->name(),plmn,flag);
							break;
						}
					}
				} else {
					// I'm not op...no way
					tip = __tr("You're not an operator: you can't change channel modes");
				}
			}
		}
		break;
		case 'n': // nick link
		{
			if(console())
			{
				KviIrcUserDataBase * db = console()->userDataBase();
				if(db)
				{
					KviIrcUserEntry * e = console()->userDataBase()->find(linkText.ptr());
					if(e)
					{
						console()->getUserTipText(linkText.ptr(),e,tip);
					} else tip.sprintf(__tr("Nothing known about %s"),linkText.ptr());
				} else tip.sprintf(__tr("Nothing known about %s (we're offline)"),linkText.ptr());
			}
		}
		break;
		case 'c': // channel link
		{
			if(console())
			{
				KviChannel * c = console()->findChannel(linkText.ptr());
				if(c)
				{
					KviStr chanMode;
					c->getChannelModeString(chanMode);
					KviStr topic = c->topicWidget()->topic();
					topic.replaceAll("<","&lt;");
					topic.replaceAll(">","&gt;");
					tip.sprintf(__tr("<b>%s</b>: +%s (%u users)<hr>%s"),linkText.ptr(),chanMode.ptr(),
						c->count(),topic.ptr());
				} else {
					tip.sprintf(__tr("Double click to join %s<br>Right click to view other options"),linkText.ptr());
				}
			}
		}
		break;
		default:
		{
			KviStr dbl,rbt,txt,mbt;
			getLinkEscapeCommand(dbl,linkCmd.ptr(),"[!dbl]",6);
			getLinkEscapeCommand(rbt,linkCmd.ptr(),"[!rbt]",6);
			getLinkEscapeCommand(txt,linkCmd.ptr(),"[!txt]",6);
			getLinkEscapeCommand(mbt,linkCmd.ptr(),"[!mbt]",6);

			if(txt.hasData())tip = txt;
			if(tip.isEmpty() && dbl.hasData())
			{
				if(tip.hasData())tip.append("<hr>");
				tip.append(KviStr::Format,__tr("<b>Double click:</b><br>%s"),dbl.ptr());
			}
			if(tip.isEmpty() && mbt.hasData())
			{
				if(tip.hasData())tip.append("<hr>");
				tip.append(KviStr::Format,__tr("<b>Middle click:</b><br>%s"),mbt.ptr());
			}
			if(tip.isEmpty() && rbt.hasData())
			{
				if(tip.hasData())tip.append("<hr>");
				tip.append(KviStr::Format,__tr("<b>Right click:</b><br>%s"),rbt.ptr());
			}
		}
		break;
	}

	if(tip.isEmpty())return;

	g_pIrcViewTipWidget->setText(tip.ptr());
	g_pIrcViewTipWidget->adjustSize();

	QPoint pnt = QCursor::pos() + QPoint(1,18);
	if(pnt.x() + g_pIrcViewTipWidget->width() > g_pApp->desktop()->width())
		pnt.setX(g_pApp->desktop()->width() - g_pIrcViewTipWidget->width());
	if(pnt.y() + g_pIrcViewTipWidget->height() > g_pApp->desktop()->height())
		pnt.setY(g_pApp->desktop()->height() - g_pIrcViewTipWidget->height());

	g_pIrcViewTipWidget->popup(pnt);
}

void KviIrcView::abortTip()
{
	if(m_iTipTimer)
	{
		killTimer(m_iTipTimer);
		m_iTipTimer = 0;
	}
	g_pIrcViewTipWidget->abort();
}

void KviIrcView::timerEvent(QTimerEvent *e)
{
	m_mouseCurrentPos = mapFromGlobal(QCursor::pos());

	if(e->timerId() == m_iSelectTimer)
	{
		calculateSelectionBounds();
		paintEvent(0);

	} else if(e->timerId() == m_iTipTimer)
	{
		killTimer(m_iTipTimer);
		m_iTipTimer = 0;
		int rectTop,rectHeight;
		KviStr linkCmd;
		KviStr linkText;

		KviIrcViewTextBlock * linkUnderMouse = getLinkUnderMouse(m_mouseCurrentPos.x(),m_mouseCurrentPos.y(),&rectTop,&rectHeight,&linkCmd,&linkText);

		if((linkUnderMouse == m_pLastLinkUnderMouse) && linkUnderMouse)doLinkToolTip(linkCmd,linkText);
		else m_pLastLinkUnderMouse = 0; //
	}
}

void KviIrcView::inputWidgetKeyPressed()
{
    abortTip();
}

// FIXME: #warning "Later remove this stuff and use a wrapper for #include <X11/Xlib.h>"
#ifdef Bool
	#undef Bool
#endif


#include "kvi_ircview.moc"
