#ifndef _KVI_IRCTOOLBAR_H_
#define _KVI_IRCTOOLBAR_H_

//
//   File : kvi_irctoolbar.h
//   Creation date : Thu Oct 29 2000 14:09:11 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000-2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include "kvi_string.h"
#include "kvi_tal_toolbar.h"

#include "kvi_list.h"
#include <qwidget.h>
//#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qwidgetstack.h>
#include <qlabel.h>

class QPopupMenu;


#define KVI_IRCTOOLBARAPPLET_BASE_SIZE 38
#define KVI_IRCTOOLBAR_SPACING 1

#define KVI_IRCTOOLBARMAXALIGNEDAPPLETS 4
#define KVI_IRCTOOLBARMAXALIGNEDAPPLETSPACES (KVI_IRCTOOLBARMAXALIGNEDAPPLETS - 1)

#define KVI_IRCTOOLBARCONTAINER_MINIMUM_WIDTH ((KVI_IRCTOOLBARAPPLET_BASE_SIZE * KVI_IRCTOOLBARMAXALIGNEDAPPLETS) + (KVI_IRCTOOLBAR_SPACING * KVI_IRCTOOLBARMAXALIGNEDAPPLETSPACES))
#define KVI_IRCTOOLBARCONTAINER_MINIMUM_HEIGHT KVI_IRCTOOLBARAPPLET_BASE_SIZE

#define KVI_IRCTOOLBARAPPLET_MAXIMUM_WIDTH ((KVI_IRCTOOLBARAPPLET_BASE_SIZE * KVI_IRCTOOLBARMAXALIGNEDAPPLETS) + (KVI_IRCTOOLBAR_SPACING * KVI_IRCTOOLBARMAXALIGNEDAPPLETSPACES))
#define KVI_IRCTOOLBARAPPLET_MAXIMUM_HEIGHT KVI_IRCTOOLBARAPPLET_BASE_SIZE


//
// This file contains all the stuff related to the built-in kvirc toolbars
// KVirc can have a single or multiple built-in toolbars (KviIrcToolBar),
// it depends on a boolean option from KviOptions
// Each KviIrcToolbar contains two widgets:
// a QWidgetStack and a KviIrcToolBarAppletContainer
// In single-toolbar-mode the QWidgetStack contains multiple KviIrcContextController widgets
// (that inherit KviIrcToolBarAppletContainer). In multi-toolbar-mode the QWidgetStack contains
// a single KviIrcContextController.
// A KviIrcToolBarAppletContainer manages a list of applet QWidgets.
// A common applet widget is a QToolButton (KviIrcContextController has a built in "connect"
// button for example), and other common applets are the graphical ones:
// these should inherit from KviIrcToolBarGraphicalApplet that takes care of painting
// a commong background for them.
//
// Yeah...I know that this is a bit complex... :)
//

class KviFrame;
class KviConsole;
class KviIrcContextController;
class KviIrcToolBar;
class KviIrcContextStatusDisplay;

//
// Applet container
//
// Manages an applet list (KviPtrList<QWidget>). The applets are automatically
// adjusted in size: They have all the same height (KVI_IRCTOOLBARAPPLET_BASE_SIZE)
// and can have a width that is a multiple of KVI_IRCTOOLBARAPPLET_BASE_SIZE (1,2 or 3 times)
// The width is guessed from the applet sizeHint().
//

class KVIRC_API KviIrcToolBarAppletContainer : public QWidget
{
	friend class KviIrcToolBar;
	Q_OBJECT
public:
	KviIrcToolBarAppletContainer(QWidget * par,const char * nam);
	~KviIrcToolBarAppletContainer();
protected:
	KviIrcToolBar                            * m_pParentToolBar;
	KviPtrList<QWidget>                           * m_pAppletList;
	QSize                                      m_horizontalSizeHint;
	QSize                                      m_verticalSizeHint;
public:
	void reparentApplets(KviIrcToolBarAppletContainer * fr);
	void addApplet(QWidget * pWidget);
	void removeApplet(QWidget * pWidget);
	KviIrcToolBar * parentToolBar() const { return m_pParentToolBar; };
	virtual QSize sizeHint() const;
	void updateGraphicalApplets();
protected:
	void recalcSizeHints();
	void setParentToolBar(KviIrcToolBar * tb){ m_pParentToolBar = tb; };
	void doLayout();
	virtual void resizeEvent(QResizeEvent *e);
//	virtual void paintEvent(QPaintEvent *e);
};

//
// IrcContextController: irc context exclusive applets container
//
// It is an applet container so it manages the applets in the same way
// additionally it has some default applets always loaded (the connect button
// and the status display...)
//

class KVIRC_API KviIrcContextController : public KviIrcToolBarAppletContainer
{
	friend class KviConsole;
	friend class KviIrcToolBar;
	Q_OBJECT
public:
	KviIrcContextController(KviConsole * pConsole,QWidget * par,KviIrcToolBar * bar);
	~KviIrcContextController();
protected:
	KviConsole                               * m_pConsole;
	QToolButton                              * m_pConnectButton;
	QToolButton                              * m_pToolsButton;
	QToolButton                              * m_pActionsButton;

	QPopupMenu                               * m_pActionsPopup;
	QPopupMenu                               * m_pRecentServersPopup;
	QPopupMenu                               * m_pRecentNicknamesPopup;
	QPopupMenu                               * m_pRecentChannelsPopup;
	QPopupMenu                               * m_pUserModePopup;

	KviIrcContextStatusDisplay               * m_pStatusLabel;
	KviIrcToolBar                            * m_pToolBar;
public:
	KviConsole * console(){ return m_pConsole; };
protected slots:
	void awayClicked();
	void setupActionsPopup();
	void setupUserModePopup();
	void setupRecentChannelsPopup();
	void setupRecentServersPopup();
	void setupRecentNicknamesPopup();
	void userModeSelected(int id);
	void recentChannelSelected(int id);
	void recentNicknameSelected(int id);
	void recentServerSelected(int id);
};

//
// Basic graphical applet
//
// Thinks about the "common" background (handles transparency stuff & co.)
// Can be a child of any AppletContainer
//

class KVIRC_API KviIrcToolBarGraphicalApplet : public QWidget
{
	Q_OBJECT
public:
	KviIrcToolBarGraphicalApplet(KviIrcToolBarAppletContainer * pContainer,const char * name = 0);
	~KviIrcToolBarGraphicalApplet();
public:
	KviIrcToolBarAppletContainer * container(){ return (KviIrcToolBarAppletContainer *)parent(); };
protected:
	virtual void paintEvent(QPaintEvent *e);
	virtual void drawContents(QPainter * p);
};

//
// Basic irc-context-exclusive graphical applet
//
// Has some helper functions relative to the irc context
// Can be only a child of KviIrcContextController and derivate classes
//

class KVIRC_API KviIrcContextGraphicalApplet : public KviIrcToolBarGraphicalApplet
{
	Q_OBJECT
public:
	KviIrcContextGraphicalApplet(KviIrcContextController * pController,const char * name = 0);
	~KviIrcContextGraphicalApplet();
public:
	KviIrcContextController * controller(){ return (KviIrcContextController *)parent(); };
	KviConsole * console(){ return controller()->console(); };
	bool isActiveContext();
};

//
// Default irc-context-exclusive graphical applet
//
// This is always present in a KviIrcContextController
//

class KviDynamicToolTip;

class KVIRC_API KviIrcContextStatusDisplay : public KviIrcContextGraphicalApplet
{
	Q_OBJECT
public:
	KviIrcContextStatusDisplay(KviIrcContextController * pController);
	~KviIrcContextStatusDisplay();
protected:
	virtual void drawContents(QPainter * p);
	virtual QSize sizeHint() const;
	virtual void mousePressEvent(QMouseEvent *e);
protected slots:
	void tipRequest(KviDynamicToolTip * tip,const QPoint &);
};

//
// And finally the toolbar
//

class KVIRC_API KviIrcToolBar : public KviTalToolBar
{
	Q_OBJECT
public:
	KviIrcToolBar(KviFrame * pFrm,const char * name);
	~KviIrcToolBar();
protected:
	KviFrame     * m_pFrm;
	QWidgetStack * m_pIccStack;
	QLabel       * m_pNullController;
	KviIrcToolBarAppletContainer * m_pFrameWideContainer;
public:
	QWidget * iccStack(){ return m_pIccStack; };
	KviIrcToolBarAppletContainer * frameWideContainer(){ return m_pFrameWideContainer; };
	void addController(KviIrcContextController * pController);
	void removeController(KviIrcContextController * pController);
	void removeControllerNoDelete(KviIrcContextController * pController);
	void setCurrentController(KviIrcContextController * pController);
	void updatePseudoTransparency();
	void reparentChildren(KviIrcToolBar * target);
//	void updateHandle();
protected:
//	virtual void paintEvent(QPaintEvent *e);
//	void drawHandle(QPainter *p);
};




#endif //_KVI_IRCTOOLBAR_H_
