//
//   File : kvi_irctoolbar.cpp
//   Creation date : Thu Oct 29 2000 14:13:13 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000-2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__
#include "kvi_irctoolbar.h"
#include "kvi_console.h"
#include "kvi_frame.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"
#include "kvi_settings.h"
#include "kvi_options.h"
#include "kvi_frame.h"
#include "kvi_app.h"
#include "kvi_dynamictooltip.h"
#include "kvi_ircurl.h"
#include "kvi_internalcmd.h"
#include "kvi_uparser.h"

#include <qobjcoll.h>
#include <qstyle.h>
#include <qpainter.h>
#include <qpopupmenu.h>

//#ifndef COMPILE_ON_WINDOWS
//	#include "kvi_xlib.h"
//#endif

#ifdef COMPILE_PSEUDO_TRANSPARENCY
	extern QPixmap * g_pShadedChildGlobalDesktopBackground;
#endif


// kvi_app.cpp
//#ifndef COMPILE_ON_WINDOWS
//	extern Display                   * g_display;
//	extern GC                          g_iccGC;
//	extern HANDLE                      g_hIccMemBuffer;
//#endif

extern QPixmap                   * g_pIccMemBuffer;

//#ifdef COMPILE_USE_AA_FONTS
//	XftFont        * g_pIccXftFont;
//	XftDraw        * g_pIccXftDraw;
//#endif

////////////////////////////////////////////////////////////////////////
//
// KviIrcToolBarGraphicalApplet
//
//     base class for all the graphical applets for the irc toolbars
//     provides support for themed background
//
////////////////////////////////////////////////////////////////////////


KviIrcToolBarGraphicalApplet::KviIrcToolBarGraphicalApplet(KviIrcToolBarAppletContainer * pContainer,const char * name)
: QWidget(pContainer,name)
{
	setBackgroundMode(QWidget::NoBackground);
}


KviIrcToolBarGraphicalApplet::~KviIrcToolBarGraphicalApplet()
{
}

void KviIrcToolBarGraphicalApplet::paintEvent(QPaintEvent *e)
{
	if(!isVisible())return;

	QPainter pa(g_pIccMemBuffer);

#ifdef COMPILE_PSEUDO_TRANSPARENCY
	if(g_pShadedChildGlobalDesktopBackground)
	{
		QPoint pnt = mapToGlobal(QPoint(0,0));
		pa.drawTiledPixmap(e->rect().left(),e->rect().top(),e->rect().width(),e->rect().height(),*g_pShadedChildGlobalDesktopBackground,pnt.x(),pnt.y());
	} else {
#endif
		if(KVI_OPTION_PIXMAP(KviOption_pixmapIrcToolBarAppletBackground).pixmap())
		{
			QPoint pnt = mapToGlobal(QPoint(0,0));
			pa.drawTiledPixmap(e->rect().left(),e->rect().top(),e->rect().width(),e->rect().height(),*(KVI_OPTION_PIXMAP(KviOption_pixmapIrcToolBarAppletBackground).pixmap()),pnt.x(),pnt.y());
		} else {
			pa.fillRect(e->rect().left(),e->rect().top(),e->rect().width(),e->rect().height(),KVI_OPTION_COLOR(KviOption_colorIrcToolBarAppletBackground));
		}
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	}
#endif

	drawContents(&pa);

	//Need to draw the sunken rect around the view now...
	pa.setPen(colorGroup().dark());
	pa.drawLine(0,0,width(),0);
	pa.drawLine(0,0,0,width());
	pa.setPen(colorGroup().light());
	pa.drawLine(1,height() - 1,width() - 1,height() - 1);
	pa.drawLine(width() - 1,1,width() - 1,height());

	bitBlt(this,e->rect().left(),e->rect().top(),g_pIccMemBuffer,e->rect().left(),e->rect().top(),e->rect().width(),e->rect().height(),Qt::CopyROP);
}

void KviIrcToolBarGraphicalApplet::drawContents(QPainter *)
{
	// nothing here
}



////////////////////////////////////////////////////////////////////////
//
// KviIrcContextGraphicalApplet
//
//     Base class for all the graphical applets for the irc toolbars
//     that live in an irc context
//     Provides support for context management
//
////////////////////////////////////////////////////////////////////////

KviIrcContextGraphicalApplet::KviIrcContextGraphicalApplet(KviIrcContextController * pController,const char * name)
: KviIrcToolBarGraphicalApplet(pController,name)
{
}

KviIrcContextGraphicalApplet::~KviIrcContextGraphicalApplet()
{
}

bool KviIrcContextGraphicalApplet::isActiveContext()
{
	KviConsole * pCons = console();
	if(!pCons)return false;
	KviFrame * frm = pCons->frame();
	if(!frm)return false;
	KviWindow * pWnd = frm->activeWindow();
	if(!pWnd)return false;
	return (console() == pWnd->console());
}





//////////////////////////////////////////////////////////////////////////////
//
// KviIrcContextStatusDisplay
//
//      Main applet of all irc contexts
//      Displays the server connection status, server name
//      nickname, user mode and the graphical indication of the context
//
//////////////////////////////////////////////////////////////////////////////

KviIrcContextStatusDisplay::KviIrcContextStatusDisplay(KviIrcContextController * pController)
: KviIrcContextGraphicalApplet(pController)
{
	KviDynamicToolTip * tip = new KviDynamicToolTip(this);
	connect(tip,SIGNAL(tipRequest(KviDynamicToolTip *,const QPoint &)),this,SLOT(tipRequest(KviDynamicToolTip *,const QPoint &)));
}


KviIrcContextStatusDisplay::~KviIrcContextStatusDisplay()
{
}

void KviIrcContextStatusDisplay::tipRequest(KviDynamicToolTip * tip,const QPoint &)
{
	KviConnectionInfo * i = console()->connectionInfo();
	KviStr txt;
	if(!i)txt.sprintf(__tr("<b>No connection</b><br>(Irc context %u)"),console()->ircContextId());
	else {
		KviStr nickAndMode = console()->currentNickName();
		if(!console()->userModeEmpty())nickAndMode.append(KviStr::Format," (+%s)",console()->currentUserMode());
		txt.sprintf(__tr("<b>%s</b><br>%s<br>(Irc context %u)"),
			console()->currentServerName(),nickAndMode.ptr(),console()->ircContextId());
	}
	tip->tip(rect(),txt.ptr());
}


QSize KviIrcContextStatusDisplay::sizeHint() const
{
	return QSize(KVI_IRCTOOLBARAPPLET_MAXIMUM_WIDTH,KVI_IRCTOOLBARAPPLET_MAXIMUM_HEIGHT);
}

#define KVI_APPLETIRCCONTEXTINDICATORWIDTH 14

void KviIrcContextStatusDisplay::drawContents(QPainter * p)
{
	// The context indicator


	QColor base = colorGroup().background();
	QColor cntx = KVI_OPTION_ICCOLOR(controller()->console()->ircContextId() % KVI_NUM_ICCOLOR_OPTIONS);
	base.setRgb((base.red() + cntx.red()) >> 1,(base.green() + cntx.green()) >> 1,
		(base.blue() + cntx.blue()) >> 1);

	p->fillRect(2,2, KVI_APPLETIRCCONTEXTINDICATORWIDTH - 2,height() - 4,base);

	p->setPen(KVI_OPTION_COLOR(isActiveContext() ? KviOption_colorIrcToolBarAppletForegroundMidContrast : KviOption_colorIrcToolBarAppletForegroundLowContrast));
	p->drawLine(1,1,width() - 1,1);
	p->drawLine(1,1,1,height() - 1);
	p->drawLine(2,height() - 2,width() - 1,height() - 2);
	p->drawLine(width() - 2,1,width() - 2,height());
	p->drawLine(KVI_APPLETIRCCONTEXTINDICATORWIDTH,2,KVI_APPLETIRCCONTEXTINDICATORWIDTH,height() - 2);

	KviConnectionInfo * i = console()->connectionInfo();
	KviStr serv,nick;
	if(!i)
	{
		serv = __tr("No connection");
	} else {
		if(console()->isConnected())
		{
			nick = console()->currentNickName();
			if(!console()->userModeEmpty())
			{
				nick.append(KviStr::Format," (+%s",console()->currentUserMode());
				if(console()->userIsAway())nick.append(__tr(" away)"));
				else nick.append(")");
			} else {
				if(console()->userIsAway())nick.append(__tr(" (away)"));
			}
			serv = console()->currentServerName();
		} else {
			serv = __tr("In progress...");
		}
	}

	p->setFont(KVI_OPTION_FONT(KviOption_fontIrcToolBarApplet));


	if(isActiveContext())
	{
		p->setPen(KVI_OPTION_COLOR(KviOption_colorIrcToolBarAppletForegroundHighContrastActive1));
	} else {
		p->setPen(KVI_OPTION_COLOR(KviOption_colorIrcToolBarAppletForegroundMidContrast));
	}
	
	p->setClipRect(KVI_APPLETIRCCONTEXTINDICATORWIDTH + 2,2,width() - (KVI_APPLETIRCCONTEXTINDICATORWIDTH + 4),height() - 4);

	p->drawText(KVI_APPLETIRCCONTEXTINDICATORWIDTH + 4,16,serv.ptr(),serv.len());
	p->drawText(KVI_APPLETIRCCONTEXTINDICATORWIDTH + 4,30,nick.ptr(),nick.len());

	p->setClipping(false);

//	p->fillRect(im + 2,yPixmap + 1,14,15,base);
//	draw_frame_helper(p,im + 1,yPixmap,im + 15,yPixmap + 15,base.light(180),base.dark());	
}

/*
void KviIrcContextStatusDisplay::drawContents(QPaintEvent *e)
{
	XSetForeground(g_display,g_iccGC,KVI_OPTION_COLOR(isActiveContext() ? KviOption_colorIrcToolBarAppletForegroundMidContrast : KviOption_colorIrcToolBarAppletForegroundLowContrast).pixel());

	XSetLineAttributes(g_display,g_iccGC,1,LineSolid,CapButt,JoinMiter); //need this for line size
	XDrawLine(g_display,g_hIccMemBuffer,g_iccGC,3,3,width() - 3,3);
	XDrawLine(g_display,g_hIccMemBuffer,g_iccGC,3,3,3,height() - 3);
	XDrawLine(g_display,g_hIccMemBuffer,g_iccGC,4,height() - 4,width() - 4,height() - 4);
	XDrawLine(g_display,g_hIccMemBuffer,g_iccGC,width() - 4,4,width() - 4,height() - 3);
	XDrawLine(g_display,g_hIccMemBuffer,g_iccGC,10,4,10,height() - 4);


	if(isActiveContext())
	{
		XSetForeground(g_display,g_iccGC,KVI_OPTION_ICCOLOR(controller()->console()->ircContextId() % KVI_NUM_ICCOLOR_OPTIONS).pixel());
	} else {
		QColor fore = KVI_OPTION_ICCOLOR(controller()->console()->ircContextId() % KVI_NUM_ICCOLOR_OPTIONS);
		QColor mix = KVI_OPTION_COLOR(KviOption_colorIrcToolBarAppletForegroundLowContrast);
		fore.setRgb((fore.red() + mix.red()) >> 1,(fore.green() + mix.green()) >> 1,(fore.blue() + mix.blue()) >> 1);
		XSetForeground(g_display,g_iccGC,fore.pixel());
	}

	XFillRectangle(g_display,g_hIccMemBuffer,g_iccGC,4,4,6,height() - 8);


	KviConnectionInfo * i = console()->connectionInfo();
	KviStr serv,nick;
	if(!i)
	{
		serv = __tr("No connection");
	} else {
		if(console()->isConnected())
		{
			nick = console()->currentNickName();
			if(!console()->userModeEmpty())nick.append(KviStr::Format," (+%s)",console()->currentUserMode());
			serv = console()->currentServerName();
		} else {
			serv = __tr("In progress...");
		}
	}

#ifdef COMPILE_USE_AA_FONTS
	if(kvi_xft_enabled())
	{
		g_pIccXftFont = kvi_xft_font(&(KVI_OPTION_FONT(KviOption_fontIrcToolBarApplet)));
		g_pIccXftDraw = kvi_xft_lookup_drawable(g_hIccMemBuffer,g_pIccMemBuffer,0);
		if(!g_pIccXftDraw)
		{
			g_pIccXftFont = 0;
			XSetFont(g_display,g_iccGC,KVI_OPTION_FONT(KviOption_fontIrcToolBarApplet).handle());
		}
	} else {
#endif
		XSetFont(g_display,g_iccGC,KVI_OPTION_FONT(KviOption_fontIrcToolBarApplet).handle());
#ifdef COMPILE_USE_AA_FONTS
		g_pIccXftFont = 0;
		g_pIccXftDraw = 0;
	}
#endif

#ifdef COMPILE_USE_AA_FONTS
	if(g_pIccXftFont)
	{
		QColor * clr = isActiveContext() ? &(KVI_OPTION_COLOR(KviOption_colorIrcToolBarAppletForegroundHighContrastActive1)) :
											&(KVI_OPTION_COLOR(KviOption_colorIrcToolBarAppletForegroundMidContrast));
		XftColor color;
		color.color.red = clr->red() | clr->red() << 8;
		color.color.green = clr->green() | clr->green() << 8;
		color.color.blue = clr->blue() | clr->blue() << 8;
		color.color.alpha = 0xffff;
		color.pixel = clr->pixel();

		QRegion reg(11,4,width() - 16,height() - 4);

		XftDrawSetClip(g_pIccXftDraw,reg.handle());

		XftDrawString8(g_pIccXftDraw,&color,g_pIccXftFont,13,16,(unsigned char *)serv.ptr(),serv.len());
		XftDrawString8(g_pIccXftDraw,&color,g_pIccXftFont,13,30,(unsigned char *)nick.ptr(),nick.len());

		XftDrawSetClip(g_pIccXftDraw,None);

	} else {
#endif
		if(isActiveContext())
		{
			XSetForeground(g_display,g_iccGC,KVI_OPTION_COLOR(KviOption_colorIrcToolBarAppletForegroundHighContrastActive1).pixel());
		} else {
			XSetForeground(g_display,g_iccGC,KVI_OPTION_COLOR(KviOption_colorIrcToolBarAppletForegroundMidContrast).pixel());
		}
		
		XRectangle rectangle={ 11,4,width() - 16,height() - 4 };
	
		XSetClipRectangles(g_display,g_iccGC,0,0,&rectangle,1,Unsorted);
	
		XDrawString(g_display,g_hIccMemBuffer,g_iccGC,13,16,serv.ptr(),serv.len());
		XDrawString(g_display,g_hIccMemBuffer,g_iccGC,13,30,nick.ptr(),nick.len());

		XSetClipMask(g_display,g_iccGC,None);
#ifdef COMPILE_USE_AA_FONTS
	}
#endif

}
*/

void KviIrcContextStatusDisplay::mousePressEvent(QMouseEvent *e)
{
	console()->frame()->setActiveWindow(console());
}



//////////////////////////////////////////////////////////////////////////////
//
// KviIrcToolBarAppletContainer
//
//        Container for the applets
//        Manages geometry and reparenting to other containers
//
//////////////////////////////////////////////////////////////////////////////



KviIrcToolBarAppletContainer::KviIrcToolBarAppletContainer(QWidget * par,const char * nam)
: QWidget(par,nam)
{
	if((g_pIccMemBuffer->width() < KVI_IRCTOOLBARAPPLET_MAXIMUM_WIDTH) || 
		(g_pIccMemBuffer->height() < KVI_IRCTOOLBARAPPLET_MAXIMUM_HEIGHT))
	{
		g_pIccMemBuffer->resize(KVI_IRCTOOLBARAPPLET_MAXIMUM_WIDTH,KVI_IRCTOOLBARAPPLET_MAXIMUM_HEIGHT);

//		g_hIccMemBuffer = g_pIccMemBuffer->handle();
	}

	m_pAppletList = new KviPtrList<QWidget>;
	m_pAppletList->setAutoDelete(true);

	m_pParentToolBar = 0;

//	if(par)setBackgroundMode(par->backgroundMode());
	setBackgroundMode(QWidget::PaletteButton);
}

KviIrcToolBarAppletContainer::~KviIrcToolBarAppletContainer()
{
	delete m_pAppletList;
}

void KviIrcToolBarAppletContainer::updateGraphicalApplets()
{
	for(QWidget * w = m_pAppletList->first();w;w = m_pAppletList->next())
	{
		if(w->inherits("KviIrcContextGraphicalApplet"))w->update();
	}
}

void KviIrcToolBarAppletContainer::reparentApplets(KviIrcToolBarAppletContainer * fr)
{
	for(QWidget * w = m_pAppletList->first();w;w = m_pAppletList->next())
	{
		w->reparent(fr,QPoint(0,0),false); // reparent to the friend container
		fr->addApplet(w); // notify him of a new applet
		w->show();       // ensure it is shown
	}
	m_pAppletList->setAutoDelete(false);
	m_pAppletList->clear();
	m_pAppletList->setAutoDelete(true);
	// we're going to die I guess...
}

void KviIrcToolBarAppletContainer::resizeEvent(QResizeEvent *e)
{
	QWidget::resizeEvent(e);
	doLayout();

}

void KviIrcToolBarAppletContainer::recalcSizeHints()
{
	int curHorzWidth = 0;
	int curVertHeight = 0;
	int curVertX = 0;
	for(QWidget * w = m_pAppletList->first();w;w = m_pAppletList->next())
	{
		int steps = w->sizeHint().width() / KVI_IRCTOOLBARAPPLET_BASE_SIZE;
		if(steps < 1)steps = 1;
		else if(steps > KVI_IRCTOOLBARMAXALIGNEDAPPLETS)steps = KVI_IRCTOOLBARMAXALIGNEDAPPLETS;
		int wdth = (steps * KVI_IRCTOOLBARAPPLET_BASE_SIZE) + ((steps - 1) * KVI_IRCTOOLBAR_SPACING);
		curHorzWidth += wdth + KVI_IRCTOOLBAR_SPACING;

		if(wdth + curVertX > KVI_IRCTOOLBARCONTAINER_MINIMUM_WIDTH)
		{
			curVertX = 0;
			curVertHeight += KVI_IRCTOOLBARAPPLET_BASE_SIZE + KVI_IRCTOOLBAR_SPACING;
		}
		curVertX += wdth + KVI_IRCTOOLBAR_SPACING;
		if(curVertX >= KVI_IRCTOOLBARAPPLET_MAXIMUM_WIDTH)
		{
			curVertX = 0;
			curVertHeight += KVI_IRCTOOLBARAPPLET_BASE_SIZE + KVI_IRCTOOLBAR_SPACING;
		}
	}
	if(curVertX > 0)curVertHeight += KVI_IRCTOOLBARAPPLET_BASE_SIZE + KVI_IRCTOOLBAR_SPACING;
	m_horizontalSizeHint = QSize(curHorzWidth,KVI_IRCTOOLBARCONTAINER_MINIMUM_HEIGHT);
	m_verticalSizeHint = QSize(KVI_IRCTOOLBARCONTAINER_MINIMUM_WIDTH,curVertHeight);
}

void KviIrcToolBarAppletContainer::addApplet(QWidget *pWidget)
{
	m_pAppletList->append(pWidget);
	recalcSizeHints();
//#if QT_VERSION < 300
	if(m_pAppletList->count() == 1)setMinimumSize(QSize(KVI_IRCTOOLBARCONTAINER_MINIMUM_WIDTH,KVI_IRCTOOLBARCONTAINER_MINIMUM_HEIGHT));
//#endif
	if(parentToolBar())g_pApp->postEvent(parentToolBar(),new QEvent(QEvent::LayoutHint));
	doLayout();
	pWidget->show();
}

void KviIrcToolBarAppletContainer::removeApplet(QWidget *pWidget)
{
	m_pAppletList->removeRef(pWidget);
//#if QT_VERSIOn < 300
	if(m_pAppletList->isEmpty())setMinimumSize(QSize(0,0));
//#endif
	recalcSizeHints();
	if(parentToolBar())g_pApp->postEvent(parentToolBar(),new QEvent(QEvent::LayoutHint));
	doLayout();
}

QSize KviIrcToolBarAppletContainer::sizeHint() const
{
	if(!parentToolBar())return QSize(KVI_IRCTOOLBARCONTAINER_MINIMUM_WIDTH,KVI_IRCTOOLBARCONTAINER_MINIMUM_HEIGHT);
	if(parentToolBar()->orientation() == QToolBar::Horizontal)
		return m_horizontalSizeHint;
	return m_verticalSizeHint;
}


void KviIrcToolBarAppletContainer::doLayout()
{
	if(!parentToolBar())return; //ops...
	if(parentToolBar()->orientation() == QToolBar::Horizontal)
	{
		int curX = 0;
		for(QWidget * w = m_pAppletList->first();w;w = m_pAppletList->next())
		{
			int steps = w->sizeHint().width() / KVI_IRCTOOLBARAPPLET_BASE_SIZE;
			if(steps < 1)steps = 1;
			else if(steps > KVI_IRCTOOLBARMAXALIGNEDAPPLETS)steps = KVI_IRCTOOLBARMAXALIGNEDAPPLETS;
			int wdth = (steps * KVI_IRCTOOLBARAPPLET_BASE_SIZE) + ((steps - 1) * KVI_IRCTOOLBAR_SPACING);
			w->setGeometry(curX,0,wdth,KVI_IRCTOOLBARAPPLET_BASE_SIZE);
			curX += wdth + KVI_IRCTOOLBAR_SPACING;
#ifdef COMPILE_PSEUDO_TRANSPARENCY
			if(w->inherits("KviIrcToolBarGraphicalApplet"))w->update();
#endif
		}
//		setMinimumWidth(curX + 300);
//		/setMinimumHeight(KVI_IRCTOOLBARCONTAINER_MINIMUM_HEIGHT);
	} else {
		int curY = 0;
		int curX = 0;
		for(QWidget *w = m_pAppletList->first();w;w = m_pAppletList->next())
		{
			int steps = w->sizeHint().width() / KVI_IRCTOOLBARAPPLET_BASE_SIZE;
			if(steps < 1)steps = 1;
			else if(steps > KVI_IRCTOOLBARMAXALIGNEDAPPLETS)steps = KVI_IRCTOOLBARMAXALIGNEDAPPLETS;
			int wdth = (steps * KVI_IRCTOOLBARAPPLET_BASE_SIZE) + ((steps - 1) * KVI_IRCTOOLBAR_SPACING);
//			if(wdth + curX > KVI_IRCTOOLBARCONTAINER_MINIMUM_WIDTH)
			if((wdth + curX) > width())
			{
				curX = 0;
				curY += KVI_IRCTOOLBARAPPLET_BASE_SIZE + KVI_IRCTOOLBAR_SPACING;
			}
			w->setGeometry(curX,curY,wdth,KVI_IRCTOOLBARAPPLET_BASE_SIZE);
			curX += wdth + KVI_IRCTOOLBAR_SPACING;
//			if(curX > KVI_IRCTOOLBARAPPLET_MAXIMUM_WIDTH)
//			if(curX > width())
//			{
//				curX = 0;
//				curY += KVI_IRCTOOLBARAPPLET_BASE_SIZE + KVI_IRCTOOLBAR_SPACING;
//			}
#ifdef COMPILE_PSEUDO_TRANSPARENCY
			if(w->inherits("KviIrcToolBarGraphicalApplet"))w->update();
#endif
		}
//		setMinimumWidth(KVI_IRCTOOLBARCONTAINER_MINIMUM_WIDTH);
//		setMinimumHeight(curY);
	}
//	((QWidget *)parentToolBar())->layout()->invalidate();
}

/*
#define COMPILE_GRAPHIC_EXCESS

void KviIrcToolBarAppletContainer::paintEvent(QPaintEvent *e)
{
	if(!isVisible())return;
#ifdef COMPILE_PSEUDO_TRANSPARENCY && defined(COMPILE_GRAPHIC_EXCESS)
	if(g_pShadedChildKdeDesktopBackground)
	{
		XSetTile(g_display,g_iccGC,g_pShadedChildKdeDesktopBackground->handle());
		XSetFillStyle(g_display,g_iccGC,FillTiled);
		QPoint pnt = mapToGlobal(QPoint(0,0));
		XSetTSOrigin(g_display,g_iccGC,-pnt.x(),-pnt.y());
	   	XFillRectangle(g_display,handle(),g_iccGC,e->rect().x(),e->rect().y(),e->rect().width(),e->rect().height());
//		XSetFillStyle(g_display,g_iccGC,FillSolid);
//		XCopyArea(g_display,g_hIccMemBuffer,this->handle(),g_iccGC,e->rect().left(),e->rect().top(),
//			e->rect().width(),e->rect().height(),e->rect().left(),e->rect().top());
	} else {
#endif
		QWidget::paintEvent(e);
#ifdef COMPILE_PSEUDO_TRANSPARENCY && defined(COMPILE_GRAPHIC_EXCESS)
	}
#endif
}
*/


//////////////////////////////////////////////////////////////////////////////
//
// KviIrcContextController
//
//        Container for an irc context
//        Initially contains a "connect button", a "tools button",
//        and an irc context status display
//
//////////////////////////////////////////////////////////////////////////////


KviIrcContextController::KviIrcContextController(KviConsole * pConsole,QWidget * par,KviIrcToolBar * bar)
: KviIrcToolBarAppletContainer(par,"irc_context_controller")
{
	m_pToolBar = bar;
	m_pConsole = pConsole;

	m_pConnectButton = new QToolButton(this,"connect_button");
	m_pConnectButton->setPixmap(*(g_pIconManager->getBigIcon(KVI_BIGICON_CONNECT)));
	m_pConnectButton->setTextLabel(__c2q(__tr("Connect")));
	m_pConnectButton->setUsesBigPixmap(true);
	m_pConnectButton->setAutoRaise(true);
	connect(m_pConnectButton,SIGNAL(clicked()),pConsole,SLOT(connectButtonClicked()));

	QToolButton * m_pToolsButton = new QToolButton(this,"tools_button");
	m_pToolsButton->setPixmap(*(g_pIconManager->getBigIcon(KVI_BIGICON_TOOLS)));
	m_pToolsButton->setTextLabel(__tr("Irc tools"));
	m_pToolsButton->setUsesBigPixmap(true);
	m_pToolsButton->setAutoRaise(true);

	QPopupMenu * popup = new QPopupMenu(this);
	m_pToolsButton->setPopup(popup);
	m_pToolsButton->setPopupDelay(1);
	int id = popup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_SPY)),__c2q(__tr("&Socket Spy")),pConsole,SLOT(executeInternalCommand(int)));
	popup->setItemParameter(id,KVI_INTERNALCOMMAND_SOCKETSPY_OPEN);
	id = popup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_LINKS)),__tr("&Links"),pConsole,SLOT(executeInternalCommand(int)));
	popup->setItemParameter(id,KVI_INTERNALCOMMAND_LINKS_OPEN);
	id = popup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_LIST)),__tr("&Channel list"),pConsole,SLOT(executeInternalCommand(int)));
	popup->setItemParameter(id,KVI_INTERNALCOMMAND_LIST_OPEN);

	QToolButton * m_pActionsButton = new QToolButton(this,"actions_button");
	m_pActionsButton->setPixmap(*(g_pIconManager->getBigIcon(KVI_BIGICON_ACTIONS)));
	m_pActionsButton->setTextLabel(__tr("Actions"));
	m_pActionsButton->setUsesBigPixmap(true);
	m_pActionsButton->setAutoRaise(true);

	m_pActionsPopup = new QPopupMenu(this);
	connect(m_pActionsPopup,SIGNAL(aboutToShow()),this,SLOT(setupActionsPopup()));
	m_pActionsButton->setPopup(m_pActionsPopup);
	m_pActionsButton->setPopupDelay(1);

	// Defer creation
	m_pRecentServersPopup = 0;
	m_pRecentNicknamesPopup = 0;
	m_pRecentChannelsPopup = 0;
	m_pUserModePopup = 0;



	m_pStatusLabel = new KviIrcContextStatusDisplay(this);

	addApplet(m_pStatusLabel);
	addApplet(m_pConnectButton);
	addApplet(m_pActionsButton);
	addApplet(m_pToolsButton);
}

KviIrcContextController::~KviIrcContextController()
{
}

void KviIrcContextController::setupActionsPopup()
{
	m_pActionsPopup->clear();
	int id;

	id = m_pActionsPopup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_AWAY)),__tr("&Away"),this,SLOT(awayClicked()));
	if(!m_pConsole->isConnected())m_pActionsPopup->setItemEnabled(id,false);
	else m_pActionsPopup->setItemChecked(id,m_pConsole->userIsAway());

	if(!m_pUserModePopup)
	{
		m_pUserModePopup = new QPopupMenu(m_pActionsPopup);
		connect(m_pUserModePopup,SIGNAL(aboutToShow()),this,SLOT(setupUserModePopup()));
		connect(m_pUserModePopup,SIGNAL(activated(int)),this,SLOT(userModeSelected(int)));
	}
	id = m_pActionsPopup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_MODE)),__c2q(__tr("&User mode")),m_pUserModePopup);
	if(!m_pConsole->isConnected())m_pActionsPopup->setItemEnabled(id,false);
	m_pActionsPopup->insertSeparator();

	if(!m_pRecentChannelsPopup)
	{
		m_pRecentChannelsPopup = new QPopupMenu(m_pActionsPopup);
		connect(m_pRecentChannelsPopup,SIGNAL(aboutToShow()),this,SLOT(setupRecentChannelsPopup()));
		connect(m_pRecentChannelsPopup,SIGNAL(activated(int)),this,SLOT(recentChannelSelected(int)));
	}
	id = m_pActionsPopup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_CHANNEL)),__c2q(__tr("&Recent channels")),m_pRecentChannelsPopup);
	if(!m_pConsole->isConnected())m_pActionsPopup->setItemEnabled(id,false);

	if(!m_pRecentNicknamesPopup)
	{
		m_pRecentNicknamesPopup = new QPopupMenu(m_pActionsPopup);
		connect(m_pRecentNicknamesPopup,SIGNAL(aboutToShow()),this,SLOT(setupRecentNicknamesPopup()));
		connect(m_pRecentNicknamesPopup,SIGNAL(activated(int)),this,SLOT(recentNicknameSelected(int)));
	}
	id = m_pActionsPopup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_NICK)),__c2q(__tr("&Recent nicknames")),m_pRecentNicknamesPopup);
	if(!m_pConsole->isConnected())m_pActionsPopup->setItemEnabled(id,false);

	m_pActionsPopup->insertSeparator();

	if(!m_pRecentServersPopup)
	{
		m_pRecentServersPopup = new QPopupMenu(m_pActionsPopup);
		connect(m_pRecentServersPopup,SIGNAL(aboutToShow()),this,SLOT(setupRecentServersPopup()));
		connect(m_pRecentServersPopup,SIGNAL(activated(int)),this,SLOT(recentServerSelected(int)));
	}
	m_pActionsPopup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_SERVER)),__c2q(__tr("&Recent servers")),m_pRecentServersPopup);

}

void KviIrcContextController::setupRecentServersPopup()
{
	g_pApp->fillRecentServersPopup(m_pRecentServersPopup);
}

void KviIrcContextController::setupRecentNicknamesPopup()
{
	g_pApp->fillRecentNicknamesPopup(m_pRecentNicknamesPopup,m_pConsole);
}

void KviIrcContextController::setupRecentChannelsPopup()
{
	g_pApp->fillRecentChannelsPopup(m_pRecentChannelsPopup,m_pConsole);
}

void KviIrcContextController::setupUserModePopup()
{
	m_pUserModePopup->clear();
	int id;
	id = m_pUserModePopup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_WALLOPS)),__tr("w (Wallops)"));
	m_pUserModePopup->setItemChecked(id,m_pConsole->hasUserMode('w'));
	id = m_pUserModePopup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_SERVERNOTICE)),__c2q(__tr("s (Server notices)")));
	m_pUserModePopup->setItemChecked(id,m_pConsole->hasUserMode('s'));
	id = m_pUserModePopup->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_INVISIBLE)),__c2q(__tr("i (Invisible)")));
	m_pUserModePopup->setItemChecked(id,m_pConsole->hasUserMode('i'));
}

void KviIrcContextController::awayClicked()
{
	if(!m_pConsole->isConnected())return;
	KviStr command = "if($away)back; else away";
	g_pUserParser->parseCommandBuffer(command.ptr(),m_pConsole);
}

void KviIrcContextController::userModeSelected(int id)
{
	KviStr text = m_pUserModePopup->text(id);
	if(!m_pConsole->isConnected())return;
	if(text.hasData())
	{
		text.cutFromFirst(' ');
		KviStr command = "mode ";
		command.append(m_pConsole->currentNickName());
		command.append(m_pConsole->hasUserMode(*(text.ptr())) ? " -" : " +");
		command.append(*(text.ptr()));
		g_pUserParser->parseCommandBuffer(command.ptr(),m_pConsole);
	}
}

void KviIrcContextController::recentChannelSelected(int id)
{
	KviStr text = m_pRecentChannelsPopup->text(id);
	if(text.hasData())
	{
		text.prepend("join ");
		g_pUserParser->parseCommandBuffer(text.ptr(),m_pConsole);
	}
}

void KviIrcContextController::recentServerSelected(int id)
{
	KviStr text = m_pRecentServersPopup->text(id);
	if(text.hasData())
	{
		KviStr szCommand;
		if(parseIrcUrl(text.ptr(),szCommand,KVI_IRCURL_CONTEXT_THIS))
		{
			g_pUserParser->parseCommandBuffer(szCommand.ptr(),m_pConsole);
		}
	}
}

void KviIrcContextController::recentNicknameSelected(int id)
{
	KviStr text = m_pRecentNicknamesPopup->text(id);
	if(text.hasData())
	{
		text.prepend("nick ");
		g_pUserParser->parseCommandBuffer(text.ptr(),m_pConsole);
	}
}





//////////////////////////////////////////////////////////////////////////////
//
// KviIrcToolBar
//
//      A KVIrc irc toolbar
//      Contains a stack of KviIrcContextController widgets
//      and a frame widget applet container that manages
//      frame widge applets that are not bound to any irc context
//
//////////////////////////////////////////////////////////////////////////////

KviIrcToolBar::KviIrcToolBar(KviFrame * pFrm,const char * name)
#if QT_VERSION >= 300
: KviTalToolBar(__tr("IrcToolBar"),pFrm,Qt::DockTop,false,name)
#else
: KviTalToolBar(__tr("IrcToolBar"),pFrm,QMainWindow::Top,false,name)
#endif
{
	m_pIccStack = new QWidgetStack(this,"icc_stack");
	addSeparator();
	m_pFrameWideContainer = new KviIrcToolBarAppletContainer(this,"frame_applet_container");
	m_pFrameWideContainer->setParentToolBar(this);
	setStretchableWidget(m_pFrameWideContainer);
	setVerticalStretchable(true);
	setHorizontalStretchable(true);
	m_pNullController = 0;
	m_pFrm = pFrm;
	m_pFrameWideContainer->show();
	m_pIccStack->show();
//	setBackgroundMode(QWidget::NoBackground);
}


KviIrcToolBar::~KviIrcToolBar()
{
	// check if we can reparent the frame wide applets to some other irc toolbar in this frame...
	KviIrcToolBar * tb = m_pFrm->findFriendToolBar(this);
	if(tb)
	{
		// hoho....have a friend tool bar...
		m_pFrameWideContainer->reparentApplets(tb->frameWideContainer());
	} // else no firends....sigh.... our frame wide applets are going to die
}

void KviIrcToolBar::updatePseudoTransparency()
{
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	QObjectList * l = queryList("KviIrcToolBarAppletContainer");
	if(l)
	{
		QObjectListIt it(*l);
		if(it.current())
		{
			((KviIrcToolBarAppletContainer *)(it.current()))->updateGraphicalApplets();
		}
		delete l;
	}
#endif
}

void KviIrcToolBar::reparentChildren(KviIrcToolBar * target)
{
	QObjectList * l = m_pIccStack->queryList("KviIrcContextController");
	if(l)
	{
		QObjectListIt it(*l);
		while(it.current())
		{
			m_pIccStack->removeWidget(((QWidget *)it.current()));
			((QWidget *)it.current())->reparent(target->iccStack(),QPoint(0,0));
			target->addController(((KviIrcContextController *)it.current()));
			++it;
		}
	}
	m_pFrameWideContainer->reparentApplets(target->frameWideContainer());
}

void KviIrcToolBar::addController(KviIrcContextController * pController)
{
	m_pIccStack->addWidget(pController,0);
	pController->setParentToolBar(this);
	m_pIccStack->raiseWidget(pController);
	m_pIccStack->updateGeometry();
	updateGeometry();
	//adjustSize();
}

void KviIrcToolBar::removeController(KviIrcContextController * pController)
{
	removeControllerNoDelete(pController);
	delete pController;
}

void KviIrcToolBar::removeControllerNoDelete(KviIrcContextController * pController)
{
	bool bIsTopWidget = (pController == m_pIccStack->visibleWidget());
	m_pIccStack->removeWidget(pController);
	if(!bIsTopWidget)return;
	QObjectList * l = m_pIccStack->queryList("KviIrcContextController");
	if(l)
	{
		QObjectListIt it(*l);
		if(it.current())
		{
			m_pIccStack->raiseWidget(((QWidget *)(it.current())));
			delete l;
			return;
		}
		delete l;
	}
	if(m_pNullController)m_pIccStack->raiseWidget(m_pNullController);
}

void KviIrcToolBar::setCurrentController(KviIrcContextController * pController)
{
	if(pController)m_pIccStack->raiseWidget(pController);
	else {
		// we need to show a "null" controller...
		if(!m_pNullController)
		{
			m_pNullController = new QLabel(__tr("No irc context"),m_pIccStack);
			m_pNullController->setAlignment(AlignCenter);
			//m_pNullController->setFixedHeight(QSize(KVI_IRCTOOLBARCONTAINER_MINIMUM_WIDTH,KVI_IRCTOOLBARAPPLET_BASE_SIZE));
			m_pIccStack->addWidget(m_pNullController,0);
		}
		m_pIccStack->raiseWidget(m_pNullController);
	}
//	QPainter p(this);
//	drawHandle(&p);
}


static void draw_frame_helper(QPainter * p,int x1,int y1,int x2,int y2,QColor light,QColor dark)
{
	p->setPen(light);
	p->drawLine(x1,y1,x2,y1);
	p->drawLine(x1,y1,x1,y2);

	p->setPen(dark);
	p->drawLine(x1,y2,x2,y2);
	p->drawLine(x2,y1,x2,y2);
}

#ifdef Bool
	#undef Bool
#endif

#include "kvi_irctoolbar.moc"
