#ifndef _KVI_FRAME_H_
#define _KVI_FRAME_H_

//
//   File : kvi_frame.h
//   Creation date : Sun Jun 18 2000 17:59:02 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include "kvi_tal_mainwindow.h"

#include "kvi_list.h"

class KviMenuBar;
class KviMdiManager;
class KviMdiChild;
class KviWindow;
class KviConsole;
class KviTaskBarBase;
class KviIrcToolBar;
class KviIrcToolBarAppletContainer;
class QSplitter;
class KviConfig;
class QAccel;

#ifdef COMPILE_ON_WINDOWS
	// MSCV has problems with KviPtrList<KviWindow> otherwise
	#include "kvi_window.h"
#endif

class KVIRC_API KviDockExtension
{
public:
	KviDockExtension(){};
	~KviDockExtension(){};
public:
	virtual void refresh(){};
	virtual void die(){ delete this; };
};

class KVIRC_API KviFrame : public KviTalMainWindow
{
	friend class KviWindow;
	friend class KviConsole;
	friend class KviApp;
	friend class KviServerParser;
	Q_OBJECT
public:
	KviFrame(unsigned int id,const char * name);
	~KviFrame();
protected:
	QSplitter                      * m_pSplitter;
	KviMenuBar                     * m_pMenuBar;
	KviMdiManager                  * m_pMdi;
	KviTaskBarBase                 * m_pTaskBar;
	KviPtrList<KviWindow>          * m_pWinList;
	KviWindow                      * m_pActiveWindow;
	KviIrcToolBar                  * m_pIrcToolBar;
	KviDockExtension               * m_pDockExtension;
public:
	void                           updateCaption();
	KviMdiManager                * mdiManager(){ return m_pMdi; };
	KviWindow                    * activeWindow();
	KviPtrList<KviWindow>        * windowList() { return m_pWinList; };
	QSplitter                    * splitter(){ return m_pSplitter; };
	KviConsole                   * createNewConsole(bool bFirstInFrame = false);
	KviIrcToolBar                * findFriendToolBar(KviIrcToolBar * bar);
	KviIrcToolBar                * ircToolBar(){ return m_pIrcToolBar; }; // returns 0 if in multi toolbar mode
	KviIrcToolBar                * getIrcToolBar(); // returns always a toolbar, the main one or a new one
	KviIrcToolBarAppletContainer * frameAppletContainer();

	void                           setDockExtension(KviDockExtension * e){ m_pDockExtension = e; };
	KviDockExtension             * dockExtension(){ return m_pDockExtension; };

	void                           setActiveWindow(KviWindow *wnd);
	void                           addWindow(KviWindow *wnd,bool bShow = true); // public for modules
	unsigned int consoleCount();
	KviConsole * firstConsole();
	KviConsole * firstNotConnectedConsole();
	KviTaskBarBase * taskBar(){ return m_pTaskBar; };
	KviMenuBar * mainMenuBar(){ return m_pMenuBar; };
	bool windowExists(KviWindow * wnd){ return (m_pWinList->findRef(wnd) != -1); };
	void saveWindowProperties(KviWindow * wnd,const char * szSection);
public slots:
	void newConsole();
protected:
	void createTaskBar();
	void recreateTaskBar();
	KviMdiChild * dockWindow(KviWindow *wnd,bool bShow = true,bool bCascade = true,QRect * setGeom = 0);
	void undockWindow(KviWindow *wnd);
	void closeWindow(KviWindow *wnd);
	void childWindowCloseRequest(KviWindow *wnd);
	void childWindowGainFocus(KviWindow *wnd);
	virtual void closeEvent(QCloseEvent *e);
	virtual void resizeEvent(QResizeEvent *e);
	virtual void moveEvent(QMoveEvent *e);
	virtual bool focusNextPrevChild(bool next);
	void updatePseudoTransparency();
	QAccel * installAccelerators(QWidget * wnd);
	void switchToNextWindow();
	void switchToPrevWindow();
	void switchToNextWindowInContext();
	void switchToPrevWindowInContext();
	void maximizeWindow();
	void minimizeWindow();
protected slots:
	void accelActivated(int id);
	void enteredSdiMode();
	void leftSdiMode();
//	void createMdiHelpBrowser();
//	void createStaticHelpBrowser();
	void executeInternalCommand(int index);
	void updateIrcToolBars();
protected:
	void applyOptions();
private:
	void saveToolBarPositions();
	void restoreToolBarPositions();
#if QT_VERSION < 300
	void saveToolBarState(QToolBar * t,KviConfig * cfg);
	void restoreToolBarState(QToolBar * t,KviConfig * cfg,QMainWindow::ToolBarDock defDock,int defIndex,bool bDefNewline,int defExtra);
#endif
};

#endif //_KVI_FRAME_H_
