//
//   File : kvi_frame.cpp
//   Creation date : Sun Jun 18 2000 17:59:02 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__
#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_settings.h"
#include "kvi_frame.h"
#include "kvi_options.h"
#include "kvi_menubar.h"
#include "kvi_mdimanager.h"
#include "kvi_mdichild.h"
#include "kvi_iconmanager.h"
#include "kvi_window.h"
#include "kvi_taskbar.h"
#include "kvi_console.h"
#include "kvi_config.h"
#include "kvi_internalcmd.h"
#include "kvi_uparser.h"
#include "kvi_console.h"
#include "kvi_debug.h"
#include "kvi_irctoolbar.h"
#include "kvi_confignames.h"
#include "kvi_event.h"
#include "kvi_parameterlist.h"

#include <qsplitter.h>
#include <qvariant.h>
#include <qlineedit.h>
#include <qobjcoll.h>
#include <qaccel.h>

#if QT_VERSION >= 300
	#include <qfile.h>
	#include <qtextstream.h>
#endif

#include <time.h>

#ifdef COMPILE_PSEUDO_TRANSPARENCY
	#include <qpixmap.h>
	// kvi_app.h
	extern QPixmap * g_pShadedParentGlobalDesktopBackground;
	extern QPixmap * g_pShadedChildGlobalDesktopBackground;
// FIXME: #warning "When a toolbar is moved , MdiManager is resized but does not update the MdiChild backgrounds"
#endif

// FIXME: #warning "LAG-O-METER : With PINGS to server , disconnect and reconnect on lag too big"
// FIXME: #warning "Randomly colored nicknames, (easy reading of the channel)"

// Declared and managed by KviApp (kvi_app.cpp)
extern KviConfig * g_pWinPropertiesConfig;

KviFrame::KviFrame(unsigned int id,const char * name)
: KviTalMainWindow(0,name)
{
	setIcon(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_KVIRC)));

	m_pWinList  = new KviPtrList<KviWindow>;
	m_pWinList->setAutoDelete(false);

	m_pActiveWindow = 0;

	m_pDockExtension = 0;

	m_pSplitter = new QSplitter(QSplitter::Horizontal,this,"main_splitter");
	setCentralWidget(m_pSplitter);

	m_pMdi      = new KviMdiManager(m_pSplitter,this,"mdi_manager");

	connect(m_pMdi,SIGNAL(enteredSdiMode()),this,SLOT(enteredSdiMode()));
	connect(m_pMdi,SIGNAL(leftSdiMode()),this,SLOT(leftSdiMode()));

	m_pMenuBar   = new KviMenuBar(this,"main_menu_bar"); // This theoretically had to exists before KviMdiManager (that uses enterSdiMode)

	m_pTaskBar = 0;

	createTaskBar();

	if(KVI_OPTION_BOOL(KviOption_boolSingleIrcToolBar))
	{
		m_pIrcToolBar = new KviIrcToolBar(this,"main_irc_toolbar");
	} else {
		m_pIrcToolBar = 0;
	}

	resize(KVI_OPTION_RECT(KviOption_rectFrameGeometry).width(),
		KVI_OPTION_RECT(KviOption_rectFrameGeometry).height());
	move(KVI_OPTION_RECT(KviOption_rectFrameGeometry).x(),
		KVI_OPTION_RECT(KviOption_rectFrameGeometry).y());

	restoreToolBarPositions();

	applyOptions();

	installAccelerators(this);
}

KviFrame::~KviFrame()
{
	KVI_OPTION_RECT(KviOption_rectFrameGeometry) = QRect(pos().x(),pos().y(),
			size().width(),size().height());

	saveToolBarPositions();

	if(m_pDockExtension)
	{
		m_pDockExtension->die();
		m_pDockExtension = 0;
	}

	while(m_pWinList->first())closeWindow(m_pWinList->first());
	delete m_pWinList;
}

QAccel * KviFrame::installAccelerators(QWidget * wnd)
{
	QAccel *ac = new QAccel(wnd ? (QWidget *)wnd : (QWidget *)this);

	static int accel_table[] = {
		Key_Left + CTRL ,    // prev window
		Key_Right + CTRL ,   // next window
		Key_Up + CTRL ,      // maximize window
		Key_Down + CTRL ,    // minimize window
		Key_Escape ,         // minimize window
		Key_Left + ALT ,     // prev window in context
		Key_Right + ALT ,    // next window in context
		Key_1 + CTRL ,       // script accels...
		Key_2 + CTRL ,
		Key_3 + CTRL ,
		Key_4 + CTRL ,
		Key_5 + CTRL ,
		Key_6 + CTRL ,
		Key_7 + CTRL ,
		Key_8 + CTRL ,
		Key_9 + CTRL ,
		Key_0 + CTRL ,
		Key_F1 ,
		Key_F2 ,
		Key_F3 ,
		Key_F4 ,
		Key_F5 ,
		Key_F6 ,
		Key_F7 ,
		Key_F8 ,
		Key_F9 ,
		Key_F10 ,
		Key_F11 ,
		Key_F12 ,
		Key_F1 + SHIFT ,
		Key_F2 + SHIFT ,
		Key_F3 + SHIFT ,
		Key_F4 + SHIFT ,
		Key_F5 + SHIFT ,
		Key_F6 + SHIFT ,
		Key_F7 + SHIFT ,
		Key_F8 + SHIFT ,
		Key_F9 + SHIFT ,
		Key_F10 + SHIFT ,
		Key_F11 + SHIFT ,
		Key_F12 + SHIFT ,
		0
	};

	int i=0;
	int keys;
	while(keys = accel_table[i])
	{
		ac->insertItem(keys);
		i++;
	}

	connect(ac,SIGNAL(activated(int)),this,SLOT(accelActivated(int)));
	return ac;
}

void KviFrame::accelActivated(int id)
{
	QAccel * acc = (QAccel *)sender();

	int keys = (int)(acc->key(id));

//	KviStr keysstr = (QString)(acc->key(id));
//
//	debug("Accel keys: %s",keysstr.ptr());

	switch(keys)
	{
		case (Key_Left+CTRL):  switchToPrevWindow(); break;
		case (Key_Right+CTRL): switchToNextWindow(); break;
		case (Key_Up+CTRL):    maximizeWindow(); break;
		case (Key_Escape):
		case (Key_Down+CTRL):  minimizeWindow(); break;
		case (Key_Left+ALT):   switchToPrevWindowInContext(); break;
		case (Key_Right+ALT):  switchToNextWindowInContext(); break;
		default:
		{
//			debug("Unhandled accel keys %d",keys);
#if QT_VERSION >= 300
			KviStr * keysstr = new KviStr((QString)(acc->key(id)));
#else
			KviStr * keysstr = new KviStr(QAccel::keyToString(acc->key(id)));
#endif
			TRIGGER_EVENT_1PARAM_NONEW(KviEvent_OnAccelKeyPressed,activeWindow(),keysstr);
		}
		break;
	};
}

void KviFrame::executeInternalCommand(int index)
{
	g_pUserParser->parseCommandBuffer(kvi_getInternalCommandBuffer(index),firstConsole());
}


void KviFrame::saveWindowProperties(KviWindow * wnd,const char * szSection)
{
	g_pWinPropertiesConfig->setGroup(szSection);
	g_pWinPropertiesConfig->writeEntry("EntryTimestamp",(unsigned int)time(0));

	// Allow max 30 window properties to be floating around
	while(g_pWinPropertiesConfig->groupsCount() > 30)
	{
		// Kill the oldest group
		KviConfigIterator it(*(g_pWinPropertiesConfig->dict()));
		KviStr minKey;
		unsigned int minVal = time(0);
		while(it.current() && minVal)
		{
			KviStr * pVal = it.current()->find("EntryTimestamp");
			if(pVal)
			{
				bool bOk;
				unsigned int uVal = pVal->toUInt(&bOk);
				if(bOk)
				{
					if(uVal < minVal)
					{
						minVal = uVal;
						minKey = it.currentKey();
					}
				} else {
					minVal = 0;
					minKey = it.currentKey();
				}
			} else {
				minVal = 0;
				minKey = it.currentKey();
			}
			++it;
		}

		if(minKey.hasData())g_pWinPropertiesConfig->clearGroup(minKey.ptr());
		else debug("Oops...no minimum key found!");
	}

	// The following line should NOT be needed...but just to be sure...
	g_pWinPropertiesConfig->setGroup(szSection);

	g_pWinPropertiesConfig->writeEntry("IsDocked",wnd->mdiParent());
// FIXME: #warning "IS MAXIMIZED IF THE TOP WINDOW IS MAXIMIZED!!!"
	g_pWinPropertiesConfig->writeEntry("IsMaximized",wnd->isMaximized());
	g_pWinPropertiesConfig->writeEntry("WinRect",wnd->externalGeometry());

	wnd->saveProperties(g_pWinPropertiesConfig);
}


void KviFrame::closeWindow(KviWindow *wnd)
{
	if(KVI_OPTION_BOOL(KviOption_boolWindowsRememberProperties) && (wnd->type() == KVI_WINDOW_TYPE_CHANNEL))
	{
		KviStr group;
		wnd->getConfigGroupName(group);
		saveWindowProperties(wnd,group.ptr());
	}

	if(wnd == m_pActiveWindow)
	{
		m_pActiveWindow = 0;
		if(wnd == g_pApp->m_pActiveWindow)g_pApp->m_pActiveWindow = 0;
	}

	m_pWinList->removeRef(wnd);

	if(wnd->mdiParent())m_pMdi->destroyChild(wnd->mdiParent(),true);
	else delete wnd;
}



void KviFrame::addWindow(KviWindow *wnd,bool bShow)
{
	m_pWinList->append(wnd);

	KviStr group;
	wnd->getConfigGroupName(group);

	if(g_pWinPropertiesConfig->hasGroup(group.ptr()))
		g_pWinPropertiesConfig->setGroup(group.ptr());
	else
		g_pWinPropertiesConfig->setGroup(wnd->typeString());

	bool bDocked    = g_pWinPropertiesConfig->readBoolEntry("IsDocked",true);
	bool bMaximized = g_pWinPropertiesConfig->readBoolEntry("IsMaximized",false);
	QRect rect      = g_pWinPropertiesConfig->readRectEntry("WinRect",QRect(10,10,500,380));

	wnd->loadProperties(g_pWinPropertiesConfig); // load it anyway (will set defaults if windows don't remember properties)

	if(KVI_OPTION_BOOL(KviOption_boolWindowsRememberProperties))
	{
		if(bDocked)
		{
			KviMdiChild * lpC = dockWindow(wnd,false,false,&rect);
			wnd->triggerCreationEvents();
			if(bShow)m_pMdi->showAndActivate(lpC);
			if(bMaximized && bShow)wnd->maximize();
		} else {
			wnd->setGeometry(rect);
			wnd->triggerCreationEvents();
			if(bShow)
			{
				wnd->show();
				if(bMaximized)wnd->maximize();
			}
			wnd->youAreUndocked();
			if(bShow)
			{
				wnd->raise();
				wnd->setFocus();
			}
		}
	} else {
		KviMdiChild * lpC = dockWindow(wnd,false,true); //cascade it
		wnd->triggerCreationEvents();
		if(bShow)m_pMdi->showAndActivate(lpC);
	}
}

KviMdiChild * KviFrame::dockWindow(KviWindow *wnd,bool bShow,bool bCascade,QRect *setGeom)
{
	if(wnd->mdiParent())return wnd->mdiParent();
	KviStr tmp(KviStr::Format,"mdi_child_%s",wnd->name());
	KviMdiChild * lpC = new KviMdiChild(m_pMdi,tmp.ptr());
	lpC->setClient(wnd);
	wnd->youAreDocked();
	m_pMdi->manageChild(lpC,bCascade,setGeom);
	if(bShow)m_pMdi->showAndActivate(lpC);
	return lpC;
}

void KviFrame::undockWindow(KviWindow *wnd)
{
	if(!(wnd->mdiParent()))return;
	KviMdiChild * lpC = wnd->mdiParent();
	lpC->unsetClient();
	m_pMdi->destroyChild(lpC,false);
	wnd->youAreUndocked();
	wnd->raise();
	wnd->setFocus();
}


void KviFrame::newConsole()
{
	createNewConsole();
}

KviConsole * KviFrame::createNewConsole(bool bFirstInFrame)
{
	static unsigned int uNextIrcContextId = 0;
	int iFlags = uNextIrcContextId == 0 ? KVI_CONSOLE_FLAG_FIRSTINAPP : 0;
	uNextIrcContextId++;
	if(bFirstInFrame)iFlags |= KVI_CONSOLE_FLAG_FIRSTINFRAME;
	KviConsole * c = new KviConsole(this,uNextIrcContextId,"CONSOLE",iFlags);
	addWindow(c);
	return c;
}

unsigned int KviFrame::consoleCount()
{
	unsigned int count = 0;
	for(KviWindow * wnd = m_pWinList->first();wnd;wnd = m_pWinList->next())
	{
		if(wnd->type() == KVI_WINDOW_TYPE_CONSOLE)count++;
	}
	return count;
}

KviConsole * KviFrame::firstConsole()
{
	for(KviWindow * wnd = m_pWinList->first();wnd;wnd = m_pWinList->next())
	{
		if(wnd->type() == KVI_WINDOW_TYPE_CONSOLE)return (KviConsole *)wnd;
	}
	__range_valid(false);
	return 0; //newer here!
}

KviConsole * KviFrame::firstNotConnectedConsole()
{
//	debug("Looking for an available console (%d)",m_pWinList->count());
	for(KviWindow * wnd = m_pWinList->first();wnd;wnd = m_pWinList->next())
	{
//		debug("Caption %s",wnd->plainTextCaption());
		if(wnd->type() == KVI_WINDOW_TYPE_CONSOLE)
		{
//			debug("Found console %u",((KviConsole *)wnd)->ircContextId());
			if(!((KviConsole *)wnd)->connectionInProgress())
				return (KviConsole *)wnd;
//			debug("But has connection in progress");
		}// else debug("Not a console");
	}
//	debug("No available consoles");
	return 0;
}

KviWindow * KviFrame::activeWindow()
{
	return m_pActiveWindow ? m_pActiveWindow : m_pWinList->first();
}

void KviFrame::childWindowCloseRequest(KviWindow *wnd)
{
//	switch(wnd->type())
//	{
//		case KVI_WINDOW_TYPE_CONSOLE:
//			if(wnd->isNotConnected())closeWindow(wnd);
//			else {
//				// Attempt to disconnect first
//				
//			}
//		break;
//		case KVI_WINDOW_TYPE_CHANNEL:
//			
//		break;
//		default: closeWindow(wnd); break;
//	}
	closeWindow(wnd);
}

KviIrcToolBar * KviFrame::getIrcToolBar()
{
	if(KVI_OPTION_BOOL(KviOption_boolSingleIrcToolBar))
	{
		__range_valid(m_pIrcToolBar);
		return m_pIrcToolBar;
	} else {
		KviIrcToolBar * tb = new KviIrcToolBar(this,"main_irc_toolbar");
		tb->show();
		return tb;
	}
}

KviIrcToolBarAppletContainer * KviFrame::frameAppletContainer()
{
	if(m_pIrcToolBar)return m_pIrcToolBar->frameWideContainer();
	else return firstConsole()->icController()->parentToolBar()->frameWideContainer();
}

KviIrcToolBar * KviFrame::findFriendToolBar(KviIrcToolBar * bar)
{
	QObjectList * l = queryList("KviIrcToolBar");
	if(!l)return 0;
	QObjectListIt it(*l);
	KviIrcToolBar * fr = 0;
	while(it.current() && (!fr))
	{
		if(((KviIrcToolBar *)it.current()) != bar)fr = (KviIrcToolBar *)it.current(); // got a friend tool bar!
		++it;
	}
	delete l;
	return fr;
}

void KviFrame::updateIrcToolBars()
{
	if(KVI_OPTION_BOOL(KviOption_boolSingleIrcToolBar))
	{
		if(m_pIrcToolBar == 0)
		{
			// All the irc toolbars must reparent their applets to one
			//__range_invalid(m_pIrcToolBar);
	
			QObjectList * l = queryList("KviIrcToolBar");
			if(!l)return; // ops ?
	
			m_pIrcToolBar = new KviIrcToolBar(this,"main_irc_tool_bar");
	
			QObjectListIt it(*l);
			while(it.current())
			{
				((KviIrcToolBar *)it.current())->reparentChildren(m_pIrcToolBar);
				delete it.current();
				++it;
			}
			delete l;
	
			m_pIrcToolBar->show();
	
			KviWindow * oldAct = m_pActiveWindow;
			m_pActiveWindow = 0;
			childWindowGainFocus(oldAct);
		}

	} else {
		// The single irc toolbar must split her controllers thru multiple toolbars

		if(m_pIrcToolBar)
		{
			// n-1 controllers get reparented
	
			bool bFirst = true;
	
			for(KviWindow * wnd = m_pWinList->first();wnd;wnd = m_pWinList->next())
			{
				if(wnd->type() == KVI_WINDOW_TYPE_CONSOLE)
				{
					if(!bFirst)
					{
						KviIrcToolBar * tb = getIrcToolBar();
						tb->removeControllerNoDelete(((KviConsole *)wnd)->icController());
						((KviConsole *)wnd)->icController()->reparent(tb->iccStack(),QPoint(0,0));
						tb->addController(((KviConsole *)wnd)->icController());
					} else {
						bFirst = false; // skip the first one
					}
				}
			}
	
			m_pIrcToolBar = 0;
		}
	}
}

void KviFrame::setActiveWindow(KviWindow *wnd)
{
	if(wnd->isMinimized())wnd->restore();
	if(wnd->mdiParent())wnd->setFocus();
	else wnd->delayedAutoRaise();
}

void KviFrame::childWindowGainFocus(KviWindow *wnd)
{
	KviConsole * lastConsole = m_pActiveWindow ? m_pActiveWindow->console() : 0;
	if(!windowExists(lastConsole))lastConsole = 0;

	m_pActiveWindow = wnd;
	g_pApp->m_pActiveWindow = wnd;
	if(wnd->isMaximized() && wnd->mdiParent())updateCaption();

	if(KVI_OPTION_BOOL(KviOption_boolSingleIrcToolBar))
	{
		// hide all the iccontrollers...
		if(wnd->console())
		{
			m_pIrcToolBar->setCurrentController(wnd->console()->icController());
		} else {
			m_pIrcToolBar->setCurrentController(0);
		}
	} else {
		if(lastConsole != wnd->console())
		{
			if(wnd->console())wnd->console()->icController()->updateGraphicalApplets(); // Active state change
			if(lastConsole)lastConsole->icController()->updateGraphicalApplets();       // same as above
		}
	}

	TRIGGER_EVENT(KviEvent_OnWindowActivated,wnd);
}


void KviFrame::enteredSdiMode()
{
	updateCaption();
}

void KviFrame::leftSdiMode()
{
	updateCaption();
}

void KviFrame::updateCaption()
{
	KviWindow *w = activeWindow();
	if(w)
	{
		if(w->isMaximized() && w->mdiParent())
		{
			KviStr tmp(KviStr::Format,"%s %s",w->plainTextCaption(),KVI_OPTION_STRING(KviOption_stringFrameCaption).ptr());
			setCaption(tmp.ptr());
			return;
		}
	}
	setCaption(KVI_OPTION_STRING(KviOption_stringFrameCaption).ptr());
}

void KviFrame::closeEvent(QCloseEvent *e)
{
	e->ignore();
	g_pApp->destroyFrame(this);
}

void KviFrame::resizeEvent(QResizeEvent *e)
{
	KVI_OPTION_RECT(KviOption_rectFrameGeometry) = QRect(pos().x(),pos().y(),
			size().width(),size().height());
	KviTalMainWindow::resizeEvent(e);
}

void KviFrame::updatePseudoTransparency()
{
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	if(g_pShadedParentGlobalDesktopBackground)m_pMdi->update();

	if(g_pShadedChildGlobalDesktopBackground)
	{
		for(KviWindow * wnd = m_pWinList->first();wnd;wnd = m_pWinList->next())wnd->updateBackgrounds();
		QObjectList * l = queryList("KviIrcToolBar");
		if(l)
		{
			QObjectListIt it(*l);
			while(it.current())
			{
				((KviIrcToolBar *)(it.current()))->updatePseudoTransparency();
				++it;
			}
			delete l;
		}
		m_pTaskBar->updatePseudoTransparency();
	}
#endif
}

void KviFrame::moveEvent(QMoveEvent *e)
{
	KVI_OPTION_RECT(KviOption_rectFrameGeometry) = QRect(pos().x(),pos().y(),
			size().width(),size().height());
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	updatePseudoTransparency();
#endif
	KviTalMainWindow::moveEvent(e);
}

void KviFrame::applyOptions()
{
	m_pMdi->update();
	for(KviWindow * wnd = m_pWinList->first();wnd;wnd = m_pWinList->next())wnd->applyOptions();

	updateCaption();
}

bool KviFrame::focusNextPrevChild(bool next)
{
	QWidget * w = focusWidget();
	if(w)
	{
		QVariant v = w->property("KviProperty_FocusOwner");
		if(v.isValid())return false; // Do NOT change the focus widget!
		if(w->parent())v = w->parent()->property("KviProperty_ChildFocusOwner");
		if(v.isValid())return false; // Do NOT change the focus widget!
	}
	return KviTalMainWindow::focusNextPrevChild(next);
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Toolbar positioning stuff
////////////////////////////////////////////////////////////////////////////////////////////////////

#if QT_VERSION < 300

static QMainWindow::ToolBarDock g_dockSites[7]= {
	QMainWindow::Top ,
	QMainWindow::Left ,
	QMainWindow::Right ,
	QMainWindow::Bottom ,
	QMainWindow::TornOff ,
	QMainWindow::Unmanaged ,
	QMainWindow::Minimized
};

#endif

void KviFrame::saveToolBarPositions()
{
	KviStr szTemp;
	g_pApp->getLocalKvircDirectory(szTemp,KviApp::Config,KVI_CONFIGFILE_TOOLBARS);

#if QT_VERSION < 300

	KviConfig cfg(szTemp.ptr());

	int idx = 0;

	for(int i=0;i<7;i++)
	{
		KviPtrList<QToolBar> l = toolBars(g_dockSites[i]);
	
		for(QToolBar * b = l.first();b;b = l.next())
		{
			if(b->parent() == this)
			{
				cfg.setGroup("Main");
				KviStr tmp(KviStr::Format,"Toolbar%d",idx);
				KviStr lab = b->label();
				cfg.writeEntry(tmp.ptr(),lab.ptr());
				saveToolBarState(b,&cfg);
			}
			idx++;
		}
	}

	cfg.setGroup("Main");
	cfg.writeEntry("NumToolbars",idx);
#else
	QFile f(szTemp.ptr());
	if(f.open(IO_WriteOnly | IO_Truncate))
	{
		QTextStream ts(&f);
		ts << *this;
		f.close();
	}
#endif
}


void KviFrame::restoreToolBarPositions()
{
	KviStr szTemp;
	g_pApp->getLocalKvircDirectory(szTemp,KviApp::Config,KVI_CONFIGFILE_TOOLBARS);

#if QT_VERSION < 300
	KviConfig cfg(szTemp.ptr());
	cfg.setGroup("Main");

	int nToolbars = cfg.readIntEntry("NumToolbars",0);

	if(nToolbars > 0)
	{
		for(int i=0;i<nToolbars;i++)
		{
			cfg.setGroup("Main");
			KviStr tmp(KviStr::Format,"Toolbar%d",i);
			KviStr label = cfg.readEntry(tmp.ptr(),"");
			if(label.hasData())
			{
				QObjectList * l = queryList("QToolBar",0,false,false);
				if(l)
				{
					QObjectListIt it(*l);
					while(it.current())
					{
						if(it.current()->parent() == this)
						{
							KviStr tbLab = ((QToolBar *)it.current())->label();
							if(kvi_strEqualCI(tbLab.ptr(),label.ptr()))
							{
								restoreToolBarState((QToolBar *)it.current(),&cfg,QMainWindow::Top,0,false,0);
								break;
							}
						}
						++it;
					}
					delete l;
				}
			}
		}
	}
#else
	QFile f(szTemp.ptr());
	if(f.open(IO_ReadOnly))
	{
		QTextStream ts(&f);
		ts >> *this;
		f.close();
	} else {
		// reasonable defaults
		QString def = "\n\n\nIrcToolBar,\n[IrcToolBar,0,0,-1,-1,1]\nTaskbar,\n[Taskbar,-18,1,86,-1,1]\n\n\n\n";
		QTextStream ts(def,IO_ReadOnly);
		ts >> *this;
		f.close();
	}
#endif
}

#if QT_VERSION < 300

void KviFrame::saveToolBarState(QToolBar * t,KviConfig * cfg)
{

	QMainWindow::ToolBarDock dock;
	int index;
	bool bNl;
	int extra;

	if(getLocation(t,dock,index,bNl,extra))
	{
		KviStr tmp =t->label();
		cfg->setGroup(tmp.ptr());

		cfg->writeEntry("Visible",t->isVisible());
		cfg->writeEntry("Dock",(int)dock);
		cfg->writeEntry("Index",index);
		cfg->writeEntry("Newline",bNl);
		cfg->writeEntry("ExtraSpace",extra);
	}
}

#endif

#if QT_VERSION < 300

void KviFrame::restoreToolBarState(QToolBar * t,KviConfig * cfg,QMainWindow::ToolBarDock defDock,int defIndex,bool bDefNewline,int defExtra)
{
	QMainWindow::ToolBarDock dock;
	int index , extra;
	bool bVisible , bNl;

	KviStr tmp = t->label().ascii();

	cfg->setGroup(tmp.ptr());

	bVisible   = cfg->readBoolEntry("Visible",true);
	dock       = (QMainWindow::ToolBarDock)cfg->readIntEntry("Dock",defDock);
	index      = cfg->readIntEntry("Index",defIndex);
	bNl        = cfg->readBoolEntry("Newline",bDefNewline);
	extra      = cfg->readIntEntry("ExtraSpace",defExtra);

	if(bVisible)t->show();
	else t->hide();

	moveToolBar(t,dock,bNl,index,extra);
}

#endif

void KviFrame::createTaskBar()
{
	if(KVI_OPTION_BOOL(KviOption_boolUseTreeWindowListTaskBar))m_pTaskBar = new KviTreeTaskBar(this);
	else m_pTaskBar = new KviClassicTaskBar(this);
	
}

void KviFrame::recreateTaskBar()
{
	saveToolBarPositions();
	KviWindow * w;
	for(w = m_pWinList->first();w;w = m_pWinList->next())
	{
		w->destroyTaskBarItem();
	}
#if QT_VERSION >= 300
	removeDockWindow(m_pTaskBar);
#endif
	delete m_pTaskBar;
	createTaskBar();
	for(w = m_pWinList->first();w;w = m_pWinList->next())
	{
		w->createTaskBarItem();
	}
	restoreToolBarPositions();
	if(m_pActiveWindow)m_pTaskBar->setActiveItem(m_pActiveWindow->taskBarItem());
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Some accelerators
////////////////////////////////////////////////////////////////////////////////////////////////////

void KviFrame::maximizeWindow(void)
{
	if(m_pActiveWindow)
	{
		if(m_pActiveWindow->isMaximized())
		{
			m_pActiveWindow->restore();
		} else {
			m_pActiveWindow->maximize();
		}
	}
}

void KviFrame::minimizeWindow(void)
{
	if(m_pActiveWindow)m_pActiveWindow->minimize();
}

void KviFrame::switchToPrevWindow(void)
{
	m_pTaskBar->switchWindow(false,false);
}

void KviFrame::switchToNextWindow(void)
{
	m_pTaskBar->switchWindow(true,false);
}

void KviFrame::switchToPrevWindowInContext(void)
{
	m_pTaskBar->switchWindow(false,true);
}

void KviFrame::switchToNextWindowInContext(void)
{
	m_pTaskBar->switchWindow(true,true);
}

#include "kvi_frame.moc"
