#ifndef _KVI_FILEDIALOG_H_
#define _KVI_FILEDIALOG_H_

//
//   File : kvi_filedialog.h
//   Creation date : Mon Nov 20 2000 03:52:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifdef Unsorted
	#undef Unsorted
#endif
#include "kvi_settings.h"
#include "kvi_string.h"

#include <qfiledialog.h>
#include <qscrollview.h>
#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qstringlist.h>

class QToolButton;

class KVIRC_API KviFileDialog : public QFileDialog
{
	Q_OBJECT
public:
	KviFileDialog(const QString &dirName, const QString &filter=QString::null,
					QWidget *parent=0, const char *name=0, bool modal=false);
	~KviFileDialog();
protected:
	QPopupMenu * m_pBookmarkPopup;
	QToolButton *m_pShowHiddenButton;
protected:
	void fillBookmarkPopup();
protected slots:
	void showHiddenFilesToggled(bool show);
	void bookmarkSelected(int id);
	void addBookmark();
	void goHome();
	void goKvirc();
public:
	static bool askForOpenFileName(KviStr &buffer,const char * caption,const char * initial = 0,const char * filter = 0,bool showHidden = false);
	static bool askForSaveFileName(KviStr &buffer,const char * caption,const char * initial = 0,const char * filter = 0,bool showHidden = false,bool bConfirmOverwrite = false);
	static bool askForDirectoryName(KviStr &buffer,const char * caption,const char * initial = 0,const char * filter = 0,bool showHidden = false);
	static bool askForOpenFileNames(QStringList &buffer,const char * caption,const char * initial = 0,const char * filter = 0,bool showHidden = false);

};


class KVIRC_API KviFilePreview : public QScrollView , public QFilePreview
{
	Q_OBJECT
public:
	KviFilePreview(QWidget * par);
	~KviFilePreview();
protected:
	QPixmap * m_pMemPixmap;
public:
	virtual void previewUrl(const QUrl &url);
protected:
	virtual void drawContents(QPainter *p,int cx,int cy,int cw,int ch);
};


#endif //_KVI_FILEDIALOG_H_
