#ifndef _KVI_CHANNEL_H_
#define _KVI_CHANNEL_H_
//
//   File : kvi_channel.h
//   Creation date : Tue Aug 1 2000 01:42:00 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_settings.h"

#include "kvi_window.h"
#include "kvi_string.h"
#include "kvi_ircuserdb.h"
#include "kvi_pixmap.h"
#include "kvi_userlistview.h"

#include <qasciidict.h>
#include <qdatetime.h>

class KviConsole;
class QSplitter;
class QToolButton;
class KviTopicWidget;
class KviIrcMask;
class KviThemedLabel;
typedef struct _KviMaskEntry KviMaskEntry; // kvi_maskeditor.h
class KviMaskEditor;
class KviModeEditor;

#define KVI_CHANNEL_STATE_HAVEALLNAMES 1
#define KVI_CHANNEL_STATE_HAVEBANLIST 2
#define KVI_CHANNEL_STATE_HAVEWHOLIST 4
#define KVI_CHANNEL_STATE_HAVEBANEXCEPTIONLIST 8
#define KVI_CHANNEL_STATE_HAVEINVITEEXCEPTIONLIST 16
#define KVI_CHANNEL_STATE_DEADCHAN 32


#define KVI_CHANNEL_STATE_SENTPART 64


class KVIRC_API KviChannel : public KviWindow
{
	Q_OBJECT
public:
	KviChannel(KviFrame * lpFrm,KviConsole * lpConsole,const char * name);
	~KviChannel();
protected:
	QSplitter                           * m_pTopSplitter;
	QSplitter                           * m_pVertSplitter;
	QToolButton                         * m_pDoubleViewButton;
	QToolButton                         * m_pListViewButton;
	QToolButton                         * m_pBanEditorButton;
	QToolButton                         * m_pBanExceptionEditorButton;
	QToolButton                         * m_pInviteExceptionEditorButton;
	QToolButton                         * m_pModeEditorButton;
	KviMaskEditor                       * m_pBanEditor;
	KviMaskEditor                       * m_pBanExceptionEditor;
	KviMaskEditor                       * m_pInviteExceptionEditor;
	KviModeEditor                       * m_pModeEditor;
	KviIrcView                          * m_pMessageView;
	KviTopicWidget                      * m_pTopicWidget;
	KviUserListView                     * m_pUserListView;
	KviThemedLabel                      * m_pModeLabel;
	int                                   m_iStateFlags;
	KviStr                                m_szChannelMode;
	KviStr                                m_szChannelKey;
	KviStr                                m_szChannelLimit;
	KviPtrList<KviMaskEntry>            * m_pBanList;
	KviPtrList<KviMaskEntry>            * m_pBanExceptionList;
	KviPtrList<KviMaskEntry>            * m_pInviteExceptionList;
	KviPixmap                             m_privateBackground;
	QTime                                 m_joinTime;
	KviStr                                m_szNameWithUserFlag;
protected:
	bool eventFilter(QObject *, QEvent *);
	virtual QPixmap * myIconPtr();
	virtual void fillCaptionBuffers();
	virtual void resizeEvent(QResizeEvent *e);
	virtual void closeEvent(QCloseEvent *e);
//	virtual void fillContextPopup(QPopupMenu * p);
	virtual void getConfigGroupName(KviStr &buf);
	virtual void saveProperties(KviConfig * cfg);
	virtual void loadProperties(KviConfig * cfg);
	virtual void applyOptions();
	virtual void getBaseLogFileName(KviStr &buffer);
	virtual void triggerCreationEvents();
	void toggleEditor(KviMaskEditor ** ppEd,QToolButton ** ppBtn,KviPtrList<KviMaskEntry> *l,char flag,const char *edName);
	void internalMask(const char * mask,bool bAdd,const char * setBy,const char * setAt,KviPtrList<KviMaskEntry> *l,KviMaskEditor **ppEd);
	void showDoubleView(bool bShow);
public:
	KviPtrList<KviMaskEntry> * banList(){ return m_pBanList; };
	KviPtrList<KviMaskEntry> * banExceptionList(){ return m_pBanExceptionList; };
	KviPtrList<KviMaskEntry> * inviteExceptionList(){ return m_pInviteExceptionList; };

	KviStr * firstSelectedNickname(){ return m_pUserListView->firstSelectedNickname(); };
	KviStr * nextSelectedNickname(){ return m_pUserListView->nextSelectedNickname(); };

	int opCount(){ return m_pUserListView->opCount(); };
	int voiceCount(){ return m_pUserListView->voiceCount(); };
	int halfOpCount(){ return m_pUserListView->halfOpCount(); };
//	unsigned int banCount(){ return m_pBanList->count(); };
//	unsigned int banExceptionCount(){ return m_pBanExceptionList->count(); };
//	unsigned int inviteExceptionList(){ return m_pInviteExceptionLIst->count(); };
	unsigned int count(){ return m_pUserListView->count(); };
	
	const char * nameWithUserFlag(){ return m_szNameWithUserFlag.ptr(); };
	const char * target(){ return name(); };
//	void appendSelectedNicknames(KviStr &buffer);
	void banMask(const char * mask,bool bAdd,const char * setBy,const char * setAt);
	void banExceptionMask(const char * mask,bool bAdd,const char * setBy,const char * setAt);
	void inviteExceptionMask(const char * mask,bool bAdd,const char * setBy,const char * setAt);
	bool hasAllNames(){ return (m_iStateFlags & KVI_CHANNEL_STATE_HAVEALLNAMES); };
	void setHasAllNames(){ m_iStateFlags |= KVI_CHANNEL_STATE_HAVEALLNAMES; };
	bool hasBanExceptionList(){ return (m_iStateFlags & KVI_CHANNEL_STATE_HAVEBANEXCEPTIONLIST); };
	void setHasBanExceptionList(){ m_iStateFlags |= KVI_CHANNEL_STATE_HAVEBANEXCEPTIONLIST; };
	bool hasInviteExceptionList(){ return (m_iStateFlags & KVI_CHANNEL_STATE_HAVEINVITEEXCEPTIONLIST); };
	void setHasInviteExceptionList(){ m_iStateFlags |= KVI_CHANNEL_STATE_HAVEINVITEEXCEPTIONLIST; };
	bool hasWhoList(){ return (m_iStateFlags & KVI_CHANNEL_STATE_HAVEWHOLIST); };
	void setHasWhoList(){ m_iStateFlags |= KVI_CHANNEL_STATE_HAVEWHOLIST; };
	bool hasBanList(){ return (m_iStateFlags & KVI_CHANNEL_STATE_HAVEBANLIST); };
	void setHasBanList();
	void setDeadChan();
	void prependUserFlag(const char * nick,KviStr &buffer){ m_pUserListView->prependUserFlag(nick,buffer); };
	char getUserFlag(const char * nick){ return m_pUserListView->getUserFlag(nick); };
	bool isDeadChan(){ return (m_iStateFlags & KVI_CHANNEL_STATE_DEADCHAN); };
	virtual QSize sizeHint() const;
	void enableUserListUpdates(bool bEnable){ m_pUserListView->enableUpdates(bEnable); };
	KviUserListEntry * join(const char *nick,const char * user = 0,const char * host = 0,int iFlags = 0)
		{ return m_pUserListView->join(nick,user,host,iFlags); };
	bool op(const char *nick,bool bOp){ return m_pUserListView->op(nick,bOp); };
	bool avatarChanged(const char * nick){ return m_pUserListView->avatarChanged(nick); };
	bool voice(const char * nick,bool bVoice){ return m_pUserListView->voice(nick,bVoice); };
	bool halfop(const char * nick,bool bHalfOp){ return m_pUserListView->halfop(nick,bHalfOp); };
	void userAction(KviIrcMask * user,int actionTemperature){ m_pUserListView->userAction(user,actionTemperature); };
	bool nickChange(const char * oldNick,const char * newNick){ return m_pUserListView->nickChange(oldNick,newNick); };
	bool part(const char * nick){ return m_pUserListView->part(nick); };
	bool isOn(const char * nick){ return (m_pUserListView->findEntry(nick) != 0); };
	KviUserListEntry * findEntry(const char * nick){ return m_pUserListView->findEntry(nick); };
//	QAsciiDict<KviUserListEntry> * entryDict(){ return m_pUserListView->entryDict(); };
	KviUserListView * userListView(){ return m_pUserListView; };
	bool isMeOp();
	bool isMeVoice();
	bool isMeHalfOp();
	bool isOp(const char * nick){ return m_pUserListView->isOp(nick); };
	bool isVoice(const char * nick){ return m_pUserListView->isVoice(nick); };
	bool isHalfOp(const char * nick){ return m_pUserListView->isHalfOp(nick); };
	int myFlags();
	void updateModeLabel();
	KviTopicWidget * topicWidget(){ return m_pTopicWidget; };
	virtual void outputMessage(int msg_type,const char * format,...);
	void ownMessage(const char * buffer);
	void ownAction(const char * buffer);
	void setChannelMode(char  mode,bool bAdd);
	void setChannelKey(const char * key);
	void setChannelLimit(const char * limit);
	
	void getChannelModeString(KviStr &buffer);

	KviStr & channelLimit(){ return m_szChannelLimit; };
	bool hasChannelLimit(){ return m_szChannelLimit.hasData(); };
	KviStr & channelKey(){ return m_szChannelKey; };
//	bool hasChannelKey(){ return m_szChannelKey.hasData(); };
	
	void resetState();
private slots:
//	void savePropertiesAsDefault();
	void toggleDoubleView();
	void toggleListView();
	void toggleBanEditor();
	void toggleBanExceptionEditor();
	void toggleInviteExceptionEditor();
	void toggleModeEditor();
	void topicSelected(const char * topic);
	void setMode(const char * mode);
	void modeSelectorDone();
	void textViewRightClicked();
	void removeMasks(KviMaskEditor *ed,KviPtrList<KviMaskEntry> *l);
};

#endif //_KVI_CHANNEL_H_
