//
//   File : kvi_sparser.cpp
//   Creation date : Sun Jun 30 2000 03:25:17 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__
#define _KVI_SPARSER_CPP_
 
#include "kvi_sparser.h"
#include "kvi_window.h"
#include "kvi_out.h"
#include "kvi_locale.h"
#include "kvi_ircsocket.h"
#include "kvi_options.h"
#include "kvi_event.h"
#include "kvi_uparser.h"
#include "kvi_parameterlist.h"

KviServerParser * g_pServerParser = 0;

KviIrcMessage::KviIrcMessage(const char * message,KviConsole * console)
{
	m_pConsole = console;
	m_iFlags   = 0;

	const char * aux;
	m_ptr = message;

	m_pParams = new KviPtrList<KviStr>;
	m_pParams->setAutoDelete(true);

	while(*m_ptr == ' ')++m_ptr;
	const char * allParams = m_ptr; // just to be sure
	if(*m_ptr)
	{
		if(*m_ptr == ':')
		{
			aux = ++m_ptr;
			while(*m_ptr && (*m_ptr != ' '))++m_ptr;
			m_szPrefix.extractFromString(aux,m_ptr);
			while(*m_ptr == ' ')++m_ptr;
		}
		aux = m_ptr;
		while(*m_ptr && (*m_ptr != ' '))++m_ptr;
		m_szCommand.extractFromString(aux,m_ptr);
		while(*m_ptr == ' ')++m_ptr;
		allParams = m_ptr;
		while(*m_ptr)
		{
			if(*m_ptr == ':')
			{
				++m_ptr;
				m_pParams->append(new KviStr(m_ptr));
				break; // this was the last
			} else {
				aux = m_ptr;
				while(*m_ptr && (*m_ptr != ' '))++m_ptr;
				m_pParams->append(new KviStr(aux,m_ptr));
				while(*m_ptr == ' ')++m_ptr;
			}
		}
	}
	m_ptr = allParams;

	m_iNumericCommand = (*m_szCommand.ptr() - '0') * 100;

	if((m_szCommand.len() == 3) && (m_iNumericCommand <= 900) && (m_iNumericCommand >= 0))
	{
		aux = m_szCommand.ptr();
		aux++;
		if((*aux >= '0') && (*aux <= '9'))
		{
			m_iNumericCommand += (*aux - '0') * 10;
			aux++;
			if((*aux >= '0') && (*aux <= '9'))
			{
				m_iNumericCommand += (*aux - '0');
			} else {
				m_iNumericCommand = -1;
				m_szCommand.toUpper();
			}
		} else {
			m_iNumericCommand = -1;
			m_szCommand.toUpper();
		}
	} else {
		m_iNumericCommand = -1;
		m_szCommand.toUpper();
	}
}

KviIrcMessage::~KviIrcMessage()
{
	delete m_pParams;
}

KviServerParser::KviServerParser()
: QObject(0,"server_parser")
{
}

KviServerParser::~KviServerParser()
{
}

void KviServerParser::parseMessage(const char * message,KviConsole * console)
{
	KviIrcMessage msg(message,console);

	if(msg.isNumeric())
	{
		if(g_pEventManager->hasRawEventHandlers(msg.numeric()))
		{
			KviParameterList parms;

			parms.setAutoDelete(false);
			parms.append(msg.prefixPtr());
			parms.append(msg.commandPtr());

			for(KviStr * str = msg.firstParam();str;str = msg.nextParam())
				parms.append(str);

			if(g_pUserParser->triggerEvent(msg.numeric(),console,&parms,false,true))
				msg.setHaltOutput();
		}

		messageParseProc proc = m_numericParseProcTable[msg.numeric()];
		if(proc)
		{
			(this->*proc)(&msg);
			if(!msg.unrecognized())return; // parsed
		}
	} else {
		for(int i=0;m_literalParseProcTable[i].msgName;i++)
		{
			if(kvi_strEqualCS(m_literalParseProcTable[i].msgName,msg.command()))
			{
				(this->*(m_literalParseProcTable[i].proc))(&msg);
				if(!msg.unrecognized())return; // parsed
			}
		}


		if(g_pEventManager->hasEventHandlers(KviEvent_OnUnhandledLiteral))
		{
			KviParameterList parms;
	
			parms.setAutoDelete(false);
			parms.append(msg.prefixPtr());
			parms.append(msg.commandPtr());
	
			for(KviStr * str = msg.firstParam();str;str = msg.nextParam())
				parms.append(str);
	
			if(g_pUserParser->triggerEvent(KviEvent_OnUnhandledLiteral,console,&parms,false,false))
				msg.setHaltOutput();
		}

	}

	if(!msg.haltOutput())
	{
		if(msg.unrecognized())
		{
			console->output(KVI_OUT_UNRECOGNIZED,
				__tr("[Server parser]: encountered problems while parsing the following message:"));
			console->output(KVI_OUT_UNRECOGNIZED,
				__tr("[Server parser]: [%s][%s] %s"),msg.prefix(),msg.command(),msg.allParams());
			console->output(KVI_OUT_UNRECOGNIZED,
				__tr("[Server parser]: %s"),m_szLastParserError.ptr());

		} else {
			console->output(KVI_OUT_UNHANDLED,
				"[%s][%s] %s",msg.prefix(),msg.command(),msg.allParams());
		}
	}
}



const char * KviServerParser::formatGenericLink(const char * escape,const char * link,KviStr &buffer)
{
	buffer.sprintf("\r!%s\r%s\r",escape,link);
	return buffer.ptr();
}

const char * KviServerParser::formatServerLink(const char * link,KviStr &buffer)
{
	return formatGenericLink("s",link,buffer);
}

const char * KviServerParser::formatHostLink(const char * link,KviStr &buffer)
{
	return formatGenericLink("h",link,buffer);
}

const char * KviServerParser::formatChannelLink(const char * link,KviStr &buffer)
{
	return formatGenericLink("c",link,buffer);
}

const char * KviServerParser::formatNickLink(const char * link,KviStr &buffer)
{
	return formatGenericLink("n",link,buffer);
}



//const char * KviServerParser::formatMaskLink(const char * link,KviStr &buffer)
//{
//	return formatGenericLink("m",link,buffer);
//}

#include "kvi_sparser.moc"
