#ifndef _KVI_TEXTICONMANAGER_H_
#define _KVI_TEXTICONMANAGER_H_

//
//   File : kvi_texticonmanager.h
//   Creation date : Thu 15 May 2002 12:04:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include <qpixmap.h>
#include <qasciidict.h>

#include "kvi_iconmanager.h"

class KviTextIcon
{
protected:
	QPixmap *m_pPixPtr;
	int      m_iId;
public:
	KviTextIcon(int id)
		: m_iId(id) {};
	~KviTextIcon(){};
public:
	inline int id(){ return m_iId; };
};

class KVIRC_API KviTextIconManager : public QObject
{
	friend class KviTextIconWindow;
	friend class KviTextIconsOptionsWidget;
	Q_OBJECT
public:
	KviTextIconManager();
	~KviTextIconManager();
private:
	QAsciiDict<KviTextIcon> * m_pTextIconDict;
protected:
	QAsciiDict<KviTextIcon> * textIconDict(){ return m_pTextIconDict; };
signals:
	void changed();
public:
	void checkDefaultAssociations();
	void clear();
	void insert(const char * name,int id);
	int lookupTextIcon(const char * name){ KviTextIcon * i = m_pTextIconDict->find(name); return i ? i->id() : KVI_SMALLICON_HELP; };
	void save(const char * filename);
	void load(const char * filename);
};

#ifndef _KVI_TEXTICONMANAGER_CPP_
	extern KVIRC_API KviTextIconManager * g_pTextIconManager;
#endif


#endif //_KVI_TEXTICONMANAGER_H_
