//
//   File : kvi_texticonmanager.cpp
//   Creation date : Thu 15 May 2002 12:04:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __KVIRC__

#define _KVI_TEXTICONMANAGER_CPP_

#include <qpixmap.h>

#include "kvi_texticonmanager.h"
#include "kvi_string.h"
#include "kvi_list.h"
#include "kvi_config.h"

KVIRC_API KviTextIconManager * g_pTextIconManager = 0;

KviTextIconManager::KviTextIconManager()
: QObject()
{
	m_pTextIconDict = new QAsciiDict<KviTextIcon>(47,false,true);
	m_pTextIconDict->setAutoDelete(true);
}

KviTextIconManager::~KviTextIconManager()
{
	delete m_pTextIconDict;
}

void KviTextIconManager::clear()
{
	m_pTextIconDict->clear();
}

void KviTextIconManager::insert(const char * name,int id)
{
	m_pTextIconDict->replace(name,new KviTextIcon(id));
    emit changed();
}

typedef struct _KviTextIconAssocEntry
{
	const char * name;
	int          iVal;
} KviTextIconAssocEntry;

static KviTextIconAssocEntry default_associations[]=
{
	{ ":)"                , KVI_SMALLICON_SMILE      },
	{ ":*"                , KVI_SMALLICON_KISS       },
	{ ":D"                , KVI_SMALLICON_BIGGRIN    },
	{ ":("                , KVI_SMALLICON_UGLY       },
	{ ":/"                , KVI_SMALLICON_ANGRY      },
//	{ ":\\"               , KVI_SMALLICON_ANGRY      },
	{ ":O"                , KVI_SMALLICON_SURPRISED2 },
	{ ":P"                , KVI_SMALLICON_TONGUE     },
	{ 0                   , 0                        }
};

void KviTextIconManager::checkDefaultAssociations()
{
	for(int i=0;default_associations[i].name;i++)
	{
		if(!m_pTextIconDict->find(default_associations[i].name))
			insert(default_associations[i].name,default_associations[i].iVal);
	}
    emit changed();
}

void KviTextIconManager::load(const char * filename)
{
	m_pTextIconDict->clear();
	KviConfig cfg(filename);

	KviStrDict * dict = cfg.dict()->find("TextIcons");
	KviStrDictIterator it(*dict);

	KviPtrList<KviStr> names;
	names.setAutoDelete(true);

	while(it.current())
	{
		names.append(new KviStr(it.currentKey()));
		++it;
	}

	cfg.setGroup("TextIcons");

	for(KviStr * s = names.first();s;s = names.next())
	{
		//debug("Loading entry %s",s->ptr());
		int id = cfg.readIntEntry(s->ptr(),KVI_SMALLICON_HELP);
		//debug("Got id %d",id);
		QPixmap * pix = g_pIconManager->getSmallIcon(id);
		if(pix)insert(s->ptr(),id);
	}

	checkDefaultAssociations();
    emit changed();
}

void KviTextIconManager::save(const char * filename)
{
	KviConfig cfg(filename);
	cfg.clear();

	cfg.setGroup("TextIcons");

	QAsciiDictIterator<KviTextIcon> it(*m_pTextIconDict);
	while(KviTextIcon * i = it.current())
	{
		cfg.writeEntry(it.currentKey(),i->id());
		++it;
	}
}

#include "kvi_texticonmanager.moc"
