#ifndef _KVI_SSLMASTER_H_
#define _KVI_SSLMASTER_H_
//
//   File : kvi_sslmaster.h
//   Creation date : Mon Jun 17 2002 20:34:00 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_settings.h"

#ifdef COMPILE_SSL_SUPPORT

#include "kvi_ssl.h"
#include "kvi_sockettype.h"

class KviWindow;

namespace KviSSLMaster
{
	extern KVIRC_API void printSSLCipherInfo(KviWindow * wnd,const char * description,KviSSLCipherInfo * c);
	extern KVIRC_API void printSSLCertificate(KviWindow * wnd,const char * description,KviSSLCertificate * c);

	extern KVIRC_API void printSSLConnectionInfo(KviWindow * wnd,KviSSL * s);

	extern KVIRC_API KviSSL * allocSSL(KviWindow * wnd,kvi_socket_t sock,KviSSL::Method m);
	extern KVIRC_API void freeSSL(KviSSL * s);
}

#endif


#endif //_KVI_SSLMASTER_H_
