//
//   File : kvi_options.cpp
//   Creation date : Tue Jun 20 2000 11:42:00 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __KVIRC__

#define _KVI_OPTIONS_CPP_

#include "kvi_options.h"
#include "kvi_defaults.h"
#include "kvi_config.h"
#include "kvi_app.h"
#include "kvi_iconmanager.h"
#include "kvi_mirccntrl.h"
#include "kvi_locale.h"
#include "kvi_confignames.h"
#include "kvi_window.h"
#include "kvi_out.h"
#include "kvi_stringconversion.h"
#include "kvi_settings.h"
#include "kvi_splash.h"
#include "kvi_frame.h"
#include "kvi_internalcmd.h"

// kvi_app.cpp
extern KVIRC_API bool g_bIdentDaemonRunning;


#define RECT_OPTION(_txt,_val,_flags) KviRectOption(KVI_RECT_OPTIONS_PREFIX _txt, _val , _flags)

KviRectOption g_rectOptionsTable[KVI_NUM_RECT_OPTIONS]=
{
	RECT_OPTION("FrameGeometry",QRect(10,50,720,500),KviOption_sectFlagFrame),
	RECT_OPTION("GeneralOptionsDialogGeometry",QRect(50,50,600,450),KviOption_sectFlagFrame),
	RECT_OPTION("RegisteredUsersDialogGeometry",QRect(50,50,600,450),KviOption_sectFlagFrame)
};

#define BOOL_OPTION(_txt,_val,_flags) KviBoolOption(KVI_BOOL_OPTIONS_PREFIX _txt,_val,_flags)

KviBoolOption g_boolOptionsTable[KVI_NUM_BOOL_OPTIONS]=
{
	BOOL_OPTION("WindowsRememberProperties",true,KviOption_sectFlagWindows),
	BOOL_OPTION("IrcViewShowImages",true,KviOption_sectFlagIrcView),
	BOOL_OPTION("IrcViewTimestamp",true,KviOption_sectFlagIrcView),
	BOOL_OPTION("IrcViewUrlHighlighting",true,KviOption_sectFlagIrcView),
	BOOL_OPTION("IrcViewWrapMargin",true,KviOption_sectFlagIrcView),
	BOOL_OPTION("InputHistoryCursorAtEnd",true,KviOption_sectFlagInput),
	BOOL_OPTION("AvoidParserWarnings",false,KviOption_sectFlagUserParser),
	BOOL_OPTION("UseProxyHost",false,KviOption_sectFlagConnection),
	BOOL_OPTION("ShowGeneralOptionsDialogAsToplevel",true,KviOption_sectFlagFrame),
	BOOL_OPTION("ForceBrutalQuit",false,KviOption_sectFlagIrcSocket),
	BOOL_OPTION("ShowPingPong",true,KviOption_sectFlagConnection),
	BOOL_OPTION("BeVerbose",false,KviOption_sectFlagConnection),
	BOOL_OPTION("ShowExtendedServerInfo",false,KviOption_sectFlagConnection),
	BOOL_OPTION("EchoNumericTopic",false,KviOption_sectFlagConnection),
	BOOL_OPTION("ShowOwnParts",true,KviOption_sectFlagConnection),
	BOOL_OPTION("UseAntiSpamOnPrivmsg",false,KviOption_sectFlagAntiSpam),
	BOOL_OPTION("UseExtendedPrivmsgView",false,KviOption_sectFlagIrcView),
	BOOL_OPTION("ShowUserAndHostInPrivmsgView",false,KviOption_sectFlagIrcView),
	BOOL_OPTION("UseWordHighlighting",false,KviOption_sectFlagIrcView),
	BOOL_OPTION("UNUSED",false,KviOption_sectFlagFrame),
	BOOL_OPTION("CleanupUnusedModules",true,KviOption_sectFlagModules),
	BOOL_OPTION("IgnoreCtcpPing",false,KviOption_sectFlagCtcp),
	BOOL_OPTION("IgnoreCtcpVersion",false,KviOption_sectFlagCtcp),
	BOOL_OPTION("UseCtcpFloodProtection",true,KviOption_sectFlagCtcp),
	BOOL_OPTION("DisableBrokenEventHandlers",true,KviOption_sectFlagUserParser),
	BOOL_OPTION("IgnoreCtcpClientinfo",false,KviOption_sectFlagCtcp),
	BOOL_OPTION("IgnoreCtcpUserinfo",false,KviOption_sectFlagCtcp),
	BOOL_OPTION("IgnoreCtcpFinger",false,KviOption_sectFlagCtcp),
	BOOL_OPTION("IgnoreCtcpSource",false,KviOption_sectFlagCtcp),
	BOOL_OPTION("IgnoreCtcpTime",false,KviOption_sectFlagCtcp),
	BOOL_OPTION("RequestMissingAvatars",true,KviOption_sectFlagAvatar),
	BOOL_OPTION("ShowCompactModeChanges",false,KviOption_sectFlagConnection),
	BOOL_OPTION("IgnoreCtcpDcc",false,KviOption_sectFlagDcc),
	BOOL_OPTION("AutoAcceptDccChat",false,KviOption_sectFlagDcc),
	BOOL_OPTION("AutoAcceptDccSend",false,KviOption_sectFlagDcc),
	BOOL_OPTION("SendZeroAckInDccRecv",false,KviOption_sectFlagDcc),
	BOOL_OPTION("UseFastDccSend",true,KviOption_sectFlagDcc),
	BOOL_OPTION("ObtainGlobalBackgroundFromKde",false,KviOption_sectFlagGui | KviOption_resetUpdatePseudoTransparency),
	BOOL_OPTION("UseTaskBarIrcContextIndicator",true,KviOption_sectFlagTaskBar | KviOption_resetUpdateGui),
	BOOL_OPTION("UseGlobalApplicationFont",false,KviOption_sectFlagGui | KviOption_resetUpdateAppFont),
	BOOL_OPTION("UseGuiEffectAnimateMenu",false,KviOption_sectFlagGui | KviOption_resetUpdateGuiEffects),
	BOOL_OPTION("UseGuiEffectFadeMenu",false,KviOption_sectFlagGui | KviOption_resetUpdateGuiEffects),
	BOOL_OPTION("UseGuiEffectAnimateToolTip",false,KviOption_sectFlagGui | KviOption_resetUpdateGuiEffects),
	BOOL_OPTION("UseGuiEffectFadeToolTip",false,KviOption_sectFlagGui | KviOption_resetUpdateGuiEffects),
	BOOL_OPTION("UseGuiEffectAnimateCombo",false,KviOption_sectFlagGui | KviOption_resetUpdateGuiEffects),
	BOOL_OPTION("IrcViewTimestampUTC",false,KviOption_sectFlagIrcView),
	BOOL_OPTION("UseGlobalPseudoTransparency",false,KviOption_sectFlagGui | KviOption_resetUpdatePseudoTransparency),
	BOOL_OPTION("UseNotifyList",false,KviOption_sectFlagConnection | KviOption_resetRestartNotifyList),
	BOOL_OPTION("NotifyListChangesToActiveWindow",true,KviOption_sectFlagConnection),
	BOOL_OPTION("SingleIrcToolBar",true,KviOption_sectFlagFrame | KviOption_resetUpdateIrcToolBars),
	BOOL_OPTION("LimitOutgoingTraffic",false,KviOption_sectFlagIrcSocket),
	BOOL_OPTION("SendUnknownCommandsAsRaw",false,KviOption_sectFlagUserParser),
	BOOL_OPTION("LimitAliasRecursion",false,KviOption_sectFlagUserParser),
	BOOL_OPTION("ShowChannelSyncTime",true,KviOption_sectFlagConnection),
	BOOL_OPTION("RejoinChannelOnKick",true,KviOption_sectFlagConnection),
	BOOL_OPTION("KeepChannelOpenOnKick",false,KviOption_sectFlagConnection),
	BOOL_OPTION("AutoCloseDccSendOnSuccess",false,KviOption_sectFlagDcc),
	BOOL_OPTION("NotifyDccSendSuccessInConsole",false,KviOption_sectFlagDcc),
	BOOL_OPTION("CreateMinimizedDccSend",false,KviOption_sectFlagDcc),
	BOOL_OPTION("CreateMinimizedDccChat",false,KviOption_sectFlagDcc),
	BOOL_OPTION("AutoAcceptIncomingAvatars",false,KviOption_sectFlagDcc),
	BOOL_OPTION("UseNickCompletionPostfixForFirstWordOnly",true,KviOption_sectFlagInput),
	BOOL_OPTION("UNUSED",false,KviOption_sectFlagDcc), /* UNUSED!!! */
	BOOL_OPTION("CreateMinimizedDccSendWhenAutoAccepted",true,KviOption_sectFlagDcc),
	BOOL_OPTION("CreateMinimizedDccChatWhenAutoAccepted",true,KviOption_sectFlagDcc),
	BOOL_OPTION("ShowScriptCenterDialogAsToplevel",true,KviOption_sectFlagFrame),
	BOOL_OPTION("ShowRegisteredUsersDialogAsToplevel",true,KviOption_sectFlagFrame),
	BOOL_OPTION("AutoLogQueries",false,KviOption_sectFlagLogging),
	BOOL_OPTION("AutoLogChannels",false,KviOption_sectFlagLogging),
	BOOL_OPTION("AutoLogDccChat",false,KviOption_sectFlagLogging),
	BOOL_OPTION("AutoLogConsole",false,KviOption_sectFlagLogging),
	BOOL_OPTION("SilentAntiSpam",false,KviOption_sectFlagAntiSpam),
	BOOL_OPTION("UseIncomingDccMediaTypeSavePath",true,KviOption_sectFlagDcc),
	BOOL_OPTION("NotifyListSendUserhostForOnlineUsers",true,KviOption_sectFlagConnection),
	BOOL_OPTION("UseIntelligentNotifyListManager",true,KviOption_sectFlagConnection),
	BOOL_OPTION("UseWatchListIfAvailable",true,KviOption_sectFlagConnection),
	BOOL_OPTION("UseTreeWindowListTaskBar",true,KviOption_sectFlagTaskBar | KviOption_resetUpdateTaskBar),
	BOOL_OPTION("BindIrcIpV4ConnectionsToSpecifiedAddress",false,KviOption_sectFlagConnection),
	BOOL_OPTION("BindIrcIpV6ConnectionsToSpecifiedAddress",false,KviOption_sectFlagConnection),
	BOOL_OPTION("UseAntiSpamOnNotice",false,KviOption_sectFlagAntiSpam),
	BOOL_OPTION("SetLastAvatarAsDefaultForRegisteredUsers",true,KviOption_sectFlagAvatar),
	BOOL_OPTION("CantAcceptIncomingDccConnections",false,KviOption_sectFlagDcc),
	BOOL_OPTION("IgnoreCtcpAvatar",false,KviOption_sectFlagCtcp),
	BOOL_OPTION("CtcpRepliesToActiveWindow",true,KviOption_sectFlagCtcp),
	BOOL_OPTION("AutoAcceptDccCanvas",false,KviOption_sectFlagDcc),
	BOOL_OPTION("EnableAutomaticNickServIdentification",false,KviOption_sectFlagConnection),
	BOOL_OPTION("KillBrokenTimers",true,KviOption_sectFlagUserParser),
	BOOL_OPTION("DccVoiceVolumeSliderControlsPCM", true, KviOption_sectFlagDcc),
	BOOL_OPTION("DccVoiceForceHalfDuplex", false, KviOption_sectFlagDcc),
	BOOL_OPTION("AutoAcceptDccVoice", false, KviOption_sectFlagDcc),
	BOOL_OPTION("CreateMinimizedDccVoice", false, KviOption_sectFlagDcc),
	BOOL_OPTION("CreateMinimizedDccVoiceWhenAutoAccepted",true,KviOption_sectFlagDcc),
#ifdef COMPILE_ON_WINDOWS
	BOOL_OPTION("UseIdentService",true,KviOption_sectFlagConnection | KviOption_resetRestartIdentd),
#else
	BOOL_OPTION("UseIdentService",false,KviOption_sectFlagConnection | KviOption_resetRestartIdentd),
#endif
	BOOL_OPTION("ShowTipAtStartup",true,KviOption_sectFlagFrame),
	BOOL_OPTION("IdentdEnableIpV6",false,KviOption_sectFlagConnection | KviOption_resetRestartIdentd),
#ifdef COMPILE_ON_WINDOWS
	BOOL_OPTION("IdentdIpV6ContainsIpV4",false,KviOption_sectFlagConnection | KviOption_resetRestartIdentd),
#else
	BOOL_OPTION("IdentdIpV6ContainsIpV4",true,KviOption_sectFlagConnection | KviOption_resetRestartIdentd),
#endif
	BOOL_OPTION("ScaleAvatars",true,KviOption_sectFlagAvatar | KviOption_resetUpdateGui),
	BOOL_OPTION("ColorNicks",false,KviOption_sectFlagIrcView),
	BOOL_OPTION("BoldedNicks",false,KviOption_sectFlagIrcView),
	BOOL_OPTION("DccListenOnSpecifiedInterfaceByDefault",false,KviOption_sectFlagDcc),
	BOOL_OPTION("ChangeNickAway", false, KviOption_sectFlagConnection),
	BOOL_OPTION("AutoGeneratedAwayNick",true,KviOption_sectFlagConnection),
	BOOL_OPTION("ExitAwayOnInput",false,KviOption_sectFlagConnection),
	BOOL_OPTION("AlwaysHighlightNick",false,KviOption_sectFlagIrcView),
	BOOL_OPTION("ShowChannelsJoinOnIrc",true,KviOption_sectFlagFrame),
	BOOL_OPTION("ShowChannelsJoinDialogAsToplevel",true,KviOption_sectFlagFrame),
	BOOL_OPTION("UserDefinedPortRange",false,KviOption_sectFlagDcc),
	BOOL_OPTION("CreateQueryOnPrivmsg",true,KviOption_sectFlagConnection),
	BOOL_OPTION("CreateQueryOnNotice",true,KviOption_sectFlagConnection),
	BOOL_OPTION("CreateMinimizedQuery",false,KviOption_sectFlagConnection),
	BOOL_OPTION("AutoJoinOnInvite",false,KviOption_sectFlagConnection),
	BOOL_OPTION("ShowServersConnectDialogOnStart",true, KviOption_sectFlagFrame),
	BOOL_OPTION("ShowServersConnectDialogAsToplevel",true,KviOption_sectFlagFrame),
	BOOL_OPTION("AcceptBrokenFileNameDccResumeRequests",true,KviOption_sectFlagFrame),
	BOOL_OPTION("AutoReconnectOnUnexpectedDisconnect",false,KviOption_sectFlagFrame),
	BOOL_OPTION("RejoinChannelsAfterReconnect",true,KviOption_sectFlagFrame),
	BOOL_OPTION("ReopenQueriesAfterReconnect",true,KviOption_sectFlagFrame),
	BOOL_OPTION("EnableQueryTracing",true,KviOption_sectFlagConnection),
	BOOL_OPTION("WallopsToConsole",false,KviOption_sectFlagConnection),
	BOOL_OPTION("InviteToConsole",false,KviOption_sectFlagConnection),
	BOOL_OPTION("ShowChannelUserFlagInPrivmsgView",false,KviOption_sectFlagConnection),
	BOOL_OPTION("DccSendFakeAddressByDefault",false,KviOption_sectFlagDcc),
	BOOL_OPTION("CloseChannelsJoinAfterJoinUNUSED",true,KviOption_sectFlagFrame),
	BOOL_OPTION("CloseServerWidgetAfterConnect",false,KviOption_sectFlagFrame),
	BOOL_OPTION("ShowIdentityDialogAsToplevel",true,KviOption_sectFlagFrame),
	BOOL_OPTION("ShowUserChannelIcons",true,KviOption_sectFlagUserListView | KviOption_resetUpdateGui),
	BOOL_OPTION("ShowUserChannelState",true,KviOption_sectFlagUserListView | KviOption_resetUpdateGui),
	BOOL_OPTION("EnableIgnoreOnPrivMsg",true,KviOption_sectFlagConnection),
	BOOL_OPTION("VerboseIgnore",true,KviOption_sectFlagConnection),
	BOOL_OPTION("EnableIgnoreOnNotice",true,KviOption_sectFlagConnection),
	BOOL_OPTION("NotifyFailedDccHandshakes",true,KviOption_sectFlagDcc),
	BOOL_OPTION("AutoTileWindows",false,KviOption_sectFlagMdi),
    BOOL_OPTION("DrawEmoticons",false,KviOption_sectFlagIrcView),
	BOOL_OPTION("IgnoreCtcpPage",false,KviOption_sectFlagCtcp),
	BOOL_OPTION("ShowDialogOnCtcpPage",true,KviOption_sectFlagCtcp),
	BOOL_OPTION("BashLikeNickCompletion",false,KviOption_sectFlagInput),
	BOOL_OPTION("UseSSLCertificate",false,KviOption_sectFlagConnection),
	BOOL_OPTION("UseSSLPrivateKey",false,KviOption_sectFlagConnection)
};

#define STRING_OPTION(_txt,_val,_flags) KviStringOption(KVI_STRING_OPTIONS_PREFIX _txt,_val,_flags)

// FIXME: #warning "Remove the unused string options here!"

#ifdef COMPILE_ON_WINDOWS
	#define RUN_THE_BROWSER "run explorer.exe $0"
#else
	#ifdef COMPILE_KDE_SUPPORT
		#define RUN_THE_BROWSER "run konqueror $0"
	#else
		#define RUN_THE_BROWSER "run kvi_run_netscape.sh $0"
	#endif
#endif

KviStringOption g_stringOptionsTable[KVI_NUM_STRING_OPTIONS]=
{
	STRING_OPTION("FrameCaption",KVI_DEFAULT_FRAME_CAPTION,KviOption_sectFlagFrame | KviOption_resetUpdateCaption),
	STRING_OPTION("Nickname1",KVI_DEFAULT_NICKNAME1,KviOption_sectFlagUser),
	STRING_OPTION("Nickname2",KVI_DEFAULT_NICKNAME2,KviOption_sectFlagUser),
	STRING_OPTION("Nickname3",KVI_DEFAULT_NICKNAME3,KviOption_sectFlagUser),
	STRING_OPTION("Nickname4",KVI_DEFAULT_NICKNAME4,KviOption_sectFlagUser),
	STRING_OPTION("Username",KVI_DEFAULT_USERNAME,KviOption_sectFlagUser),
	STRING_OPTION("Realname",KVI_DEFAULT_REALNAME,KviOption_sectFlagUser),
	STRING_OPTION("LocalHostIp","127.0.0.1",KviOption_sectFlagIrcSocket),
	STRING_OPTION("PartMessage",KVI_DEFAULT_PART_MESSAGE,KviOption_sectFlagConnection),
	STRING_OPTION("QuitMessage",KVI_DEFAULT_QUIT_MESSAGE,KviOption_sectFlagConnection),
	STRING_OPTION("UrlHttpCommand",RUN_THE_BROWSER,KviOption_sectFlagUrl),
	STRING_OPTION("ExtendedPrivmsgPrefix","[",KviOption_sectFlagIrcView),
	STRING_OPTION("ExtendedPrivmsgPostfix","] ",KviOption_sectFlagIrcView),
	STRING_OPTION("CtcpVersionPostfix","",KviOption_sectFlagCtcp),
	STRING_OPTION("CtcpUserinfoReply",KVI_DEFAULT_CTCP_USERINFO_REPLY,KviOption_sectFlagCtcp),
	STRING_OPTION("CtcpSourcePostfix","",KviOption_sectFlagCtcp),
	STRING_OPTION("UrlFtpCommand",RUN_THE_BROWSER,KviOption_sectFlagUrl),
	STRING_OPTION("UrlHttpsCommand",RUN_THE_BROWSER,KviOption_sectFlagUrl),
	STRING_OPTION("UrlMailtoCommand",RUN_THE_BROWSER,KviOption_sectFlagUrl),
	STRING_OPTION("UNUSED:UrlIrcCommand","UNUSEDircurl $0",KviOption_sectFlagUrl),
	STRING_OPTION("UrlFileCommand","play $0",KviOption_sectFlagUrl),
	STRING_OPTION("NickCompletionPostfix",": ",KviOption_sectFlagInput),
	STRING_OPTION("UrlUnknownCommand",RUN_THE_BROWSER,KviOption_sectFlagUrl),
	STRING_OPTION("IpV4ConnectionBindAddress","",KviOption_sectFlagConnection),
	STRING_OPTION("IpV6ConnectionBindAddress","",KviOption_sectFlagConnection),
	STRING_OPTION("DccVoiceSoundDevice", "/dev/dsp",KviOption_sectFlagDcc),
	STRING_OPTION("DccVoiceMixerDevice", "/dev/mixer",KviOption_sectFlagDcc),
	STRING_OPTION("AwayMessage",KVI_DEFAULT_AWAY_MESSAGE,KviOption_sectFlagConnection),
	STRING_OPTION("IdentdUser",KVI_DEFAULT_IDENTD_USER,KviOption_sectFlagConnection | KviOption_resetRestartIdentd),
	STRING_OPTION("DccListenDefaultInterface","ppp0",KviOption_sectFlagDcc),
	STRING_OPTION("CustomAwayNick", KVI_DEFAULT_AWAY_NICK,KviOption_sectFlagConnection),
	STRING_OPTION("DefaultDccFakeAddress","",KviOption_sectFlagDcc),
	STRING_OPTION("CtcpPageReply",KVI_DEFAULT_CTCP_PAGE_REPLY,KviOption_sectFlagCtcp),
	STRING_OPTION("SSLCertificatePath","",KviOption_sectFlagConnection),
	STRING_OPTION("SSLCertificatePass","",KviOption_sectFlagConnection),
	STRING_OPTION("SSLPrivateKeyPath","",KviOption_sectFlagConnection),
	STRING_OPTION("SSLPrivateKeyPass","",KviOption_sectFlagConnection)
};

#define STRINGLIST_OPTION(_txt,_flags) \
	KviStringListOption(KVI_STRINGLIST_OPTIONS_PREFIX _txt,QStringList(),_flags)

KviStringListOption g_stringlistOptionsTable[KVI_NUM_STRINGLIST_OPTIONS]=
{
	STRINGLIST_OPTION("HighlightWords",KviOption_sectFlagIrcView),
	STRINGLIST_OPTION("SpamWords",KviOption_sectFlagAntiSpam),
	STRINGLIST_OPTION("RecentChannels",KviOption_sectFlagRecent),
	STRINGLIST_OPTION("RecentServers",KviOption_sectFlagRecent),
	STRINGLIST_OPTION("RecentNicknames",KviOption_sectFlagRecent)
};

#define MIRC_COLOR_OPTION(_num,_red,_green,_blue) \
	KviColorOption(KVI_MIRCCOLOR_OPTIONS_PREFIX _num,QColor(_red,_green,_blue), \
		KviOption_sectFlagMircColor | KviOption_resetUpdateGui)

KviColorOption g_mirccolorOptionsTable[KVI_NUM_MIRCCOLOR_OPTIONS]=
{
	MIRC_COLOR_OPTION("0",255,255,255),
	MIRC_COLOR_OPTION("1",0,0,0),
	MIRC_COLOR_OPTION("2",0,0,140),
	MIRC_COLOR_OPTION("3",0,100,0),
	MIRC_COLOR_OPTION("4",230,0,0),
	MIRC_COLOR_OPTION("5",150,0,0),
	MIRC_COLOR_OPTION("6",80,0,80),
	MIRC_COLOR_OPTION("7",255,90,0),
	MIRC_COLOR_OPTION("8",255,255,0),
	MIRC_COLOR_OPTION("9",0,255,0),
	MIRC_COLOR_OPTION("10",0,150,180),
	MIRC_COLOR_OPTION("11",170,170,255),
	MIRC_COLOR_OPTION("12",15,15,255),
	MIRC_COLOR_OPTION("13",200,0,200),
	MIRC_COLOR_OPTION("14",80,80,80),
	MIRC_COLOR_OPTION("15",170,170,170)
};

#define COLOR_OPTION(_name,_red,_green,_blue,_flags) \
	KviColorOption(KVI_COLOR_OPTIONS_PREFIX _name, \
		QColor(_red,_green,_blue), \
		_flags | KviOption_resetUpdateGui)

KviColorOption g_colorOptionsTable[KVI_NUM_COLOR_OPTIONS]=
{
	COLOR_OPTION("MdiBackground",0,0,0,KviOption_sectFlagMdi),
	COLOR_OPTION("TaskBarNormalText",0,0,0,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TaskBarMinimizedText",60,60,60,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TaskBarHighlight1Text",0,16,144,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TaskBarHighlight2Text",32,0,255,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TaskBarProgressBar",180,180,180,KviOption_sectFlagTaskBar),
	COLOR_OPTION("MdiCaptionActive",0,0,0,KviOption_sectFlagMdi),
	COLOR_OPTION("MdiCaptionInactive",180,180,180,KviOption_sectFlagMdi),
	COLOR_OPTION("CaptionTextActive",255,255,255,KviOption_sectFlagWindows),
	COLOR_OPTION("CaptionTextActive2",255,30,30,KviOption_sectFlagWindows),
	COLOR_OPTION("CaptionTextInactive",0,0,0,KviOption_sectFlagWindows),
	COLOR_OPTION("CaptionTextInactive2",30,30,30,KviOption_sectFlagWindows),
	COLOR_OPTION("IrcViewBackground",255,255,255,KviOption_sectFlagIrcView),
	COLOR_OPTION("InputBackgroundColor",255,255,255,KviOption_sectFlagInput),
	COLOR_OPTION("InputSelectionBackground",0,0,0,KviOption_sectFlagInput),
	COLOR_OPTION("InputSelectionForeground",255,255,255,KviOption_sectFlagInput),
	COLOR_OPTION("InputCursor",255,0,0,KviOption_sectFlagInput),
	COLOR_OPTION("InputControl",200,100,0,KviOption_sectFlagInput),
	COLOR_OPTION("InputForeground",0,0,0,KviOption_sectFlagInput),
	COLOR_OPTION("UserListViewBackground",255,255,255,KviOption_sectFlagUserListView),
	COLOR_OPTION("UserListViewOpForeground",200,0,0,KviOption_sectFlagUserListView),
	COLOR_OPTION("UserListViewVoiceForeground",0,0,200,KviOption_sectFlagUserListView),
	COLOR_OPTION("UserListViewNormalForeground",0,0,0,KviOption_sectFlagUserListView),
	COLOR_OPTION("UserListViewSelectionBackground",0,0,0,KviOption_sectFlagUserListView),
	COLOR_OPTION("UserListViewSelectionForeground",255,255,255,KviOption_sectFlagUserListView),
	COLOR_OPTION("LabelBackground",255,255,255,KviOption_sectFlagLabel),
	COLOR_OPTION("LabelForeground",0,0,0,KviOption_sectFlagLabel),
	COLOR_OPTION("GlobalTransparencyFade",255,255,255,KviOption_sectFlagGui | KviOption_resetUpdatePseudoTransparency),
	COLOR_OPTION("IrcToolBarAppletBackground",255,255,255,KviOption_sectFlagIrcToolBar),
	COLOR_OPTION("IrcToolBarAppletForegroundLowContrast",180,180,180,KviOption_sectFlagIrcToolBar),
	COLOR_OPTION("IrcToolBarAppletForegroundMidContrast",110,110,110,KviOption_sectFlagIrcToolBar),
	COLOR_OPTION("IrcToolBarAppletForegroundHighContrastInactive1",40,40,40,KviOption_sectFlagIrcToolBar),
	COLOR_OPTION("IrcToolBarAppletForegroundHighContrastInactive2",40,40,40,KviOption_sectFlagIrcToolBar),
	COLOR_OPTION("IrcToolBarAppletForegroundHighContrastActive1",0,0,0,KviOption_sectFlagIrcToolBar),
	COLOR_OPTION("IrcToolBarAppletForegroundHighContrastActive2",0,60,0,KviOption_sectFlagIrcToolBar),
	COLOR_OPTION("TreeTaskBarBackground",255,255,255,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TreeTaskBarActiveBackground",200,200,200,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TreeTaskBarForeground",0,0,0,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TreeTaskBarActiveForeground",0,0,0,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TreeTaskBarHighlight1Foreground",0,16,144,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TreeTaskBarHighlight2Foreground",32,0,255,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TreeTaskBarProgress",150,150,150,KviOption_sectFlagTaskBar),
	COLOR_OPTION("UserListViewHalfOpForeground",119,0,178,KviOption_sectFlagUserListView),
	COLOR_OPTION("TaskBarHighlight3Text",128,20,255,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TaskBarHighlight4Text",220,0,255,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TaskBarHighlight5Text",255,0,0,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TreeTaskBarHighlight3Foreground",128,0,255,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TreeTaskBarHighlight4Foreground",220,0,255,KviOption_sectFlagTaskBar),
	COLOR_OPTION("TreeTaskBarHighlight5Foreground",255,0,0,KviOption_sectFlagTaskBar)
};


#define IC_COLOR_OPTION(_num,_red,_green,_blue) \
	KviColorOption( \
		KVI_ICCOLOR_OPTIONS_PREFIX _num, \
		QColor(_red,_green,_blue), \
		KviOption_sectFlagTaskBar | KviOption_resetUpdateGui)

KviColorOption g_iccolorOptionsTable[KVI_NUM_ICCOLOR_OPTIONS]=
{
	IC_COLOR_OPTION("0",250,250,0),
	IC_COLOR_OPTION("1",0,0,0),
	IC_COLOR_OPTION("2",0,0,200),
	IC_COLOR_OPTION("3",200,0,0),
	IC_COLOR_OPTION("4",255,255,255),
	IC_COLOR_OPTION("5",0,150,190),
	IC_COLOR_OPTION("6",0,130,0),
	IC_COLOR_OPTION("7",150,0,170)
};

#define PIXMAP_OPTION(_name,_flags) \
	KviPixmapOption( \
		KVI_PIXMAP_OPTIONS_PREFIX _name , \
		KviPixmap(), \
		_flags | KviOption_resetUpdateGui)

KviPixmapOption g_pixmapOptionsTable[KVI_NUM_PIXMAP_OPTIONS]=
{
	PIXMAP_OPTION("MdiBackground",KviOption_sectFlagMdi),
	PIXMAP_OPTION("IrcViewBackground",KviOption_sectFlagIrcView),
	PIXMAP_OPTION("InputBackground",KviOption_sectFlagInput),
	PIXMAP_OPTION("UserListViewBackground",KviOption_sectFlagUserListView),
	PIXMAP_OPTION("LabelBackground",KviOption_sectFlagLabel),
	PIXMAP_OPTION("MyAvatar",KviOption_sectFlagUser),
	PIXMAP_OPTION("IrcToolBarAppletBackground",KviOption_sectFlagIrcToolBar),
	PIXMAP_OPTION("TreeTaskBarBackground",KviOption_sectFlagTaskBar),
	PIXMAP_OPTION("GlobalTransparencyBackground",KviOption_sectFlagGui | KviOption_resetUpdatePseudoTransparency)
};

//#define INT_OPTION(_name,_value,_flags) 
//	{ 
//		KVI_INT_OPTIONS_PREFIX _name , 
//		_value , 
//		_flags 
//	}
//
//KviIntOption g_intOptionsTable[KVI_NUM_INT_OPTIONS]=
//{
//	INT_OPTION("IrcViewMaxBufferSize",KVI_IRCVIEW_MAX_LINES,KviOption_sectFlagIrcView),
//	INT_OPTION("IrcViewTollTipTimeoutInMsec",1800,KviOption_sectFlagIrcView),
//	INT_OPTION("IrcViewToolTipHideTimeoutInMsec",10000,KviOption_sectFlagIrcView)
//};

#define UINT_OPTION(_name,_value,_flags) \
	KviUIntOption( \
		KVI_UINT_OPTIONS_PREFIX _name , \
		_value , \
		_flags \
	)

KviUIntOption g_uintOptionsTable[KVI_NUM_UINT_OPTIONS]=
{
	UINT_OPTION("IrcSocketTimeout",60,KviOption_sectFlagIrcSocket),
	UINT_OPTION("ModuleCleanupTimerInterval",90,KviOption_sectFlagModules),
	UINT_OPTION("ModuleCleanupTimeout",180,KviOption_sectFlagModules),
	UINT_OPTION("MaxCtcpRequests",2,KviOption_sectFlagCtcp),
	UINT_OPTION("CtcpFloodCheckInterval",6,KviOption_sectFlagCtcp),
	UINT_OPTION("ModeChangesPerMessage",3,KviOption_sectFlagUserParser),
	UINT_OPTION("DccSocketTimeout",180,KviOption_sectFlagDcc),
	UINT_OPTION("DccSendIdleStepInMSec",30,KviOption_sectFlagDcc),
	UINT_OPTION("DccSendPacketSize",512,KviOption_sectFlagDcc),
	UINT_OPTION("GlobalTransparencyParentFadeFactor",10,KviOption_sectFlagGui | KviOption_resetUpdatePseudoTransparency),
	UINT_OPTION("GlobalTransparencyChildFadeFactor",50,KviOption_sectFlagGui | KviOption_resetUpdatePseudoTransparency),
	UINT_OPTION("NotifyListCheckTimeInSecs",180,KviOption_sectFlagConnection),
	UINT_OPTION("SocketQueueFlushTimeout",500,KviOption_sectFlagIrcSocket),
	UINT_OPTION("OutgoingTrafficLimitUSeconds",2000000,KviOption_sectFlagIrcSocket),
	UINT_OPTION("NotifyListIsOnDelayTimeInSecs",5,KviOption_sectFlagConnection),
	UINT_OPTION("NotifyListUserhostDelayTimeInSecs",5,KviOption_sectFlagConnection),
	UINT_OPTION("TreeTaskBarMinimumWidth",24,KviOption_sectFlagTaskBar | KviOption_resetUpdateTaskBar),
	UINT_OPTION("AvatarOfferTimeoutInSecs",60,KviOption_sectFlagAvatar),
	UINT_OPTION("IrcViewMaxBufferSize",KVI_IRCVIEW_MAX_LINES,KviOption_sectFlagIrcView),
	UINT_OPTION("IrcViewToolTipTimeoutInMsec",1200,KviOption_sectFlagIrcView),
	UINT_OPTION("IrcViewToolTipHideTimeoutInMsec",12000,KviOption_sectFlagIrcView),
	UINT_OPTION("DccVoicePreBufferSize",32000,KviOption_sectFlagDcc),
	UINT_OPTION("IdentdPort",113,KviOption_sectFlagConnection | KviOption_resetRestartIdentd),
	UINT_OPTION("AvatarScaleWidth",80,KviOption_sectFlagAvatar | KviOption_resetUpdateGui),
	UINT_OPTION("AvatarScaleHeight",80,KviOption_sectFlagAvatar | KviOption_resetUpdateGui),
	UINT_OPTION("DccMinPort",30000,KviOption_sectFlagDcc),
	UINT_OPTION("DccMaxPort",31000,KviOption_sectFlagDcc),
	UINT_OPTION("SoundOfferTimeoutInSecs",60,KviOption_sectFlagConnection),
	UINT_OPTION("MaximumRequestedAvatarSize",102400,KviOption_sectFlagAvatar),
	//FIXME XXX: Change the section!!! <---- ugh :D
	UINT_OPTION("SoundSystem",1,KviOption_sectFlagIrcView),
    UINT_OPTION("TreeTaskBarMaximumWidth",200,KviOption_sectFlagTaskBar | KviOption_resetUpdateTaskBar),
    UINT_OPTION("PasteDelay",2000,KviOption_sectFlagInput),
	UINT_OPTION("MaxDccSendTransfers",10,KviOption_sectFlagDcc),
	UINT_OPTION("MaxDccSlots",64,KviOption_sectFlagDcc),
	UINT_OPTION("TileMethod",5,KviOption_sectFlagMdi)
};

#define FONT_OPTION(_name,_face,_size,_flags) \
	KviFontOption( \
		KVI_FONT_OPTIONS_PREFIX _name , \
		QFont(_face,_size) , \
		_flags \
	)

KviFontOption g_fontOptionsTable[KVI_NUM_FONT_OPTIONS]=
{
#ifdef COMPILE_ON_WINDOWS
	FONT_OPTION("IrcView","Arial",9,KviOption_sectFlagIrcView | KviOption_resetUpdateGui),
	FONT_OPTION("Input","Arial",12,KviOption_sectFlagInput | KviOption_resetUpdateGui),
	FONT_OPTION("UserListView","Arial",9,KviOption_sectFlagUserListView | KviOption_resetUpdateGui),
	FONT_OPTION("Label","Arial",9,KviOption_sectFlagLabel | KviOption_resetUpdateGui),
	FONT_OPTION("Application","Arial",9,KviOption_sectFlagGui | KviOption_resetUpdateAppFont),
	FONT_OPTION("IrcToolBarApplet","Arial",9,KviOption_sectFlagIrcToolBar | KviOption_resetUpdateIrcToolBars)
#else
	#if QT_VERSION >= 300
		FONT_OPTION("IrcView","helvetica",10,KviOption_sectFlagIrcView | KviOption_resetUpdateGui),
		FONT_OPTION("Input","helvetica",12,KviOption_sectFlagInput | KviOption_resetUpdateGui),
		FONT_OPTION("UserListView","helvetica",10,KviOption_sectFlagUserListView | KviOption_resetUpdateGui),
		FONT_OPTION("Label","helvetica",10,KviOption_sectFlagLabel | KviOption_resetUpdateGui),
		FONT_OPTION("Application","helvetica",10,KviOption_sectFlagGui | KviOption_resetUpdateAppFont),
		FONT_OPTION("IrcToolBarApplet","helvetica",10,KviOption_sectFlagIrcToolBar | KviOption_resetUpdateIrcToolBars)
	#else
		FONT_OPTION("IrcView","helvetica",12,KviOption_sectFlagIrcView | KviOption_resetUpdateGui),
		FONT_OPTION("Input","helvetica",16,KviOption_sectFlagInput | KviOption_resetUpdateGui),
		FONT_OPTION("UserListView","helvetica",12,KviOption_sectFlagUserListView | KviOption_resetUpdateGui),
		FONT_OPTION("Label","helvetica",12,KviOption_sectFlagLabel | KviOption_resetUpdateGui),
		FONT_OPTION("Application","helvetica",12,KviOption_sectFlagGui | KviOption_resetUpdateAppFont),
		FONT_OPTION("IrcToolBarApplet","helvetica",10,KviOption_sectFlagIrcToolBar | KviOption_resetUpdateIrcToolBars)
	#endif
#endif
};

#define MSGTYPE_OPTION(_name,_text,_icon,_levl) \
	KviMsgTypeOption( \
		KVI_MSGTYPE_OPTIONS_PREFIX _name , \
		KviMsgType(_text,_icon,KVI_BLACK,KVI_TRANSPARENT,true,_levl), \
		KviOption_sectFlagMsgType \
	)

#define MSGTYPE_OPTION_SPEC(_name,_text,_icon,_fore,_back,_levl) \
	KviMsgTypeOption( \
		KVI_MSGTYPE_OPTIONS_PREFIX _name , \
		KviMsgType(_text,_icon,_fore,_back,true,_levl), \
		KviOption_sectFlagMsgType \
	)



// FIXME: #warning "FIX THE ICONS HERE!!!"

KviMsgTypeOption g_msgtypeOptionsTable[KVI_NUM_MSGTYPE_OPTIONS]=
{
	MSGTYPE_OPTION("Echo",__tr("normal text"),KVI_SMALLICON_NONE,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION_SPEC("Selection",__tr("selection"),KVI_SMALLICON_NONE,KVI_WHITE,KVI_BLACK,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION_SPEC("Highlight",__tr("highlighted text"),KVI_SMALLICON_NONE,KVI_WHITE,KVI_BLACK,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION_SPEC("Url",__tr("url foreground"),KVI_SMALLICON_NONE,KVI_BLUE,KVI_TRANSPARENT,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION_SPEC("Link",__tr("link overlay foreground"),KVI_SMALLICON_NONE,KVI_BLUE,KVI_TRANSPARENT,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION_SPEC("ParserError",__tr("parser error"),KVI_SMALLICON_PARSERERROR,KVI_RED,KVI_TRANSPARENT,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION_SPEC("ParserWarning",__tr("parser warning"),KVI_SMALLICON_PARSERWARNING,KVI_RED,KVI_TRANSPARENT,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("HostLookup",__tr("host lookup result"),KVI_SMALLICON_SERVER,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("SocketMessage",__tr("socket message"),KVI_SMALLICON_SOCKETMESSAGE,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("SocketWarning",__tr("socket warning"),KVI_SMALLICON_SOCKETWARNING,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION_SPEC("SocketError",__tr("socket error"),KVI_SMALLICON_SOCKETERROR,KVI_RED,KVI_TRANSPARENT,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION_SPEC("SystemError",__tr("system error"),KVI_SMALLICON_SYSTEMERROR,KVI_RED,KVI_TRANSPARENT,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("Raw",__tr("raw data to server"),KVI_SMALLICON_RAW,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("Connection",__tr("connection status"),KVI_SMALLICON_WORLD,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("SystemWarning",__tr("system warning"),KVI_SMALLICON_SYSTEMWARNING,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("SystemMessage",__tr("system message"),KVI_SMALLICON_SYSTEMMESSAGE,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("UnhandledReply",__tr("unhandled server reply"),KVI_SMALLICON_UNHANDLED,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("ServerInfo",__tr("server informations"),KVI_SMALLICON_SERVERINFO,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("Motd",__tr("server message of the day"),KVI_SMALLICON_MOTD,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("ServerPing",__tr("server ping"),KVI_SMALLICON_SERVERPING,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("Join",__tr("join message"),KVI_SMALLICON_JOIN,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("Part",__tr("part message"),KVI_SMALLICON_PART,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("Unrecognized",__tr("unrecognized/broken message"),KVI_SMALLICON_UNRECOGNIZED,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Topic",__tr("topic message"),KVI_SMALLICON_TOPIC,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("OwnPrivateMessage",__tr("own private message"),KVI_SMALLICON_OWNPRIVMSG,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("ChannelPrivateMessage",__tr("channel private message"),KVI_SMALLICON_CHANPRIVMSG,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("QueryPrivateMessage",__tr("query private message"),KVI_SMALLICON_QUERYPRIVMSG,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("CtcpReply",__tr("CTCP reply"),KVI_SMALLICON_CTCPREPLY,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("CtcpRequestReplied",__tr("CTCP request replied"),KVI_SMALLICON_CTCPREQUESTREPLIED,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("CtcpRequestIgnored",__tr("CTCP request ignored"),KVI_SMALLICON_CTCPREQUESTIGNORED,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("CtcpRequestFlood",__tr("CTCP request flood warning"),KVI_SMALLICON_CTCPREQUESTFLOOD,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("CtcpRequestUnknown",__tr("CTCP request unknown"),KVI_SMALLICON_CTCPREQUESTUNKNOWN,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("Action",__tr("user action"),KVI_SMALLICON_ACTION,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("AvatarChange",__tr("avatar change"),KVI_SMALLICON_AVATAR,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("Quit",__tr("quit message"),KVI_SMALLICON_QUIT,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("Split",__tr("split message"),KVI_SMALLICON_SPLIT,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("QuitSplit",__tr("quit on split message"),KVI_SMALLICON_QUITSPLIT,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Nick",__tr("nick changes"),KVI_SMALLICON_NICK,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Op",__tr("+o mode change"),KVI_SMALLICON_OP,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Deop",__tr("-o mode change"),KVI_SMALLICON_DEOP,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Voice",__tr("+v mode change"),KVI_SMALLICON_VOICE,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Devoice",__tr("-v mode change"),KVI_SMALLICON_DEVOICE,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Mode",__tr("multiple user mode change"),KVI_SMALLICON_MODE,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Key",__tr("channel key change"),KVI_SMALLICON_KEY,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Limit",__tr("channel limit change"),KVI_SMALLICON_LIMIT,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Ban",__tr("+b mode change"),KVI_SMALLICON_BAN,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Unban",__tr("-b mode change"),KVI_SMALLICON_UNBAN,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("BanExcept",__tr("+e mode change"),KVI_SMALLICON_BANEXCEPT,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("BanUnexcept",__tr("-e mode change change"),KVI_SMALLICON_BANUNEXCEPT,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("InviteExcept",__tr("+I mode change"),KVI_SMALLICON_INVITEEXCEPT,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("InviteUnexcept",__tr("-I mode change"),KVI_SMALLICON_INVITEUNEXCEPT,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("ChanMode",__tr("multiple channel mode change"),KVI_SMALLICON_CHANMODE,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Who",__tr("who reply"),KVI_SMALLICON_WHO,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("DccRequest",__tr("dcc request"),KVI_SMALLICON_DCCREQUEST,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("DccMsg",__tr("dcc message"),KVI_SMALLICON_DCCMSG,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("DccError",__tr("dcc error"),KVI_SMALLICON_DCCERROR,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("NicknameProblem",__tr("nickname problem"),KVI_SMALLICON_NICKNAMEPROBLEM,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("WhoisUser",__tr("whois user reply"),KVI_SMALLICON_WHOISUSER,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("WhoisChannels",__tr("whois channels reply"),KVI_SMALLICON_WHOISCHANNELS,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("WhoisIdle",__tr("whois idle reply"),KVI_SMALLICON_WHOISIDLE,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("WhoisServer",__tr("whois server reply"),KVI_SMALLICON_WHOISSERVER,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("WhoisOther",__tr("whois other reply"),KVI_SMALLICON_WHOISOTHER,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("CreationTime",__tr("creation time reply"),KVI_SMALLICON_TIME,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("NotifyOnLine",__tr("notify list joins"),KVI_SMALLICON_NOTIFYONLINE,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("NotifyOffLine",__tr("notify list leaves"),KVI_SMALLICON_NOTIFYOFFLINE,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("OwnPrivmsgCrypted",__tr("own crypted private message"),KVI_SMALLICON_OWNPRIVMSGCRYPTED,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("ChanPrivmsgCrypted",__tr("channel crypted private message"),KVI_SMALLICON_CHANPRIVMSGCRYPTED,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("QueryPrivmsgCrypted",__tr("query crypted private message"),KVI_SMALLICON_QUERYPRIVMSGCRYPTED,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("DccChatMsg",__tr("DCC chat message"),KVI_SMALLICON_DCCCHATMSG,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("DccChatMsgCrypted",__tr("crypted dcc chat message"),KVI_SMALLICON_DCCCHATMSGCRYPTED,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("Irc",__tr("login operations completed"),KVI_SMALLICON_IRC,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("Kick",__tr("kick action"),KVI_SMALLICON_KICK,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Links",__tr("links reply"),KVI_SMALLICON_LINKS,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("Spam",__tr("spam report"),KVI_SMALLICON_SPAM,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("Icq",__tr("ICQ message"),KVI_SMALLICON_ICQ,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("IcqMessage",__tr("ICQ user-message"),KVI_SMALLICON_MESSAGE,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("IcqMessageSent",__tr("outgoing irc user-message"),KVI_SMALLICON_MESSAGESENT,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("ChannelNotice",__tr("channel notice"),KVI_SMALLICON_CHANNELNOTICE,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("ChannelNoticeCrypted",__tr("crypted channel notice"),KVI_SMALLICON_CHANNELNOTICECRYPTED,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("QueryNotice",__tr("query notice"),KVI_SMALLICON_QUERYNOTICE,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("QueryNoticeCrypted",__tr("query notice crypted"),KVI_SMALLICON_QUERYNOTICECRYPTED,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("ServerNotice",__tr("server notice"),KVI_SMALLICON_SERVERNOTICE,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("HalfOp",__tr("half op mode change"),KVI_SMALLICON_HALFOP,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("CtcpReplyUnknown",__tr("unknown CTCP reply"),KVI_SMALLICON_CTCPREPLYUNKNOWN,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("NickServ",__tr("NickServ message"),KVI_SMALLICON_NICKSERV,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("ChanServ",__tr("ChanServ message"),KVI_SMALLICON_CHANSERV,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("Away",__tr("away message"),KVI_SMALLICON_AWAY,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("Ident",__tr("ident message"),KVI_SMALLICON_IDENT,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("List",__tr("channel list message"),KVI_SMALLICON_LIST,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("HalfDeOp",__tr("half deop mode change"),KVI_SMALLICON_HALFDEOP,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("Invite",__tr("invite message"),KVI_SMALLICON_INVITE,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("Multimedia",__tr("multimedia message"),KVI_SMALLICON_MULTIMEDIA,KVI_MSGTYPE_LEVEL_2),
	MSGTYPE_OPTION("QueryTrace",__tr("query trace message"),KVI_SMALLICON_QUERYTRACE,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("Wallops",__tr("wallops message"),KVI_SMALLICON_WALLOPS,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("JoinError",__tr("join error message"),KVI_SMALLICON_NOCHANNEL,KVI_MSGTYPE_LEVEL_4),
	MSGTYPE_OPTION("BroadcastPrivmsg",__tr("broadcast private message"),KVI_SMALLICON_BROADCASTPRIVMSG,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("BroadcastNotice",__tr("broadcast notice"),KVI_SMALLICON_BROADCASTNOTICE,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("MeKick",__tr("me kicked"),KVI_SMALLICON_MEKICK,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("MeOp",__tr("me oped"),KVI_SMALLICON_MEOP,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("MeVoice",__tr("me voiced"),KVI_SMALLICON_MEVOICE,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("MeDeOp",__tr("me de-oped"),KVI_SMALLICON_MEDEOP,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("MeDeVoice",__tr("me de-voiced"),KVI_SMALLICON_MEDEVOICE,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("MeHalfOp",__tr("me half-oped"),KVI_SMALLICON_MEHALFOP,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("MeDeHalfOp",__tr("me de-half-oped"),KVI_SMALLICON_MEDEHALFOP,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("MeBan",__tr("ban matching my mask"),KVI_SMALLICON_MEBAN,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("MeUnban",__tr("unban matching my mask"),KVI_SMALLICON_MEUNBAN,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("MeBanExcept",__tr("ban exception matching my mask"),KVI_SMALLICON_MEBANEXCEPT,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("MeBanUnExcept",__tr("ban unexception matching my mask"),KVI_SMALLICON_MEBANUNEXCEPT,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("MeInviteExcept",__tr("invite exception matching my mask"),KVI_SMALLICON_MEINVITEEXCEPT,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("MeInviteUnexcept",__tr("invite unexception matching my mask"),KVI_SMALLICON_MEINVITEUNEXCEPT,KVI_MSGTYPE_LEVEL_5),
	MSGTYPE_OPTION("Ignore",__tr("ignored user message"),KVI_SMALLICON_IGNORE,KVI_MSGTYPE_LEVEL_3),
	MSGTYPE_OPTION("Stats",__tr("server statistics"),KVI_SMALLICON_STATS,KVI_MSGTYPE_LEVEL_1),
	MSGTYPE_OPTION("SSL",__tr("ssl message"),KVI_SMALLICON_SSL,KVI_MSGTYPE_LEVEL_1)
};

static const char * options_section_table[KVI_NUM_OPTION_SECT_FLAGS] =
{
	"None",          "Frame",       "Mdi",              "Windows",
	"TaskBar",       "IrcView",     "MsgType",          "MircColor",
	"Input",         "UserParser",  "Connection",       "IrcSocket",
	"User",          "UserListView","Label",            "Modules",
	"Ctcp",          "Dcc",         "Gui",              "IrcToolBar",
	"Logging",       "AntiSpam",    "Avatar",           "Url",
	"Recent"
};


static void config_set_section(int flag,KviConfig * cfg)
{
	int index = flag & KviOption_sectMask;
	if((index < KVI_NUM_OPTION_SECT_FLAGS) && (index >= 0))
	{
		cfg->setGroup(options_section_table[index]);
	} else cfg->setGroup(""); // Default group
}


void KviApp::loadOptions()
{

	KviStr buffer;
	if(getReadOnlyConfigPath(buffer,KVI_CONFIGFILE_MAIN))
	{
		KviConfig cfg(buffer.ptr());

		int prg = 4;
		int i;

		#define READ_OPTIONS(_num,_table,_readFnc) \
		for(i=0;i<_num;i++) \
		{ \
			config_set_section(_table[i].flags,&cfg); \
			_table[i].option = cfg._readFnc(_table[i].name,_table[i].option); \
		} \
		prg += 3; \
		KVI_SPLASH_SET_PROGRESS(prg)

		READ_OPTIONS(KVI_NUM_RECT_OPTIONS,g_rectOptionsTable,readRectEntry)
		READ_OPTIONS(KVI_NUM_BOOL_OPTIONS,g_boolOptionsTable,readBoolEntry)
		READ_OPTIONS(KVI_NUM_STRING_OPTIONS,g_stringOptionsTable,readEntry)
		READ_OPTIONS(KVI_NUM_COLOR_OPTIONS,g_colorOptionsTable,readColorEntry)
		READ_OPTIONS(KVI_NUM_PIXMAP_OPTIONS,g_pixmapOptionsTable,readPixmapEntry)
//		READ_OPTIONS(KVI_NUM_INT_OPTIONS,g_intOptionsTable,readIntEntry)
		READ_OPTIONS(KVI_NUM_UINT_OPTIONS,g_uintOptionsTable,readUIntEntry)
		READ_OPTIONS(KVI_NUM_FONT_OPTIONS,g_fontOptionsTable,readFontEntry)
		READ_OPTIONS(KVI_NUM_MSGTYPE_OPTIONS,g_msgtypeOptionsTable,readMsgTypeEntry)
		READ_OPTIONS(KVI_NUM_STRINGLIST_OPTIONS,g_stringlistOptionsTable,readStringListEntry)
		READ_OPTIONS(KVI_NUM_MIRCCOLOR_OPTIONS,g_mirccolorOptionsTable,readColorEntry)
		READ_OPTIONS(KVI_NUM_ICCOLOR_OPTIONS,g_iccolorOptionsTable,readColorEntry)

	} // else already have the defaults
}

void KviApp::saveOptions()
{
	KviStr buffer;
	getLocalKvircDirectory(buffer,Config,KVI_CONFIGFILE_MAIN);
	KviConfig cfg(buffer.ptr());

	int i;

	#define WRITE_OPTIONS(_num,_table) \
	for(i=0;i<_num;i++) \
	{ \
		config_set_section(_table[i].flags,&cfg); \
		cfg.writeEntry(_table[i].name,_table[i].option); \
	}

	WRITE_OPTIONS(KVI_NUM_RECT_OPTIONS,g_rectOptionsTable)
	WRITE_OPTIONS(KVI_NUM_BOOL_OPTIONS,g_boolOptionsTable)
	WRITE_OPTIONS(KVI_NUM_STRING_OPTIONS,g_stringOptionsTable)
	WRITE_OPTIONS(KVI_NUM_COLOR_OPTIONS,g_colorOptionsTable)
	WRITE_OPTIONS(KVI_NUM_PIXMAP_OPTIONS,g_pixmapOptionsTable)
//	WRITE_OPTIONS(KVI_NUM_INT_OPTIONS,g_intOptionsTable)
	WRITE_OPTIONS(KVI_NUM_UINT_OPTIONS,g_uintOptionsTable)
	WRITE_OPTIONS(KVI_NUM_FONT_OPTIONS,g_fontOptionsTable)
	WRITE_OPTIONS(KVI_NUM_MSGTYPE_OPTIONS,g_msgtypeOptionsTable)
	WRITE_OPTIONS(KVI_NUM_STRINGLIST_OPTIONS,g_stringlistOptionsTable)
	WRITE_OPTIONS(KVI_NUM_MIRCCOLOR_OPTIONS,g_mirccolorOptionsTable)
	WRITE_OPTIONS(KVI_NUM_ICCOLOR_OPTIONS,g_iccolorOptionsTable)

}



void KviApp::listAvailableOptions(KviWindow *wnd)
{
	int i;

	#define LIST_OPTIONS(__txt,__num,__table) \
		wnd->output(KVI_OUT_SYSTEMMESSAGE,"%c%s%c",KVI_TEXT_BOLD,__txt,KVI_TEXT_BOLD); \
		for(i = 0;i < __num;i++)wnd->outputNoFmt(KVI_OUT_SYSTEMMESSAGE,__table[i].name);

	LIST_OPTIONS(__tr("Boolean options (1/0)"),KVI_NUM_BOOL_OPTIONS,g_boolOptionsTable)
	LIST_OPTIONS(__tr("Rectangle options (x,y,width,height)"),KVI_NUM_RECT_OPTIONS,g_rectOptionsTable)
	LIST_OPTIONS(__tr("String options (string value)"),KVI_NUM_STRING_OPTIONS,g_stringOptionsTable)
	LIST_OPTIONS(__tr("Color options (#RRGGBB)"),KVI_NUM_COLOR_OPTIONS,g_colorOptionsTable)
	LIST_OPTIONS(__tr("Mirccolor options (#RRGGBB)"),KVI_NUM_MIRCCOLOR_OPTIONS,g_mirccolorOptionsTable)
	LIST_OPTIONS(__tr("Irc context color options (#RRGGBB)"),KVI_NUM_ICCOLOR_OPTIONS,g_iccolorOptionsTable)
	LIST_OPTIONS(__tr("Pixmap options (image path)"),KVI_NUM_PIXMAP_OPTIONS,g_pixmapOptionsTable)
//	LIST_OPTIONS(__tr("Integer options (signed integer constant)"),KVI_NUM_INT_OPTIONS,g_intOptionsTable)
	LIST_OPTIONS(__tr("Unsigned integer options (unsigned integer constant)"),KVI_NUM_UINT_OPTIONS,g_uintOptionsTable)
	LIST_OPTIONS(__tr("Font options (family,pointsize,style,charset,weight,flags (biusf))"),KVI_NUM_FONT_OPTIONS,g_fontOptionsTable)
	LIST_OPTIONS(__tr("Message color options (image_id,foreground,background,logFlag (0/1))"),KVI_NUM_MSGTYPE_OPTIONS,g_msgtypeOptionsTable)
	LIST_OPTIONS(__tr("String list options (comma separated list of strings)"),KVI_NUM_STRINGLIST_OPTIONS,g_stringlistOptionsTable)

	#undef LIST_OPTIONS
}

//using namespace KviStringConversion;

bool KviApp::getOptionString(const char * optName,KviStr &buffer)
{

	#define GET_OPTION_STRING(__numOpt,__table,__prefix,__prefixLen) \
		if(kvi_strEqualCIN(optName,__prefix,__prefixLen)) \
		{ \
			for(int i=0;i < __numOpt;i++) \
			{ \
				if(kvi_strEqualCI(optName,__table[i].name)) \
				{ \
					KviStringConversion::toString(__table[i].option,buffer); \
					return true; \
				} \
			} \
			return false; \
		}

	// WARNING : stringlist prefix must go BEFORE the string prefix (otherwise it will match)

	GET_OPTION_STRING(KVI_NUM_BOOL_OPTIONS,g_boolOptionsTable,KVI_BOOL_OPTIONS_PREFIX,KVI_BOOL_OPTIONS_PREFIX_LEN)
	GET_OPTION_STRING(KVI_NUM_RECT_OPTIONS,g_rectOptionsTable,KVI_BOOL_OPTIONS_PREFIX,KVI_BOOL_OPTIONS_PREFIX_LEN)
	GET_OPTION_STRING(KVI_NUM_STRINGLIST_OPTIONS,g_stringlistOptionsTable,KVI_STRINGLIST_OPTIONS_PREFIX,KVI_STRINGLIST_OPTIONS_PREFIX_LEN)
	GET_OPTION_STRING(KVI_NUM_STRING_OPTIONS,g_stringOptionsTable,KVI_STRING_OPTIONS_PREFIX,KVI_STRING_OPTIONS_PREFIX_LEN)
	GET_OPTION_STRING(KVI_NUM_COLOR_OPTIONS,g_colorOptionsTable,KVI_COLOR_OPTIONS_PREFIX,KVI_COLOR_OPTIONS_PREFIX_LEN)
	GET_OPTION_STRING(KVI_NUM_MIRCCOLOR_OPTIONS,g_mirccolorOptionsTable,KVI_MIRCCOLOR_OPTIONS_PREFIX,KVI_MIRCCOLOR_OPTIONS_PREFIX_LEN)
	GET_OPTION_STRING(KVI_NUM_ICCOLOR_OPTIONS,g_iccolorOptionsTable,KVI_ICCOLOR_OPTIONS_PREFIX,KVI_ICCOLOR_OPTIONS_PREFIX_LEN)
	GET_OPTION_STRING(KVI_NUM_PIXMAP_OPTIONS,g_pixmapOptionsTable,KVI_PIXMAP_OPTIONS_PREFIX,KVI_PIXMAP_OPTIONS_PREFIX_LEN)
//	GET_OPTION_STRING(KVI_NUM_INT_OPTIONS,g_intOptionsTable,KVI_INT_OPTIONS_PREFIX,KVI_INT_OPTIONS_PREFIX_LEN)
	GET_OPTION_STRING(KVI_NUM_UINT_OPTIONS,g_uintOptionsTable,KVI_UINT_OPTIONS_PREFIX,KVI_UINT_OPTIONS_PREFIX_LEN)
	GET_OPTION_STRING(KVI_NUM_FONT_OPTIONS,g_fontOptionsTable,KVI_FONT_OPTIONS_PREFIX,KVI_FONT_OPTIONS_PREFIX_LEN)
	GET_OPTION_STRING(KVI_NUM_MSGTYPE_OPTIONS,g_msgtypeOptionsTable,KVI_MSGTYPE_OPTIONS_PREFIX,KVI_MSGTYPE_OPTIONS_PREFIX_LEN)
	return false;

	#undef GET_OPTION_STRING
}

void KviApp::optionResetUpdate(int flags)
{
	if(flags & KviOption_resetUpdateIrcToolBars)
	{
		updateIrcToolBars();
	}

	if(flags & KviOption_resetUpdateCaption)
	{
		updateFrameCaptions();
	}

	if(flags & KviOption_resetUpdateAppFont)
	{
		updateApplicationFont();
	}

#ifdef COMPILE_PSEUDO_TRANSPARENCY
	if(flags & KviOption_resetUpdatePseudoTransparency)
	{
		triggerUpdatePseudoTransparency();
	}
#endif

	if(flags & KviOption_resetRestartIdentd)
	{
		if(g_bIdentDaemonRunning)
			activeFrame()->executeInternalCommand(KVI_INTERNALCOMMAND_IDENT_STOP);
		if(g_boolOptionsTable[KviOption_boolUseIdentService].option)
			activeFrame()->executeInternalCommand(KVI_INTERNALCOMMAND_IDENT_START);
	}

	if(flags & KviOption_resetUpdateGuiEffects)
	{
		updateGuiEffects();
	}

	if(flags & KviOption_resetUpdateGui)
	{
		triggerUpdateGui();
	}

	if(flags & KviOption_resetUpdateTaskBar)
	{
		updateTaskBar();
	}

	if(flags & KviOption_resetRestartNotifyList)
	{
		g_pApp->restartNotifyLists();
	}
}

bool KviApp::setOptionValue(const char * optName,const char * value)
{

	#define SET_OPTION_VALUE(__numOpt,__table,__prefix,__prefixLen) \
		if(kvi_strEqualCIN(optName,__prefix,__prefixLen)) \
		{ \
			for(int i=0;i < __numOpt;i++) \
			{ \
				if(kvi_strEqualCI(optName,__table[i].name)) \
				{ \
					if(!KviStringConversion::fromString(value,__table[i].option))return false; \
					optionResetUpdate(__table[i].flags); \
					return true; \
				} \
			} \
			return false; \
		}

	SET_OPTION_VALUE(KVI_NUM_BOOL_OPTIONS,g_boolOptionsTable,KVI_BOOL_OPTIONS_PREFIX,KVI_BOOL_OPTIONS_PREFIX_LEN)
	SET_OPTION_VALUE(KVI_NUM_RECT_OPTIONS,g_rectOptionsTable,KVI_BOOL_OPTIONS_PREFIX,KVI_BOOL_OPTIONS_PREFIX_LEN)
	SET_OPTION_VALUE(KVI_NUM_STRINGLIST_OPTIONS,g_stringlistOptionsTable,KVI_STRINGLIST_OPTIONS_PREFIX,KVI_STRINGLIST_OPTIONS_PREFIX_LEN)
	SET_OPTION_VALUE(KVI_NUM_STRING_OPTIONS,g_stringOptionsTable,KVI_STRING_OPTIONS_PREFIX,KVI_STRING_OPTIONS_PREFIX_LEN)
	SET_OPTION_VALUE(KVI_NUM_COLOR_OPTIONS,g_colorOptionsTable,KVI_COLOR_OPTIONS_PREFIX,KVI_COLOR_OPTIONS_PREFIX_LEN)
	SET_OPTION_VALUE(KVI_NUM_MIRCCOLOR_OPTIONS,g_mirccolorOptionsTable,KVI_MIRCCOLOR_OPTIONS_PREFIX,KVI_MIRCCOLOR_OPTIONS_PREFIX_LEN)
	SET_OPTION_VALUE(KVI_NUM_ICCOLOR_OPTIONS,g_iccolorOptionsTable,KVI_ICCOLOR_OPTIONS_PREFIX,KVI_ICCOLOR_OPTIONS_PREFIX_LEN)
//	SET_OPTION_VALUE(KVI_NUM_PIXMAP_OPTIONS,g_pixmapOptionsTable,KVI_PIXMAP_OPTIONS_PREFIX,KVI_PIXMAP_OPTIONS_PREFIX_LEN)
//	SET_OPTION_VALUE(KVI_NUM_INT_OPTIONS,g_intOptionsTable,KVI_INT_OPTIONS_PREFIX,KVI_INT_OPTIONS_PREFIX_LEN)
	SET_OPTION_VALUE(KVI_NUM_UINT_OPTIONS,g_uintOptionsTable,KVI_UINT_OPTIONS_PREFIX,KVI_UINT_OPTIONS_PREFIX_LEN)
	SET_OPTION_VALUE(KVI_NUM_FONT_OPTIONS,g_fontOptionsTable,KVI_FONT_OPTIONS_PREFIX,KVI_FONT_OPTIONS_PREFIX_LEN)
	SET_OPTION_VALUE(KVI_NUM_MSGTYPE_OPTIONS,g_msgtypeOptionsTable,KVI_MSGTYPE_OPTIONS_PREFIX,KVI_MSGTYPE_OPTIONS_PREFIX_LEN)

	// The pixmap options have special treating
	if(kvi_strEqualCIN(optName,KVI_PIXMAP_OPTIONS_PREFIX,KVI_PIXMAP_OPTIONS_PREFIX_LEN))
	{
		// We lookup the image path (so we allow also relative paths for this option type)
		KviStr szVal = value;
		szVal.stripWhiteSpace();
		KviStr szBuffer;
		if(szVal.hasData())
		{
			findImage(szBuffer,szVal.ptr());
		} else {
			szBuffer = szVal;
		}

		for(int i=0;i < KVI_NUM_PIXMAP_OPTIONS;i++)
		{
			if(kvi_strEqualCI(optName,g_pixmapOptionsTable[i].name))
			{
				if(!KviStringConversion::fromString(szBuffer.ptr(),g_pixmapOptionsTable[i].option))return false;
				optionResetUpdate(g_pixmapOptionsTable[i].flags);
				return true;
			}
		}
		return false;
	}

	return false;

	#undef SET_OPTION_VALUE
}
