#ifndef _KVI_NOTIFYLIST_H_
#define _KVI_NOTIFYLIST_H_

//
//   File : kvi_notifylist.h
//   Creation date : Fri Oct 27 2000 23:39:09 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include <qobject.h>
#include "kvi_list.h"
#include <qasciidict.h>
#include <qtimer.h>

#include "kvi_string.h"

class KviConsole;
class KviIrcMessage;
class KviIrcMask;

class KVIRC_API KviNotifyListManager : public QObject
{
	friend class KviConsole;
	friend class KviServerParser;
	Q_OBJECT
protected:
	KviNotifyListManager(KviConsole * console);
	~KviNotifyListManager();
protected:
	KviConsole * m_pConsole;
protected:
	virtual void start();
	virtual void stop();
	virtual bool handleUserhost(KviIrcMessage * msg);
	virtual bool handleIsOn(KviIrcMessage * msg);
	virtual bool handleWatchReply(KviIrcMessage *msg);
public:
	KviConsole * console(){ return m_pConsole;  };
};

class KVIRC_API KviIsOnNotifyListManager : public KviNotifyListManager
{
	friend class KviConsole;
	friend class KviServerParser;
	Q_OBJECT
protected:
	KviIsOnNotifyListManager(KviConsole * console);
	~KviIsOnNotifyListManager();
private:
	QAsciiDict<KviStr> * m_pRegUserDict;            // dict notifystring->reguser name
	KviPtrList<KviStr> * m_pNotifyList;                  // list of notifystring (total)
	KviPtrList<KviStr> * m_pIsOnList;                    // list of notifystring (one session)
	KviStr          m_szIsOnString;                 // m_pIsOnList in form of a string
	KviPtrList<KviStr> * m_pOnlineList;                  //
	KviPtrList<KviStr> * m_pUserhostList;
	KviStr          m_szUserhostString;
	bool            m_bExpectingIsOn;
	bool            m_bExpectingUserhost;
	QTimer        * m_pDelayedIsOnTimer;
	QTimer        * m_pDelayedNotifyTimer;
	QTimer        * m_pDelayedUserhostTimer;
	bool            m_bRunning;
protected:
	virtual void start();
	virtual void stop();
	virtual bool handleUserhost(KviIrcMessage *msg);
	virtual bool handleIsOn(KviIrcMessage *msg);
private:
	void delayedNotifySession();
	void delayedIsOnSession();
	void delayedUserhostSession();
private slots:
	void newNotifySession();
	void newIsOnSession();
	void newUserhostSession();

	void buildRegUserDict();
	void buildIsOnList();
	void buildUserhostList();
	void buildNotifyList();
	void sendIsOn();
	void sendUserhost();
	bool doMatchUser(const char * notifyString,const KviIrcMask & mask);

};


class KVIRC_API KviStupidNotifyListManager : public KviNotifyListManager
{
	friend class KviConsole;
	friend class KviServerParser;
	Q_OBJECT
protected:
	KviStupidNotifyListManager(KviConsole * console);
	~KviStupidNotifyListManager();
protected:
	KviPtrList<KviStr> * m_pNickList;
	KviStr m_szLastIsOnMsg;
	int m_iNextNickToCheck;
	int m_iRestartTimer;
protected:
	virtual void start();
	virtual void stop();
	virtual bool handleIsOn(KviIrcMessage *msg);
//	virtual bool handleUserhost(KviIrcMessage *msg);
protected:
	virtual void timerEvent(QTimerEvent *e);
private:
	void buildNickList();
	void sendIsOn();
};

class KVIRC_API KviWatchNotifyListManager : public KviNotifyListManager
{
	friend class KviConsole;
	friend class KviServerParser;
	Q_OBJECT
public:
	KviWatchNotifyListManager(KviConsole * console);
	~KviWatchNotifyListManager();
protected:
	QAsciiDict<KviStr> * m_pRegUserDict;            // dict notifystring->reguser name
protected:
	void buildRegUserDict();
	virtual void start();
	virtual void stop();
	virtual bool handleWatchReply(KviIrcMessage *msg);
	bool doMatchUser(KviIrcMessage *msg,const char * notifyString,const KviIrcMask & mask);

};

#endif //_KVI_NOTIFYLIST_H_
