//=============================================================================
//
//   File : kvi_main.cpp
//   Creation date : Sun Jun 18 2000 12:38:45 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================
#define __KVIRC__
#include "kvi_app.h"
#include "kvi_string.h"
#include "kvi_settings.h"
#include "kvi_ircurl.h"
#include "kvi_defaults.h"

#ifndef COMPILE_NO_IPC
	extern bool kvi_sendIpcMessage(const char * message); // kvi_ipc.cpp
#endif

#ifndef COMPILE_ON_WINDOWS
	#ifndef COMPILE_USE_AA_FONTS
		#include "kvi_env.h"
	#endif
#endif

#include <qglobal.h> //for debug()

#include <qmessagebox.h>

#define KVI_ARGS_RETCODE_OK 0
#define KVI_ARGS_RETCODE_ERROR 1
#define KVI_ARGS_RETCODE_STOP 2


int parseArgs(int argc,char **argv,char ** configFile,bool *createFile,bool *bForceNewSession,bool *bShowPopup,
	KviStr &execCommand,KviStr &execRemoteCommand)
{
	KviStr szServer;
	KviStr szPort;

	if(argc > 1){
		int idx = 1;
		while(idx < argc)
		{
			if(kvi_strEqualCI("-v",argv[idx]) || kvi_strEqualCI("--version",argv[idx]))
			{
				debug("%s",KVI_VERSION);
				debug("Build date: %s",BUILD_DATE);
				debug("Script language tag: %s",KVI_SCRIPT_LANGUAGE_TAG);
				debug("Home page: http://www.kvirc.net");

				return KVI_ARGS_RETCODE_STOP;

			} else if(kvi_strEqualCI("-h",argv[idx]) || kvi_strEqualCI("--help",argv[idx]))
			{
				debug("Usage:");
				debug("    %s [options] [server [port]] [ircurl [ircurl [...]]]",argv[0]);
				debug("");
				debug("Available options:");
				debug("    -h            : Print this help and exit");
				debug("    -v            : Print the version informations and exit");
#ifndef COMPILE_ON_WINDOWS
				debug("    -c <file>     : Use <file> as config file instead of ~/%s",KVI_HOME_CONFIG_FILE_NAME);
				debug("                    (defaults to ~/%s if <file> does not exist)",KVI_HOME_CONFIG_FILE_NAME);
				debug("    -n <file>     : Use <file> as config file instead of ~/%s",KVI_HOME_CONFIG_FILE_NAME);
				debug("                    (create <file> if it does not exist)");
#endif
#ifdef COMPILE_NO_IPC
				debug("    -f            : Accepted but ignored (for compatibility)");
#else
				debug("    -f            : Force a new KVIrc session, even if there is already");
				debug("                    a running one.");
#endif
				debug("    -e <commands> : If a KVirc session is already running, execute");
				debug("                    the <commands> in that session, otherwise startup");
				debug("                    normally and execute <commands>");
				debug("                    <commands> must be a single shell token.");
				debug("                    You can eventually use this switch more than once");
				debug("    -r <commands> : If a KVIrc session is already running, execute the <commands>");
				debug("                    in that session, otherwise startup normally (and do not execute)");
				debug("                    <commands> must be a single shell token.");
				debug("                    You can eventually use this switch more than once");
				debug("    -m            : If a KVIrc session is already running, show an informational");
				debug("                    popup dialog instead of writing to the console");
				debug("    [server]      : Connect to this server after startup");
				debug("    [port]        : Use this port for connection");
				debug("    [ircurl]      : Url in the following form:");
				debug("                    irc[6]://<server>[:<port>][/<channel>[?<pass>]]");

				return KVI_ARGS_RETCODE_STOP;
#ifndef COMPILE_ON_WINDOWS
			} else if(kvi_strEqualCI("-c",argv[idx]))
			{
				idx++;
				if(idx >= argc)
				{
					debug("Option -c requires a config file name");
					return KVI_ARGS_RETCODE_ERROR;
				}
				*configFile = argv[idx];
				debug("Using file %s as config",argv[idx]);
#endif
			} else if(kvi_strEqualCI("-e",argv[idx]))
			{
				idx++;
				if(idx >= argc)
				{
					debug("Option -e requires a command");
					return KVI_ARGS_RETCODE_ERROR;
				}
				if(execCommand.hasData())execCommand.append("\n");
				execCommand.append(argv[idx]);
			} else if(kvi_strEqualCI("-r",argv[idx]))
			{
				idx++;
				if(idx >= argc)
				{
					debug("Option -r requires a command");
					return KVI_ARGS_RETCODE_ERROR;
				}
				if(execRemoteCommand.hasData())execRemoteCommand.append("\n");
				execRemoteCommand.append(argv[idx]);
			} else if(kvi_strEqualCI("-m",argv[idx]))
			{
				*bShowPopup = true;
#ifndef COMPILE_ON_WINDOWS
			} else if(kvi_strEqualCI("-n",argv[idx]))
			{
				idx++;
				if(idx >= argc)
				{
					debug("Option -n requires a config file name");
					return KVI_ARGS_RETCODE_ERROR;
				}
				*configFile = argv[idx];
				*createFile=true;
				debug("Using file %s as config",argv[idx]);
#endif
			} else if(kvi_strEqualCI("-f",argv[idx]))
			{
				*bForceNewSession = true;
			} else {
				if(*(argv[idx]) != '-')
				{
					// no dash
					if(kvi_strEqualCIN(argv[idx],"irc://",6) || kvi_strEqualCIN(argv[idx],"irc6://",7))
					{
						KviStr tmp;
						if(parseIrcUrl(argv[idx],tmp))
						{
							if(execCommand.hasData())execCommand.append('\n');
							execCommand.append(tmp);
						} else debug("Invalid IRCURL \"%s\"",argv[idx]);
					} else {
						KviStr tmp(argv[idx]);
						if(tmp.isUnsignedNum())szPort = tmp;
						else szServer = tmp;
					}
				}
			}
			idx++;
		}
	}

	if(szServer.hasData())
	{
		if(execCommand.hasData())execCommand.append('\n');
		execCommand.append("server -u ");
		execCommand.append(szServer);
		if(szPort.hasData())
		{
			execCommand.append(' ');
			execCommand.append(szPort);
		}
//		execCommand.append(';');
	}

	return KVI_ARGS_RETCODE_OK;
}


int main(int argc,char ** argv)
{
	char * configFile         = 0;
	bool createFile           = false;
	bool bForceNewSession     = false;
	bool bShowPopup           = false;
	KviStr szExecCommand;
	KviStr szRemoteExecCommand;

	int retCode = parseArgs(argc,argv,&configFile,&createFile,&bForceNewSession,&bShowPopup,szExecCommand,szRemoteExecCommand);

	//if(configFile != 0)debug("Config file here = %s",configFile);

	if(retCode != KVI_ARGS_RETCODE_OK)return ((retCode == KVI_ARGS_RETCODE_ERROR) ? (-1) : 0);

#ifndef COMPILE_ON_WINDOWS
	#ifndef COMPILE_USE_AA_FONTS
		kvi_unsetenv("QT_XFT"); // no anti-aliasing, thank you: we don't want broken font metrics
	#endif
#endif

	// Need to have the X socket open before IPC startup
	KviApp * theApp = new KviApp(argc,argv);

	KviStr szRemoteCommand = szExecCommand;
	if(szRemoteExecCommand.hasData())
	{
		if(szRemoteCommand.hasData())szRemoteCommand.append('\n');
		szRemoteCommand.append(szRemoteExecCommand);
	}

#ifndef COMPILE_NO_IPC
	if(!bForceNewSession)
	{
		if(kvi_sendIpcMessage(szRemoteCommand.ptr()))
		{
			if(szRemoteCommand.isEmpty())
			{
				if(bShowPopup)
				{
					KviStr tmp(KviStr::Format,"Another KVIrc session is already running on this display\nUse %s -f if you want to force a new session",argv[0]);
					QMessageBox::information(0,"KVIrc session",tmp.ptr(),QMessageBox::Ok);
				} else {
					debug("Another KVIrc session is already running on this display");
					debug("Use %s -f if you want to force a new session",argv[0]);
				}
			}
			delete theApp;
			return 0;
		}
	}
#endif

	theApp->m_bCreateConfig      = createFile;
	theApp->m_pConfigFile        = configFile;
	theApp->m_szExecAfterStartup = szExecCommand;
	theApp->setup();

	int retVal = theApp->exec();
	delete theApp;
	return retVal;
}
