#ifndef _KVI_IRCSOCKET_H_
#define _KVI_IRCSOCKET_H_
//
//   File : kvi_ircsocket.h
//   Creation date : Wed Jul 26 2000 13:45:20 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include <qobject.h>
#include "kvi_string.h"
#include "kvi_sockettype.h"
#include "kvi_time.h"


class KviConsole;
class KviIrcServer;
class KviProxy;

class QTimer;
class QSocketNotifier;

typedef struct _KviIrcSocketMsgEntry
{
	char                         * data_ptr;
	int                            data_len;
	struct _KviIrcSocketMsgEntry * next_ptr;
} KviIrcSocketMsgEntry;

//#ifdef COMPILE_SSL_SUPPORT
//	#include "kvi_ssl.h"
//#endif

class KviSSL;

class KVIRC_API KviIrcSocketMonitor
{
public:
	KviIrcSocketMonitor(KviConsole * lpConsole);
	virtual ~KviIrcSocketMonitor();
protected:
	KviConsole * m_pMyConsole;
public:
	// message is null terminated
	virtual void incomingMessage(const char * message){};
	// message is NOT null terminated! For proxy connections it might spit out binary data!
	virtual void outgoingMessage(const char * message,int len){};
	virtual void connectionInitiated(){};
	virtual void connectionTerminated(){};
	// The monitor MUST die here!
	virtual void die(){ delete this; };
};

class KVIRC_API KviIrcSocket : public QObject
{
	Q_OBJECT
public:
	KviIrcSocket(KviConsole * console,const char * name);
	~KviIrcSocket();
public:
	enum SockState { Ready , Connecting , ProxyLogin , Connected , ProxyFinalV4 ,
					ProxyFinalV5 , ProxySelectAuthMethodV5 , ProxyUserPassV5 ,
					ProxyFinalHttp , SSLHandshake };
	enum SockEvent { Error , Warning , Message , StateChange , ProxyMessage ,
					ProxyError , SSLMessage , SSLError , SSLCertificate , SSLCipherInfo };
protected:
	KviConsole           * m_pConsole;
	kvi_socket_t           m_sock;
	SockState              m_state;
	QSocketNotifier      * m_pWsn;
	QSocketNotifier      * m_pRsn;
	KviIrcServer         * m_pIrcServer;
	KviProxy             * m_pProxy;
	QTimer               * m_pTimeoutTimer;
	char                 * m_pReadBuffer;
	unsigned int           m_uReadBufferLen;
	unsigned int           m_uReadBytes;
	unsigned int           m_uSentBytes;
	unsigned int           m_uReadPackets;
	unsigned int           m_uSentPackets;
	KviIrcSocketMsgEntry * m_pSendQueueHead;
	KviIrcSocketMsgEntry * m_pSendQueueTail;
	QTimer               * m_pFlushTimer;
	struct timeval         m_tAntiFloodLastMessageTime;
#ifdef COMPILE_SSL_SUPPORT
	KviSSL               * m_pSSL;
#endif
public:
#ifdef COMPILE_SSL_SUPPORT
	bool usingSSL(){ return m_pSSL; };
#else
	bool usingSSL(){ return false; };
#endif
	unsigned int readBytes(){ return m_uReadBytes; };
	unsigned int sentBytes(){ return m_uSentBytes; };
	SockState state(){ return m_state; };
	bool isConnected(){ return m_state == Connected; };
	bool isReady(){ return m_state == Ready; };
	int connectToIrcHost(KviIrcServer * srv,KviProxy * prx = 0,const char * bindAddress = 0);
	bool sendData(const char *buffer,int buflen = -1);
	bool sendRawData(const char *buffer,int buflen);
	bool sendFmtData(const char *fmt,...);
	void abortConnection(){ reset(); };
	bool getLocalHostIp(KviStr &szIp,bool bIpV6);
protected slots:
	void connectionTimedOut();
	void writeNotifierFired(int);
	void readIrcData(int);
	void readProxyData(int);
	void flushSendQueue();
	void doSSLHandshake(int);
private:
#ifdef COMPILE_SSL_SUPPORT
	void raiseSSLError();
	void printSSLPeerCertificate();
	void printSSLCipherInfo();
#endif
	void connectionEstabilished();
	void proxyLoginHttp();
	void proxyLoginV4();
	void proxyLoginV5();
	void proxyAuthUserPassV5();
	void proxySendTargetDataV5();
	void proxyHandleV5AuthReply(unsigned char reply);
	void proxyHandleV5MethodReply(unsigned char reply);
	void proxyHandleV5FinalReply(unsigned char reply);
	void proxyHandleV4FinalReply(unsigned char reply);
	void proxyHandleHttpFinalReply(const char * buffer,int bufLen);
	void handleInvalidSocketRead(int readedLength);
	void reset();
	bool queue_removeMessage();
	void queue_removeAllMessages();
	void queue_insertMessage(KviIrcSocketMsgEntry *msg_ptr);
	void setState(SockState st);
//	int errorFromSystemError(int sysErr);
};


#endif //_KVI_IRCSOCKET_H_
