//
//   File : kvi_ipc.hcpp
//   Creation date : Tue Apr 10 2001 15:04:45 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__
#include "kvi_ipc.h"


#ifndef COMPILE_NO_IPC

	#include "kvi_memmove.h"
	#include "kvi_app.h"

#ifdef COMPILE_ON_WINDOWS

	static HWND kvi_win_findIpcSentinel()
	{
		return ::FindWindow("QWidget","[Freeware] - kvirc_ipc_sentinel");
	}

#else //!COMPILE_ON_WINDOWS

	#include <X11/Xatom.h>



	static Atom kvi_atom_ipc_sentinel_window;
	static Atom kvi_atom_ipc_remote_command;
	static Atom kvi_atom_ipc_remote_message;
	static const char * kvi_sentinel_id = "tonno e mistero";
	static int kvi_sentinel_id_len = 15;
	static bool g_bIpcAtomsLoaded = false;

	static void kvi_ipcLoadAtoms()
	{
		if(g_bIpcAtomsLoaded)return;
		g_bIpcAtomsLoaded = true;
		kvi_atom_ipc_sentinel_window = XInternAtom(qt_xdisplay(),"XA_KVI_IPC_SENTINEL_WINDOW",False);
		kvi_atom_ipc_remote_command = XInternAtom(qt_xdisplay(),"XA_KVI_IPC_REMOTE_COMMAND",False);
		kvi_atom_ipc_remote_message = XInternAtom(qt_xdisplay(),"XA_KVI_IPC_REMOTE_MESSAGE",False);
	}

	static void kvi_ipcSetRemoteCommand(Window w,const char * command)
	{
		XChangeProperty(qt_xdisplay(),w,kvi_atom_ipc_remote_command,
			XA_STRING,8,PropModeReplace,(const unsigned char *)command,kvi_strLen(command) + 1);
	}

	static Window kvi_x11_findIpcSentinel(Window win)
	{
//		debug("Looking for sentinel %d",win);
		Atom type;
		int format;
		unsigned long nItems,after;
		unsigned char * data = 0;
		if(XGetWindowProperty(qt_xdisplay(),win,kvi_atom_ipc_sentinel_window,0,32,FALSE,XA_STRING,
			&type,&format,&nItems,&after,&data) == Success)
		{
			if((type == XA_STRING) && (format == 8))
			{
//				debug("Has the requested property! (win = %d)(%d) (format = %d,items = %d,type = %d)",win,kvi_atom_ipc_sentinel_window,format,nItems,type);
				if((nItems == kvi_sentinel_id_len) && data)
				{
//					debug("And everything matches (%s:%s)",data,kvi_sentinel_id);
					if(kvi_strEqualCSN((const char *)data,(const char *)kvi_sentinel_id,kvi_sentinel_id_len))
					{
//						debug("Yup: this one");
						XFree((char *)data);
						return win;
					}
				}
			}
		}

		Window root,parent;
		Window * children;
		unsigned int nChildren;

		if(!XQueryTree(qt_xdisplay(),win,&root,&parent,&children,&nChildren))
		{
			if(children)XFree((char *)children);
			return 0;
		}

		Window found = 0;

	    for(int i=nChildren-1;(!found) && (i >= 0);i--)
			found = kvi_x11_findIpcSentinel(children[i]);

 		if(children)XFree((char *)children);

		return found;
	}

#endif //!COMPILE_ON_WINDOWS


	#define KVI_WINDOWS_IPC_MESSAGE 0x2FACE5

	bool kvi_sendIpcMessage(const char * message)
	{
#ifdef COMPILE_ON_WINDOWS
		HWND hSentinel = kvi_win_findIpcSentinel();
		//debug("Sentinel : %d",hSentinel);
		if(hSentinel != NULL)
		{
			COPYDATASTRUCT cpd;
			cpd.cbData = sizeof(cpd);
			cpd.dwData = KVI_WINDOWS_IPC_MESSAGE;
			cpd.lpData = (void *)message;
			DWORD dwResult;
			//debug("Sending message");
			::SendMessageTimeout(hSentinel,WM_COPYDATA,(WPARAM)NULL,(LPARAM)&cpd,SMTO_ABORTIFHUNG,1000,&dwResult);
			//debug("Message sent");
			return true;
		}
#else //!COMPILE_ON_WINDOWS
		kvi_ipcLoadAtoms();

		Window sentinel = kvi_x11_findIpcSentinel(qt_xrootwin());
		if(sentinel != 0)
		{
//			debug("FOund the sentinel!");
//			XChangeProperty(qt_xdisplay(),sentinel,kvi_atom_ipc_remote_command,XA_STRING,8,
//				PropModeReplace,(const unsigned char *)message,kvi_strLen(message));
			kvi_ipcSetRemoteCommand(sentinel,message);

			XEvent e;
			kvi_memset(&e,0,sizeof(XEvent));
			e.type = ClientMessage;
			e.xclient.display = qt_xdisplay();
			e.xclient.window = sentinel;
			e.xclient.message_type = kvi_atom_ipc_remote_message;
			e.xclient.format = 8;

			XSendEvent(qt_xdisplay(),sentinel,False,0,&e);

			return true;
		} //else debug("Sentinel not found");
#endif //!COMPILE_ON_WINDOWS
		return false;
	}


	//////////////////////////////////////////////////////////////////////
	// class KviIpcSentinel
	//
	//    hidden sentinel of ipc messages
	//
	//////////////////////////////////////////////////////////////////////

	KviIpcSentinel::KviIpcSentinel()
	: QWidget(0,"kvirc_ipc_sentinel")
	{
#ifdef COMPILE_ON_WINDOWS
		setCaption("kvirc_ipc_sentinel");
#else //!COMPILE_ON_WINDOWS
		kvi_ipcLoadAtoms();

		XChangeProperty(qt_xdisplay(),winId(),kvi_atom_ipc_sentinel_window,XA_STRING,8,
			PropModeReplace,(const unsigned char *)kvi_sentinel_id,kvi_sentinel_id_len);

		kvi_ipcSetRemoteCommand(winId(),"");
#endif //!COMPILE_ON_WINDOWS

//		debug("Sentinel created on this side: %d",winId());

		move(-50,-50);
		resize(1,1);
		hide();

		//debug("Sentinel up");
	}
	
	KviIpcSentinel::~KviIpcSentinel()
	{
	}

#ifdef COMPILE_ON_WINDOWS

	bool KviIpcSentinel::winEvent(MSG * msg)
	{
		//debug("Win event");
		if(msg->message == WM_COPYDATA)
		{
			//debug("Copy data");
			COPYDATASTRUCT * cpd = (COPYDATASTRUCT *)msg->lParam;
			if(cpd)
			{
				if(cpd->dwData == KVI_WINDOWS_IPC_MESSAGE)
				{
					if(g_pApp)g_pApp->ipcMessage((char *)(cpd->lpData));
					return true;
				}
			}
		}
		return false;
	}

#else //!COMPILE_ON_WINDOWS

	bool KviIpcSentinel::x11Event(XEvent *e)
	{
//		debug("X11 message");
		if(e->type == ClientMessage)
		{
//			debug("      Client message (format = %d,type = %d)",e->xclient.format,e->xclient.message_type);
			if((e->xclient.message_type = kvi_atom_ipc_remote_message) && (e->xclient.format == 8))
			{
				Atom type;
				int format;
				unsigned long nItems,after;
				unsigned char * data = 0;
				KviStr szData;
				if(XGetWindowProperty(qt_xdisplay(),winId(),kvi_atom_ipc_remote_command,0,1024,FALSE,XA_STRING,
					&type,&format,&nItems,&after,&data) == Success)
				{
					if((type == XA_STRING) && (format == 8) && (nItems > 0) && data)
					{
						szData = (char *)data;
						XFree((char *)data);
					}
				}
				kvi_ipcSetRemoteCommand(winId(),"");

				if(g_pApp)g_pApp->ipcMessage(szData.ptr());
				return true;
			}
		}
		return false;
	}

#endif //!COMPILE_ON_WINDOWS

	#include "kvi_ipc.moc"

#endif
