//
//   File : kvi_app.cpp
//   Creation date : Sun Jun 18 2000 12:39:45 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __KVIRC__

#define _KVI_APP_CPP_

#include "kvi_app.h"
#include "kvi_debug.h"
#include "kvi_frame.h"
#include "kvi_msgbox.h"
#include "kvi_iconmanager.h"
#include "kvi_ircview.h"
#include "kvi_input.h"
#include "kvi_config.h"
#include "kvi_colorwin.h"
#include "kvi_uparser.h"
#include "kvi_window.h"
#include "kvi_ircserverdb.h"
#include "kvi_proxydb.h"
#include "kvi_menubar.h"
#include "kvi_options.h"
#include "kvi_sparser.h"
#include "kvi_modulemanager.h"
#include "kvi_event.h"
#include "kvi_mediatype.h"
#include "kvi_scriptobject.h"
#include "kvi_regusersdb.h"
#include "kvi_thread.h"
#include "kvi_filetrader.h"
#include "kvi_popupmanager.h"
#include "kvi_confignames.h"
#include "kvi_aliasmanager.h"
#include "kvi_taskbar.h"
#include "kvi_defaults.h"
#include "kvi_locale.h"
#include "kvi_out.h"
#include "kvi_splash.h"
#include "kvi_nickserv.h"
#include "kvi_timermanager.h"
#include "kvi_xlib.h"
#include "kvi_garbage.h"
#include "kvi_texticonmanager.h"
#include "kvi_texticonwin.h"
#include "kvi_ctcppagedialog.h"

#ifndef COMPILE_NO_IPC
	#include "kvi_ipc.h"
#endif

#include <qpopupmenu.h>
#include <qsplitter.h>
#include <qstringlist.h>
#include <qasciidict.h>
#include <qmime.h>
#include <qlistbox.h>

#ifdef COMPILE_SSL_SUPPORT
	#include "kvi_ssl.h"
#endif



KviApp                    * g_pApp                    = 0; // global application pointer

KviConfig                 * g_pWinPropertiesConfig    = 0;
KVIRC_API KviIrcServerDataBase      * g_pIrcServerDataBase      = 0;
KVIRC_API KviProxyDataBase          * g_pProxyDataBase          = 0;

// Graphic stuff

QPixmap                   * g_pIrcViewMemBuffer       = 0;
KviPtrList<KviIrcView>         * g_pIrcViewWidgetList      = 0;
QPixmap                   * g_pInputMemBuffer         = 0;
KviPtrList<KviInput>           * g_pInputWidgetList        = 0;
QPixmap                   * g_pIccMemBuffer           = 0;

#ifndef COMPILE_NO_X_DRAW_CALLS
	Display                   * g_display             = 0; // global display pointer
	GC                          g_ircviewGC; // irc view
	HANDLE                      g_hIrcViewMemBuffer;
#endif

// Global windows

KVIRC_API KviColorWindow            * g_pColorWindow            = 0;
KVIRC_API KviTextIconWindow         * g_pTextIconWindow         = 0;
KVIRC_API QPopupMenu                * g_pInputPopup             = 0;
KVIRC_API QStringList               * g_pRecentTopicList        = 0;
KVIRC_API QStringList               * g_pBookmarkList           = 0;
KVIRC_API QAsciiDict<KviWindow>     * g_pGlobalWindowDict       = 0;
KVIRC_API KviMediaManager           * g_pMediaManager           = 0;
KVIRC_API KviRegisteredUserDataBase * g_pRegisteredUserDataBase = 0;
KVIRC_API KviFileTrader             * g_pFileTrader             = 0;
KVIRC_API KviNickServDataBase       * g_pNickServDataBase       = 0;
KVIRC_API KviTimerManager           * g_pTimerManager           = 0;
KVIRC_API KviGarbageCollector       * g_pGarbageCollector       = 0;
KVIRC_API KviCtcpPageDialog         * g_pCtcpPageDialog         = 0;

KVIRC_API bool                        g_bIdentDaemonRunning     = false; // this is eventually set by libkviident

#ifdef COMPILE_SPLASH_SCREEN
	KVIRC_API KviSplashScreen       * g_pSplashScreen           = 0;
#endif

// Loaded and destroyed by KviIconManager
QPixmap                             * g_pUserChanStatePixmap    = 0;


#ifdef COMPILE_PSEUDO_TRANSPARENCY

	#ifdef COMPILE_KDE_SUPPORT
		#include <ksharedpixmap.h>
		#include <netwm.h>
		#include <kimageeffect.h>
		#include <dcopclient.h>
		#include <qdatastream.h>
		#include <qcstring.h>

		KSharedPixmap         * g_pKdeDesktopBackground             = 0; // the shared pixmap that we get from KWin
	#endif

	#include <qimage.h>

	KVIRC_API QPixmap               * g_pShadedParentGlobalDesktopBackground = 0; // the pixmap that we use for MdiManager
	KVIRC_API QPixmap               * g_pShadedChildGlobalDesktopBackground  = 0; // the pixmap that we use for MdiChild
#endif

#ifdef COMPILE_CRYPT_SUPPORT
	#include "kvi_crypt.h"
	KVIRC_API KviCryptEngineManager * g_pCryptEngineManager = 0; // global crypt engine manager
#endif

KviApp::KviApp(int argc,char ** argv)
: KviTalApplication(argc,argv)
{
	// Ok...everything begins here
	g_pApp                  = this;
	m_pConfigFile           = 0;
	m_bCreateConfig         = false;
	m_pActiveWindow         = 0;
	m_bUpdateGuiPending     = false;
	m_pPendingAvatarChanges = 0;
#ifndef COMPILE_NO_IPC	
	m_pIpcSentinel          = 0;
#endif
	// Setup all the pointers
	m_pFrameList    = new KviPtrList<KviFrame>;
	m_pFrameList->setAutoDelete(true);
	// next step is setup()
	m_bSetupDone = false;
}



void KviApp::setup()
{
#ifdef COMPILE_ON_WINDOWS
	WSADATA w;
	WSAStartup(MAKELONG((unsigned short)2,(unsigned short)0),&w);
#endif


#ifndef COMPILE_NO_IPC
	// Create this vry early
	createIpcSentinel();
#endif

#if defined(COMPILE_USE_AA_FONTS) && !defined(COMPILE_NO_X_DRAW_CALLS)
// FIXME: #warning "FIXME: this should be not needed , check with newer qt/X releases"
	#if QT_VERSION < 300
		setFont(QFont("helvetica",12)); // Force QT to choose a decent font
	#endif
#endif

	// Inintialize the thread manager early
	KviThreadManager::globalInit();

#ifdef COMPILE_SSL_SUPPORT
	KviSSL::globalInit();
#endif

	// Setup our filesystem and initalize locale
	loadDirectories();

#ifdef COMPILE_SPLASH_SCREEN
	// Now we can create the splash screen (we can locate the splash image)
	createSplashScreen();
#endif

	KVI_SPLASH_SET_PROGRESS(0)

	// Set the default help files search path
	QStringList list;
	KviStr tmp;
	getLocalKvircDirectory(tmp,Help);
	list.append(tmp.ptr());
	getGlobalKvircDirectory(tmp,Help);
	list.append(tmp.ptr());
	getGlobalKvircDirectory(tmp,HelpEN);
	list.append(tmp.ptr());
	QMimeSourceFactory::defaultFactory()->setFilePath(list);

	KVI_SPLASH_SET_PROGRESS(1)
	KVI_SPLASH_SET_TEXT(__tr("Loading icons..."))

	// Load the icons (needed before loading options)
	g_pIconManager = new KviIconManager();

	KVI_SPLASH_SET_PROGRESS(3)
	KVI_SPLASH_SET_TEXT(__tr("Loading options..."))

	// Load the configuration
	loadOptions();

	KVI_SPLASH_SET_PROGRESS(43)
	KVI_SPLASH_SET_TEXT(__tr("Performing early initializations..."))

	// set the global font if needed
	updateApplicationFont();
	// activate the gui effets if needed
	updateGuiEffects();
	// update the pseudo transparency if needed
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	updatePseudoTransparency();
//    connect(kapp, SIGNAL(backgroundChanged(int)), SLOT(slotBackgroundChanged(int)));
#endif

	KVI_SPLASH_SET_PROGRESS(45)
	KVI_SPLASH_SET_TEXT(__tr("Loading window configuration database..."))

	// Load the win properties config
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_WINPROPERTIES);
	g_pWinPropertiesConfig = new KviConfig(tmp.ptr());

	KVI_SPLASH_SET_PROGRESS(48)
	KVI_SPLASH_SET_TEXT(__tr("Loading server & proxy database..."))

	// Load the server database
	g_pIrcServerDataBase   = new KviIrcServerDataBase();
	if(getReadOnlyConfigPath(tmp,KVI_CONFIGFILE_SERVERDB))
		g_pIrcServerDataBase->load(tmp.ptr());

	KVI_SPLASH_SET_PROGRESS(51)

	// Load the proxy database
	g_pProxyDataBase = new KviProxyDataBase();
	if(getReadOnlyConfigPath(tmp,KVI_CONFIGFILE_PROXYDB))
		g_pProxyDataBase->load(tmp.ptr());

	KVI_SPLASH_SET_TEXT(__tr("Loading event handlers..."))
	KVI_SPLASH_SET_PROGRESS(54)

	// Event manager
	g_pEventManager = new KviEventManager();
	if(getReadOnlyConfigPath(tmp,KVI_CONFIGFILE_EVENTS))
		g_pEventManager->load(tmp.ptr());

	KVI_SPLASH_SET_TEXT(__tr("Loading raw event handlers..."))
	KVI_SPLASH_SET_PROGRESS(59)

	if(getReadOnlyConfigPath(tmp,KVI_CONFIGFILE_RAWEVENTS))
		g_pEventManager->loadRaw(tmp.ptr());

	KVI_SPLASH_SET_TEXT(__tr("Loading popups..."))
	KVI_SPLASH_SET_PROGRESS(62)

	// Popup manager
	g_pPopupManager = new KviPopupManager();
	if(getReadOnlyConfigPath(tmp,KVI_CONFIGFILE_POPUPS))
		g_pPopupManager->load(tmp.ptr());

	KVI_SPLASH_SET_TEXT(__tr("Loading aliases..."))
	KVI_SPLASH_SET_PROGRESS(70)

	// Alias manager
	g_pAliasManager = new KviAliasManager();
	if(getReadOnlyConfigPath(tmp,KVI_CONFIGFILE_ALIASES))
		g_pAliasManager->load(tmp.ptr());


	KVI_SPLASH_SET_PROGRESS(77)
	KVI_SPLASH_SET_TEXT(__tr("Loading text icon associations..."))
	g_pTextIconManager = new KviTextIconManager();
	if(getReadOnlyConfigPath(tmp,KVI_CONFIGFILE_TEXTICONS))
		g_pTextIconManager->load(tmp.ptr());

	KVI_SPLASH_SET_PROGRESS(78)
	KVI_SPLASH_SET_TEXT(__tr("Loading recent entries..."))

	// load the recent data lists
	g_pRecentTopicList = new QStringList();
	g_pBookmarkList = new QStringList();
	loadRecentEntries();

	KVI_SPLASH_SET_PROGRESS(81)
	KVI_SPLASH_SET_TEXT(__tr("Loading media types..."))

	// media manager
	g_pMediaManager = new KviMediaManager();
	g_pMediaManager->lock();
	if(getReadOnlyConfigPath(tmp,KVI_CONFIGFILE_MEDIATYPES))
		g_pMediaManager->load(tmp.ptr());
	g_pMediaManager->unlock();


	KVI_SPLASH_SET_TEXT(__tr("Loading registered users..."))
	KVI_SPLASH_SET_PROGRESS(84)

	// registered user data base
	g_pRegisteredUserDataBase = new KviRegisteredUserDataBase();
	if(getReadOnlyConfigPath(tmp,KVI_CONFIGFILE_REGUSERDB))
		g_pRegisteredUserDataBase->load(tmp.ptr());

	KVI_SPLASH_SET_TEXT(__tr("Loading file trader configuration..."))
	KVI_SPLASH_SET_PROGRESS(88)

	// file trader
	g_pFileTrader = new KviFileTrader();
	if(getReadOnlyConfigPath(tmp,KVI_CONFIGFILE_FILETRADER))
		g_pFileTrader->load(tmp.ptr());

	KVI_SPLASH_SET_TEXT(__tr("Loading nick serv service configuration..."))
	KVI_SPLASH_SET_PROGRESS(90)

	// nick serv data base
	g_pNickServDataBase = new KviNickServDataBase();
	if(getReadOnlyConfigPath(tmp,KVI_CONFIGFILE_NICKSERVDATABASE))
		g_pNickServDataBase->load(tmp.ptr());

	KVI_SPLASH_SET_TEXT(__tr("Creating internal structures..."))
	KVI_SPLASH_SET_PROGRESS(92)

	// Init some other globals
	createSharedGraphicGlobals();

	// Eventually initialize the crypt engine manager
#ifdef COMPILE_CRYPT_SUPPORT
	g_pCryptEngineManager = new KviCryptEngineManager();
#endif

	g_pGarbageCollector = new KviGarbageCollector();

	// Create the color windoww
	//g_pColorWindow = new KviColorWindow();
	//g_pColorWindow->hide();
	// and the input popup
	g_pInputPopup = new QPopupMenu();
	// create the parsers
	g_pUserParser = new KviUserParser();
	g_pServerParser = new KviServerParser();
	// And the timer manager
	g_pTimerManager = new KviTimerManager();

	KVI_SPLASH_SET_PROGRESS(95)

	// Global window dictionary
	g_pGlobalWindowDict = new QAsciiDict<KviWindow>(41);
	g_pGlobalWindowDict->setAutoDelete(false);
	// Script object controller
	g_pScriptObjectController = new KviScriptObjectController();
	// Module manager
	g_pModuleManager = new KviModuleManager();

	KVI_SPLASH_SET_TEXT(__tr("Starting up the engine..."))
	KVI_SPLASH_SET_PROGRESS(98)

	// and finally create the first frame: we're up and running now
	createNewFrame();

	if(firstTimeRun())
	{
		// Load the default script
		KviStr cmd;
		getGlobalKvircDirectory(cmd,KviApp::DefScript,"default.kvs");
		cmd.prepend("/parse \"");
		cmd.append("\"");
#ifdef COMPILE_ON_WINDOWS
		cmd.replaceAll("\\","\\\\");
#endif
		g_pUserParser->parseUserCommand(cmd,m_pFrameList->first()->firstConsole());
	}

	// hello world!
	m_bSetupDone = true;

	// something else ?

	KVI_SPLASH_SET_PROGRESS(100)
	KVI_SPLASH_SET_TEXT(__tr("Have fun! :)"))

#ifdef COMPILE_SPLASH_SCREEN
	destroySplashScreen();
#endif

}



KviApp::~KviApp()
{

#ifndef COMPILE_NO_IPC
	destroyIpcSentinel();
#endif

#ifdef COMPILE_SPLASH_SCREEN
	if(g_pSplashScreen != 0)delete g_pSplashScreen;
#endif

	if(g_pCtcpPageDialog != 0)delete g_pCtcpPageDialog;

	delete g_pGarbageCollector;

	// kill all the frames (if any...a normal quit will have none)
	// while(m_pFrameList->first())m_pFrameList->removeFirst();
	delete m_pFrameList;
	m_pFrameList    = 0;
	m_pActiveWindow = 0;

	if(!m_bSetupDone)return; // killed with IPC (nothing except the m_pFrameList was created yet)

	// NO MORE EVENTS ARE TRIGGERED FROM NOW ON: NO COMMANDS ARE EXECUTED
	// dangerous part.... we're unloading all the modules
	delete g_pModuleManager;
	// NO MORE EXTERNAL MODULES EXIST: NO "UNKNOWN" ACTIONS ARE PERFORMED
	// we are safe here...
	saveOptions();
	// now kill the stuff that the frame depends on
	saveIrcServerDataBase();
	delete g_pIrcServerDataBase;
	saveProxyDataBase();
	delete g_pProxyDataBase;
	delete g_pWinPropertiesConfig;
	saveTextIcons();
	delete g_pTextIconManager;
	delete g_pIconManager;
	delete g_pTimerManager;
	delete g_pUserParser;
	delete g_pServerParser;
	saveMediaTypes();
	delete g_pMediaManager;
	saveRecentEntries();
	delete g_pBookmarkList;
	delete g_pRecentTopicList;
	saveRegisteredUsers();
	delete g_pRegisteredUserDataBase;
	saveNickServ();
	delete g_pNickServDataBase;
	saveFileOffers();
	delete g_pFileTrader;
	saveEvents();
	saveRawEvents();
	delete g_pEventManager;
	savePopups();
	delete g_pPopupManager;
	saveAliases();
	delete g_pAliasManager;
	delete g_pGlobalWindowDict;
	// kill the remaining resources
	destroySharedGraphicGlobals();
	delete g_pColorWindow;
	if(g_pTextIconWindow)delete g_pTextIconWindow;
	delete g_pInputPopup;
	delete g_pScriptObjectController;
#ifdef COMPILE_CRYPT_SUPPORT
	delete g_pCryptEngineManager;
#endif
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	destroyPseudoTransparency();
#endif
	if(m_pPendingAvatarChanges)
	{
		delete m_pPendingAvatarChanges;
	}
	// Kill the thread manager.... all the slave threads should have been already terminated ...
#ifdef COMPILE_SSL_SUPPORT
	KviSSL::globalDestroy();
#endif
	KviThreadManager::globalDestroy();

#ifdef COMPILE_ON_WINDOWS
	WSACleanup();
#endif

	// goodbye cruel world...
}

void KviApp::collectGarbage(QObject * garbage)
{
//	if(!g_pGarbageCollector)debug("Ops... no garbage collector ?");
	g_pGarbageCollector->collect(garbage);
}

#ifndef COMPILE_NO_IPC


void KviApp::createIpcSentinel()
{
	m_pIpcSentinel = new KviIpcSentinel();
}

void KviApp::destroyIpcSentinel()
{
	if(m_pIpcSentinel)delete m_pIpcSentinel;
}

void KviApp::ipcMessage(char * message)
{
	if(KviFrame * frm = activeFrame())
	{
		KviConsole * cns = frm->firstConsole();
		if(cns)
		{
			if(KVI_OPTION_BOOL(KviOption_boolBeVerbose))
			{
				KviStr cmd = message;
				if(cmd.len() > 30)cmd.cutRight(cmd.len() - 30);
				int idx = cmd.findFirstIdx('\n');
				if(idx != -1)cmd.cutRight(cmd.len() - (idx + 1));
				cns->output(KVI_OUT_SYSTEMMESSAGE,__tr("Remote command received (%s ...)"),cmd.ptr());
			}
			g_pUserParser->parseCommandBuffer(message,cns);
		}
	}
}

#endif // COMPILE_NO_IPC

#ifdef COMPILE_SPLASH_SCREEN

void KviApp::createSplashScreen()
{
	g_pSplashScreen = new KviSplashScreen();
	g_pSplashScreen->show();
}

void KviApp::destroySplashScreen()
{
	g_pSplashScreen->die();
}

#endif

void KviApp::setAvatarOnFileReceived(KviConsole * pConsole,const char * fileName,const char * nick,const char * user,const char * host)
{
	if(!m_pPendingAvatarChanges)
	{
		m_pPendingAvatarChanges = new KviPtrList<KviPendingAvatarChange>;
		m_pPendingAvatarChanges->setAutoDelete(true);
	}

	if(m_pPendingAvatarChanges->count() >= KVI_MAX_PENDING_AVATARS) // can't be...
	{
		m_pPendingAvatarChanges->removeFirst(); // kill the first entry
	}

	KviPendingAvatarChange * p = new KviPendingAvatarChange;
	p->pConsole = pConsole;
	p->szFileName = fileName;
	p->szNick = nick;
	p->szUser = user;
	p->szHost = host;

	m_pPendingAvatarChanges->append(p);
}

void KviApp::dccFileReceived(const char * sendFileName,const char * localFileName,const char * nick)
{
	KviPendingAvatarChange * p = findPendingAvatarChange(0,nick,sendFileName);
	if(p)
	{
		if(windowExists(p->pConsole))
		{
			p->pConsole->setAvatar(nick,p->szUser.ptr(),p->szHost.ptr(),localFileName);
		}
		m_pPendingAvatarChanges->removeRef(p);
		if(m_pPendingAvatarChanges->count() == 0)
		{
			delete m_pPendingAvatarChanges;
			m_pPendingAvatarChanges = 0;
		}
	}
}

KviPendingAvatarChange * KviApp::findPendingAvatarChange(KviConsole * pConsole,const char * nick,const char * fileName)
{
	if(!m_pPendingAvatarChanges)return 0;

	for(KviPendingAvatarChange * p = m_pPendingAvatarChanges->first();p;p = m_pPendingAvatarChanges->next())
	{
		if((pConsole == 0) || (p->pConsole == pConsole))
		{
			if(kvi_strEqualCI(nick,p->szNick.ptr()))
			{
				if(kvi_strEqualCS(fileName,p->szFileName.ptr()))
				{
					return p;
				}
			}
		}
	}
	return 0;
}


#ifdef COMPILE_PSEUDO_TRANSPARENCY

	#ifdef COMPILE_KDE_SUPPORT

		void KviApp::downloadKdeRootPixmap()
		{
			if(g_pKdeDesktopBackground)delete g_pKdeDesktopBackground;
			g_pKdeDesktopBackground = 0;
	
			// This has been extracted from the KDELIBS KRootPixmap interface
			NETRootInfo rinfo( qt_xdisplay(), NET::CurrentDesktop );
			rinfo.activate();
	
		    QString name = QString("DESKTOP%1").arg(rinfo.currentDesktop());
	
			g_pKdeDesktopBackground = new KSharedPixmap();
			connect(g_pKdeDesktopBackground,SIGNAL(done(bool)),this,SLOT(kdeRootPixmapDownloadComplete(bool)));
	
		    if(!(g_pKdeDesktopBackground->isAvailable(name)))
			{
				// Pixmap not available!!!
				delete g_pKdeDesktopBackground;
				g_pKdeDesktopBackground = 0;
				if(m_bUpdatePseudoTransparencyPending)return; // Already sent a request....
				// Send a request to kdesktop....
				DCOPClient *client = kapp->dcopClient();
				if(!client->isAttached())client->attach();
				QByteArray data;
				QDataStream args(data,IO_WriteOnly);
				args << 1;
				client->send("kdesktop","KBackgroundIface","setExport(int)",data);
				m_bUpdatePseudoTransparencyPending = true;
				// Now wait a while and try again....
				QTimer::singleShot(500,this,SLOT(updatePseudoTransparency()));
				return;
			}
	
			if(!g_pKdeDesktopBackground->loadFromShared(QString("DESKTOP%1").arg(rinfo.currentDesktop())))
			{
				debug("Can't load the KDE root background image...");
				delete g_pKdeDesktopBackground;
				g_pKdeDesktopBackground = 0;
			} //else debug("Root pixmap downalod initiated");
		}

	#endif //COMPILE_KDE_SUPPORT

	void KviApp::destroyPseudoTransparency()
	{
#ifdef COMPILE_KDE_SUPPORT
		if(g_pKdeDesktopBackground)
		{
			delete g_pKdeDesktopBackground;
			g_pKdeDesktopBackground = 0;
		}
#endif //COMPILE_KDE_SUPPORT
		if(g_pShadedParentGlobalDesktopBackground)
		{
			delete g_pShadedParentGlobalDesktopBackground;
			g_pShadedParentGlobalDesktopBackground = 0;
		}
		if(g_pShadedChildGlobalDesktopBackground)
		{
			delete g_pShadedChildGlobalDesktopBackground;
			g_pShadedChildGlobalDesktopBackground = 0;
		}
	}

	void KviApp::triggerUpdatePseudoTransparency()
	{
		if(m_bUpdatePseudoTransparencyPending)return;
		m_bUpdatePseudoTransparencyPending = true;
		QTimer::singleShot(0,this,SLOT(updatePseudoTransparency()));
	}

#ifdef COMPILE_KDE_SUPPORT

	#define kimageeffect_fade KImageEffect::fade

#else //!COMPILE_KDE_SUPPORT

	//
	// This function is taken from the KDE kimageeffect.cpp
	// The authors listed at the top of the file are :)
	//    Copyright (C) 1998, 1999 Christian Tibirna <ctibirna@total.net>
	//              (C) 1998, 1999 Daniel M. Duley <mosfet@kde.org>
	//              (C) 1998, 1999 Dirk A. Mueller <mueller@kde.org>
	//              (C) 2000       Josef Weidendorfer <weidendo@in.tum.de>
	//

	QImage& kimageeffect_fade(QImage &img,float val,const QColor &color)
	{
		if(img.width() == 0 || img.height() == 0)return img;
	
		// We don't handle bitmaps
		if (img.depth() == 1)return img;
	
		unsigned char tbl[256];
		for (int i=0; i<256; i++)tbl[i] = (int) (val * i + 0.5);
	
		int red = color.red();
		int green = color.green();
		int blue = color.blue();
	
		QRgb col;
		int r, g, b, cr, cg, cb;
	
		if (img.depth() <= 8)
		{
			// pseudo color
			for(int i=0; i<img.numColors(); i++)
			{
				col = img.color(i);
				cr = qRed(col); cg = qGreen(col); cb = qBlue(col);
				if (cr > red)r = cr - tbl[cr - red];
				else r = cr + tbl[red - cr];
				if (cg > green)g = cg - tbl[cg - green];
				else g = cg + tbl[green - cg];
				if (cb > blue)b = cb - tbl[cb - blue];
				else b = cb + tbl[blue - cb];
				img.setColor(i, qRgb(r, g, b));
			}
		} else {
		// truecolor
			for(int y=0; y<img.height(); y++)
			{
				QRgb *data = (QRgb *) img.scanLine(y);
				for (int x=0; x<img.width(); x++)
				{
					col = *data;
					cr = qRed(col); cg = qGreen(col); cb = qBlue(col);
					if (cr > red)r = cr - tbl[cr - red];
					else r = cr + tbl[red - cr];
					if (cg > green)g = cg - tbl[cg - green];
					else g = cg + tbl[green - cg];
					if (cb > blue)b = cb - tbl[cb - blue];
					else b = cb + tbl[blue - cb];
					*data++ = qRgb(r, g, b);
				}
			}
		}
		return img;
	}

#endif //!COMPILE_KDE_SUPPORT

	void KviApp::createGlobalBackgrounds(QPixmap * pix)
	{
		// create shaded copies...
		if(g_pShadedParentGlobalDesktopBackground)delete g_pShadedParentGlobalDesktopBackground;
		if(g_pShadedChildGlobalDesktopBackground)delete g_pShadedChildGlobalDesktopBackground;
		g_pShadedParentGlobalDesktopBackground = new QPixmap();
		g_pShadedChildGlobalDesktopBackground = new QPixmap();
		QImage img = pix->convertToImage();
		// play with the fade factors
		KVI_OPTION_UINT(KviOption_uintGlobalTransparencyParentFadeFactor) %= 100;
		if(KVI_OPTION_UINT(KviOption_uintGlobalTransparencyParentFadeFactor) > 0)
		{
			g_pShadedParentGlobalDesktopBackground->convertFromImage(
				kimageeffect_fade(img,
					(float)((float)KVI_OPTION_UINT(KviOption_uintGlobalTransparencyParentFadeFactor) / (float)100),
					KVI_OPTION_COLOR(KviOption_colorGlobalTransparencyFade)),0);
		}
		KVI_OPTION_UINT(KviOption_uintGlobalTransparencyChildFadeFactor) %= 100;
		if(KVI_OPTION_UINT(KviOption_uintGlobalTransparencyChildFadeFactor) > 0)
		{
			g_pShadedChildGlobalDesktopBackground->convertFromImage(
				kimageeffect_fade(img,
					(float)((float)KVI_OPTION_UINT(KviOption_uintGlobalTransparencyChildFadeFactor) / (float)100),
					KVI_OPTION_COLOR(KviOption_colorGlobalTransparencyFade)),0);
		}
		//debug("Download success!");
		for(KviFrame * f = m_pFrameList->first();f;f = m_pFrameList->next())f->updatePseudoTransparency();
	}

#endif //COMPILE_PSEUDO_TRANSPARENCY



void KviApp::kdeRootPixmapDownloadComplete(bool bSuccess)
{
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	#ifdef COMPILE_KDE_SUPPORT
		if(!bSuccess)
		{
			debug("Failed to download the KDE root background image...");
		} else {
			// downloaded!
			// create shaded copies...
			createGlobalBackgrounds(g_pKdeDesktopBackground);
		}
		delete g_pKdeDesktopBackground;
		g_pKdeDesktopBackground = 0;
	#endif //COMPILE_KDE_SUPPORT
#endif //COMPILE_PSEUDO_TRANSPARENCY
}


void KviApp::updatePseudoTransparency()
{
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	m_bUpdatePseudoTransparencyPending = false;
	if(KVI_OPTION_BOOL(KviOption_boolUseGlobalPseudoTransparency))
	{
#ifdef COMPILE_KDE_SUPPORT
		if(KVI_OPTION_BOOL(KviOption_boolObtainGlobalBackgroundFromKde))
		{
			downloadKdeRootPixmap();
		} else {
#endif //COMPILE_KDE_SUPPORT
			if(KVI_OPTION_PIXMAP(KviOption_pixmapGlobalTransparencyBackground).pixmap())
			{
				createGlobalBackgrounds(KVI_OPTION_PIXMAP(KviOption_pixmapGlobalTransparencyBackground).pixmap());
			} else {
				destroyPseudoTransparency();
				KVI_OPTION_BOOL(KviOption_boolUseGlobalPseudoTransparency) = false;
			}
#ifdef COMPILE_KDE_SUPPORT
		}
#endif //COMPILE_KDE_SUPPORT
	} else {
		destroyPseudoTransparency();
		for(KviFrame * f = m_pFrameList->first();f;f = m_pFrameList->next())f->updatePseudoTransparency();
	}
#endif //COMPILE_PSEUDO_TRANSPARENCY
}



void KviApp::createSharedGraphicGlobals()
{
#ifndef COMPILE_NO_X_DRAW_CALLS
	// The global display
	g_display = qt_xdisplay();
#endif
	// The memory buffer for KviIrcView
	g_pIrcViewMemBuffer = new QPixmap(1,1);
#ifndef COMPILE_NO_X_DRAW_CALLS
	g_hIrcViewMemBuffer = g_pIrcViewMemBuffer->handle();
	// And the related graphic context
	g_ircviewGC = XCreateGC(g_display,g_hIrcViewMemBuffer,0,0);
#endif
	// The global list of KviIrcView widgets
	g_pIrcViewWidgetList = new KviPtrList<KviIrcView>;
	g_pIrcViewWidgetList->setAutoDelete(false);
	// The memory buffer for KviInput
	g_pInputMemBuffer = new QPixmap(1,1);
//#ifndef COMPILE_ON_WINDOWS
//	g_hInputMemBuffer = g_pInputMemBuffer->handle();
//	// And the related graphic context
//	g_inputGC = XCreateGC(g_display,g_hInputMemBuffer,0,0);
//#endif
	// The global list of KviInput widgets
	g_pInputWidgetList = new KviPtrList<KviInput>;
	g_pInputWidgetList->setAutoDelete(false);
	// The memory buffer for Irc Context Controller widgets
	g_pIccMemBuffer = new QPixmap(1,1);
//#ifndef COMPILE_ON_WINDOWS
//	g_hIccMemBuffer = g_pIccMemBuffer->handle();
//	// And the related graphic context
//	g_iccGC = XCreateGC(g_display,g_hIccMemBuffer,0,0);
//#endif
}

void KviApp::triggerUpdateGui()
{
	if(m_bUpdateGuiPending)return;
	m_bUpdateGuiPending = true;
	QTimer::singleShot(0,this,SLOT(updateGui()));
}

void KviApp::updateGui()
{
	m_bUpdateGuiPending = false;

// FIXME: #warning "Should repaint all the icc toolbars"

	for(KviFrame * f = m_pFrameList->first();f;f = m_pFrameList->next())
	{
		f->applyOptions();
	}
}

void KviApp::updateFrameCaptions()
{
	for(KviFrame * f = m_pFrameList->first();f;f = m_pFrameList->next())
	{
		f->updateCaption();
	}
}
/*
void KviApp::updateTaskBarSorting()
{
	for(KviFrame * f = m_pFrameList->first();f;f = m_pFrameList->next())
	{
		f->taskBar()->sortButtons();
	}
}
*/

void KviApp::updateTaskBar()
{
	for(KviFrame * f = m_pFrameList->first();f;f = m_pFrameList->next())
	{
		f->recreateTaskBar();
	}
}

void KviApp::updateApplicationFont()
{
	if(KVI_OPTION_BOOL(KviOption_boolUseGlobalApplicationFont))
	{
		if(font() != KVI_OPTION_FONT(KviOption_fontApplication))
			setFont(KVI_OPTION_FONT(KviOption_fontApplication),true);
	}
// FIXME: #warning "And what if this option is turned off ?...a reboot only"
}

void KviApp::updateIrcToolBars()
{
	// quote complex task...
	for(KviFrame * f = m_pFrameList->first();f;f = m_pFrameList->next())
	{
		f->updateIrcToolBars();
	}
}

void KviApp::updateGuiEffects()
{
	setEffectEnabled(Qt::UI_AnimateMenu,KVI_OPTION_BOOL(KviOption_boolUseGuiEffectAnimateMenu));
	setEffectEnabled(Qt::UI_FadeMenu,KVI_OPTION_BOOL(KviOption_boolUseGuiEffectFadeMenu));
	setEffectEnabled(Qt::UI_AnimateTooltip,KVI_OPTION_BOOL(KviOption_boolUseGuiEffectAnimateToolTip));
	setEffectEnabled(Qt::UI_FadeTooltip,KVI_OPTION_BOOL(KviOption_boolUseGuiEffectFadeToolTip));
	setEffectEnabled(Qt::UI_AnimateCombo,KVI_OPTION_BOOL(KviOption_boolUseGuiEffectAnimateCombo));
}

void KviApp::destroySharedGraphicGlobals()
{
	// Kill the shared graphic globals
	delete g_pIrcViewWidgetList;
#ifndef COMPILE_NO_X_DRAW_CALLS
	XFreeGC(g_display,g_ircviewGC);
#endif
	delete g_pIrcViewMemBuffer;
	delete g_pInputWidgetList;
//#ifndef COMPILE_ON_WINDOWS
//	XFreeGC(g_display,g_inputGC);
//#endif
	delete g_pInputMemBuffer;
//#ifndef COMPILE_ON_WINDOWS
//	XFreeGC(g_display,g_iccGC);
//#endif
	delete g_pIccMemBuffer;
}

void KviApp::loadRecentEntries()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_RECENT);
	KviConfig cfg(tmp.ptr());
	*g_pRecentTopicList = cfg.readStringListEntry("RecentTopicList",QStringList());
	*g_pBookmarkList = cfg.readStringListEntry("Bookmarks",QStringList());
}

void KviApp::saveRecentEntries()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_RECENT);
	KviConfig cfg(tmp.ptr());
	cfg.writeEntry("RecentTopicList",*g_pRecentTopicList);
	cfg.writeEntry("Bookmarks",*g_pBookmarkList);
}

void KviApp::savePopups()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_POPUPS);
	g_pPopupManager->save(tmp.ptr());
}

void KviApp::saveAliases()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_ALIASES);
	g_pAliasManager->save(tmp.ptr());
}

void KviApp::saveTextIcons()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_TEXTICONS);
	g_pTextIconManager->save(tmp.ptr());
}

void KviApp::saveEvents()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_EVENTS);
	g_pEventManager->save(tmp.ptr());
}

void KviApp::saveRawEvents()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_RAWEVENTS);
	g_pEventManager->saveRaw(tmp.ptr());
}

void KviApp::saveMediaTypes()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_MEDIATYPES);
	g_pMediaManager->lock();
	g_pMediaManager->save(tmp.ptr());
	g_pMediaManager->unlock();
}

void KviApp::saveIrcServerDataBase()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_SERVERDB);
	g_pIrcServerDataBase->save(tmp.ptr());
}

void KviApp::saveProxyDataBase()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_PROXYDB);
	g_pProxyDataBase->save(tmp.ptr());
}

void KviApp::saveRegisteredUsers()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_REGUSERDB);
	g_pRegisteredUserDataBase->save(tmp.ptr());
}

void KviApp::saveNickServ()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_NICKSERVDATABASE);
	g_pNickServDataBase->save(tmp.ptr());
}

void KviApp::saveFileOffers()
{
	KviStr tmp;
	getLocalKvircDirectory(tmp,Config,KVI_CONFIGFILE_FILETRADER);
	g_pFileTrader->save(tmp.ptr());
}

void KviApp::saveConfiguration()
{
	saveOptions();
	saveIrcServerDataBase();
	saveProxyDataBase();
	saveRecentEntries();
	saveEvents();
	saveRawEvents();
	saveMediaTypes();
	saveRegisteredUsers();
	saveNickServ();
	saveFileOffers();
	savePopups();
	saveAliases();
	saveTextIcons();
	g_pWinPropertiesConfig->sync();
}

void KviApp::createNewFrame()
{
	// create a new frame with an unique id
	static unsigned int uNextFrameId = 0;

	KviStr frName(KviStr::Format,"FRAME_%u",uNextFrameId);
	KviFrame * theFrame = new KviFrame(uNextFrameId,frName.ptr());
	uNextFrameId++;

	m_pFrameList->append(theFrame);

	theFrame->show();

	theFrame->createNewConsole(true);

	if(m_szExecAfterStartup.hasData())
	{
		g_pUserParser->parseCommandBuffer(m_szExecAfterStartup.ptr(),theFrame->firstConsole(),0);
		m_szExecAfterStartup = "";
	}
}

void KviApp::destroyFrame(KviFrame * frm)
{
	if(m_pActiveWindow)
	{
		if(m_pActiveWindow->frame() == frm)m_pActiveWindow = 0;
	}
	m_pFrameList->removeRef(frm);

	if(m_pFrameList->isEmpty())quit();
}

bool KviApp::windowExists(KviWindow *wnd)
{
	QAsciiDictIterator<KviWindow> it(*g_pGlobalWindowDict);

	while(it.current())
	{
		if(it.current() == wnd)return true;
		++it;
	}
	return false;
}

//KviConsole * KviApp::preferredConsole(KviConsole * c,KviFrame *f)
//{
//	// We want a console
//	// The preferred one is c , if still exists,
//	// otherwise get the first one in f , if still exists
//	// otherwise get the active console
//	if(windowExists(c))return c;
//	__range_valid(m_pFrameList);
//	if(m_pFrameList->findRef(f) != -1)return f->firstConsole();
//	return activeConsole();
//}

//KviFrame * KviApp::preferredFrame(KviFrame *f)
//{
//	__range_valid(m_pFrameList);
//	if(m_pFrameList->findRef(f) != -1)return f;
//	return m_pFrameList->first();
//}


KviConsole * KviApp::findConsole(KviStr &server,KviStr &nick)
{
	QAsciiDictIterator<KviWindow> it(*g_pGlobalWindowDict);

	while(it.current())
	{
		if(it.current()->type() == KVI_WINDOW_TYPE_CONSOLE)
		{
			if(((KviConsole *)it.current())->isConnected())
			{
				if(server.hasData())
				{
					if(kvi_strEqualCI(server.ptr(),
						((KviConsole *)it.current())->currentServerName()))
					{
						if(nick.hasData())
						{
							if(kvi_strEqualCI(nick.ptr(),
								((KviConsole *)it.current())->currentNickName()))
									return ((KviConsole *)it.current());
						} else return ((KviConsole *)it.current());
					}
				} else {
					if(nick.hasData())
					{
						if(kvi_strEqualCI(nick.ptr(),
							((KviConsole *)it.current())->currentNickName()))
								return ((KviConsole *)it.current());
					}
				}
			}
		}
		++it;
	}
	return 0;
}


void KviApp::restartNotifyLists()
{
	QAsciiDictIterator<KviWindow> it(*g_pGlobalWindowDict);

	while(it.current())
	{
		if(it.current()->type() == KVI_WINDOW_TYPE_CONSOLE)
		{
			((KviConsole *)it.current())->restartNotifyList();
		}
		++it;
	}
}

KviConsole * KviApp::findConsole(unsigned int ircContextId)
{
	QAsciiDictIterator<KviWindow> it(*g_pGlobalWindowDict);

	while(it.current())
	{
		if(it.current()->type() == KVI_WINDOW_TYPE_CONSOLE)
		{
			if(((KviConsole *)it.current())->ircContextId() == ircContextId)
				return ((KviConsole *)it.current());
		}
		++it;
	}
	return 0;
}

bool KviApp::isAnyConsoleConnected() {
	QAsciiDictIterator<KviWindow> it(*g_pGlobalWindowDict);

	while(it.current())
	{
		if(it.current()->type() == KVI_WINDOW_TYPE_CONSOLE)
		{
			if(((KviConsole *)it.current())->isConnected())
				return true;
		}
		++it;
	}
	return false;
}

KviWindow * KviApp::findWindow(const char * windowId)
{
	return g_pGlobalWindowDict->find(windowId);
}

KviWindow * KviApp::findWindowByCaption(const char * windowCaption)
{
	QAsciiDictIterator<KviWindow> it(*g_pGlobalWindowDict);

	while(it.current())
	{
		if(kvi_strEqualCI(windowCaption,it.current()->plainTextCaption()))
			return it.current();
		++it;
	}
	return 0;
}

void KviApp::registerWindow(KviWindow *wnd)
{
	g_pGlobalWindowDict->insert(wnd->id(),wnd);
}

void KviApp::unregisterWindow(KviWindow *wnd)
{
	g_pGlobalWindowDict->remove(wnd->id());
}


KviConsole * KviApp::activeConsole()
{
	if(!m_pFrameList)return 0;
	if(m_pActiveWindow)
	{
		if(m_pActiveWindow->console())return m_pActiveWindow->console();
	}
	return m_pFrameList->first()->firstConsole();
}

KviWindow * KviApp::activeWindow()
{
	if(!m_pFrameList)return 0;
	return m_pActiveWindow ? m_pActiveWindow : m_pFrameList->first()->activeWindow();
}

KviFrame * KviApp::activeFrame()
{
	if(!m_pFrameList)return 0;
	return m_pActiveWindow ? m_pActiveWindow->frame() : m_pFrameList->first();
}

/////////////////// RECENT STUFF LISTS & POPUPS HANDLING

// Helper for KviApp::addRecent*()
static void merge_to_stringlist_option(QString &item,int iOption,int iMaxEntries)
{
	if(KVI_OPTION_STRINGLIST(iOption).find(item) == KVI_OPTION_STRINGLIST(iOption).end())
	{
		// Not in the recent list
		while(KVI_OPTION_STRINGLIST(iOption).count() >= (unsigned int)iMaxEntries)
		{
			KVI_OPTION_STRINGLIST(iOption).remove(KVI_OPTION_STRINGLIST(iOption).fromLast());
		}
	} else 	{ // in the recent list, remove and put the first so more recents items are always up
		KVI_OPTION_STRINGLIST(iOption).remove(KVI_OPTION_STRINGLIST(iOption).find(item));
	}
	KVI_OPTION_STRINGLIST(iOption).prepend(item);
}

void KviApp::addRecentNickname(const char * newNick)
{
	QString nk(newNick);
	merge_to_stringlist_option(nk,KviOption_stringlistRecentNicknames,KVI_MAX_RECENT_NICKNAMES);
}

void KviApp::addRecentChannel(const char * chan)
{
	QString ch(chan);
	merge_to_stringlist_option(ch,KviOption_stringlistRecentChannels,KVI_MAX_RECENT_CHANNELS);
}

void KviApp::addRecentServer(const char * server)
{
	QString sr(server);
	merge_to_stringlist_option(sr,KviOption_stringlistRecentServers,KVI_MAX_RECENT_SERVERS);
}

void KviApp::fillRecentServersPopup(QPopupMenu * m)
{
// FIXME: #warning "MAYBE DISABLE THE SERVERS THAT WE ARE ALREADY CONNECTED TO ?"
	m->clear();
	for(QStringList::Iterator it = KVI_OPTION_STRINGLIST(KviOption_stringlistRecentServers).begin(); it != KVI_OPTION_STRINGLIST(KviOption_stringlistRecentServers).end(); ++it)
	{
		m->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_SERVER)),*it);
	}
}



void KviApp::fillRecentNicknamesPopup(QPopupMenu * m,KviConsole * pConsole)
{
	m->clear();
	int id;
	bool bAlreadyFound = false;
	for(QStringList::Iterator it = KVI_OPTION_STRINGLIST(KviOption_stringlistRecentNicknames).begin(); it != KVI_OPTION_STRINGLIST(KviOption_stringlistRecentNicknames).end(); ++it)
	{
		id = m->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_NICK)),*it);
		if(!pConsole->isConnected())m->setItemEnabled(id,false);
		else {
			if(!bAlreadyFound)
			{
				KviStr tmp = *it;
				bool bIsCurrent = kvi_strEqualCS(pConsole->currentNickName(),tmp.ptr());
				m->setItemEnabled(id,!bIsCurrent);
				if(bIsCurrent)bAlreadyFound = true;
			}
		}
	}
}

void KviApp::fillRecentChannelsPopup(QPopupMenu * m,KviConsole * pConsole)
{
	m->clear();
	int id;
	for(QStringList::Iterator it = KVI_OPTION_STRINGLIST(KviOption_stringlistRecentChannels).begin(); it != KVI_OPTION_STRINGLIST(KviOption_stringlistRecentChannels).end(); ++it)
	{
		id = m->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_CHANNEL)),*it);
		if(!pConsole->isConnected())m->setItemEnabled(id,false);
		else {
			KviStr tmp = *it;
			m->setItemEnabled(id,!(pConsole->findChannel(tmp.ptr())));
		}
	}
}

void KviApp::fillRecentChannelsListBox(QListBox * l)
{
	l->clear();
	for(QStringList::Iterator it = KVI_OPTION_STRINGLIST(KviOption_stringlistRecentChannels).begin(); it != KVI_OPTION_STRINGLIST(KviOption_stringlistRecentChannels).end(); ++it)
	{
		l->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_CHANNEL)),*it);	
	}
}
/*
void KviApp::fillRecentServersListBox(QListBox * l)
{
	l->clear();
	for(QStringList::Iterator it = KVI_OPTION_STRINGLIST(KviOption_stringlistRecentServers).begin(); it != KVI_OPTION_STRINGLIST(KviOption_stringlistRecentServers).end(); ++it)
		l->insertItem(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_SERVER)),*it);
}
*/
bool KviApp::playFile(const char * filename,KviStr &error,KviWindow * w)
{
	g_pMediaManager->lock();
	KviMediaType * m = g_pMediaManager->findMediaType(filename);
	if(m)
	{
		KviStr szCommandline = m->szCommandline;
		KviStr szDescription = m->szDescription;
		g_pMediaManager->unlock();
		if(szCommandline.hasData())
		{
			KviParameterList * l = new KviParameterList;
			l->append(new KviStr(filename));

			if(!g_pUserParser->parseCommandBuffer(szCommandline.ptr(),w ? w : activeWindow(),l))
			{
				error.sprintf(__tr("The commandline for media type '%s' seems to be broken"),szDescription.ptr());
				return false;
			}
		} else {
			error.sprintf(__tr("Media type of file %s matched to '%s' but no commandline specified"),filename,szDescription.ptr());
			return false;
		}
	} else {
		g_pMediaManager->unlock();
		error.sprintf(__tr("No idea on how to play file %s (no media type match)"),filename);
		return false;
	}
	return true;
}


// qvariant.h uses this , and it is included by the qt generated moc file for Qt >= 3.0.0
#ifdef Bool
	#undef Bool
#endif



#include "kvi_app.moc"
