#ifndef _KVI_TIME_H_
#define _KVI_TIME_H_

//=============================================================================
//
//   File : kvi_time.h
//   Creation date : Tue Sep 25 17:28:46 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"

#include <time.h> // for time()


#ifdef COMPILE_ON_WINDOWS

	#include <winsock2.h> // struct timeval

	extern KVILIB_API void kvi_gettimeofday(struct timeval * tmv,struct timezone * tmz);

#else //!COMPILE_ON_WINDOWS

	#include <sys/time.h> // gettimeofday() , struct timeval


	inline void kvi_gettimeofday(struct timeval * tmv,struct timezone * tmz)
	{
		gettimeofday(tmv,tmz);
	};

#endif //!COMPILE_ON_WINDOWS

extern KVILIB_API void kvi_secondsToDaysHoursMinsSecs(unsigned int uSecs,
			unsigned int * uD,unsigned int * uH,unsigned int * uM,unsigned int * uS);

#endif //_KVI_TIME_H_
